/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSerie;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf!\u0002\u000e\u001c\u0001m)\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006Y!\u0013\u0005\u0006K\u0002!\tA\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019\t\b\u0001)A\u0005]\")!\u000f\u0001C\u0001g\"9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\ty\u0005\u0001C\u0001\u0003#:\u0001\"!\u0017\u001c\u0011\u0003Y\u00121\f\u0004\b5mA\taGA/\u0011\u0019)W\u0002\"\u0001\u0002`!A\u0011\u0011M\u0007\u0005\u0002m\t\u0019G\u0002\u0004\u0002j5\u0001\u00111\u000e\u0005\neB\u0011\t\u0011)A\u0005\u0003[B\u0001\u0002 \t\u0003\u0002\u0003\u0006I!\u0010\u0005\t}B\u0011\t\u0011)A\u0005{!AA\b\u0005B\u0001B\u0003%Q\b\u0003\u0006\u0002xA\u0011\t\u0011)A\u0006\u0003sBa!\u001a\t\u0005\u0002\u0005}\u0004B\u0002:\u0011\t\u0003\t\t\nC\u0004\u0002\u0016B!\t!a&\t\u0013\u0005uU\"%A\u0005\u0002\u0005}%aD%oM2,\bpR3oKJ\fGo\u001c:\u000b\u0005qi\u0012\u0001C5oM2,\b\u0010\u001a2\u000b\u0005yy\u0012!\u00049s_\u000e,7o]\"pk:$8O\u0003\u0002!C\u0005Ya.^:tW:\f7m[3s\u0015\t\u00113%\u0001\u0003u_V\\'\"\u0001\u0013\u0002\u0005Ad7c\u0001\u0001'YA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005E\u0012\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003M\n1aY8n\u0013\t)dFA\u0006MCjLHj\\4hS:<\u0017AB2p]\u001aLwm\u0001\u0001\u0011\u0005eRT\"A\u000e\n\u0005mZ\"\u0001D%oM2,\bpQ8oM&<\u0017aA3omB\u0011a(\u0012\b\u0003\u007f\r\u0003\"\u0001\u0011\u0015\u000e\u0003\u0005S!AQ\u001c\u0002\rq\u0012xn\u001c;?\u0013\t!\u0005&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\r\u001e\u0013aa\u0015;sS:<'B\u0001#)\u0003\u001d\u0011\u0017mY6f]\u0012\u0004RAS(R/jk\u0011a\u0013\u0006\u0003\u00196\u000baa\u00197jK:$(\"\u0001(\u0002\tM$H\u000f]\u0005\u0003!.\u00131b\u0015;ua\n\u000b7m[3oIB\u0011!+V\u0007\u0002'*\u0011A\u000bK\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001,T\u0005\u00191U\u000f^;sKB\u0011q\u0005W\u0005\u00033\"\u0012qAT8uQ&tw\r\u0005\u0002\\E:\u0011A\f\u0019\b\u0003;~s!\u0001\u00110\n\u00039K!\u0001T'\n\u0005\u0005\\\u0015a\u00029bG.\fw-Z\u0005\u0003G\u0012\u0014\u0001BT8uQ&tw\r\u0016\u0006\u0003C.\u000ba\u0001P5oSRtDcA4kWR\u0011\u0001.\u001b\t\u0003s\u0001AQ\u0001\u0013\u0003A\u0004%CQA\u000e\u0003A\u0002aBq\u0001\u0010\u0003\u0011\u0002\u0003\u0007Q(\u0001\u0007j]\u001adW\u000f_\"mS\u0016tG/F\u0001o!\tIt.\u0003\u0002q7\t\u00112+[7qY\u0016LeN\u001a7vq\u000ec\u0017.\u001a8u\u00035IgN\u001a7vq\u000ec\u0017.\u001a8uA\u0005)\u0011/^3ssR1Ao_?\u0000\u00033\u00012AU+v!\u0011qd/\u0010=\n\u0005]<%aA'baB\u0011q%_\u0005\u0003u\"\u0012A\u0001T8oO\")Ap\u0002a\u0001{\u0005Y\u0001O]8dKN\u001ch*Y7f\u0011\u0015qx\u00011\u0001>\u0003)iW\r\u001e:jG:\u000bW.\u001a\u0005\b\u0003\u00039\u0001\u0019AA\u0002\u0003!!\u0017\r^3Ge>l\u0007#B\u0014\u0002\u0006\u0005%\u0011bAA\u0004Q\t1q\n\u001d;j_:\u0004B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0003uS6,'BAA\n\u0003\u0011Q\u0017M^1\n\t\u0005]\u0011Q\u0002\u0002\u000e\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000f\u0005mq\u00011\u0001\u0002\n\u00051A-\u0019;f)>\fa\u0002Z3uK\u000e$(+Z:uCJ$8\u000f\u0006\u0005\u0002\"\u0005M\u0012QGA\u001c!\u0011\u0011V+a\t\u0011\r\u0005\u0015\u0012QFA\u0005\u001d\u0011\t9#a\u000b\u000f\u0007\u0001\u000bI#C\u0001*\u0013\t\t\u0007&\u0003\u0003\u00020\u0005E\"\u0001\u0002'jgRT!!\u0019\u0015\t\u000bqD\u0001\u0019A\u001f\t\u000f\u0005\u0005\u0001\u00021\u0001\u0002\n!9\u00111\u0004\u0005A\u0002\u0005%\u0011\u0001\b:fC\u0012\u0014Vm\u001d;beR\u001chI]8n'>,(oY3D_VtGo\u001d\u000b\u0005\u0003G\ti\u0004C\u0004\u0002@%\u0001\r!!\u0011\u0002\u0019M|WO]2f\u0007>,h\u000e^:\u0011\u0007e\n\u0019%C\u0002\u0002Fm\u00111\"\u00138gYVD8+\u001a:jK\u0006y\u0001/\u0019:tK&sg\r\\;y\t\u0006$X\r\u0006\u0003\u0002\n\u0005-\u0003BBA'\u0015\u0001\u0007Q(\u0001\u0003eCR,\u0017!B2m_N,GCAA*!\r9\u0013QK\u0005\u0004\u0003/B#\u0001B+oSR\fq\"\u00138gYVDx)\u001a8fe\u0006$xN\u001d\t\u0003s5\u0019\"!\u0004\u0014\u0015\u0005\u0005m\u0013A\u0004;p\u000bB|7\r[*fG>tGm\u001d\u000b\u0004q\u0006\u0015\u0004bBA4\u001f\u0001\u0007\u0011\u0011B\u0001\u0002I\n\u0001\u0002k\\5oi&sG+[7f#V,'/_\n\u0004!\u0019b\u0003CB\u0014\u0002pu\n\u0019(C\u0002\u0002r!\u0012\u0011BR;oGRLwN\\\u0019\u0011\tI+\u0016Q\u000f\t\u0007\u0003K\ti#!\u0011\u0002\u0005\u0015\u001c\u0007c\u0001*\u0002|%\u0019\u0011QP*\u0003!\u0015CXmY;uS>t7i\u001c8uKb$HCCAA\u0003\u0013\u000bY)!$\u0002\u0010R!\u00111QAD!\r\t)\tE\u0007\u0002\u001b!9\u0011q\u000f\fA\u0004\u0005e\u0004B\u0002:\u0017\u0001\u0004\ti\u0007C\u0003}-\u0001\u0007Q\bC\u0003\u007f-\u0001\u0007Q\bC\u0003=-\u0001\u0007Q\bF\u0002u\u0003'Cq!!\u0014\u0018\u0001\u0004\tI!\u0001\u0014sKR\u0014\u0018.\u001a<f\u001f:d\u0017PU3tk2$hI]8n\u0003\u000e$\u0018n\u001c8WC2,X-U;fef$2\u0001^AM\u0011\u0019\tY\n\u0007a\u0001{\u0005Y\u0011/^3ssN#(/\u001b8h\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0015\u0016\u0004{\u0005\r6FAAS!\u0011\t9+!-\u000e\u0005\u0005%&\u0002BAV\u0003[\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=\u0006&\u0001\u0006b]:|G/\u0019;j_:LA!a-\u0002*\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class InfluxGenerator
implements LazyLogging {
    private final String env;
    private final SimpleInfluxClient influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static String $lessinit$greater$default$2() {
        return InfluxGenerator$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private SimpleInfluxClient influxClient() {
        return this.influxClient;
    }

    public Future<Map<String, Object>> query(String processName, String metricName, Option<LocalDateTime> dateFrom, LocalDateTime dateTo) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1<String, Future<List<InfluxSerie>>>)(Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2, ExecutionContext.Implicits$.MODULE$.global()), processName, metricName, this.env, ExecutionContext.Implicits$.MODULE$.global());
        return pointInTimeQuery.query(dateTo).flatMap((Function1 & Serializable & scala.Serializable)valuesAtEnd -> ((Future)dateFrom.map((Function1 & Serializable & scala.Serializable)date -> pointInTimeQuery.query((LocalDateTime)date)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            long value = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<List<LocalDateTime>> detectRestarts(String processName, LocalDateTime dateFrom, LocalDateTime dateTo) {
        long from = InfluxGenerator$.MODULE$.toEpochSeconds(dateFrom);
        long to = InfluxGenerator$.MODULE$.toEpochSeconds(dateTo);
        String queryString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(140).append("SELECT derivative(value) FROM \"source.count\" WHERE\n         |\"process\" = '").append(processName).append("' AND env = '").append(this.env).append("'\n         | AND time >= ").append(from).append("s and time < ").append(to).append("s GROUP BY slot").toString())).stripMargin();
        return this.influxClient().query(queryString, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)series -> (List)series.headOption().map((Function1 & Serializable & scala.Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSerie)sourceCounts)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), ExecutionContext.Implicits$.MODULE$.global());
    }

    /*
     * WARNING - void declaration
     */
    private List<LocalDateTime> readRestartsFromSourceCounts(InfluxSerie sourceCounts) {
        void var2_2;
        List restarts = (List)sourceCounts.values().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.tl$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.tl$access$1();
                            if (derivative instanceof BigDecimal) {
                                BigDecimal bigDecimal = (BigDecimal)derivative;
                                if (Nil$.MODULE$.equals(list2) && bigDecimal.$less((Object)BigDecimal$.MODULE$.int2bigDecimal(0))) {
                                    object = this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                                    return (B1)object;
                                }
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                Object date = colon2.head();
                List list2 = colon2.tl$access$1();
                if (!(date instanceof String)) return false;
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                Object derivative = colon3.head();
                List list3 = colon3.tl$access$1();
                if (!(derivative instanceof BigDecimal)) return false;
                BigDecimal bigDecimal = (BigDecimal)derivative;
                if (!Nil$.MODULE$.equals(list3)) return false;
                if (!bigDecimal.$less((Object)BigDecimal$.MODULE$.int2bigDecimal(0))) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return var2_2;
    }

    public LocalDateTime pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public void close() {
        this.influxClient().close();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<Future, Nothing$, ?> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.influxClient = new SimpleInfluxClient(config, backend);
    }

    public static class PointInTimeQuery
    implements LazyLogging {
        private final Function1<String, Future<List<InfluxSerie>>> query;
        private final String processName;
        private final String metricName;
        private final String env;
        private final ExecutionContext ec;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
        }

        public Future<Map<String, Object>> query(LocalDateTime date) {
            long around = InfluxGenerator$.MODULE$.toEpochSeconds(date);
            return this.retrieveOnlyResultFromActionValueQuery(new StringBuilder(135).append("select action, last(value) as value from \"").append(this.metricName).append(".count\" where process = '").append(this.processName).append("' ").append("and time <= ").append(around).append("s and time > ").append(around).append("s - 1h and env = '").append(this.env).append("' group by slot, action").toString()).flatMap((Function1 & Serializable & scala.Serializable)valuesBefore -> this.retrieveOnlyResultFromActionValueQuery(new StringBuilder(136).append("select action, first(value) as value from \"").append($this.metricName).append(".count\" where process = '").append($this.processName).append("' ").append("and time >= ").append(around).append("s and time < ").append(around).append("s + 1h and env = '").append($this.env).append("' group by slot, action").toString()).map((Function1 & Serializable & scala.Serializable)valuesAfter -> valuesBefore.$plus$plus((GenTraversableOnce)valuesAfter), $this.ec), this.ec);
        }

        /*
         * WARNING - void declaration
         */
        public Future<Map<String, Object>> retrieveOnlyResultFromActionValueQuery(String queryString) {
            void var2_2;
            Future groupedResults = ((Future)this.query.apply((Object)queryString)).map((Function1 & Serializable & scala.Serializable)seriesList -> ((TraversableLike)seriesList.map((Function1 & Serializable & scala.Serializable)oneSeries -> {
                Map firstResult = (Map)oneSeries.toMap().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                return new Tuple2((Object)((String)firstResult.getOrElse((Object)"action", (Function0 & Serializable & scala.Serializable)() -> "UNKNOWN")), (Object)BoxesRunTime.boxToLong((long)((Number)firstResult.getOrElse((Object)"value", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)).longValue()));
            }, List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1()).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)PointInTimeQuery.$anonfun$retrieveOnlyResultFromActionValueQuery$7(x$2))), this.ec);
            groupedResults.foreach((Function1 & Serializable & scala.Serializable)evaluated -> {
                PointInTimeQuery.$anonfun$retrieveOnlyResultFromActionValueQuery$9(this, queryString, evaluated);
                return BoxedUnit.UNIT;
            }, this.ec);
            return var2_2;
        }

        public static final /* synthetic */ long $anonfun$retrieveOnlyResultFromActionValueQuery$7(List x$2) {
            return BoxesRunTime.unboxToLong((Object)((TraversableOnce)x$2.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._2$mcJ$sp()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }

        public static final /* synthetic */ void $anonfun$retrieveOnlyResultFromActionValueQuery$9(PointInTimeQuery $this, String queryString$1, Map evaluated) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Query: {} retrieved grouped results: {}", new Object[]{queryString$1, evaluated});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        public PointInTimeQuery(Function1<String, Future<List<InfluxSerie>>> query2, String processName, String metricName, String env, ExecutionContext ec) {
            this.query = query2;
            this.processName = processName;
            this.metricName = metricName;
            this.env = env;
            this.ec = ec;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

