/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.CannotFetchCountsError;
import pl.touk.nussknacker.processCounts.CountsReporter;
import pl.touk.nussknacker.processCounts.CountsRequest;
import pl.touk.nussknacker.processCounts.ExecutionCount;
import pl.touk.nussknacker.processCounts.RangeCount;
import pl.touk.nussknacker.processCounts.influxdb.InfluxBaseCountsReporter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0007\u000f\u0001eA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003-!\bC\u0003X\u0001\u0011\u0005\u0001\fC\u0004_\u0001\t\u0007I\u0011B0\t\r!\u0004\u0001\u0015!\u0003a\u0011\u001dI\u0007A1A\u0005\n)DaA\u001c\u0001!\u0002\u0013Y\u0007\"B8\u0001\t\u0003\u0002\bbBA\t\u0001\u0011%\u00111\u0003\u0005\b\u0003W\u0001A\u0011BA\u0017\u0011\u001d\tY\u0004\u0001C!\u0003{\u0011A#\u00138gYVD8i\\;oiN\u0014V\r]8si\u0016\u0014(BA\b\u0011\u0003!IgN\u001a7vq\u0012\u0014'BA\t\u0013\u00035\u0001(o\\2fgN\u001cu.\u001e8ug*\u00111\u0003F\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u0016-\u0005!Ao\\;l\u0015\u00059\u0012A\u00019m\u0007\u0001\u00192\u0001\u0001\u000e#!\tY\u0002%D\u0001\u001d\u0015\tib$\u0001\u0003mC:<'\"A\u0010\u0002\t)\fg/Y\u0005\u0003Cq\u0011aa\u00142kK\u000e$\bCA\u0012%\u001b\u0005\u0001\u0012BA\u0013\u0011\u00059\u0019u.\u001e8ugJ+\u0007o\u001c:uKJ\f1!\u001a8w!\tA\u0013G\u0004\u0002*_A\u0011!&L\u0007\u0002W)\u0011A\u0006G\u0001\u0007yI|w\u000e\u001e \u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003a5\naaY8oM&<\u0007C\u0001\u001c8\u001b\u0005q\u0011B\u0001\u001d\u000f\u00051IeN\u001a7vq\u000e{gNZ5h\u0003\u001d\u0011\u0017mY6f]\u0012\u0004Ra\u000f!C\u00112k\u0011\u0001\u0010\u0006\u0003{y\naa\u00197jK:$(\"A \u0002\tM$H\u000f]\u0005\u0003\u0003r\u00121b\u0015;ua\n\u000b7m[3oIB\u00111IR\u0007\u0002\t*\u0011Q)L\u0001\u000bG>t7-\u001e:sK:$\u0018BA$E\u0005\u00191U\u000f^;sKB\u0011\u0011JS\u0007\u0002[%\u00111*\f\u0002\b\u001d>$\b.\u001b8h!\tiEK\u0004\u0002O%:\u0011q*\u0015\b\u0003UAK\u0011aP\u0005\u0003{yJ!a\u0015\u001f\u0002\u000fA\f7m[1hK&\u0011QK\u0016\u0002\t\u001d>$\b.\u001b8h)*\u00111\u000bP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007ecV\f\u0006\u0002[7B\u0011a\u0007\u0001\u0005\u0006s\u0011\u0001\u001dA\u000f\u0005\u0006M\u0011\u0001\ra\n\u0005\u0006i\u0011\u0001\r!N\u0001\u0012I\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014X#\u00011\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017A\u00024pe6\fGO\u0003\u0002f=\u0005!A/[7f\u0013\t9'MA\tECR,G+[7f\r>\u0014X.\u0019;uKJ\f!\u0003Z1uKRKW.\u001a$pe6\fG\u000f^3sA\u0005\u0011\u0012N\u001c4mkb\u0014\u0015m]3SKB|'\u000f^3s+\u0005Y\u0007C\u0001\u001cm\u0013\tigB\u0001\rJ]\u001adW\u000f\u001f\"bg\u0016\u001cu.\u001e8ugJ+\u0007o\u001c:uKJ\f1#\u001b8gYVD()Y:f%\u0016\u0004xN\u001d;fe\u0002\n\u0001\u0003\u001d:fa\u0006\u0014XMU1x\u0007>,h\u000e^:\u0015\u000bE\f\u0019!a\u0002\u0015\u0005Id\bcA\"GgB!\u0011\n^\u0014w\u0013\t)XFA\u0005Gk:\u001cG/[8ocA\u0019\u0011j^=\n\u0005al#AB(qi&|g\u000e\u0005\u0002Ju&\u001110\f\u0002\u0005\u0019>tw\rC\u0003~\u0013\u0001\u000fa0\u0001\u0002fGB\u00111i`\u0005\u0004\u0003\u0003!%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0019\t)!\u0003a\u0001O\u0005I\u0001O]8dKN\u001c\u0018\n\u001a\u0005\b\u0003\u0013I\u0001\u0019AA\u0006\u00035\u0019w.\u001e8ugJ+\u0017/^3tiB\u00191%!\u0004\n\u0007\u0005=\u0001CA\u0007D_VtGo\u001d*fcV,7\u000f^\u0001\u0013aJ,\u0007/\u0019:f%\u0006tw-Z\"pk:$8\u000f\u0006\u0005\u0002\u0016\u0005e\u00111DA\u0014)\r\u0011\u0018q\u0003\u0005\u0006{*\u0001\u001dA \u0005\u0007\u0003\u000bQ\u0001\u0019A\u0014\t\u000f\u0005u!\u00021\u0001\u0002 \u0005AaM]8n\t\u0006$X\r\u0005\u0003\u0002\"\u0005\rR\"\u00013\n\u0007\u0005\u0015BMA\u0007M_\u000e\fG\u000eR1uKRKW.\u001a\u0005\b\u0003SQ\u0001\u0019AA\u0010\u0003\u0019!x\u000eR1uK\u0006Y\u0011/^3ss&sg\r\\;y)!\ty#a\r\u00026\u0005eBc\u0001:\u00022!)Qp\u0003a\u0002}\"1\u0011QA\u0006A\u0002\u001dBq!!\b\f\u0001\u0004\t9\u0004\u0005\u0003Jo\u0006}\u0001bBA\u0015\u0017\u0001\u0007\u0011qD\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u007f\u00012!SA!\u0013\r\t\u0019%\f\u0002\u0005+:LG\u000f")
public class InfluxCountsReporter
implements CountsReporter {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final InfluxBaseCountsReporter influxBaseReporter;

    private DateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    private InfluxBaseCountsReporter influxBaseReporter() {
        return this.influxBaseReporter;
    }

    @Override
    public Future<Function1<String, Option<Object>>> prepareRawCounts(String processId, CountsRequest countsRequest, ExecutionContext ec) {
        Future<Function1<String, Option<Object>>> future;
        CountsRequest countsRequest2 = countsRequest;
        if (countsRequest2 instanceof RangeCount) {
            RangeCount rangeCount = (RangeCount)countsRequest2;
            LocalDateTime fromDate = rangeCount.fromDate();
            LocalDateTime toDate = rangeCount.toDate();
            future = this.prepareRangeCounts(processId, fromDate, toDate, ec);
        } else if (countsRequest2 instanceof ExecutionCount) {
            ExecutionCount executionCount = (ExecutionCount)countsRequest2;
            LocalDateTime pointInTime = executionCount.pointInTime();
            future = this.queryInflux(processId, (Option<LocalDateTime>)None$.MODULE$, pointInTime, ec);
        } else {
            throw new MatchError((Object)countsRequest2);
        }
        return future;
    }

    private Future<Function1<String, Option<Object>>> prepareRangeCounts(String processId, LocalDateTime fromDate, LocalDateTime toDate, ExecutionContext ec) {
        return this.influxBaseReporter().detectRestarts(processId, fromDate, toDate).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list = x0$1;
            Future future = Nil$.MODULE$.equals(list) ? this.queryInflux(processId, (Option<LocalDateTime>)new Some((Object)fromDate), toDate, ec) : Future$.MODULE$.failed((Throwable)new CannotFetchCountsError(new StringBuilder(75).append("Counts unavailable, as process was restarted/deployed on ").append(" following dates: ").append(((TraversableOnce)list.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.format(this.dateTimeFormatter()), List$.MODULE$.canBuildFrom())).mkString(", ")).toString()));
            return future;
        }, ec);
    }

    private Future<Function1<String, Option<Object>>> queryInflux(String processId, Option<LocalDateTime> fromDate, LocalDateTime toDate, ExecutionContext ec) {
        return this.influxBaseReporter().fetchBaseProcessCounts(processId, fromDate, toDate).map((Function1 & Serializable & scala.Serializable)pbc -> (Function1 & Serializable & scala.Serializable)nodeId -> pbc.getCountForNodeId((String)nodeId), ec);
    }

    @Override
    public void close() {
        this.influxBaseReporter().influxGenerator().close();
    }

    public InfluxCountsReporter(String env, InfluxConfig config, SttpBackend<Future, Nothing$, ?> backend) {
        this.influxBaseReporter = new InfluxBaseCountsReporter(env, config, backend);
    }
}

