/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSerie;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!\u0002\u000e\u001c\u0001m)\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006Y!\u0013\u0005\u0006K\u0002!\tA\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019\t\b\u0001)A\u0005]\")!\u000f\u0001C\u0001g\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA \u0001\u0011%\u0011\u0011\t\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\t)\u0006\u0001C\u0001\u0003/:\u0001\"a\u0018\u001c\u0011\u0003Y\u0012\u0011\r\u0004\b5mA\taGA2\u0011\u0019)W\u0002\"\u0001\u0002f!A\u0011qM\u0007\u0005\u0002m\tIG\u0002\u0004\u0002p5\u0001\u0011\u0011\u000f\u0005\neB\u0011\t\u0011)A\u0005\u0003gB\u0001\u0002 \t\u0003\u0002\u0003\u0006I!\u0010\u0005\tyA\u0011\t\u0011)A\u0005{!Ia\u0007\u0005B\u0001B\u0003%\u00111\u0004\u0005\u000b\u0003{\u0002\"\u0011!Q\u0001\f\u0005}\u0004BB3\u0011\t\u0003\t)\t\u0003\u0004s!\u0011\u0005\u0011q\u0013\u0005\b\u00037\u0003B\u0011AAO\u0011%\t\u0019+DI\u0001\n\u0003\t)KA\bJ]\u001adW\u000f_$f]\u0016\u0014\u0018\r^8s\u0015\taR$\u0001\u0005j]\u001adW\u000f\u001f3c\u0015\tqr$A\u0007qe>\u001cWm]:D_VtGo\u001d\u0006\u0003A\u0005\n1B\\;tg.t\u0017mY6fe*\u0011!eI\u0001\u0005i>,8NC\u0001%\u0003\t\u0001HnE\u0002\u0001M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u00175\u001b\u0005q#BA\u00181\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\t$'\u0001\u0005usB,7/\u00194f\u0015\u0005\u0019\u0014aA2p[&\u0011QG\f\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004d_:4\u0017nZ\u0002\u0001!\tI$(D\u0001\u001c\u0013\tY4D\u0001\u0007J]\u001adW\u000f_\"p]\u001aLw-A\u0002f]Z\u0004\"AP#\u000f\u0005}\u001a\u0005C\u0001!)\u001b\u0005\t%B\u0001\"8\u0003\u0019a$o\\8u}%\u0011A\tK\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002EQ\u00059!-Y2lK:$\u0007#\u0002&P#^SV\"A&\u000b\u00051k\u0015AB2mS\u0016tGOC\u0001O\u0003\u0011\u0019H\u000f\u001e9\n\u0005A[%aC*uiB\u0014\u0015mY6f]\u0012\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u0015\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002W'\n1a)\u001e;ve\u0016\u0004\"a\n-\n\u0005eC#a\u0002(pi\"Lgn\u001a\t\u00037\nt!\u0001\u00181\u000f\u0005u{fB\u0001!_\u0013\u0005q\u0015B\u0001'N\u0013\t\t7*A\u0004qC\u000e\\\u0017mZ3\n\u0005\r$'\u0001\u0003(pi\"Lgn\u001a+\u000b\u0005\u0005\\\u0015A\u0002\u001fj]&$h\bF\u0002hU.$\"\u0001[5\u0011\u0005e\u0002\u0001\"\u0002%\u0005\u0001\bI\u0005\"\u0002\u001c\u0005\u0001\u0004A\u0004b\u0002\u001f\u0005!\u0003\u0005\r!P\u0001\rS:4G.\u001e=DY&,g\u000e^\u000b\u0002]B\u0011\u0011h\\\u0005\u0003an\u0011!cU5na2,\u0017J\u001c4mkb\u001cE.[3oi\u0006i\u0011N\u001c4mkb\u001cE.[3oi\u0002\nQ!];fef$r\u0001^>~\u0003+\tI\u0002E\u0002S+V\u0004BA\u0010<>q&\u0011qo\u0012\u0002\u0004\u001b\u0006\u0004\bCA\u0014z\u0013\tQ\bF\u0001\u0003M_:<\u0007\"\u0002?\b\u0001\u0004i\u0014a\u00039s_\u000e,7o\u001d(b[\u0016DQA`\u0004A\u0002}\f\u0001\u0002Z1uK\u001a\u0013x.\u001c\t\u0006O\u0005\u0005\u0011QA\u0005\u0004\u0003\u0007A#AB(qi&|g\u000e\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\tQLW.\u001a\u0006\u0003\u0003\u001f\tAA[1wC&!\u00111CA\u0005\u00055aunY1m\t\u0006$X\rV5nK\"9\u0011qC\u0004A\u0002\u0005\u0015\u0011A\u00023bi\u0016$v\u000e\u0003\u00047\u000f\u0001\u0007\u00111\u0004\t\u0004s\u0005u\u0011bAA\u00107\tiQ*\u001a;sS\u000e\u001c8i\u001c8gS\u001e\fa\u0002Z3uK\u000e$(+Z:uCJ$8\u000f\u0006\u0006\u0002&\u0005]\u0012\u0011HA\u001e\u0003{\u0001BAU+\u0002(A1\u0011\u0011FA\u0019\u0003\u000bqA!a\u000b\u000209\u0019\u0001)!\f\n\u0003%J!!\u0019\u0015\n\t\u0005M\u0012Q\u0007\u0002\u0005\u0019&\u001cHO\u0003\u0002bQ!)A\u0010\u0003a\u0001{!1a\u0010\u0003a\u0001\u0003\u000bAq!a\u0006\t\u0001\u0004\t)\u0001\u0003\u00047\u0011\u0001\u0007\u00111D\u0001\u001de\u0016\fGMU3ti\u0006\u0014Ho\u001d$s_6\u001cv.\u001e:dK\u000e{WO\u001c;t)\u0011\t9#a\u0011\t\u000f\u0005\u0015\u0013\u00021\u0001\u0002H\u0005a1o\\;sG\u0016\u001cu.\u001e8ugB\u0019\u0011(!\u0013\n\u0007\u0005-3DA\u0006J]\u001adW\u000f_*fe&,\u0017a\u00049beN,\u0017J\u001c4mkb$\u0015\r^3\u0015\t\u0005\u0015\u0011\u0011\u000b\u0005\u0007\u0003'R\u0001\u0019A\u001f\u0002\t\u0011\fG/Z\u0001\u0006G2|7/\u001a\u000b\u0003\u00033\u00022aJA.\u0013\r\ti\u0006\u000b\u0002\u0005+:LG/A\bJ]\u001adW\u000f_$f]\u0016\u0014\u0018\r^8s!\tITb\u0005\u0002\u000eMQ\u0011\u0011\u0011M\u0001\u000fi>,\u0005o\\2i'\u0016\u001cwN\u001c3t)\rA\u00181\u000e\u0005\b\u0003[z\u0001\u0019AA\u0003\u0003\u0005!'\u0001\u0005)pS:$\u0018J\u001c+j[\u0016\fV/\u001a:z'\r\u0001b\u0005\f\t\u0007O\u0005UT(!\u001f\n\u0007\u0005]\u0004FA\u0005Gk:\u001cG/[8ocA!!+VA>!\u0019\tI#!\r\u0002H\u0005\u0011Qm\u0019\t\u0004%\u0006\u0005\u0015bAAB'\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u000b\u000b\u0003\u000f\u000by)!%\u0002\u0014\u0006UE\u0003BAE\u0003\u001b\u00032!a#\u0011\u001b\u0005i\u0001bBA?-\u0001\u000f\u0011q\u0010\u0005\u0007eZ\u0001\r!a\u001d\t\u000bq4\u0002\u0019A\u001f\t\u000bq2\u0002\u0019A\u001f\t\rY2\u0002\u0019AA\u000e)\r!\u0018\u0011\u0014\u0005\b\u0003':\u0002\u0019AA\u0003\u0003\u0019\u0012X\r\u001e:jKZ,wJ\u001c7z%\u0016\u001cX\u000f\u001c;Ge>l\u0017i\u0019;j_:4\u0016\r\\;f#V,'/\u001f\u000b\u0004i\u0006}\u0005BBAQ1\u0001\u0007Q(A\u0006rk\u0016\u0014\u0018p\u0015;sS:<\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002(*\u001aQ(!+,\u0005\u0005-\u0006\u0003BAW\u0003ok!!a,\u000b\t\u0005E\u00161W\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!.)\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\u000byKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class InfluxGenerator
implements LazyLogging {
    private final String env;
    private final SimpleInfluxClient influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static String $lessinit$greater$default$2() {
        return InfluxGenerator$.MODULE$.$lessinit$greater$default$2();
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private SimpleInfluxClient influxClient() {
        return this.influxClient;
    }

    public Future<Map<String, Object>> query(String processName, Option<LocalDateTime> dateFrom, LocalDateTime dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1<String, Future<List<InfluxSerie>>>)(Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2, ExecutionContext.Implicits$.MODULE$.global()), processName, this.env, config, ExecutionContext.Implicits$.MODULE$.global());
        return pointInTimeQuery.query(dateTo).flatMap((Function1 & Serializable & scala.Serializable)valuesAtEnd -> ((Future)dateFrom.map((Function1 & Serializable & scala.Serializable)date -> pointInTimeQuery.query((LocalDateTime)date)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            long value = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<List<LocalDateTime>> detectRestarts(String processName, LocalDateTime dateFrom, LocalDateTime dateTo, MetricsConfig config) {
        long from = InfluxGenerator$.MODULE$.toEpochSeconds(dateFrom);
        long to = InfluxGenerator$.MODULE$.toEpochSeconds(dateTo);
        String queryString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("SELECT derivative(").append(config.countField()).append(") FROM \"").append(config.sourceCountMetric()).append("\" WHERE\n         | \"").append(config.processTag()).append("\" = '").append(processName).append("' AND ").append(config.envTag()).append(" = '").append(this.env).append("'\n         | AND time >= ").append(from).append("s and time < ").append(to).append("s GROUP BY ").append(config.slotTag()).toString())).stripMargin();
        return this.influxClient().query(queryString, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)series -> (List)series.headOption().map((Function1 & Serializable & scala.Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSerie)sourceCounts)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), ExecutionContext.Implicits$.MODULE$.global());
    }

    /*
     * WARNING - void declaration
     */
    private List<LocalDateTime> readRestartsFromSourceCounts(InfluxSerie sourceCounts) {
        void var2_2;
        List restarts = (List)sourceCounts.values().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.tl$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.tl$access$1();
                            if (derivative instanceof BigDecimal) {
                                BigDecimal bigDecimal = (BigDecimal)derivative;
                                if (Nil$.MODULE$.equals(list2) && bigDecimal.$less((Object)BigDecimal$.MODULE$.int2bigDecimal(0))) {
                                    object = this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                                    return (B1)object;
                                }
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                Object date = colon2.head();
                List list2 = colon2.tl$access$1();
                if (!(date instanceof String)) return false;
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                Object derivative = colon3.head();
                List list3 = colon3.tl$access$1();
                if (!(derivative instanceof BigDecimal)) return false;
                BigDecimal bigDecimal = (BigDecimal)derivative;
                if (!Nil$.MODULE$.equals(list3)) return false;
                if (!bigDecimal.$less((Object)BigDecimal$.MODULE$.int2bigDecimal(0))) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return var2_2;
    }

    public LocalDateTime pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public void close() {
        this.influxClient().close();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<Future, Nothing$, ?> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.influxClient = new SimpleInfluxClient(config, backend);
    }

    public static class PointInTimeQuery
    implements LazyLogging {
        private final Function1<String, Future<List<InfluxSerie>>> query;
        private final String processName;
        private final String env;
        private final MetricsConfig config;
        private final ExecutionContext ec;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
        }

        public Future<Map<String, Object>> query(LocalDateTime date) {
            long around = InfluxGenerator$.MODULE$.toEpochSeconds(date);
            return this.retrieveOnlyResultFromActionValueQuery(this.query$1(new StringBuilder(27).append("time <= ").append(around).append("s and time > ").append(around).append("s - 1h").toString(), "last")).flatMap((Function1 & Serializable & scala.Serializable)valuesBefore -> this.retrieveOnlyResultFromActionValueQuery(this.query$1(new StringBuilder(27).append("time >= ").append(around).append("s and time < ").append(around).append("s + 1h").toString(), "first")).map((Function1 & Serializable & scala.Serializable)valuesAfter -> valuesBefore.$plus$plus((GenTraversableOnce)valuesAfter), $this.ec), this.ec);
        }

        /*
         * WARNING - void declaration
         */
        public Future<Map<String, Object>> retrieveOnlyResultFromActionValueQuery(String queryString) {
            void var2_2;
            Future groupedResults = ((Future)this.query.apply((Object)queryString)).map((Function1 & Serializable & scala.Serializable)seriesList -> ((TraversableLike)seriesList.map((Function1 & Serializable & scala.Serializable)oneSeries -> {
                Map firstResult = (Map)oneSeries.toMap().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                return new Tuple2((Object)((String)firstResult.getOrElse((Object)"nodeId", (Function0 & Serializable & scala.Serializable)() -> "UNKNOWN")), (Object)BoxesRunTime.boxToLong((long)((Number)firstResult.getOrElse((Object)"count", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)).longValue()));
            }, List$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1()).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)PointInTimeQuery.$anonfun$retrieveOnlyResultFromActionValueQuery$7(x$2))), this.ec);
            groupedResults.foreach((Function1 & Serializable & scala.Serializable)evaluated -> {
                PointInTimeQuery.$anonfun$retrieveOnlyResultFromActionValueQuery$9(this, queryString, evaluated);
                return BoxedUnit.UNIT;
            }, this.ec);
            return var2_2;
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("select ").append(this.config.nodeIdTag()).append(" as nodeId, ").append(aggregateFunction).append("(").append(this.config.countField()).append(") as count\n           | from \"").append(this.config.nodeCountMetric()).append("\" where ").append(this.config.processTag()).append(" = '").append(this.processName).append("'\n           | and ").append(timeCondition).append(" and ").append(this.config.envTag()).append(" = '").append(this.env).append("' group by ").append(this.config.slotTag()).append(", ").append(this.config.nodeIdTag()).append(" fill(0)").toString())).stripMargin();
        }

        public static final /* synthetic */ long $anonfun$retrieveOnlyResultFromActionValueQuery$7(List x$2) {
            return BoxesRunTime.unboxToLong((Object)((TraversableOnce)x$2.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._2$mcJ$sp()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }

        public static final /* synthetic */ void $anonfun$retrieveOnlyResultFromActionValueQuery$9(PointInTimeQuery $this, String queryString$1, Map evaluated) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Query: {} retrieved grouped results: {}", new Object[]{queryString$1, evaluated});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        public PointInTimeQuery(Function1<String, Future<List<InfluxSerie>>> query2, String processName, String env, MetricsConfig config, ExecutionContext ec) {
            this.query = query2;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.ec = ec;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

