/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005mf!\u0002\u000e\u001c\u0001m)\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006Y!\u0013\u0005\u0006K\u0002!\tA\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019\t\b\u0001)A\u0005]\")!\u000f\u0001C\u0001g\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\tI\u0006\u0001C\u0005\u00037Bq!!\u0019\u0001\t\u0003\t\u0019gB\u0004\u0002lmA\t!!\u001c\u0007\riY\u0002\u0012AA8\u0011\u0019)g\u0002\"\u0001\u0002r!A\u00111\u000f\b\u0005\u0002m\t)\bC\u0004\u0002|9!\t!! \u0007\r\u0005}e\u0002AAQ\u0011)\tyI\u0005B\u0001B\u0003%\u0011\u0011\u0013\u0005\tyJ\u0011\t\u0011)A\u0005{!AAH\u0005B\u0001B\u0003%Q\bC\u00057%\t\u0005\t\u0015!\u0003\u0002\u001c!Q\u00111\u0011\n\u0003\u0002\u0003\u0006Y!!\"\t\r\u0015\u0014B\u0011AAR\u0011\u001d\t)L\u0005C\u0001\u0003o\u0013q\"\u00138gYVDx)\u001a8fe\u0006$xN\u001d\u0006\u00039u\t\u0001\"\u001b8gYVDHM\u0019\u0006\u0003=}\tQ\u0002\u001d:pG\u0016\u001c8oQ8v]R\u001c(B\u0001\u0011\"\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005\t\u001a\u0013\u0001\u0002;pk.T\u0011\u0001J\u0001\u0003a2\u001c2\u0001\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0019\te.\u001f*fMB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003cI\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002g\u0005\u00191m\\7\n\u0005Ur#a\u0003'bufdunZ4j]\u001e\faaY8oM&<7\u0001\u0001\t\u0003sij\u0011aG\u0005\u0003wm\u0011A\"\u00138gYVD8i\u001c8gS\u001e\f1!\u001a8w!\tqTI\u0004\u0002@\u0007B\u0011\u0001\tK\u0007\u0002\u0003*\u0011!iN\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011C\u0013A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001\u0012\u0015\u0002\u000f\t\f7m[3oIB)!jT)X56\t1J\u0003\u0002M\u001b\u000611\r\\5f]RT\u0011AT\u0001\u0005gR$\b/\u0003\u0002Q\u0017\nY1\u000b\u001e;q\u0005\u0006\u001c7.\u001a8e!\t\u0011V+D\u0001T\u0015\t!\u0006&\u0001\u0006d_:\u001cWO\u001d:f]RL!AV*\u0003\r\u0019+H/\u001e:f!\t9\u0003,\u0003\u0002ZQ\t9aj\u001c;iS:<\u0007CA.c\u001d\ta\u0006M\u0004\u0002^?:\u0011\u0001IX\u0005\u0002\u001d&\u0011A*T\u0005\u0003C.\u000bq\u0001]1dW\u0006<W-\u0003\u0002dI\nAaj\u001c;iS:<GK\u0003\u0002b\u0017\u00061A(\u001b8jiz\"2a\u001a6l)\tA\u0017\u000e\u0005\u0002:\u0001!)\u0001\n\u0002a\u0002\u0013\")a\u0007\u0002a\u0001q!)A\b\u0002a\u0001{\u0005a\u0011N\u001c4mkb\u001cE.[3oiV\ta\u000e\u0005\u0002:_&\u0011\u0001o\u0007\u0002\u0013'&l\u0007\u000f\\3J]\u001adW\u000f_\"mS\u0016tG/A\u0007j]\u001adW\u000f_\"mS\u0016tG\u000fI\u0001\u0018cV,'/\u001f\"z'&tw\r\\3ES\u001a4WM]3oG\u0016$r\u0001^>~\u0003+\tI\u0002E\u0002S+V\u0004BA\u0010<>q&\u0011qo\u0012\u0002\u0004\u001b\u0006\u0004\bCA\u0014z\u0013\tQ\bF\u0001\u0003M_:<\u0007\"\u0002?\b\u0001\u0004i\u0014a\u00039s_\u000e,7o\u001d(b[\u0016DQA`\u0004A\u0002}\f\u0001\u0002Z1uK\u001a\u0013x.\u001c\t\u0006O\u0005\u0005\u0011QA\u0005\u0004\u0003\u0007A#AB(qi&|g\u000e\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\tQLW.\u001a\u0006\u0003\u0003\u001f\tAA[1wC&!\u00111CA\u0005\u00055aunY1m\t\u0006$X\rV5nK\"9\u0011qC\u0004A\u0002\u0005\u0015\u0011A\u00023bi\u0016$v\u000e\u0003\u00047\u000f\u0001\u0007\u00111\u0004\t\u0004s\u0005u\u0011bAA\u00107\tiQ*\u001a;sS\u000e\u001c8i\u001c8gS\u001e\fq#];fef\u0014\u0015pU;n\u001f\u001a$\u0015N\u001a4fe\u0016t7-Z:\u0015\u0013Q\f)#a\n\u0002*\u0005-\u0002\"\u0002?\t\u0001\u0004i\u0004B\u0002@\t\u0001\u0004\t)\u0001C\u0004\u0002\u0018!\u0001\r!!\u0002\t\rYB\u0001\u0019AA\u000e\u00039!W\r^3diJ+7\u000f^1siN$\"\"!\r\u0002D\u0005\u0015\u0013qIA%!\u0011\u0011V+a\r\u0011\r\u0005U\u0012QHA\u0003\u001d\u0011\t9$a\u000f\u000f\u0007\u0001\u000bI$C\u0001*\u0013\t\t\u0007&\u0003\u0003\u0002@\u0005\u0005#\u0001\u0002'jgRT!!\u0019\u0015\t\u000bqL\u0001\u0019A\u001f\t\ryL\u0001\u0019AA\u0003\u0011\u001d\t9\"\u0003a\u0001\u0003\u000bAaAN\u0005A\u0002\u0005m\u0011\u0001\b:fC\u0012\u0014Vm\u001d;beR\u001chI]8n'>,(oY3D_VtGo\u001d\u000b\u0005\u0003g\ty\u0005C\u0004\u0002R)\u0001\r!a\u0015\u0002\u0019M|WO]2f\u0007>,h\u000e^:\u0011\u0007e\n)&C\u0002\u0002Xm\u0011A\"\u00138gYVD8+\u001a:jKN\fq\u0002]1sg\u0016LeN\u001a7vq\u0012\u000bG/\u001a\u000b\u0005\u0003\u000b\ti\u0006\u0003\u0004\u0002`-\u0001\r!P\u0001\u0005I\u0006$X-A\u0003dY>\u001cX\r\u0006\u0002\u0002fA\u0019q%a\u001a\n\u0007\u0005%\u0004F\u0001\u0003V]&$\u0018aD%oM2,\bpR3oKJ\fGo\u001c:\u0011\u0005er1c\u0001\b'YQ\u0011\u0011QN\u0001\u000fi>,\u0005o\\2i'\u0016\u001cwN\u001c3t)\rA\u0018q\u000f\u0005\b\u0003s\u0002\u0002\u0019AA\u0003\u0003\u0005!\u0017A\n:fiJLWM^3P]2L(+Z:vYR4%o\\7BGRLwN\u001c,bYV,\u0017+^3ssRA\u0011qPAF\u0003\u001b\u000bY\nF\u0002u\u0003\u0003Cq!a!\u0012\u0001\b\t))\u0001\u0002fGB\u0019!+a\"\n\u0007\u0005%5K\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"1a'\u0005a\u0001\u00037Aq!a$\u0012\u0001\u0004\t\t*A\u0006j]Z|7.Z)vKJL\bCB\u0014\u0002\u0014v\n9*C\u0002\u0002\u0016\"\u0012\u0011BR;oGRLwN\\\u0019\u0011\tI+\u0016\u0011\u0014\t\u0007\u0003k\ti$a\u0015\t\r\u0005u\u0015\u00031\u0001>\u0003-\tX/\u001a:z'R\u0014\u0018N\\4\u0003!A{\u0017N\u001c;J]RKW.Z)vKJL8c\u0001\n'YQQ\u0011QUAW\u0003_\u000b\t,a-\u0015\t\u0005\u001d\u00161\u0016\t\u0004\u0003S\u0013R\"\u0001\b\t\u000f\u0005\r\u0005\u0004q\u0001\u0002\u0006\"9\u0011q\u0012\rA\u0002\u0005E\u0005\"\u0002?\u0019\u0001\u0004i\u0004\"\u0002\u001f\u0019\u0001\u0004i\u0004B\u0002\u001c\u0019\u0001\u0004\tY\"A\u0003rk\u0016\u0014\u0018\u0010F\u0002u\u0003sCq!a\u0018\u001a\u0001\u0004\t)\u0001")
public class InfluxGenerator
implements LazyLogging {
    private final String env;
    private final SimpleInfluxClient influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Future<Map<String, Object>> retrieveOnlyResultFromActionValueQuery(MetricsConfig metricsConfig, Function1<String, Future<List<InfluxSeries>>> function1, String string, ExecutionContext executionContext) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(metricsConfig, function1, string, executionContext);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private SimpleInfluxClient influxClient() {
        return this.influxClient;
    }

    public Future<Map<String, Object>> queryBySingleDifference(String processName, Option<LocalDateTime> dateFrom, LocalDateTime dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1<String, Future<List<InfluxSeries>>>)(Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2, ExecutionContext.Implicits$.MODULE$.global()), processName, this.env, config, ExecutionContext.Implicits$.MODULE$.global());
        return pointInTimeQuery.query(dateTo).flatMap((Function1 & Serializable & scala.Serializable)valuesAtEnd -> ((Future)dateFrom.map((Function1 & Serializable & scala.Serializable)date -> pointInTimeQuery.query((LocalDateTime)date)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            long value = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<Map<String, Object>> queryBySumOfDifferences(String processName, LocalDateTime dateFrom, LocalDateTime dateTo, MetricsConfig config) {
        String query3 = new StringBuilder(173).append("select sum(diff) as count from (SELECT non_negative_difference(\"").append(config.countField()).append("\") AS diff\n     FROM \"").append(config.nodeCountMetric()).append("\"\n     WHERE ").append(config.envTag()).append(" = '").append(this.env).append("' AND ").append(config.processTag()).append(" = '").append(processName).append("'\n     AND time > ").append(InfluxGenerator$.MODULE$.toEpochSeconds(dateFrom)).append("s AND time < ").append(InfluxGenerator$.MODULE$.toEpochSeconds(dateTo)).append("s\n     GROUP BY ").append(config.nodeIdTag()).append(", ").append(config.slotTag()).append(") group by ").append(config.nodeIdTag()).toString();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1<String, Future<List<InfluxSeries>>>)(Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2, ExecutionContext.Implicits$.MODULE$.global()), query3, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<List<LocalDateTime>> detectRestarts(String processName, LocalDateTime dateFrom, LocalDateTime dateTo, MetricsConfig config) {
        long from = InfluxGenerator$.MODULE$.toEpochSeconds(dateFrom);
        long to = InfluxGenerator$.MODULE$.toEpochSeconds(dateTo);
        String queryString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("SELECT diff FROM (\n         |  SELECT difference(").append(config.countField()).append(") as diff FROM \"").append(config.sourceCountMetric()).append("\" WHERE\n         | \"").append(config.processTag()).append("\" = '").append(processName).append("' AND ").append(config.envTag()).append(" = '").append(this.env).append("'\n         | AND time >= ").append(from).append("s and time < ").append(to).append("s GROUP BY ").append(config.slotTag()).append(", ").append(config.nodeIdTag()).append(") where diff < 0 ").toString())).stripMargin();
        return this.influxClient().query(queryString, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)series -> (List)series.headOption().map((Function1 & Serializable & scala.Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), ExecutionContext.Implicits$.MODULE$.global());
    }

    /*
     * WARNING - void declaration
     */
    private List<LocalDateTime> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        void var2_2;
        List restarts = (List)sourceCounts.values().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.tl$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.tl$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                object = this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                Object date = colon2.head();
                List list2 = colon2.tl$access$1();
                if (!(date instanceof String)) return false;
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                Object derivative = colon3.head();
                List list3 = colon3.tl$access$1();
                if (!(derivative instanceof BigDecimal)) return false;
                if (!Nil$.MODULE$.equals(list3)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return var2_2;
    }

    public LocalDateTime pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public void close() {
        this.influxClient().close();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<Future, Nothing$, ?> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.influxClient = new SimpleInfluxClient(config, backend);
    }

    public static class PointInTimeQuery
    implements LazyLogging {
        private final Function1<String, Future<List<InfluxSeries>>> invokeQuery;
        private final String processName;
        private final String env;
        private final MetricsConfig config;
        private final ExecutionContext ec;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
        }

        public Future<Map<String, Object>> query(LocalDateTime date) {
            long around = InfluxGenerator$.MODULE$.toEpochSeconds(date);
            return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(this.config, this.invokeQuery, this.query$1(new StringBuilder(27).append("time <= ").append(around).append("s and time > ").append(around).append("s - 1h").toString(), "last"), this.ec).flatMap((Function1 & Serializable & scala.Serializable)valuesBefore -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1(new StringBuilder(27).append("time >= ").append(around).append("s and time < ").append(around).append("s + 1h").toString(), "first"), $this.ec).map((Function1 & Serializable & scala.Serializable)valuesAfter -> valuesBefore.$plus$plus((GenTraversableOnce)valuesAfter), $this.ec), this.ec);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("select ").append(this.config.nodeIdTag()).append(" as nodeId, ").append(aggregateFunction).append("(").append(this.config.countField()).append(") as count\n           | from \"").append(this.config.nodeCountMetric()).append("\" where ").append(this.config.processTag()).append(" = '").append(this.processName).append("'\n           | and ").append(timeCondition).append(" and ").append(this.config.envTag()).append(" = '").append(this.env).append("' group by ").append(this.config.slotTag()).append(", ").append(this.config.nodeIdTag()).append(" fill(0)").toString())).stripMargin();
        }

        public PointInTimeQuery(Function1<String, Future<List<InfluxSeries>>> invokeQuery, String processName, String env, MetricsConfig config, ExecutionContext ec) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.ec = ec;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

