/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.processCounts.CannotFetchCountsError$;
import pl.touk.nussknacker.processCounts.CountsReporter;
import pl.touk.nussknacker.processCounts.CountsRequest;
import pl.touk.nussknacker.processCounts.ExecutionCount;
import pl.touk.nussknacker.processCounts.RangeCount;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig$;
import pl.touk.nussknacker.processCounts.influxdb.QueryMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\u0007\u000e\u0001aA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A!\t\u0001B\u0001B\u0003-1\tC\u0003a\u0001\u0011\u0005\u0011\rC\u0004h\u0001\t\u0007I\u0011\u00015\t\r1\u0004\u0001\u0015!\u0003j\u0011\u001di\u0007A1A\u0005\n9DaA\u001d\u0001!\u0002\u0013y\u0007\"B:\u0001\t\u0003\"\bbBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003G\u0001A\u0011BA\u0013\u0005QIeN\u001a7vq\u000e{WO\u001c;t%\u0016\u0004xN\u001d;fe*\u0011abD\u0001\tS:4G.\u001e=eE*\u0011\u0001#E\u0001\u000eaJ|7-Z:t\u0007>,h\u000e^:\u000b\u0005I\u0019\u0012a\u00038vgN\\g.Y2lKJT!\u0001F\u000b\u0002\tQ|Wo\u001b\u0006\u0002-\u0005\u0011\u0001\u000f\\\u0002\u0001'\u0011\u0001\u0011$I\u0013\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012\u0001\u00027b]\u001eT\u0011AH\u0001\u0005U\u00064\u0018-\u0003\u0002!7\t1qJ\u00196fGR\u0004\"AI\u0012\u000e\u0003=I!\u0001J\b\u0003\u001d\r{WO\u001c;t%\u0016\u0004xN\u001d;feB\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003U-\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002Y\u0005\u00191m\\7\n\u00059:#a\u0003'bufdunZ4j]\u001e\f1!\u001a8w!\t\t$H\u0004\u00023qA\u00111GN\u0007\u0002i)\u0011QgF\u0001\u0007yI|w\u000e\u001e \u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0002\rA\u0013X\rZ3g\u0013\tYDH\u0001\u0004TiJLgn\u001a\u0006\u0003sY\naaY8oM&<\u0007CA A\u001b\u0005i\u0011BA!\u000e\u00051IeN\u001a7vq\u000e{gNZ5h\u0003\u001d\u0011\u0017mY6f]\u0012\u0004R\u0001R%L#Vk\u0011!\u0012\u0006\u0003\r\u001e\u000baa\u00197jK:$(\"\u0001%\u0002\tM$H\u000f]\u0005\u0003\u0015\u0016\u00131b\u0015;ua\n\u000b7m[3oIB\u0011AjT\u0007\u0002\u001b*\u0011aJN\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001)N\u0005\u00191U\u000f^;sKB\u0011!kU\u0007\u0002m%\u0011AK\u000e\u0002\b\u001d>$\b.\u001b8h!\t1VL\u0004\u0002X7:\u0011\u0001L\u0017\b\u0003geK\u0011\u0001S\u0005\u0003\r\u001eK!\u0001X#\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\t\u001d>$\b.\u001b8h)*\u0011A,R\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t,g\r\u0006\u0002dIB\u0011q\b\u0001\u0005\u0006\u0005\u0012\u0001\u001da\u0011\u0005\u0006_\u0011\u0001\r\u0001\r\u0005\u0006{\u0011\u0001\rAP\u0001\u0010S:4G.\u001e=HK:,'/\u0019;peV\t\u0011\u000e\u0005\u0002@U&\u00111.\u0004\u0002\u0010\u0013:4G.\u001e=HK:,'/\u0019;pe\u0006\u0001\u0012N\u001c4mkb<UM\\3sCR|'\u000fI\u0001\u000e[\u0016$(/[2t\u0007>tg-[4\u0016\u0003=\u0004\"a\u00109\n\u0005El!!D'fiJL7m]\"p]\u001aLw-\u0001\bnKR\u0014\u0018nY:D_:4\u0017n\u001a\u0011\u0002!A\u0014X\r]1sKJ\u000bwoQ8v]R\u001cH#B;\u0002\f\u0005=Ac\u0001<\u0002\u0002A\u0019AjT<\u0011\tIC\bG_\u0005\u0003sZ\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007I[X0\u0003\u0002}m\t1q\n\u001d;j_:\u0004\"A\u0015@\n\u0005}4$\u0001\u0002'p]\u001eDq!a\u0001\n\u0001\b\t)!\u0001\u0002fGB\u0019A*a\u0002\n\u0007\u0005%QJ\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"1\u0011QB\u0005A\u0002A\n\u0011\u0002\u001d:pG\u0016\u001c8/\u00133\t\u000f\u0005E\u0011\u00021\u0001\u0002\u0014\u0005i1m\\;oiN\u0014V-];fgR\u00042AIA\u000b\u0013\r\t9b\u0004\u0002\u000e\u0007>,h\u000e^:SKF,Xm\u001d;\u0002\u000b\rdwn]3\u0015\u0005\u0005u\u0001c\u0001*\u0002 %\u0019\u0011\u0011\u0005\u001c\u0003\tUs\u0017\u000e^\u0001\u0013aJ,\u0007/\u0019:f%\u0006tw-Z\"pk:$8\u000f\u0006\u0005\u0002(\u0005M\u0012QGA#)\u0011\tI#!\r\u0011\t1{\u00151\u0006\t\u0006c\u00055\u0002'`\u0005\u0004\u0003_a$aA'ba\"9\u00111A\u0006A\u0004\u0005\u0015\u0001BBA\u0007\u0017\u0001\u0007\u0001\u0007C\u0004\u00028-\u0001\r!!\u000f\u0002\u0011\u0019\u0014x.\u001c#bi\u0016\u0004B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007fi\u0012\u0001\u0002;j[\u0016LA!a\u0011\u0002>\t9\u0011J\\:uC:$\bbBA$\u0017\u0001\u0007\u0011\u0011H\u0001\u0007i>$\u0015\r^3")
public class InfluxCountsReporter
implements CountsReporter,
LazyLogging {
    private final InfluxConfig config;
    private final InfluxGenerator influxGenerator;
    private final MetricsConfig metricsConfig;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxCountsReporter influxCountsReporter = this;
        synchronized (influxCountsReporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public InfluxGenerator influxGenerator() {
        return this.influxGenerator;
    }

    private MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public Future<Function1<String, Option<Object>>> prepareRawCounts(String processId, CountsRequest countsRequest, ExecutionContext ec) {
        Future<Map<String, Object>> future;
        CountsRequest countsRequest2 = countsRequest;
        if (countsRequest2 instanceof RangeCount) {
            RangeCount rangeCount = (RangeCount)countsRequest2;
            Instant fromDate = rangeCount.fromDate();
            Instant toDate = rangeCount.toDate();
            future = this.prepareRangeCounts(processId, fromDate, toDate, ec);
        } else if (countsRequest2 instanceof ExecutionCount) {
            ExecutionCount executionCount = (ExecutionCount)countsRequest2;
            Instant pointInTime = executionCount.pointInTime();
            future = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)None$.MODULE$, pointInTime, this.metricsConfig());
        } else {
            throw new MatchError((Object)countsRequest2);
        }
        return future.map((Function1 & Serializable & scala.Serializable)x$1 -> (Function1 & Serializable & scala.Serializable)key -> x$1.get(key), ec);
    }

    @Override
    public void close() {
        this.influxGenerator().close();
    }

    private Future<Map<String, Object>> prepareRangeCounts(String processId, Instant fromDate, Instant toDate, ExecutionContext ec) {
        return this.influxGenerator().detectRestarts(processId, fromDate, toDate, this.metricsConfig()).flatMap((Function1 & Serializable & scala.Serializable)restarts -> {
            Tuple2 tuple2 = new Tuple2(restarts, (Object)$this.config.queryMode());
            if (tuple2 != null) {
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value2 = QueryMode$.MODULE$.OnlySumOfDifferences();
                Enumeration.Value value3 = value;
                if (value2 == null) {
                    if (value3 == null) return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                } else if (value2.equals(value3)) {
                    return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value4 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                    Enumeration.Value value5 = value;
                    if (value4 == null) {
                        if (value5 == null) return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    } else if (value4.equals(value5)) {
                        return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    }
                }
            }
            if (tuple2 != null) {
                List nonEmpty = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value6 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Restarts detected: {}, querying with differential", new Object[]{nonEmpty.mkString(",")});
                        boxedUnit = BoxedUnit.UNIT;
                        return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value8 = QueryMode$.MODULE$.OnlySingleDifference();
                    Enumeration.Value value9 = value;
                    if (value8 == null) {
                        if (value9 == null) return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    } else if (value8.equals(value9)) {
                        return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    }
                }
            }
            if (tuple2 == null) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(32).append("Unknown QueryMode ").append($this.config.queryMode()).append(" for ").append(restarts.size()).append(" restarts").toString()));
            List dates = (List)tuple2._1();
            Enumeration.Value value = (Enumeration.Value)tuple2._2();
            Enumeration.Value value10 = QueryMode$.MODULE$.OnlySingleDifference();
            Enumeration.Value value11 = value;
            if (value10 != null) {
                if (!value10.equals(value11)) return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(32).append("Unknown QueryMode ").append($this.config.queryMode()).append(" for ").append(restarts.size()).append(" restarts").toString()));
                return Future$.MODULE$.failed((Throwable)CannotFetchCountsError$.MODULE$.restartsDetected((List<Instant>)dates));
            }
            if (value11 == null) return Future$.MODULE$.failed((Throwable)CannotFetchCountsError$.MODULE$.restartsDetected((List<Instant>)dates));
            return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(32).append("Unknown QueryMode ").append($this.config.queryMode()).append(" for ").append(restarts.size()).append(" restarts").toString()));
        }, ec);
    }

    public InfluxCountsReporter(String env, InfluxConfig config, SttpBackend<Future, Nothing$, ?> backend) {
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
        this.influxGenerator = new InfluxGenerator(config, env, backend);
        this.metricsConfig = (MetricsConfig)config.metricsConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> new MetricsConfig(MetricsConfig$.MODULE$.apply$default$1(), MetricsConfig$.MODULE$.apply$default$2(), MetricsConfig$.MODULE$.apply$default$3(), MetricsConfig$.MODULE$.apply$default$4(), MetricsConfig$.MODULE$.apply$default$5(), MetricsConfig$.MODULE$.apply$default$6(), MetricsConfig$.MODULE$.apply$default$7()));
    }
}

