/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005=g!\u0002\u000e\u001c\u0001m)\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006YA\u0013\u0005\u0006A\u0002!\t!\u0019\u0005\bO\u0002\u0011\r\u0011b\u0003i\u0011\u0019y\u0007\u0001)A\u0005S\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bBB;\u0001A\u0003%!\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0003bBA2\u0001\u0011%\u0011QM\u0004\b\u0003WZ\u0002\u0012AA7\r\u0019Q2\u0004#\u0001\u0002p!1\u0001m\u0004C\u0001\u0003cBq!a\u001d\u0010\t\u0003\t)H\u0002\u0004\u0002 >\u0001\u0011\u0011\u0015\u0005\u000b\u0003\u001f\u0013\"\u0011!Q\u0001\n\u0005\u0015\u0006\"CA\u0001%\t\u0005\t\u0015!\u0003?\u0011!i$C!A!\u0002\u0013q\u0004\"C\u001c\u0013\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011)\tyK\u0005B\u0002B\u0003-\u0011\u0011\u0017\u0005\u0007AJ!\t!!.\t\u000f\u0005\u001d'\u0003\"\u0001\u0002J\ny\u0011J\u001c4mkb<UM\\3sCR|'O\u0003\u0002\u001d;\u0005A\u0011N\u001c4mkb$'M\u0003\u0002\u001f?\u0005i\u0001O]8dKN\u001c8i\\;oiNT!\u0001I\u0011\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003E\r\nA\u0001^8vW*\tA%\u0001\u0002qYV\u0011a\u0005V\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/k5\tqF\u0003\u00021c\u0005a1oY1mC2|wmZ5oO*\u0011!gM\u0001\tif\u0004Xm]1gK*\tA'A\u0002d_6L!AN\u0018\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0004\u0001A\u0011!hO\u0007\u00027%\u0011Ah\u0007\u0002\r\u0013:4G.\u001e=D_:4\u0017nZ\u0001\u0004K:4\bCA G\u001d\t\u0001E\t\u0005\u0002BS5\t!I\u0003\u0002Dq\u00051AH]8pizJ!!R\u0015\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000b&\nqAY1dW\u0016tG\r\u0005\u0003L!J[V\"\u0001'\u000b\u00055s\u0015aB2mS\u0016tGo\r\u0006\u0002\u001f\u0006!1\u000f\u001e;q\u0013\t\tFJA\u0006TiR\u0004()Y2lK:$\u0007CA*U\u0019\u0001!Q!\u0016\u0001C\u0002Y\u0013\u0011AR\u000b\u0003/z\u000b\"\u0001W.\u0011\u0005!J\u0016B\u0001.*\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u000b/\n\u0005uK#aA!os\u0012)q\f\u0016b\u0001/\n\tq,\u0001\u0004=S:LGO\u0010\u000b\u0004E\u00164GCA2e!\rQ\u0004A\u0015\u0005\u0006\u0013\u0012\u0001\u001dA\u0013\u0005\u0006o\u0011\u0001\r!\u000f\u0005\u0006{\u0011\u0001\rAP\u0001\u000b[>t\u0017\rZ#se>\u0014X#A5\u0011\u0007)l'+D\u0001l\u0015\tag*A\u0003n_:\fG-\u0003\u0002oW\nQQj\u001c8bI\u0016\u0013(o\u001c:\u0002\u00175|g.\u00193FeJ|'\u000fI\u0001\rS:4G.\u001e=DY&,g\u000e^\u000b\u0002eB\u0019!h\u001d*\n\u0005Q\\\"AE*j[BdW-\u00138gYVD8\t\\5f]R\fQ\"\u001b8gYVD8\t\\5f]R\u0004\u0013aF9vKJL()_*j]\u001edW\rR5gM\u0016\u0014XM\\2f)!Ax0a\u0001\u0002\u001e\u0005\u0005\u0002cA*UsB!qH\u001f }\u0013\tY\bJA\u0002NCB\u0004\"\u0001K?\n\u0005yL#\u0001\u0002'p]\u001eDa!!\u0001\n\u0001\u0004q\u0014a\u00039s_\u000e,7o\u001d(b[\u0016Dq!!\u0002\n\u0001\u0004\t9!\u0001\u0005eCR,gI]8n!\u0015A\u0013\u0011BA\u0007\u0013\r\tY!\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005!A/[7f\u0015\t\t9\"\u0001\u0003kCZ\f\u0017\u0002BA\u000e\u0003#\u0011q!\u00138ti\u0006tG\u000fC\u0004\u0002 %\u0001\r!!\u0004\u0002\r\u0011\fG/\u001a+p\u0011\u00199\u0014\u00021\u0001\u0002$A\u0019!(!\n\n\u0007\u0005\u001d2DA\u0007NKR\u0014\u0018nY:D_:4\u0017nZ\u0001\u0018cV,'/\u001f\"z'VlwJ\u001a#jM\u001a,'/\u001a8dKN$\u0012\u0002_A\u0017\u0003_\t\t$a\r\t\r\u0005\u0005!\u00021\u0001?\u0011\u001d\t)A\u0003a\u0001\u0003\u001bAq!a\b\u000b\u0001\u0004\ti\u0001\u0003\u00048\u0015\u0001\u0007\u00111E\u0001\u000fI\u0016$Xm\u0019;SKN$\u0018M\u001d;t))\tI$!\u0014\u0002P\u0005E\u00131\u000b\t\u0005'R\u000bY\u0004\u0005\u0004\u0002>\u0005\u001d\u0013Q\u0002\b\u0005\u0003\u007f\t\u0019ED\u0002B\u0003\u0003J\u0011AK\u0005\u0004\u0003\u000bJ\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\nYE\u0001\u0003MSN$(bAA#S!1\u0011\u0011A\u0006A\u0002yBq!!\u0002\f\u0001\u0004\ti\u0001C\u0004\u0002 -\u0001\r!!\u0004\t\r]Z\u0001\u0019AA\u0012\u0003q\u0011X-\u00193SKN$\u0018M\u001d;t\rJ|WnU8ve\u000e,7i\\;oiN$B!a\u000f\u0002Z!9\u00111\f\u0007A\u0002\u0005u\u0013\u0001D:pkJ\u001cWmQ8v]R\u001c\bc\u0001\u001e\u0002`%\u0019\u0011\u0011M\u000e\u0003\u0019%sg\r\\;y'\u0016\u0014\u0018.Z:\u0002\u001fA\f'o]3J]\u001adW\u000f\u001f#bi\u0016$B!!\u0004\u0002h!1\u0011\u0011N\u0007A\u0002y\nA\u0001Z1uK\u0006y\u0011J\u001c4mkb<UM\\3sCR|'\u000f\u0005\u0002;\u001fM\u0019qbJ\u0017\u0015\u0005\u00055\u0014A\n:fiJLWM^3P]2L(+Z:vYR4%o\\7BGRLwN\u001c,bYV,\u0017+^3ssV!\u0011qOA?)!\tI(a#\u0002\u000e\u0006mE\u0003BA>\u0003\u0007\u0003BaUA?s\u00121Q+\u0005b\u0001\u0003\u007f*2aVAA\t\u0019y\u0016Q\u0010b\u0001/\"I\u0011QQ\t\u0002\u0002\u0003\u000f\u0011qQ\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004\u0003\u00026n\u0003\u0013\u00032aUA?\u0011\u00199\u0014\u00031\u0001\u0002$!9\u0011qR\tA\u0002\u0005E\u0015aC5om>\\W-U;fef\u0004b\u0001KAJ}\u0005]\u0015bAAKS\tIa)\u001e8di&|g.\r\t\u0006'\u0006u\u0014\u0011\u0014\t\u0007\u0003{\t9%!\u0018\t\r\u0005u\u0015\u00031\u0001?\u0003-\tX/\u001a:z'R\u0014\u0018N\\4\u0003!A{\u0017N\u001c;J]RKW.Z)vKJLX\u0003BAR\u0003S\u001b2AE\u0014.!\u0019A\u00131\u0013 \u0002(B)1+!+\u0002\u001a\u00121QK\u0005b\u0001\u0003W+2aVAW\t\u0019y\u0016\u0011\u0016b\u0001/\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\t)l\u00171\u0017\t\u0004'\u0006%FCCA\\\u0003\u007f\u000b\t-a1\u0002FR!\u0011\u0011XA_!\u0015\tYLEAZ\u001b\u0005y\u0001bBAX1\u0001\u000f\u0011\u0011\u0017\u0005\b\u0003\u001fC\u0002\u0019AAS\u0011\u0019\t\t\u0001\u0007a\u0001}!)Q\b\u0007a\u0001}!1q\u0007\u0007a\u0001\u0003G\tQ!];fef$B!a3\u0002NB!1+!+z\u0011\u001d\tI'\u0007a\u0001\u0003\u001b\u0001")
public class InfluxGenerator<F>
implements LazyLogging {
    private final String env;
    private final MonadError<F> monadError;
    private final SimpleInfluxClient<F> influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <F> F retrieveOnlyResultFromActionValueQuery(MetricsConfig metricsConfig, Function1<String, F> function1, String string, MonadError<F> monadError) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(metricsConfig, function1, string, monadError);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private SimpleInfluxClient<F> influxClient() {
        return this.influxClient;
    }

    public F queryBySingleDifference(String processName, Option<Instant> dateFrom, Instant dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2), processName, this.env, config, this.monadError());
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> pointInTimeQuery.query(dateTo)).flatMap((Function1 & Serializable & scala.Serializable)valuesAtEnd -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> dateFrom.map((Function1 & Serializable & scala.Serializable)date -> pointInTimeQuery.query((Instant)date)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.monadError().unit((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            long value = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), this.monadError()), this.monadError());
    }

    public F queryBySumOfDifferences(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        String query3 = new StringBuilder(173).append("select sum(diff) as count from (SELECT non_negative_difference(\"").append(config.countField()).append("\") AS diff\n     FROM \"").append(config.nodeCountMetric()).append("\"\n     WHERE ").append(config.envTag()).append(" = '").append(this.env).append("' AND ").append(config.scenarioTag()).append(" = '").append(processName).append("'\n     AND time > ").append(dateFrom.getEpochSecond()).append("s AND time < ").append(dateTo.getEpochSecond()).append("s\n     GROUP BY ").append(config.nodeIdTag()).append(", ").append(config.additionalGroupByTags().mkString(",")).append(") group by ").append(config.nodeIdTag()).toString();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2), query3, this.monadError());
    }

    public F detectRestarts(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        long from = dateFrom.getEpochSecond();
        long to = dateTo.getEpochSecond();
        String queryString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("SELECT diff FROM (\n         |  SELECT difference(").append(config.countField()).append(") as diff FROM \"").append(config.sourceCountMetric()).append("\" WHERE\n         | \"").append(config.scenarioTag()).append("\" = '").append(processName).append("' AND ").append(config.envTag()).append(" = '").append(this.env).append("'\n         | AND time >= ").append(from).append("s and time < ").append(to).append("s GROUP BY ").append(config.additionalGroupByTags().mkString(",")).append(", ").append(config.nodeIdTag()).append(") where diff < 0 ").toString())).stripMargin();
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> this.influxClient().query(queryString)).map((Function1 & Serializable & scala.Serializable)series -> (List)series.headOption().map((Function1 & Serializable & scala.Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.monadError());
    }

    /*
     * WARNING - void declaration
     */
    private List<Instant> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        void var2_2;
        List restarts = (List)sourceCounts.values().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.tl$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.tl$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                object = this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                Object date = colon2.head();
                List list2 = colon2.tl$access$1();
                if (!(date instanceof String)) return false;
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                Object derivative = colon3.head();
                List list3 = colon3.tl$access$1();
                if (!(derivative instanceof BigDecimal)) return false;
                if (!Nil$.MODULE$.equals(list3)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return var2_2;
    }

    public Instant pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<F, Object> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.monadError = backend.responseMonad();
        this.influxClient = new SimpleInfluxClient<F>(config, backend);
    }

    public static class PointInTimeQuery<F>
    implements LazyLogging {
        private final Function1<String, F> invokeQuery;
        private final String processName;
        private final String env;
        private final MetricsConfig config;
        private final MonadError<F> evidence$2;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
        }

        public F query(Instant date) {
            long around = date.getEpochSecond();
            return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1(new StringBuilder(27).append("time <= ").append(around).append("s and time > ").append(around).append("s - 1h").toString(), "last"), $this.evidence$2)).flatMap((Function1 & Serializable & scala.Serializable)valuesBefore -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1(new StringBuilder(27).append("time >= ").append(around).append("s and time < ").append(around).append("s + 1h").toString(), "first"), $this.evidence$2)).map((Function1 & Serializable & scala.Serializable)valuesAfter -> valuesBefore.$plus$plus((GenTraversableOnce)valuesAfter), $this.evidence$2), this.evidence$2);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("select ").append(this.config.nodeIdTag()).append(" as nodeId, ").append(aggregateFunction).append("(").append(this.config.countField()).append(") as count\n           | from \"").append(this.config.nodeCountMetric()).append("\" where ").append(this.config.scenarioTag()).append(" = '").append(this.processName).append("'\n           | and ").append(timeCondition).append(" and ").append(this.config.envTag()).append(" = '").append(this.env).append("' group by ").append(this.config.additionalGroupByTags().mkString(",")).append(", ").append(this.config.nodeIdTag()).append(" fill(0)").toString())).stripMargin();
        }

        public PointInTimeQuery(Function1<String, F> invokeQuery, String processName, String env, MetricsConfig config, MonadError<F> evidence$2) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.evidence$2 = evidence$2;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

