/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.processCounts.CannotFetchCountsError$;
import pl.touk.nussknacker.processCounts.CountsReporter;
import pl.touk.nussknacker.processCounts.CountsRequest;
import pl.touk.nussknacker.processCounts.ExecutionCount;
import pl.touk.nussknacker.processCounts.RangeCount;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig$;
import pl.touk.nussknacker.processCounts.influxdb.QueryMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001\u0002\b\u0010\u0001iA\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"AA\u000b\u0001B\u0001B\u0003-Q\u000bC\u0003^\u0001\u0011\u0005a\fC\u0004e\u0001\t\u0007I\u0011B3\t\r%\u0004\u0001\u0015!\u0003g\u0011\u001dQ\u0007A1A\u0005\f-DaA\u001d\u0001!\u0002\u0013a\u0007bB:\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007q\u0002\u0001\u000b\u0011B;\t\u000be\u0004A\u0011\t>\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u00111\u0005\u0001\u0005\n\u0005\u0015\"\u0001F%oM2,\bpQ8v]R\u001c(+\u001a9peR,'O\u0003\u0002\u0011#\u0005A\u0011N\u001c4mkb$'M\u0003\u0002\u0013'\u0005i\u0001O]8dKN\u001c8i\\;oiNT!\u0001F\u000b\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003-]\tA\u0001^8vW*\t\u0001$\u0001\u0002qY\u000e\u0001QCA\u000e+'\u0011\u0001A\u0004J\u001d\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001\u00027b]\u001eT\u0011!I\u0001\u0005U\u00064\u0018-\u0003\u0002$=\t1qJ\u00196fGR\u00042!\n\u0014)\u001b\u0005\t\u0012BA\u0014\u0012\u00059\u0019u.\u001e8ugJ+\u0007o\u001c:uKJ\u0004\"!\u000b\u0016\r\u0001\u0011)1\u0006\u0001b\u0001Y\t\ta)\u0006\u0002.oE\u0011a\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\b\u001d>$\b.\u001b8h!\tyS'\u0003\u00027a\t\u0019\u0011I\\=\u0005\u000baR#\u0019A\u0017\u0003\u0003}\u0003\"AO!\u000e\u0003mR!\u0001P\u001f\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005yz\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0001\u000b1aY8n\u0013\t\u00115HA\u0006MCjLHj\\4hS:<\u0017aA3omB\u0011Q\t\u0014\b\u0003\r*\u0003\"a\u0012\u0019\u000e\u0003!S!!S\r\u0002\rq\u0012xn\u001c;?\u0013\tY\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&1\u0003\u0019\u0019wN\u001c4jOB\u0011\u0011KU\u0007\u0002\u001f%\u00111k\u0004\u0002\r\u0013:4G.\u001e=D_:4\u0017nZ\u0001\bE\u0006\u001c7.\u001a8e!\u001116\f\u000b\u001b\u000e\u0003]S!\u0001W-\u0002\u000f\rd\u0017.\u001a8ug)\t!,\u0001\u0003tiR\u0004\u0018B\u0001/X\u0005-\u0019F\u000f\u001e9CC\u000e\\WM\u001c3\u0002\rqJg.\u001b;?)\ry&m\u0019\u000b\u0003A\u0006\u00042!\u0015\u0001)\u0011\u0015!F\u0001q\u0001V\u0011\u0015\u0019E\u00011\u0001E\u0011\u0015yE\u00011\u0001Q\u0003=IgN\u001a7vq\u001e+g.\u001a:bi>\u0014X#\u00014\u0011\u0007E;\u0007&\u0003\u0002i\u001f\ty\u0011J\u001c4mkb<UM\\3sCR|'/\u0001\tj]\u001adW\u000f_$f]\u0016\u0014\u0018\r^8sA\u0005QQn\u001c8bI\u0016\u0013(o\u001c:\u0016\u00031\u00042!\u001c9)\u001b\u0005q'BA8Z\u0003\u0015iwN\\1e\u0013\t\thN\u0001\u0006N_:\fG-\u0012:s_J\f1\"\\8oC\u0012,%O]8sA\u0005iQ.\u001a;sS\u000e\u001c8i\u001c8gS\u001e,\u0012!\u001e\t\u0003#ZL!a^\b\u0003\u001b5+GO]5dg\u000e{gNZ5h\u00039iW\r\u001e:jGN\u001cuN\u001c4jO\u0002\n\u0001\u0003\u001d:fa\u0006\u0014XMU1x\u0007>,h\u000e^:\u0015\u000bm\fY!a\u0004\u0011\u0007%RC\u0010\u0005\u00030{\u0012{\u0018B\u0001@1\u0005%1UO\\2uS>t\u0017\u0007E\u00030\u0003\u0003\t)!C\u0002\u0002\u0004A\u0012aa\u00149uS>t\u0007cA\u0018\u0002\b%\u0019\u0011\u0011\u0002\u0019\u0003\t1{gn\u001a\u0005\u0007\u0003\u001bY\u0001\u0019\u0001#\u0002\u0013A\u0014xnY3tg&#\u0007bBA\t\u0017\u0001\u0007\u00111C\u0001\u000eG>,h\u000e^:SKF,Xm\u001d;\u0011\u0007\u0015\n)\"C\u0002\u0002\u0018E\u0011QbQ8v]R\u001c(+Z9vKN$\u0018!B2m_N,GCAA\u000f!\ry\u0013qD\u0005\u0004\u0003C\u0001$\u0001B+oSR\f!\u0003\u001d:fa\u0006\u0014XMU1oO\u0016\u001cu.\u001e8ugRA\u0011qEA\u0018\u0003c\t\t\u0005\u0005\u0003*U\u0005%\u0002CB#\u0002,\u0011\u000b)!C\u0002\u0002.9\u00131!T1q\u0011\u0019\ti!\u0004a\u0001\t\"9\u00111G\u0007A\u0002\u0005U\u0012\u0001\u00034s_6$\u0015\r^3\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000f!\u0003\u0011!\u0018.\\3\n\t\u0005}\u0012\u0011\b\u0002\b\u0013:\u001cH/\u00198u\u0011\u001d\t\u0019%\u0004a\u0001\u0003k\ta\u0001^8ECR,\u0007")
public class InfluxCountsReporter<F>
implements CountsReporter<F>,
LazyLogging {
    private final InfluxConfig config;
    private final InfluxGenerator<F> influxGenerator;
    private final MonadError<F> monadError;
    private final MetricsConfig metricsConfig;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxCountsReporter influxCountsReporter = this;
        synchronized (influxCountsReporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private InfluxGenerator<F> influxGenerator() {
        return this.influxGenerator;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public F prepareRawCounts(String processId, CountsRequest countsRequest) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> {
            Object f;
            CountsRequest countsRequest = countsRequest;
            if (countsRequest instanceof RangeCount) {
                RangeCount rangeCount = (RangeCount)countsRequest;
                Instant fromDate = rangeCount.fromDate();
                Instant toDate = rangeCount.toDate();
                f = this.prepareRangeCounts(processId, fromDate, toDate);
            } else if (countsRequest instanceof ExecutionCount) {
                ExecutionCount executionCount = (ExecutionCount)countsRequest;
                Instant pointInTime = executionCount.pointInTime();
                f = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)None$.MODULE$, pointInTime, this.metricsConfig());
            } else {
                throw new MatchError((Object)countsRequest);
            }
            return f;
        }).map((Function1 & Serializable & scala.Serializable)x$1 -> (Function1 & Serializable & scala.Serializable)key -> x$1.get(key), this.monadError());
    }

    @Override
    public void close() {
    }

    private F prepareRangeCounts(String processId, Instant fromDate, Instant toDate) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> this.influxGenerator().detectRestarts(processId, fromDate, toDate, this.metricsConfig())).flatMap((Function1 & Serializable & scala.Serializable)restarts -> {
            void var5_14;
            Tuple2 tuple2 = new Tuple2(restarts, (Object)$this.config.queryMode());
            if (tuple2 != null) {
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value2 = QueryMode$.MODULE$.OnlySumOfDifferences();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    Object f = this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                    return var5_14;
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value4 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        Object f = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                        return var5_14;
                    }
                }
            }
            if (tuple2 != null) {
                List nonEmpty = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value6 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Restarts detected: {}, querying with differential", new Object[]{nonEmpty.mkString(",")});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object f = this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                    return var5_14;
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value8 = QueryMode$.MODULE$.OnlySingleDifference();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        Object f = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                        return var5_14;
                    }
                }
            }
            if (tuple2 != null) {
                List dates = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value10 = QueryMode$.MODULE$.OnlySingleDifference();
                Enumeration.Value value11 = value;
                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                    Object object = this.monadError().error((Throwable)CannotFetchCountsError$.MODULE$.restartsDetected((List<Instant>)dates));
                    return var5_14;
                }
            }
            Object object = this.monadError().error((Throwable)new IllegalArgumentException(new StringBuilder(32).append("Unknown QueryMode ").append($this.config.queryMode()).append(" for ").append(restarts.size()).append(" restarts").toString()));
            return var5_14;
        }, this.monadError());
    }

    public InfluxCountsReporter(String env, InfluxConfig config, SttpBackend<F, Object> backend) {
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
        this.influxGenerator = new InfluxGenerator<F>(config, env, backend);
        this.monadError = backend.responseMonad();
        this.metricsConfig = (MetricsConfig)config.metricsConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> new MetricsConfig(MetricsConfig$.MODULE$.apply$default$1(), MetricsConfig$.MODULE$.apply$default$2(), MetricsConfig$.MODULE$.apply$default$3(), MetricsConfig$.MODULE$.apply$default$4(), MetricsConfig$.MODULE$.apply$default$5(), MetricsConfig$.MODULE$.apply$default$6(), MetricsConfig$.MODULE$.apply$default$7()));
    }
}

