/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh!\u0002\u000e\u001c\u0001m)\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006YA\u0013\u0005\u0006A\u0002!\t!\u0019\u0005\bO\u0002\u0011\r\u0011b\u0003i\u0011\u0019y\u0007\u0001)A\u0005S\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bBB;\u0001A\u0003%!\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004bBA<\u0001\u0011%\u0011\u0011P\u0004\b\u0003\u007fZ\u0002\u0012AAA\r\u0019Q2\u0004#\u0001\u0002\u0004\"1\u0001m\u0004C\u0001\u0003\u000bCq!a\"\u0010\t\u0003\tII\u0002\u0004\u00024>\u0001\u0011Q\u0017\u0005\u000b\u0003G\u0013\"\u0011!Q\u0001\n\u0005e\u0006BCA\u0001%\t\u0005\t\u0015!\u0003\u0002\u0004!AQH\u0005B\u0001B\u0003%a\bC\u00058%\t\u0005\t\u0015!\u0003\u00028!Q\u00111\u0019\n\u0003\u0004\u0003\u0006Y!!2\t\r\u0001\u0014B\u0011AAe\u0011\u001d\tYN\u0005C\u0001\u0003;\u0014q\"\u00138gYVDx)\u001a8fe\u0006$xN\u001d\u0006\u00039u\t\u0001\"\u001b8gYVDHM\u0019\u0006\u0003=}\tQ\u0002\u001d:pG\u0016\u001c8oQ8v]R\u001c(B\u0001\u0011\"\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005\t\u001a\u0013\u0001\u0002;pk.T\u0011\u0001J\u0001\u0003a2,\"A\n+\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]Uj\u0011a\f\u0006\u0003aE\nAb]2bY\u0006dwnZ4j]\u001eT!AM\u001a\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001N\u0001\u0004G>l\u0017B\u0001\u001c0\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h\u0007\u0001\u0001\"AO\u001e\u000e\u0003mI!\u0001P\u000e\u0003\u0019%sg\r\\;y\u0007>tg-[4\u0002\u0007\u0015tg\u000f\u0005\u0002@\r:\u0011\u0001\t\u0012\t\u0003\u0003&j\u0011A\u0011\u0006\u0003\u0007b\na\u0001\u0010:p_Rt\u0014BA#*\u0003\u0019\u0001&/\u001a3fM&\u0011q\t\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015K\u0013a\u00022bG.,g\u000e\u001a\t\u0005\u0017B\u00136,D\u0001M\u0015\tie*A\u0004dY&,g\u000e^\u001a\u000b\u0003=\u000bAa\u001d;ua&\u0011\u0011\u000b\u0014\u0002\f'R$\bOQ1dW\u0016tG\r\u0005\u0002T)2\u0001A!B+\u0001\u0005\u00041&!\u0001$\u0016\u0005]s\u0016C\u0001-\\!\tA\u0013,\u0003\u0002[S\t9aj\u001c;iS:<\u0007C\u0001\u0015]\u0013\ti\u0016FA\u0002B]f$Qa\u0018+C\u0002]\u0013\u0011aX\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t,g\r\u0006\u0002dIB\u0019!\b\u0001*\t\u000b%#\u00019\u0001&\t\u000b]\"\u0001\u0019A\u001d\t\u000bu\"\u0001\u0019\u0001 \u0002\u00155|g.\u00193FeJ|'/F\u0001j!\rQWNU\u0007\u0002W*\u0011ANT\u0001\u0006[>t\u0017\rZ\u0005\u0003].\u0014!\"T8oC\u0012,%O]8s\u0003-iwN\\1e\u000bJ\u0014xN\u001d\u0011\u0002\u0019%tg\r\\;y\u00072LWM\u001c;\u0016\u0003I\u00042AO:S\u0013\t!8D\u0001\nTS6\u0004H.Z%oM2,\bp\u00117jK:$\u0018!D5oM2,\bp\u00117jK:$\b%A\frk\u0016\u0014\u0018PQ=TS:<G.\u001a#jM\u001a,'/\u001a8dKRA\u0001p`A\f\u0003c\t)\u0004E\u0002T)f\u0004Ba\u0010>?y&\u00111\u0010\u0013\u0002\u0004\u001b\u0006\u0004\bC\u0001\u0015~\u0013\tq\u0018F\u0001\u0003M_:<\u0007bBA\u0001\u0013\u0001\u0007\u00111A\u0001\faJ|7-Z:t\u001d\u0006lW\r\u0005\u0003\u0002\u0006\u0005MQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u000fA\u0014xnY3tg*!\u0011QBA\b\u0003\r\t\u0007/\u001b\u0006\u0004\u0003#y\u0012AB3oO&tW-\u0003\u0003\u0002\u0016\u0005\u001d!a\u0003)s_\u000e,7o\u001d(b[\u0016Dq!!\u0007\n\u0001\u0004\tY\"\u0001\u0005eCR,gI]8n!\u0015A\u0013QDA\u0011\u0013\r\ty\"\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005!A/[7f\u0015\t\tY#\u0001\u0003kCZ\f\u0017\u0002BA\u0018\u0003K\u0011q!\u00138ti\u0006tG\u000fC\u0004\u00024%\u0001\r!!\t\u0002\r\u0011\fG/\u001a+p\u0011\u00199\u0014\u00021\u0001\u00028A\u0019!(!\u000f\n\u0007\u0005m2DA\u0007NKR\u0014\u0018nY:D_:4\u0017nZ\u0001\u0018cV,'/\u001f\"z'VlwJ\u001a#jM\u001a,'/\u001a8dKN$\u0012\u0002_A!\u0003\u0007\n)%a\u0012\t\u000f\u0005\u0005!\u00021\u0001\u0002\u0004!9\u0011\u0011\u0004\u0006A\u0002\u0005\u0005\u0002bBA\u001a\u0015\u0001\u0007\u0011\u0011\u0005\u0005\u0007o)\u0001\r!a\u000e\u0002\u001d\u0011,G/Z2u%\u0016\u001cH/\u0019:ugRQ\u0011QJA1\u0003G\n)'a\u001a\u0011\tM#\u0016q\n\t\u0007\u0003#\nY&!\t\u000f\t\u0005M\u0013q\u000b\b\u0004\u0003\u0006U\u0013\"\u0001\u0016\n\u0007\u0005e\u0013&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005u\u0013q\f\u0002\u0005\u0019&\u001cHOC\u0002\u0002Z%Bq!!\u0001\f\u0001\u0004\t\u0019\u0001C\u0004\u0002\u001a-\u0001\r!!\t\t\u000f\u0005M2\u00021\u0001\u0002\"!1qg\u0003a\u0001\u0003o\tAD]3bIJ+7\u000f^1siN4%o\\7T_V\u00148-Z\"pk:$8\u000f\u0006\u0003\u0002P\u00055\u0004bBA8\u0019\u0001\u0007\u0011\u0011O\u0001\rg>,(oY3D_VtGo\u001d\t\u0004u\u0005M\u0014bAA;7\ta\u0011J\u001c4mkb\u001cVM]5fg\u0006y\u0001/\u0019:tK&sg\r\\;y\t\u0006$X\r\u0006\u0003\u0002\"\u0005m\u0004BBA?\u001b\u0001\u0007a(\u0001\u0003eCR,\u0017aD%oM2,\bpR3oKJ\fGo\u001c:\u0011\u0005iz1cA\b([Q\u0011\u0011\u0011Q\u0001'e\u0016$(/[3wK>sG.\u001f*fgVdGO\u0012:p[\u0006\u001bG/[8o-\u0006dW/Z)vKJLX\u0003BAF\u0003##\u0002\"!$\u0002 \u0006\u0005\u0016q\u0016\u000b\u0005\u0003\u001f\u000b9\n\u0005\u0003T\u0003#KHAB+\u0012\u0005\u0004\t\u0019*F\u0002X\u0003+#aaXAI\u0005\u00049\u0006\"CAM#\u0005\u0005\t9AAN\u0003))g/\u001b3f]\u000e,G%\r\t\u0005U6\fi\nE\u0002T\u0003#CaaN\tA\u0002\u0005]\u0002bBAR#\u0001\u0007\u0011QU\u0001\fS:4xn[3Rk\u0016\u0014\u0018\u0010\u0005\u0004)\u0003Os\u00141V\u0005\u0004\u0003SK#!\u0003$v]\u000e$\u0018n\u001c82!\u0015\u0019\u0016\u0011SAW!\u0019\t\t&a\u0017\u0002r!1\u0011\u0011W\tA\u0002y\n1\"];fef\u001cFO]5oO\n\u0001\u0002k\\5oi&sG+[7f#V,'/_\u000b\u0005\u0003o\u000bilE\u0002\u0013O5\u0002b\u0001KAT}\u0005m\u0006#B*\u0002>\u00065FAB+\u0013\u0005\u0004\ty,F\u0002X\u0003\u0003$aaXA_\u0005\u00049\u0016AC3wS\u0012,gnY3%eA!!.\\Ad!\r\u0019\u0016Q\u0018\u000b\u000b\u0003\u0017\f\u0019.!6\u0002X\u0006eG\u0003BAg\u0003#\u0004R!a4\u0013\u0003\u000fl\u0011a\u0004\u0005\b\u0003\u0007D\u00029AAc\u0011\u001d\t\u0019\u000b\u0007a\u0001\u0003sCq!!\u0001\u0019\u0001\u0004\t\u0019\u0001C\u0003>1\u0001\u0007a\b\u0003\u000481\u0001\u0007\u0011qG\u0001\u0006cV,'/\u001f\u000b\u0005\u0003?\f\t\u000f\u0005\u0003T\u0003{K\bbBA?3\u0001\u0007\u0011\u0011\u0005")
public class InfluxGenerator<F>
implements LazyLogging {
    private final String env;
    private final MonadError<F> monadError;
    private final SimpleInfluxClient<F> influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <F> F retrieveOnlyResultFromActionValueQuery(MetricsConfig metricsConfig, Function1<String, F> function1, String string, MonadError<F> monadError) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(metricsConfig, function1, string, monadError);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private SimpleInfluxClient<F> influxClient() {
        return this.influxClient;
    }

    public F queryBySingleDifference(ProcessName processName, Option<Instant> dateFrom, Instant dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2), processName, this.env, config, this.monadError());
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> pointInTimeQuery.query(dateTo)).flatMap((Function1 & Serializable & scala.Serializable)valuesAtEnd -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> dateFrom.map((Function1 & Serializable & scala.Serializable)date -> pointInTimeQuery.query((Instant)date)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.monadError().unit((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            long value = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), this.monadError()), this.monadError());
    }

    public F queryBySumOfDifferences(ProcessName processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        String query3 = new StringBuilder(173).append("select sum(diff) as count from (SELECT non_negative_difference(\"").append(config.countField()).append("\") AS diff\n     FROM \"").append(config.nodeCountMetric()).append("\"\n     WHERE ").append(config.envTag()).append(" = '").append(this.env).append("' AND ").append(config.scenarioTag()).append(" = '").append(processName).append("'\n     AND time > ").append(dateFrom.getEpochSecond()).append("s AND time < ").append(dateTo.getEpochSecond()).append("s\n     GROUP BY ").append(config.nodeIdTag()).append(", ").append(config.additionalGroupByTags().mkString(",")).append(") group by ").append(config.nodeIdTag()).toString();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2), query3, this.monadError());
    }

    public F detectRestarts(ProcessName processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        long from = dateFrom.getEpochSecond();
        long to = dateTo.getEpochSecond();
        String queryString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("SELECT diff FROM (\n         |  SELECT difference(").append(config.countField()).append(") as diff FROM \"").append(config.sourceCountMetric()).append("\" WHERE\n         | \"").append(config.scenarioTag()).append("\" = '").append(processName).append("' AND ").append(config.envTag()).append(" = '").append(this.env).append("'\n         | AND time >= ").append(from).append("s and time < ").append(to).append("s GROUP BY ").append(config.additionalGroupByTags().mkString(",")).append(", ").append(config.nodeIdTag()).append(") where diff < 0 ").toString())).stripMargin();
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> this.influxClient().query(queryString)).map((Function1 & Serializable & scala.Serializable)series -> (List)series.headOption().map((Function1 & Serializable & scala.Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.monadError());
    }

    /*
     * WARNING - void declaration
     */
    private List<Instant> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        void var2_2;
        List restarts = (List)sourceCounts.values().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.tl$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.tl$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                object = this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                Object date = colon2.head();
                List list2 = colon2.tl$access$1();
                if (!(date instanceof String)) return false;
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                Object derivative = colon3.head();
                List list3 = colon3.tl$access$1();
                if (!(derivative instanceof BigDecimal)) return false;
                if (!Nil$.MODULE$.equals(list3)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return var2_2;
    }

    public Instant pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<F, Object> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.monadError = backend.responseMonad();
        this.influxClient = new SimpleInfluxClient<F>(config, backend);
    }

    public static class PointInTimeQuery<F>
    implements LazyLogging {
        private final Function1<String, F> invokeQuery;
        private final ProcessName processName;
        private final String env;
        private final MetricsConfig config;
        private final MonadError<F> evidence$2;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
        }

        public F query(Instant date) {
            long around = date.getEpochSecond();
            return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1(new StringBuilder(27).append("time <= ").append(around).append("s and time > ").append(around).append("s - 1h").toString(), "last"), $this.evidence$2)).flatMap((Function1 & Serializable & scala.Serializable)valuesBefore -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1(new StringBuilder(27).append("time >= ").append(around).append("s and time < ").append(around).append("s + 1h").toString(), "first"), $this.evidence$2)).map((Function1 & Serializable & scala.Serializable)valuesAfter -> valuesBefore.$plus$plus((GenTraversableOnce)valuesAfter), $this.evidence$2), this.evidence$2);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("select ").append(this.config.nodeIdTag()).append(" as nodeId, ").append(aggregateFunction).append("(").append(this.config.countField()).append(") as count\n           | from \"").append(this.config.nodeCountMetric()).append("\" where ").append(this.config.scenarioTag()).append(" = '").append(this.processName).append("'\n           | and ").append(timeCondition).append(" and ").append(this.config.envTag()).append(" = '").append(this.env).append("' group by ").append(this.config.additionalGroupByTags().mkString(",")).append(", ").append(this.config.nodeIdTag()).append(" fill(0)").toString())).stripMargin();
        }

        public PointInTimeQuery(Function1<String, F> invokeQuery, ProcessName processName, String env, MetricsConfig config, MonadError<F> evidence$2) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.evidence$2 = evidence$2;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

