/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef!B\r\u001b\u0001i!\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011m\u0002!\u0011!Q\u0001\nqB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006Y\u0001\u0013\u0005\u0006I\u0002!\t!\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0011\u0019\u0001\b\u0001)A\u0005[\")\u0011\u000f\u0001C\u0001e\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!a\u0018\u0001\t\u0003\t\tgB\u0004\u0002jiA\t!a\u001b\u0007\reQ\u0002\u0012AA7\u0011\u0019!g\u0002\"\u0001\u0002p!9\u0011\u0011\u000f\b\u0005\u0002\u0005MdABAK\u001d\u0001\t9\n\u0003\u0006\u0002\u0006F\u0011\t\u0011)A\u0005\u0003\u000fC\u0001b_\t\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\twE\u0011\t\u0011)A\u0005y!IQ'\u0005B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003s\n\"\u0011!Q\u0001\f\u0005m\u0004B\u00023\u0012\t\u0003\tI\nC\u0004\u0002,F!\t!!,\u0003\u001f%sg\r\\;y\u000f\u0016tWM]1u_JT!a\u0007\u000f\u0002\u0011%tg\r\\;yI\nT!!\b\u0010\u0002\u001bA\u0014xnY3tg\u000e{WO\u001c;t\u0015\ty\u0002%A\u0006okN\u001c8N\\1dW\u0016\u0014(BA\u0011#\u0003\u0011!x.^6\u000b\u0003\r\n!\u0001\u001d7\u0014\u0007\u0001)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003YMj\u0011!\f\u0006\u0003]=\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001M\u0019\u0002\u0011QL\b/Z:bM\u0016T\u0011AM\u0001\u0004G>l\u0017B\u0001\u001b.\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h\u0007\u0001\u0001\"\u0001O\u001d\u000e\u0003iI!A\u000f\u000e\u0003\u0019%sg\r\\;y\u0007>tg-[4\u0002\u0007\u0015tg\u000f\u0005\u0002>\t:\u0011aH\u0011\t\u0003\u007f\u001dj\u0011\u0001\u0011\u0006\u0003\u0003Z\na\u0001\u0010:p_Rt\u0014BA\"(\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r;\u0013a\u00022bG.,g\u000e\u001a\t\u0006\u0013:\u0003f+W\u0007\u0002\u0015*\u00111\nT\u0001\u0007G2LWM\u001c;\u000b\u00035\u000bAa\u001d;ua&\u0011qJ\u0013\u0002\f'R$\bOQ1dW\u0016tG\r\u0005\u0002R)6\t!K\u0003\u0002TO\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005U\u0013&A\u0002$viV\u0014X\r\u0005\u0002'/&\u0011\u0001l\n\u0002\b\u001d>$\b.\u001b8h!\tQ\u0016M\u0004\u0002\\?:\u0011AL\u0018\b\u0003\u007fuK\u0011!T\u0005\u0003\u00172K!\u0001\u0019&\u0002\u000fA\f7m[1hK&\u0011!m\u0019\u0002\t\u001d>$\b.\u001b8h)*\u0011\u0001MS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0019L'\u000e\u0006\u0002hQB\u0011\u0001\b\u0001\u0005\u0006\u000f\u0012\u0001\u001d\u0001\u0013\u0005\u0006k\u0011\u0001\ra\u000e\u0005\u0006w\u0011\u0001\r\u0001P\u0001\rS:4G.\u001e=DY&,g\u000e^\u000b\u0002[B\u0011\u0001H\\\u0005\u0003_j\u0011!cU5na2,\u0017J\u001c4mkb\u001cE.[3oi\u0006i\u0011N\u001c4mkb\u001cE.[3oi\u0002\nq#];fef\u0014\u0015pU5oO2,G)\u001b4gKJ,gnY3\u0015\u000fMTH0a\u0005\u0002\u0018A\u0019\u0011\u000b\u0016;\u0011\tu*Hh^\u0005\u0003m\u001a\u00131!T1q!\t1\u00030\u0003\u0002zO\t!Aj\u001c8h\u0011\u0015Yx\u00011\u0001=\u0003-\u0001(o\\2fgNt\u0015-\\3\t\u000bu<\u0001\u0019\u0001@\u0002\u0011\u0011\fG/\u001a$s_6\u0004BAJ@\u0002\u0004%\u0019\u0011\u0011A\u0014\u0003\r=\u0003H/[8o!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tA\u0001^5nK*\u0011\u0011QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0012\u0005\u001d!aB%ogR\fg\u000e\u001e\u0005\b\u0003+9\u0001\u0019AA\u0002\u0003\u0019!\u0017\r^3U_\"1Qg\u0002a\u0001\u00033\u00012\u0001OA\u000e\u0013\r\tiB\u0007\u0002\u000e\u001b\u0016$(/[2t\u0007>tg-[4\u0002/E,XM]=CsN+Xn\u00144ES\u001a4WM]3oG\u0016\u001cH#C:\u0002$\u0005\u0015\u0012qEA\u0015\u0011\u0015Y\b\u00021\u0001=\u0011\u0019i\b\u00021\u0001\u0002\u0004!9\u0011Q\u0003\u0005A\u0002\u0005\r\u0001BB\u001b\t\u0001\u0004\tI\"\u0001\beKR,7\r\u001e*fgR\f'\u000f^:\u0015\u0015\u0005=\u0012\u0011IA\"\u0003\u000b\n9\u0005\u0005\u0003R)\u0006E\u0002CBA\u001a\u0003w\t\u0019A\u0004\u0003\u00026\u0005ebbA \u00028%\t\u0001&\u0003\u0002aO%!\u0011QHA \u0005\u0011a\u0015n\u001d;\u000b\u0005\u0001<\u0003\"B>\n\u0001\u0004a\u0004BB?\n\u0001\u0004\t\u0019\u0001C\u0004\u0002\u0016%\u0001\r!a\u0001\t\rUJ\u0001\u0019AA\r\u0003q\u0011X-\u00193SKN$\u0018M\u001d;t\rJ|WnU8ve\u000e,7i\\;oiN$B!!\r\u0002N!9\u0011q\n\u0006A\u0002\u0005E\u0013\u0001D:pkJ\u001cWmQ8v]R\u001c\bc\u0001\u001d\u0002T%\u0019\u0011Q\u000b\u000e\u0003\u0019%sg\r\\;y'\u0016\u0014\u0018.Z:\u0002\u001fA\f'o]3J]\u001adW\u000f\u001f#bi\u0016$B!a\u0001\u0002\\!1\u0011QL\u0006A\u0002q\nA\u0001Z1uK\u0006)1\r\\8tKR\u0011\u00111\r\t\u0004M\u0005\u0015\u0014bAA4O\t!QK\\5u\u0003=IeN\u001a7vq\u001e+g.\u001a:bi>\u0014\bC\u0001\u001d\u000f'\rqQe\u000b\u000b\u0003\u0003W\naE]3ue&,g/Z(oYf\u0014Vm];mi\u001a\u0013x.\\!di&|gNV1mk\u0016\fV/\u001a:z)!\t)(!!\u0002\u0004\u0006EEcA:\u0002x!9\u0011\u0011\u0010\tA\u0004\u0005m\u0014AA3d!\r\t\u0016QP\u0005\u0004\u0003\u007f\u0012&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0019)\u0004\u00031\u0001\u0002\u001a!9\u0011Q\u0011\tA\u0002\u0005\u001d\u0015aC5om>\\W-U;fef\u0004bAJAEy\u00055\u0015bAAFO\tIa)\u001e8di&|g.\r\t\u0005#R\u000by\t\u0005\u0004\u00024\u0005m\u0012\u0011\u000b\u0005\u0007\u0003'\u0003\u0002\u0019\u0001\u001f\u0002\u0017E,XM]=TiJLgn\u001a\u0002\u0011!>Lg\u000e^%o)&lW-U;fef\u001c2!E\u0013,))\tY*a)\u0002&\u0006\u001d\u0016\u0011\u0016\u000b\u0005\u0003;\u000b\t\u000bE\u0002\u0002 Fi\u0011A\u0004\u0005\b\u0003s:\u00029AA>\u0011\u001d\t)i\u0006a\u0001\u0003\u000fCQa_\fA\u0002qBQaO\fA\u0002qBa!N\fA\u0002\u0005e\u0011!B9vKJLHcA:\u00020\"9\u0011Q\f\rA\u0002\u0005\r\u0001")
public class InfluxGenerator
implements LazyLogging {
    private final String env;
    private final SimpleInfluxClient influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Future<Map<String, Object>> retrieveOnlyResultFromActionValueQuery(MetricsConfig metricsConfig, Function1<String, Future<List<InfluxSeries>>> function1, String string, ExecutionContext executionContext) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(metricsConfig, function1, string, executionContext);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private SimpleInfluxClient influxClient() {
        return this.influxClient;
    }

    public Future<Map<String, Object>> queryBySingleDifference(String processName, Option<Instant> dateFrom, Instant dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1<String, Future<List<InfluxSeries>>>)(Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2, ExecutionContext.Implicits$.MODULE$.global()), processName, this.env, config, ExecutionContext.Implicits$.MODULE$.global());
        return pointInTimeQuery.query(dateTo).flatMap((Function1 & Serializable & scala.Serializable)valuesAtEnd -> ((Future)dateFrom.map((Function1 & Serializable & scala.Serializable)date -> pointInTimeQuery.query((Instant)date)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.successful((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            long value = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<Map<String, Object>> queryBySumOfDifferences(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        String query3 = new StringBuilder(173).append("select sum(diff) as count from (SELECT non_negative_difference(\"").append(config.countField()).append("\") AS diff\n     FROM \"").append(config.nodeCountMetric()).append("\"\n     WHERE ").append(config.envTag()).append(" = '").append(this.env).append("' AND ").append(config.scenarioTag()).append(" = '").append(processName).append("'\n     AND time > ").append(dateFrom.getEpochSecond()).append("s AND time < ").append(dateTo.getEpochSecond()).append("s\n     GROUP BY ").append(config.nodeIdTag()).append(", ").append(config.slotTag()).append(") group by ").append(config.nodeIdTag()).toString();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1<String, Future<List<InfluxSeries>>>)(Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2, ExecutionContext.Implicits$.MODULE$.global()), query3, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<List<Instant>> detectRestarts(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        long from = dateFrom.getEpochSecond();
        long to = dateTo.getEpochSecond();
        String queryString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("SELECT diff FROM (\n         |  SELECT difference(").append(config.countField()).append(") as diff FROM \"").append(config.sourceCountMetric()).append("\" WHERE\n         | \"").append(config.scenarioTag()).append("\" = '").append(processName).append("' AND ").append(config.envTag()).append(" = '").append(this.env).append("'\n         | AND time >= ").append(from).append("s and time < ").append(to).append("s GROUP BY ").append(config.slotTag()).append(", ").append(config.nodeIdTag()).append(") where diff < 0 ").toString())).stripMargin();
        return this.influxClient().query(queryString, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)series -> (List)series.headOption().map((Function1 & Serializable & scala.Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), ExecutionContext.Implicits$.MODULE$.global());
    }

    /*
     * WARNING - void declaration
     */
    private List<Instant> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        void var2_2;
        List restarts = (List)sourceCounts.values().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.tl$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.tl$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                object = this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                Object date = colon2.head();
                List list2 = colon2.tl$access$1();
                if (!(date instanceof String)) return false;
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                Object derivative = colon3.head();
                List list3 = colon3.tl$access$1();
                if (!(derivative instanceof BigDecimal)) return false;
                if (!Nil$.MODULE$.equals(list3)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return var2_2;
    }

    public Instant pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
    }

    public void close() {
        this.influxClient().close();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<Future, Nothing$, ?> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.influxClient = new SimpleInfluxClient(config, backend);
    }

    public static class PointInTimeQuery
    implements LazyLogging {
        private final Function1<String, Future<List<InfluxSeries>>> invokeQuery;
        private final String processName;
        private final String env;
        private final MetricsConfig config;
        private final ExecutionContext ec;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
        }

        public Future<Map<String, Object>> query(Instant date) {
            long around = date.getEpochSecond();
            return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(this.config, this.invokeQuery, this.query$1(new StringBuilder(27).append("time <= ").append(around).append("s and time > ").append(around).append("s - 1h").toString(), "last"), this.ec).flatMap((Function1 & Serializable & scala.Serializable)valuesBefore -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1(new StringBuilder(27).append("time >= ").append(around).append("s and time < ").append(around).append("s + 1h").toString(), "first"), $this.ec).map((Function1 & Serializable & scala.Serializable)valuesAfter -> valuesBefore.$plus$plus((GenTraversableOnce)valuesAfter), $this.ec), this.ec);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("select ").append(this.config.nodeIdTag()).append(" as nodeId, ").append(aggregateFunction).append("(").append(this.config.countField()).append(") as count\n           | from \"").append(this.config.nodeCountMetric()).append("\" where ").append(this.config.scenarioTag()).append(" = '").append(this.processName).append("'\n           | and ").append(timeCondition).append(" and ").append(this.config.envTag()).append(" = '").append(this.env).append("' group by ").append(this.config.slotTag()).append(", ").append(this.config.nodeIdTag()).append(" fill(0)").toString())).stripMargin();
        }

        public PointInTimeQuery(Function1<String, Future<List<InfluxSeries>>> invokeQuery, String processName, String env, MetricsConfig config, ExecutionContext ec) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.ec = ec;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

