/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.processCounts.CannotFetchCountsError$;
import pl.touk.nussknacker.processCounts.CountsReporter;
import pl.touk.nussknacker.processCounts.CountsRequest;
import pl.touk.nussknacker.processCounts.ExecutionCount;
import pl.touk.nussknacker.processCounts.RangeCount;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig$;
import pl.touk.nussknacker.processCounts.influxdb.QueryMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import sttp.client.SttpBackend;
import sttp.client.monad.MonadError;
import sttp.client.monad.syntax;
import sttp.client.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\b\u0011\u0001mA\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005^\u0001\t\u0005\t\u0015a\u0003_\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001dI\bA1A\u0005\u0002iDaA \u0001!\u0002\u0013Y\b\u0002C@\u0001\u0005\u0004%Y!!\u0001\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0007A\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005m\u0001\u0001)A\u0005\u0003+Aq!!\b\u0001\t\u0003\ny\u0002C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F\t!\u0012J\u001c4mkb\u001cu.\u001e8ugJ+\u0007o\u001c:uKJT!!\u0005\n\u0002\u0011%tg\r\\;yI\nT!a\u0005\u000b\u0002\u001bA\u0014xnY3tg\u000e{WO\u001c;t\u0015\t)b#A\u0006okN\u001c8N\\1dW\u0016\u0014(BA\f\u0019\u0003\u0011!x.^6\u000b\u0003e\t!\u0001\u001d7\u0004\u0001U\u0011AdK\n\u0005\u0001u)#\b\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!A.\u00198h\u0015\u0005\u0011\u0013\u0001\u00026bm\u0006L!\u0001J\u0010\u0003\r=\u0013'.Z2u!\r1s%K\u0007\u0002%%\u0011\u0001F\u0005\u0002\u000f\u0007>,h\u000e^:SKB|'\u000f^3s!\tQ3\u0006\u0004\u0001\u0005\u000b1\u0002!\u0019A\u0017\u0003\u0003\u0019+\"A\f\u001d\u0012\u0005=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$a\u0002(pi\"Lgn\u001a\t\u0003aYJ!aN\u0019\u0003\u0007\u0005s\u0017\u0010B\u0003:W\t\u0007aFA\u0001`!\tY$)D\u0001=\u0015\tid(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002@\u0001\u0006AA/\u001f9fg\u00064WMC\u0001B\u0003\r\u0019w.\\\u0005\u0003\u0007r\u00121\u0002T1{s2{wmZ5oO\u0006\u0019QM\u001c<\u0011\u0005\u0019keBA$L!\tA\u0015'D\u0001J\u0015\tQ%$\u0001\u0004=e>|GOP\u0005\u0003\u0019F\na\u0001\u0015:fI\u00164\u0017B\u0001(P\u0005\u0019\u0019FO]5oO*\u0011A*M\u0001\u0007G>tg-[4\u0011\u0005I\u001bV\"\u0001\t\n\u0005Q\u0003\"\u0001D%oM2,\bpQ8oM&<\u0017\u0001D<bSR4uN]\"m_N,\u0007\u0003\u0002\u0019X3jK!\u0001W\u0019\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001\u0016,5B\u0011\u0001gW\u0005\u00039F\u0012A!\u00168ji\u00069!-Y2lK:$\u0007#B0eS=2W\"\u00011\u000b\u0005\u0005\u0014\u0017AB2mS\u0016tGOC\u0001d\u0003\u0011\u0019H\u000f\u001e9\n\u0005\u0015\u0004'aC*uiB\u0014\u0015mY6f]\u0012\u0004\"a\u001a8\u000f\u0005!dgBA5l\u001d\tA%.C\u0001d\u0013\t\t'-\u0003\u0002nA\u00069\u0001/Y2lC\u001e,\u0017BA8q\u0005!qu\u000e\u001e5j]\u001e$&BA7a\u0003\u0019a\u0014N\\5u}Q!1O^<y)\t!X\u000fE\u0002S\u0001%BQ!X\u0003A\u0004yCQ\u0001R\u0003A\u0002\u0015CQ\u0001U\u0003A\u0002ECQ!V\u0003A\u0002Y\u000bq\"\u001b8gYVDx)\u001a8fe\u0006$xN]\u000b\u0002wB\u0019!\u000b`\u0015\n\u0005u\u0004\"aD%oM2,\bpR3oKJ\fGo\u001c:\u0002!%tg\r\\;y\u000f\u0016tWM]1u_J\u0004\u0013AC7p]\u0006$WI\u001d:peV\u0011\u00111\u0001\t\u0006\u0003\u000b\tY!K\u0007\u0003\u0003\u000fQ1!!\u0003a\u0003\u0015iwN\\1e\u0013\u0011\ti!a\u0002\u0003\u00155{g.\u00193FeJ|'/A\u0006n_:\fG-\u0012:s_J\u0004\u0013!D7fiJL7m]\"p]\u001aLw-\u0006\u0002\u0002\u0016A\u0019!+a\u0006\n\u0007\u0005e\u0001CA\u0007NKR\u0014\u0018nY:D_:4\u0017nZ\u0001\u000f[\u0016$(/[2t\u0007>tg-[4!\u0003A\u0001(/\u001a9be\u0016\u0014\u0016m^\"pk:$8\u000f\u0006\u0004\u0002\"\u0005E\u0012Q\u0007\t\u0005U-\n\u0019\u0003E\u00031/\u0016\u000b)\u0003E\u00031\u0003O\tY#C\u0002\u0002*E\u0012aa\u00149uS>t\u0007c\u0001\u0019\u0002.%\u0019\u0011qF\u0019\u0003\t1{gn\u001a\u0005\u0007\u0003ga\u0001\u0019A#\u0002\u0013A\u0014xnY3tg&#\u0007bBA\u001c\u0019\u0001\u0007\u0011\u0011H\u0001\u000eG>,h\u000e^:SKF,Xm\u001d;\u0011\u0007\u0019\nY$C\u0002\u0002>I\u0011QbQ8v]R\u001c(+Z9vKN$\u0018!B2m_N,G#\u0001.\u0002%A\u0014X\r]1sKJ\u000bgnZ3D_VtGo\u001d\u000b\t\u0003\u000f\ny%!\u0015\u0002bA!!fKA%!\u00191\u00151J#\u0002,%\u0019\u0011QJ(\u0003\u00075\u000b\u0007\u000f\u0003\u0004\u000249\u0001\r!\u0012\u0005\b\u0003'r\u0001\u0019AA+\u0003!1'o\\7ECR,\u0007\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005m\u0013%\u0001\u0003uS6,\u0017\u0002BA0\u00033\u0012q!\u00138ti\u0006tG\u000fC\u0004\u0002d9\u0001\r!!\u0016\u0002\rQ|G)\u0019;f\u0001")
public class InfluxCountsReporter<F>
implements CountsReporter<F>,
LazyLogging {
    private final InfluxConfig config;
    private final Function1<F, BoxedUnit> waitForClose;
    private final InfluxGenerator<F> influxGenerator;
    private final MonadError<F> monadError;
    private final MetricsConfig metricsConfig;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxCountsReporter influxCountsReporter = this;
        synchronized (influxCountsReporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public InfluxGenerator<F> influxGenerator() {
        return this.influxGenerator;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public F prepareRawCounts(String processId, CountsRequest countsRequest) {
        F f;
        CountsRequest countsRequest2 = countsRequest;
        if (countsRequest2 instanceof RangeCount) {
            RangeCount rangeCount = (RangeCount)countsRequest2;
            Instant fromDate = rangeCount.fromDate();
            Instant toDate = rangeCount.toDate();
            f = this.prepareRangeCounts(processId, fromDate, toDate);
        } else if (countsRequest2 instanceof ExecutionCount) {
            ExecutionCount executionCount = (ExecutionCount)countsRequest2;
            Instant pointInTime = executionCount.pointInTime();
            f = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)None$.MODULE$, pointInTime, this.metricsConfig());
        } else {
            throw new MatchError((Object)countsRequest2);
        }
        return (F)syntax.MonadErrorOps$.MODULE$.map$extension(syntax$.MODULE$.MonadErrorOps(f), (Function1 & Serializable & scala.Serializable)x$1 -> (Function1 & Serializable & scala.Serializable)key -> x$1.get(key), this.monadError());
    }

    @Override
    public void close() {
        this.waitForClose.apply(this.influxGenerator().close());
    }

    private F prepareRangeCounts(String processId, Instant fromDate, Instant toDate) {
        return (F)syntax.MonadErrorOps$.MODULE$.flatMap$extension(syntax$.MODULE$.MonadErrorOps(this.influxGenerator().detectRestarts(processId, fromDate, toDate, this.metricsConfig())), (Function1 & Serializable & scala.Serializable)restarts -> {
            void var5_14;
            Tuple2 tuple2 = new Tuple2(restarts, (Object)$this.config.queryMode());
            if (tuple2 != null) {
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value2 = QueryMode$.MODULE$.OnlySumOfDifferences();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    Object f = this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                    return var5_14;
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value4 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        Object f = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                        return var5_14;
                    }
                }
            }
            if (tuple2 != null) {
                List nonEmpty = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value6 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Restarts detected: {}, querying with differential", new Object[]{nonEmpty.mkString(",")});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object f = this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                    return var5_14;
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value8 = QueryMode$.MODULE$.OnlySingleDifference();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        Object f = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                        return var5_14;
                    }
                }
            }
            if (tuple2 != null) {
                List dates = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value10 = QueryMode$.MODULE$.OnlySingleDifference();
                Enumeration.Value value11 = value;
                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                    Object object = this.monadError().error((Throwable)CannotFetchCountsError$.MODULE$.restartsDetected((List<Instant>)dates));
                    return var5_14;
                }
            }
            Object object = this.monadError().error((Throwable)new IllegalArgumentException(new StringBuilder(32).append("Unknown QueryMode ").append($this.config.queryMode()).append(" for ").append(restarts.size()).append(" restarts").toString()));
            return var5_14;
        }, this.monadError());
    }

    public InfluxCountsReporter(String env, InfluxConfig config, Function1<F, BoxedUnit> waitForClose, SttpBackend<F, Nothing$, ?> backend) {
        this.config = config;
        this.waitForClose = waitForClose;
        LazyLogging.$init$((LazyLogging)this);
        this.influxGenerator = new InfluxGenerator<F>(config, env, backend);
        this.monadError = backend.responseMonad();
        this.metricsConfig = (MetricsConfig)config.metricsConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> new MetricsConfig(MetricsConfig$.MODULE$.apply$default$1(), MetricsConfig$.MODULE$.apply$default$2(), MetricsConfig$.MODULE$.apply$default$3(), MetricsConfig$.MODULE$.apply$default$4(), MetricsConfig$.MODULE$.apply$default$5(), MetricsConfig$.MODULE$.apply$default$6(), MetricsConfig$.MODULE$.apply$default$7()));
    }
}

