/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import sttp.client.SttpBackend;
import sttp.client.monad.MonadError;
import sttp.client.monad.syntax;
import sttp.client.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh!B\u000e\u001d\u0001q1\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ya\u0013\u0005\u0006Y\u0002!\t!\u001c\u0005\bg\u0002\u0011\r\u0011b\u0003u\u0011\u0019Y\b\u0001)A\u0005k\"9A\u0010\u0001b\u0001\n\u0013i\bbBA\u0002\u0001\u0001\u0006IA \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\ruaBAG9!\u0005\u0011q\u0012\u0004\u00077qA\t!!%\t\r1\u0004B\u0011AAJ\u0011\u001d\t)\n\u0005C\u0001\u0003/3a!!1\u0011\u0001\u0005\r\u0007BCAY'\t\u0005\t\u0015!\u0003\u0002H\"I\u0011\u0011D\n\u0003\u0002\u0003\u0006Ia\u0010\u0005\t}M\u0011\t\u0011)A\u0005\u007f!I\u0001h\u0005B\u0001B\u0003%\u00111\b\u0005\u000b\u0003#\u001c\"1!Q\u0001\f\u0005M\u0007B\u00027\u0014\t\u0003\t9\u000eC\u0004\u0002jN!\t!a;\u0003\u001f%sg\r\\;y\u000f\u0016tWM]1u_JT!!\b\u0010\u0002\u0011%tg\r\\;yI\nT!a\b\u0011\u0002\u001bA\u0014xnY3tg\u000e{WO\u001c;t\u0015\t\t#%A\u0006okN\u001c8N\\1dW\u0016\u0014(BA\u0012%\u0003\u0011!x.^6\u000b\u0003\u0015\n!\u0001\u001d7\u0016\u0005\u001d*6c\u0001\u0001)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\u0004\"a\f\u001c\u000e\u0003AR!!\r\u001a\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005M\"\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003U\n1aY8n\u0013\t9\u0004GA\u0006MCjLHj\\4hS:<\u0017AB2p]\u001aLwm\u0001\u0001\u0011\u0005mbT\"\u0001\u000f\n\u0005ub\"\u0001D%oM2,\bpQ8oM&<\u0017aA3omB\u0011\u0001i\u0012\b\u0003\u0003\u0016\u0003\"A\u0011\u0016\u000e\u0003\rS!\u0001R\u001d\u0002\rq\u0012xn\u001c;?\u0013\t1%&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$+\u0003\u001d\u0011\u0017mY6f]\u0012\u0004R\u0001T)T3\u0006l\u0011!\u0014\u0006\u0003\u001d>\u000baa\u00197jK:$(\"\u0001)\u0002\tM$H\u000f]\u0005\u0003%6\u00131b\u0015;ua\n\u000b7m[3oIB\u0011A+\u0016\u0007\u0001\t\u00151\u0006A1\u0001X\u0005\u00051UC\u0001-`#\tIF\f\u0005\u0002*5&\u00111L\u000b\u0002\b\u001d>$\b.\u001b8h!\tIS,\u0003\u0002_U\t\u0019\u0011I\\=\u0005\u000b\u0001,&\u0019\u0001-\u0003\u0003}\u0003\"AY5\u000f\u0005\r<gB\u00013g\u001d\t\u0011U-C\u0001Q\u0013\tqu*\u0003\u0002i\u001b\u00069\u0001/Y2lC\u001e,\u0017B\u00016l\u0005!qu\u000e\u001e5j]\u001e$&B\u00015N\u0003\u0019a\u0014N\\5u}Q\u0019a.\u001d:\u0015\u0005=\u0004\bcA\u001e\u0001'\")!\n\u0002a\u0002\u0017\")\u0001\b\u0002a\u0001u!)a\b\u0002a\u0001\u007f\u0005QQn\u001c8bI\u0016\u0013(o\u001c:\u0016\u0003U\u00042A^=T\u001b\u00059(B\u0001=N\u0003\u0015iwN\\1e\u0013\tQxO\u0001\u0006N_:\fG-\u0012:s_J\f1\"\\8oC\u0012,%O]8sA\u0005a\u0011N\u001c4mkb\u001cE.[3oiV\ta\u0010E\u0002<\u007fNK1!!\u0001\u001d\u0005I\u0019\u0016.\u001c9mK&sg\r\\;y\u00072LWM\u001c;\u0002\u001b%tg\r\\;y\u00072LWM\u001c;!\u0003]\tX/\u001a:z\u0005f\u001c\u0016N\\4mK\u0012KgMZ3sK:\u001cW\r\u0006\u0006\u0002\n\u0005]\u00111DA\u001b\u0003s\u0001B\u0001V+\u0002\fA1\u0001)!\u0004@\u0003#I1!a\u0004J\u0005\ri\u0015\r\u001d\t\u0004S\u0005M\u0011bAA\u000bU\t!Aj\u001c8h\u0011\u0019\tI\"\u0003a\u0001\u007f\u0005Y\u0001O]8dKN\u001ch*Y7f\u0011\u001d\ti\"\u0003a\u0001\u0003?\t\u0001\u0002Z1uK\u001a\u0013x.\u001c\t\u0006S\u0005\u0005\u0012QE\u0005\u0004\u0003GQ#AB(qi&|g\u000e\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\tQLW.\u001a\u0006\u0003\u0003_\tAA[1wC&!\u00111GA\u0015\u0005\u001dIen\u001d;b]RDq!a\u000e\n\u0001\u0004\t)#\u0001\u0004eCR,Gk\u001c\u0005\u0007q%\u0001\r!a\u000f\u0011\u0007m\ni$C\u0002\u0002@q\u0011Q\"T3ue&\u001c7oQ8oM&<\u0017aF9vKJL()_*v[>3G)\u001b4gKJ,gnY3t))\tI!!\u0012\u0002H\u0005%\u00131\n\u0005\u0007\u00033Q\u0001\u0019A \t\u000f\u0005u!\u00021\u0001\u0002&!9\u0011q\u0007\u0006A\u0002\u0005\u0015\u0002B\u0002\u001d\u000b\u0001\u0004\tY$\u0001\beKR,7\r\u001e*fgR\f'\u000f^:\u0015\u0015\u0005E\u00131MA3\u0003O\nI\u0007\u0005\u0003U+\u0006M\u0003CBA+\u0003;\n)C\u0004\u0003\u0002X\u0005mcb\u0001\"\u0002Z%\t1&\u0003\u0002iU%!\u0011qLA1\u0005\u0011a\u0015n\u001d;\u000b\u0005!T\u0003BBA\r\u0017\u0001\u0007q\bC\u0004\u0002\u001e-\u0001\r!!\n\t\u000f\u0005]2\u00021\u0001\u0002&!1\u0001h\u0003a\u0001\u0003w\tAD]3bIJ+7\u000f^1siN4%o\\7T_V\u00148-Z\"pk:$8\u000f\u0006\u0003\u0002T\u0005=\u0004bBA9\u0019\u0001\u0007\u00111O\u0001\rg>,(oY3D_VtGo\u001d\t\u0004w\u0005U\u0014bAA<9\ta\u0011J\u001c4mkb\u001cVM]5fg\u0006y\u0001/\u0019:tK&sg\r\\;y\t\u0006$X\r\u0006\u0003\u0002&\u0005u\u0004BBA@\u001b\u0001\u0007q(\u0001\u0003eCR,\u0017!B2m_N,GCAAC!\u0011!V+a\"\u0011\u0007%\nI)C\u0002\u0002\f*\u0012A!\u00168ji\u0006y\u0011J\u001c4mkb<UM\\3sCR|'\u000f\u0005\u0002<!M\u0019\u0001\u0003\u000b\u0018\u0015\u0005\u0005=\u0015A\n:fiJLWM^3P]2L(+Z:vYR4%o\\7BGRLwN\u001c,bYV,\u0017+^3ssV!\u0011\u0011TAP)!\tY*!,\u00020\u0006uF\u0003BAO\u0003K\u0003R\u0001VAP\u0003\u0017!aA\u0016\nC\u0002\u0005\u0005Vc\u0001-\u0002$\u00121\u0001-a(C\u0002aC\u0011\"a*\u0013\u0003\u0003\u0005\u001d!!+\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0003ws\u0006-\u0006c\u0001+\u0002 \"1\u0001H\u0005a\u0001\u0003wAq!!-\u0013\u0001\u0004\t\u0019,A\u0006j]Z|7.Z)vKJL\bCB\u0015\u00026~\nI,C\u0002\u00028*\u0012\u0011BR;oGRLwN\\\u0019\u0011\u000bQ\u000by*a/\u0011\r\u0005U\u0013QLA:\u0011\u0019\tyL\u0005a\u0001\u007f\u0005Y\u0011/^3ssN#(/\u001b8h\u0005A\u0001v.\u001b8u\u0013:$\u0016.\\3Rk\u0016\u0014\u00180\u0006\u0003\u0002F\u0006-7cA\n)]A1\u0011&!.@\u0003\u0013\u0004R\u0001VAf\u0003w#aAV\nC\u0002\u00055Wc\u0001-\u0002P\u00121\u0001-a3C\u0002a\u000b!\"\u001a<jI\u0016t7-\u001a\u00133!\u00111\u00180!6\u0011\u0007Q\u000bY\r\u0006\u0006\u0002Z\u0006\u0005\u00181]As\u0003O$B!a7\u0002`B)\u0011Q\\\n\u0002V6\t\u0001\u0003C\u0004\u0002Rf\u0001\u001d!a5\t\u000f\u0005E\u0016\u00041\u0001\u0002H\"1\u0011\u0011D\rA\u0002}BQAP\rA\u0002}Ba\u0001O\rA\u0002\u0005m\u0012!B9vKJLH\u0003BAw\u0003_\u0004R\u0001VAf\u0003\u0017Aq!a \u001b\u0001\u0004\t)\u0003")
public class InfluxGenerator<F>
implements LazyLogging {
    private final String env;
    private final MonadError<F> monadError;
    private final SimpleInfluxClient<F> influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <F> F retrieveOnlyResultFromActionValueQuery(MetricsConfig metricsConfig, Function1<String, F> function1, String string, MonadError<F> monadError) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(metricsConfig, function1, string, monadError);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private SimpleInfluxClient<F> influxClient() {
        return this.influxClient;
    }

    public F queryBySingleDifference(String processName, Option<Instant> dateFrom, Instant dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2), processName, this.env, config, this.monadError());
        return (F)syntax.MonadErrorOps$.MODULE$.flatMap$extension(syntax$.MODULE$.MonadErrorOps(pointInTimeQuery.query(dateTo)), (Function1 & Serializable & scala.Serializable)valuesAtEnd -> syntax.MonadErrorOps$.MODULE$.map$extension(syntax$.MODULE$.MonadErrorOps(dateFrom.map((Function1 & Serializable & scala.Serializable)date -> pointInTimeQuery.query((Instant)date)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.monadError().unit((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))), (Function1 & Serializable & scala.Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            long value = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), this.monadError()), this.monadError());
    }

    public F queryBySumOfDifferences(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        String query3 = new StringBuilder(173).append("select sum(diff) as count from (SELECT non_negative_difference(\"").append(config.countField()).append("\") AS diff\n     FROM \"").append(config.nodeCountMetric()).append("\"\n     WHERE ").append(config.envTag()).append(" = '").append(this.env).append("' AND ").append(config.scenarioTag()).append(" = '").append(processName).append("'\n     AND time > ").append(dateFrom.getEpochSecond()).append("s AND time < ").append(dateTo.getEpochSecond()).append("s\n     GROUP BY ").append(config.nodeIdTag()).append(", ").append(config.additionalGroupByTags().mkString(",")).append(") group by ").append(config.nodeIdTag()).toString();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2), query3, this.monadError());
    }

    public F detectRestarts(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        long from = dateFrom.getEpochSecond();
        long to = dateTo.getEpochSecond();
        String queryString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("SELECT diff FROM (\n         |  SELECT difference(").append(config.countField()).append(") as diff FROM \"").append(config.sourceCountMetric()).append("\" WHERE\n         | \"").append(config.scenarioTag()).append("\" = '").append(processName).append("' AND ").append(config.envTag()).append(" = '").append(this.env).append("'\n         | AND time >= ").append(from).append("s and time < ").append(to).append("s GROUP BY ").append(config.additionalGroupByTags().mkString(",")).append(", ").append(config.nodeIdTag()).append(") where diff < 0 ").toString())).stripMargin();
        return (F)syntax.MonadErrorOps$.MODULE$.map$extension(syntax$.MODULE$.MonadErrorOps(this.influxClient().query(queryString)), (Function1 & Serializable & scala.Serializable)series -> (List)series.headOption().map((Function1 & Serializable & scala.Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.monadError());
    }

    /*
     * WARNING - void declaration
     */
    private List<Instant> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        void var2_2;
        List restarts = (List)sourceCounts.values().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.tl$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.tl$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                object = this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                Object date = colon2.head();
                List list2 = colon2.tl$access$1();
                if (!(date instanceof String)) return false;
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                Object derivative = colon3.head();
                List list3 = colon3.tl$access$1();
                if (!(derivative instanceof BigDecimal)) return false;
                if (!Nil$.MODULE$.equals(list3)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return var2_2;
    }

    public Instant pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
    }

    public F close() {
        return this.influxClient().close();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<F, Nothing$, ?> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.monadError = backend.responseMonad();
        this.influxClient = new SimpleInfluxClient<F>(config, backend);
    }

    public static class PointInTimeQuery<F>
    implements LazyLogging {
        private final Function1<String, F> invokeQuery;
        private final String processName;
        private final String env;
        private final MetricsConfig config;
        private final MonadError<F> evidence$2;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
        }

        public F query(Instant date) {
            long around = date.getEpochSecond();
            return (F)syntax.MonadErrorOps$.MODULE$.flatMap$extension(syntax$.MODULE$.MonadErrorOps(InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(this.config, this.invokeQuery, this.query$1(new StringBuilder(27).append("time <= ").append(around).append("s and time > ").append(around).append("s - 1h").toString(), "last"), this.evidence$2)), (Function1 & Serializable & scala.Serializable)valuesBefore -> syntax.MonadErrorOps$.MODULE$.map$extension(syntax$.MODULE$.MonadErrorOps(InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1(new StringBuilder(27).append("time >= ").append(around).append("s and time < ").append(around).append("s + 1h").toString(), "first"), $this.evidence$2)), (Function1 & Serializable & scala.Serializable)valuesAfter -> valuesBefore.$plus$plus((GenTraversableOnce)valuesAfter), $this.evidence$2), this.evidence$2);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("select ").append(this.config.nodeIdTag()).append(" as nodeId, ").append(aggregateFunction).append("(").append(this.config.countField()).append(") as count\n           | from \"").append(this.config.nodeCountMetric()).append("\" where ").append(this.config.scenarioTag()).append(" = '").append(this.processName).append("'\n           | and ").append(timeCondition).append(" and ").append(this.config.envTag()).append(" = '").append(this.env).append("' group by ").append(this.config.additionalGroupByTags().mkString(",")).append(", ").append(this.config.nodeIdTag()).append(" fill(0)").toString())).stripMargin();
        }

        public PointInTimeQuery(Function1<String, F> invokeQuery, String processName, String env, MetricsConfig config, MonadError<F> evidence$2) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.evidence$2 = evidence$2;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

