/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.processCounts.CannotFetchCountsError$;
import pl.touk.nussknacker.processCounts.CountsReporter;
import pl.touk.nussknacker.processCounts.CountsRequest;
import pl.touk.nussknacker.processCounts.ExecutionCount;
import pl.touk.nussknacker.processCounts.RangeCount;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig$;
import pl.touk.nussknacker.processCounts.influxdb.QueryMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\b\u0011\u0001mA\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005^\u0001\t\u0005\t\u0015a\u0003_\u0011\u00151\u0007\u0001\"\u0001h\u0011\u001dq\u0007A1A\u0005\u0002=Daa\u001d\u0001!\u0002\u0013\u0001\bb\u0002;\u0001\u0005\u0004%Y!\u001e\u0005\u0007y\u0002\u0001\u000b\u0011\u0002<\t\u000fu\u0004!\u0019!C\u0005}\"9\u0011Q\u0001\u0001!\u0002\u0013y\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\ti\u0003\u0001C\u0005\u0003_\u0011A#\u00138gYVD8i\\;oiN\u0014V\r]8si\u0016\u0014(BA\t\u0013\u0003!IgN\u001a7vq\u0012\u0014'BA\n\u0015\u00035\u0001(o\\2fgN\u001cu.\u001e8ug*\u0011QCF\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u00181\u0005!Ao\\;l\u0015\u0005I\u0012A\u00019m\u0007\u0001)\"\u0001H\u0016\u0014\t\u0001iRE\u000f\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\nA\u0001\\1oO*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013 \u0005\u0019y%M[3diB\u0019aeJ\u0015\u000e\u0003II!\u0001\u000b\n\u0003\u001d\r{WO\u001c;t%\u0016\u0004xN\u001d;feB\u0011!f\u000b\u0007\u0001\t\u0015a\u0003A1\u0001.\u0005\u00051UC\u0001\u00189#\tyS\u0007\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0004O_RD\u0017N\\4\u0011\u0005A2\u0014BA\u001c2\u0005\r\te.\u001f\u0003\u0006s-\u0012\rA\f\u0002\u0002?B\u00111HQ\u0007\u0002y)\u0011QHP\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u007f\u0001\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0003\u0006\u00191m\\7\n\u0005\rc$a\u0003'bufdunZ4j]\u001e\f1!\u001a8w!\t1UJ\u0004\u0002H\u0017B\u0011\u0001*M\u0007\u0002\u0013*\u0011!JG\u0001\u0007yI|w\u000e\u001e \n\u00051\u000b\u0014A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001T\u0019\u0002\r\r|gNZ5h!\t\u00116+D\u0001\u0011\u0013\t!\u0006C\u0001\u0007J]\u001adW\u000f_\"p]\u001aLw-\u0001\u0007xC&$hi\u001c:DY>\u001cX\r\u0005\u00031/fS\u0016B\u0001-2\u0005%1UO\\2uS>t\u0017\u0007E\u0002+Wi\u0003\"\u0001M.\n\u0005q\u000b$\u0001B+oSR\fqAY1dW\u0016tG\r\u0005\u0003`I&*T\"\u00011\u000b\u0005\u0005\u0014\u0017aB2mS\u0016tGo\r\u0006\u0002G\u0006!1\u000f\u001e;q\u0013\t)\u0007MA\u0006TiR\u0004()Y2lK:$\u0017A\u0002\u001fj]&$h\b\u0006\u0003iW2lGCA5k!\r\u0011\u0006!\u000b\u0005\u0006;\u0016\u0001\u001dA\u0018\u0005\u0006\t\u0016\u0001\r!\u0012\u0005\u0006!\u0016\u0001\r!\u0015\u0005\u0006+\u0016\u0001\rAV\u0001\u0010S:4G.\u001e=HK:,'/\u0019;peV\t\u0001\u000fE\u0002Sc&J!A\u001d\t\u0003\u001f%sg\r\\;y\u000f\u0016tWM]1u_J\f\u0001#\u001b8gYVDx)\u001a8fe\u0006$xN\u001d\u0011\u0002\u00155|g.\u00193FeJ|'/F\u0001w!\r9(0K\u0007\u0002q*\u0011\u0011PY\u0001\u0006[>t\u0017\rZ\u0005\u0003wb\u0014!\"T8oC\u0012,%O]8s\u0003-iwN\\1e\u000bJ\u0014xN\u001d\u0011\u0002\u001b5,GO]5dg\u000e{gNZ5h+\u0005y\bc\u0001*\u0002\u0002%\u0019\u00111\u0001\t\u0003\u001b5+GO]5dg\u000e{gNZ5h\u00039iW\r\u001e:jGN\u001cuN\u001c4jO\u0002\n\u0001\u0003\u001d:fa\u0006\u0014XMU1x\u0007>,h\u000e^:\u0015\r\u0005-\u00111DA\u0010!\u0011Q3&!\u0004\u0011\u000bA:V)a\u0004\u0011\u000bA\n\t\"!\u0006\n\u0007\u0005M\u0011G\u0001\u0004PaRLwN\u001c\t\u0004a\u0005]\u0011bAA\rc\t!Aj\u001c8h\u0011\u0019\ti\u0002\u0004a\u0001\u000b\u0006I\u0001O]8dKN\u001c\u0018\n\u001a\u0005\b\u0003Ca\u0001\u0019AA\u0012\u00035\u0019w.\u001e8ugJ+\u0017/^3tiB\u0019a%!\n\n\u0007\u0005\u001d\"CA\u0007D_VtGo\u001d*fcV,7\u000f^\u0001\u0006G2|7/\u001a\u000b\u00025\u0006\u0011\u0002O]3qCJ,'+\u00198hK\u000e{WO\u001c;t)!\t\t$!\u000f\u0002<\u0005-\u0003\u0003\u0002\u0016,\u0003g\u0001bARA\u001b\u000b\u0006U\u0011bAA\u001c\u001f\n\u0019Q*\u00199\t\r\u0005ua\u00021\u0001F\u0011\u001d\tiD\u0004a\u0001\u0003\u007f\t\u0001B\u001a:p[\u0012\u000bG/\u001a\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI\u0011\u0002\tQLW.Z\u0005\u0005\u0003\u0013\n\u0019EA\u0004J]N$\u0018M\u001c;\t\u000f\u00055c\u00021\u0001\u0002@\u00051Ao\u001c#bi\u0016\u0004")
public class InfluxCountsReporter<F>
implements CountsReporter<F>,
LazyLogging {
    private final InfluxConfig config;
    private final Function1<F, BoxedUnit> waitForClose;
    private final InfluxGenerator<F> influxGenerator;
    private final MonadError<F> monadError;
    private final MetricsConfig metricsConfig;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxCountsReporter influxCountsReporter = this;
        synchronized (influxCountsReporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public InfluxGenerator<F> influxGenerator() {
        return this.influxGenerator;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public F prepareRawCounts(String processId, CountsRequest countsRequest) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> {
            Object f;
            CountsRequest countsRequest = countsRequest;
            if (countsRequest instanceof RangeCount) {
                RangeCount rangeCount = (RangeCount)countsRequest;
                Instant fromDate = rangeCount.fromDate();
                Instant toDate = rangeCount.toDate();
                f = this.prepareRangeCounts(processId, fromDate, toDate);
            } else if (countsRequest instanceof ExecutionCount) {
                ExecutionCount executionCount = (ExecutionCount)countsRequest;
                Instant pointInTime = executionCount.pointInTime();
                f = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)None$.MODULE$, pointInTime, this.metricsConfig());
            } else {
                throw new MatchError((Object)countsRequest);
            }
            return f;
        }).map((Function1 & Serializable & scala.Serializable)x$1 -> (Function1 & Serializable & scala.Serializable)key -> x$1.get(key), this.monadError());
    }

    @Override
    public void close() {
        this.waitForClose.apply(this.influxGenerator().close());
    }

    private F prepareRangeCounts(String processId, Instant fromDate, Instant toDate) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> this.influxGenerator().detectRestarts(processId, fromDate, toDate, this.metricsConfig())).flatMap((Function1 & Serializable & scala.Serializable)restarts -> {
            void var5_14;
            Tuple2 tuple2 = new Tuple2(restarts, (Object)$this.config.queryMode());
            if (tuple2 != null) {
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value2 = QueryMode$.MODULE$.OnlySumOfDifferences();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    Object f = this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                    return var5_14;
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value4 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        Object f = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                        return var5_14;
                    }
                }
            }
            if (tuple2 != null) {
                List nonEmpty = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value6 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Restarts detected: {}, querying with differential", new Object[]{nonEmpty.mkString(",")});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object f = this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                    return var5_14;
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value8 = QueryMode$.MODULE$.OnlySingleDifference();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        Object f = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                        return var5_14;
                    }
                }
            }
            if (tuple2 != null) {
                List dates = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value10 = QueryMode$.MODULE$.OnlySingleDifference();
                Enumeration.Value value11 = value;
                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                    Object object = this.monadError().error((Throwable)CannotFetchCountsError$.MODULE$.restartsDetected((List<Instant>)dates));
                    return var5_14;
                }
            }
            Object object = this.monadError().error((Throwable)new IllegalArgumentException(new StringBuilder(32).append("Unknown QueryMode ").append($this.config.queryMode()).append(" for ").append(restarts.size()).append(" restarts").toString()));
            return var5_14;
        }, this.monadError());
    }

    public InfluxCountsReporter(String env, InfluxConfig config, Function1<F, BoxedUnit> waitForClose, SttpBackend<F, Object> backend) {
        this.config = config;
        this.waitForClose = waitForClose;
        LazyLogging.$init$((LazyLogging)this);
        this.influxGenerator = new InfluxGenerator<F>(config, env, backend);
        this.monadError = backend.responseMonad();
        this.metricsConfig = (MetricsConfig)config.metricsConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> new MetricsConfig(MetricsConfig$.MODULE$.apply$default$1(), MetricsConfig$.MODULE$.apply$default$2(), MetricsConfig$.MODULE$.apply$default$3(), MetricsConfig$.MODULE$.apply$default$4(), MetricsConfig$.MODULE$.apply$default$5(), MetricsConfig$.MODULE$.apply$default$6(), MetricsConfig$.MODULE$.apply$default$7()));
    }
}

