/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug!B\u000e\u001d\u0001q1\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ya\u0013\u0005\u0006C\u0002!\tA\u0019\u0005\bQ\u0002\u0011\r\u0011b\u0003j\u0011\u0019\u0001\b\u0001)A\u0005U\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bB\u0002<\u0001A\u0003%1\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011q\u000b\u0001\u0005\n\u0005e\u0003bBA3\u0001\u0011%\u0011q\r\u0005\b\u0003[\u0002A\u0011AA8\u000f\u001d\tI\b\bE\u0001\u0003w2aa\u0007\u000f\t\u0002\u0005u\u0004BB1\u0011\t\u0003\ty\bC\u0004\u0002\u0002B!\t!a!\u0007\r\u00055\u0006\u0003AAX\u0011)\tij\u0005B\u0001B\u0003%\u00111\u0017\u0005\n\u0003\u0007\u0019\"\u0011!Q\u0001\n}B\u0001BP\n\u0003\u0002\u0003\u0006Ia\u0010\u0005\nqM\u0011\t\u0011)A\u0005\u0003KA!\"!0\u0014\u0005\u0007\u0005\u000b1BA`\u0011\u0019\t7\u0003\"\u0001\u0002D\"9\u0011Q[\n\u0005\u0002\u0005]'aD%oM2,\bpR3oKJ\fGo\u001c:\u000b\u0005uq\u0012\u0001C5oM2,\b\u0010\u001a2\u000b\u0005}\u0001\u0013!\u00049s_\u000e,7o]\"pk:$8O\u0003\u0002\"E\u0005Ya.^:tW:\f7m[3s\u0015\t\u0019C%\u0001\u0003u_V\\'\"A\u0013\u0002\u0005AdWCA\u0014V'\r\u0001\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=2T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001D:dC2\fGn\\4hS:<'BA\u001a5\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001b\u0002\u0007\r|W.\u0003\u00028a\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jO\u000e\u0001\u0001CA\u001e=\u001b\u0005a\u0012BA\u001f\u001d\u00051IeN\u001a7vq\u000e{gNZ5h\u0003\r)gN\u001e\t\u0003\u0001\u001es!!Q#\u0011\u0005\tSS\"A\"\u000b\u0005\u0011K\u0014A\u0002\u001fs_>$h(\u0003\u0002GU\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1%&A\u0004cC\u000e\\WM\u001c3\u0011\t1\u000b6\u000bX\u0007\u0002\u001b*\u0011ajT\u0001\bG2LWM\u001c;4\u0015\u0005\u0001\u0016\u0001B:uiBL!AU'\u0003\u0017M#H\u000f\u001d\"bG.,g\u000e\u001a\t\u0003)Vc\u0001\u0001B\u0003W\u0001\t\u0007qKA\u0001G+\tAv,\u0005\u0002Z9B\u0011\u0011FW\u0005\u00037*\u0012qAT8uQ&tw\r\u0005\u0002*;&\u0011aL\u000b\u0002\u0004\u0003:LH!\u00021V\u0005\u0004A&!A0\u0002\rqJg.\u001b;?)\r\u0019gm\u001a\u000b\u0003I\u0016\u00042a\u000f\u0001T\u0011\u0015QE\u0001q\u0001L\u0011\u0015AD\u00011\u0001;\u0011\u0015qD\u00011\u0001@\u0003)iwN\\1e\u000bJ\u0014xN]\u000b\u0002UB\u00191N\\*\u000e\u00031T!!\\(\u0002\u000b5|g.\u00193\n\u0005=d'AC'p]\u0006$WI\u001d:pe\u0006YQn\u001c8bI\u0016\u0013(o\u001c:!\u00031IgN\u001a7vq\u000ec\u0017.\u001a8u+\u0005\u0019\bcA\u001eu'&\u0011Q\u000f\b\u0002\u0013'&l\u0007\u000f\\3J]\u001adW\u000f_\"mS\u0016tG/A\u0007j]\u001adW\u000f_\"mS\u0016tG\u000fI\u0001\u0018cV,'/\u001f\"z'&tw\r\\3ES\u001a4WM]3oG\u0016$\u0012\"_A\u0001\u0003\u000b\ty\"a\t\u0011\u0007Q+&\u0010\u0005\u0003Aw~j\u0018B\u0001?J\u0005\ri\u0015\r\u001d\t\u0003SyL!a \u0016\u0003\t1{gn\u001a\u0005\u0007\u0003\u0007I\u0001\u0019A \u0002\u0017A\u0014xnY3tg:\u000bW.\u001a\u0005\b\u0003\u000fI\u0001\u0019AA\u0005\u0003!!\u0017\r^3Ge>l\u0007#B\u0015\u0002\f\u0005=\u0011bAA\u0007U\t1q\n\u001d;j_:\u0004B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003uS6,'BAA\r\u0003\u0011Q\u0017M^1\n\t\u0005u\u00111\u0003\u0002\b\u0013:\u001cH/\u00198u\u0011\u001d\t\t#\u0003a\u0001\u0003\u001f\ta\u0001Z1uKR{\u0007B\u0002\u001d\n\u0001\u0004\t)\u0003E\u0002<\u0003OI1!!\u000b\u001d\u00055iU\r\u001e:jGN\u001cuN\u001c4jO\u00069\u0012/^3ss\nK8+^7PM\u0012KgMZ3sK:\u001cWm\u001d\u000b\ns\u0006=\u0012\u0011GA\u001a\u0003kAa!a\u0001\u000b\u0001\u0004y\u0004bBA\u0004\u0015\u0001\u0007\u0011q\u0002\u0005\b\u0003CQ\u0001\u0019AA\b\u0011\u0019A$\u00021\u0001\u0002&\u0005qA-\u001a;fGR\u0014Vm\u001d;beR\u001cHCCA\u001e\u0003\u001f\n\t&a\u0015\u0002VA!A+VA\u001f!\u0019\ty$!\u0013\u0002\u00109!\u0011\u0011IA#\u001d\r\u0011\u00151I\u0005\u0002W%\u0019\u0011q\t\u0016\u0002\u000fA\f7m[1hK&!\u00111JA'\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u001d#\u0006\u0003\u0004\u0002\u0004-\u0001\ra\u0010\u0005\b\u0003\u000fY\u0001\u0019AA\b\u0011\u001d\t\tc\u0003a\u0001\u0003\u001fAa\u0001O\u0006A\u0002\u0005\u0015\u0012\u0001\b:fC\u0012\u0014Vm\u001d;beR\u001chI]8n'>,(oY3D_VtGo\u001d\u000b\u0005\u0003{\tY\u0006C\u0004\u0002^1\u0001\r!a\u0018\u0002\u0019M|WO]2f\u0007>,h\u000e^:\u0011\u0007m\n\t'C\u0002\u0002dq\u0011A\"\u00138gYVD8+\u001a:jKN\fq\u0002]1sg\u0016LeN\u001a7vq\u0012\u000bG/\u001a\u000b\u0005\u0003\u001f\tI\u0007\u0003\u0004\u0002l5\u0001\raP\u0001\u0005I\u0006$X-A\u0003dY>\u001cX\r\u0006\u0002\u0002rA!A+VA:!\rI\u0013QO\u0005\u0004\u0003oR#\u0001B+oSR\fq\"\u00138gYVDx)\u001a8fe\u0006$xN\u001d\t\u0003wA\u00192\u0001\u0005\u0015/)\t\tY(\u0001\u0014sKR\u0014\u0018.\u001a<f\u001f:d\u0017PU3tk2$hI]8n\u0003\u000e$\u0018n\u001c8WC2,X-U;fef,B!!\"\u0002\fRA\u0011qQAM\u00037\u000bI\u000b\u0006\u0003\u0002\n\u0006E\u0005\u0003\u0002+\u0002\fj$aA\u0016\nC\u0002\u00055Uc\u0001-\u0002\u0010\u00121\u0001-a#C\u0002aC\u0011\"a%\u0013\u0003\u0003\u0005\u001d!!&\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0003l]\u0006]\u0005c\u0001+\u0002\f\"1\u0001H\u0005a\u0001\u0003KAq!!(\u0013\u0001\u0004\ty*A\u0006j]Z|7.Z)vKJL\bCB\u0015\u0002\"~\n)+C\u0002\u0002$*\u0012\u0011BR;oGRLwN\\\u0019\u0011\u000bQ\u000bY)a*\u0011\r\u0005}\u0012\u0011JA0\u0011\u0019\tYK\u0005a\u0001\u007f\u0005Y\u0011/^3ssN#(/\u001b8h\u0005A\u0001v.\u001b8u\u0013:$\u0016.\\3Rk\u0016\u0014\u00180\u0006\u0003\u00022\u0006]6cA\n)]A1\u0011&!)@\u0003k\u0003R\u0001VA\\\u0003O#aAV\nC\u0002\u0005eVc\u0001-\u0002<\u00121\u0001-a.C\u0002a\u000b!\"\u001a<jI\u0016t7-\u001a\u00133!\u0011Yg.!1\u0011\u0007Q\u000b9\f\u0006\u0006\u0002F\u00065\u0017qZAi\u0003'$B!a2\u0002LB)\u0011\u0011Z\n\u0002B6\t\u0001\u0003C\u0004\u0002>f\u0001\u001d!a0\t\u000f\u0005u\u0015\u00041\u0001\u00024\"1\u00111A\rA\u0002}BQAP\rA\u0002}Ba\u0001O\rA\u0002\u0005\u0015\u0012!B9vKJLH\u0003BAm\u00037\u0004B\u0001VA\\u\"9\u00111\u000e\u000eA\u0002\u0005=\u0001")
public class InfluxGenerator<F>
implements LazyLogging {
    private final String env;
    private final MonadError<F> monadError;
    private final SimpleInfluxClient<F> influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <F> F retrieveOnlyResultFromActionValueQuery(MetricsConfig metricsConfig, Function1<String, F> function1, String string, MonadError<F> monadError) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(metricsConfig, function1, string, monadError);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private SimpleInfluxClient<F> influxClient() {
        return this.influxClient;
    }

    public F queryBySingleDifference(String processName, Option<Instant> dateFrom, Instant dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2), processName, this.env, config, this.monadError());
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> pointInTimeQuery.query(dateTo)).flatMap((Function1 & Serializable & scala.Serializable)valuesAtEnd -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> dateFrom.map((Function1 & Serializable & scala.Serializable)date -> pointInTimeQuery.query((Instant)date)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.monadError().unit((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            long value = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()), this.monadError()), this.monadError());
    }

    public F queryBySumOfDifferences(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        String query3 = new StringBuilder(173).append("select sum(diff) as count from (SELECT non_negative_difference(\"").append(config.countField()).append("\") AS diff\n     FROM \"").append(config.nodeCountMetric()).append("\"\n     WHERE ").append(config.envTag()).append(" = '").append(this.env).append("' AND ").append(config.scenarioTag()).append(" = '").append(processName).append("'\n     AND time > ").append(dateFrom.getEpochSecond()).append("s AND time < ").append(dateTo.getEpochSecond()).append("s\n     GROUP BY ").append(config.nodeIdTag()).append(", ").append(config.additionalGroupByTags().mkString(",")).append(") group by ").append(config.nodeIdTag()).toString();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1 & Serializable & scala.Serializable)query2 -> this.influxClient().query((String)query2), query3, this.monadError());
    }

    public F detectRestarts(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        long from = dateFrom.getEpochSecond();
        long to = dateTo.getEpochSecond();
        String queryString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("SELECT diff FROM (\n         |  SELECT difference(").append(config.countField()).append(") as diff FROM \"").append(config.sourceCountMetric()).append("\" WHERE\n         | \"").append(config.scenarioTag()).append("\" = '").append(processName).append("' AND ").append(config.envTag()).append(" = '").append(this.env).append("'\n         | AND time >= ").append(from).append("s and time < ").append(to).append("s GROUP BY ").append(config.additionalGroupByTags().mkString(",")).append(", ").append(config.nodeIdTag()).append(") where diff < 0 ").toString())).stripMargin();
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> this.influxClient().query(queryString)).map((Function1 & Serializable & scala.Serializable)series -> (List)series.headOption().map((Function1 & Serializable & scala.Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.monadError());
    }

    /*
     * WARNING - void declaration
     */
    private List<Instant> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        void var2_2;
        List restarts = (List)sourceCounts.values().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.tl$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.tl$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                object = this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (!(list instanceof .colon.colon)) return false;
                .colon.colon colon2 = (.colon.colon)list;
                Object date = colon2.head();
                List list2 = colon2.tl$access$1();
                if (!(date instanceof String)) return false;
                if (!(list2 instanceof .colon.colon)) return false;
                .colon.colon colon3 = (.colon.colon)list2;
                Object derivative = colon3.head();
                List list3 = colon3.tl$access$1();
                if (!(derivative instanceof BigDecimal)) return false;
                if (!Nil$.MODULE$.equals(list3)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return var2_2;
    }

    public Instant pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
    }

    public F close() {
        return this.influxClient().close();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<F, Object> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.monadError = backend.responseMonad();
        this.influxClient = new SimpleInfluxClient<F>(config, backend);
    }

    public static class PointInTimeQuery<F>
    implements LazyLogging {
        private final Function1<String, F> invokeQuery;
        private final String processName;
        private final String env;
        private final MetricsConfig config;
        private final MonadError<F> evidence$2;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
        }

        public F query(Instant date) {
            long around = date.getEpochSecond();
            return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1(new StringBuilder(27).append("time <= ").append(around).append("s and time > ").append(around).append("s - 1h").toString(), "last"), $this.evidence$2)).flatMap((Function1 & Serializable & scala.Serializable)valuesBefore -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable & scala.Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1(new StringBuilder(27).append("time >= ").append(around).append("s and time < ").append(around).append("s + 1h").toString(), "first"), $this.evidence$2)).map((Function1 & Serializable & scala.Serializable)valuesAfter -> valuesBefore.$plus$plus((GenTraversableOnce)valuesAfter), $this.evidence$2), this.evidence$2);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("select ").append(this.config.nodeIdTag()).append(" as nodeId, ").append(aggregateFunction).append("(").append(this.config.countField()).append(") as count\n           | from \"").append(this.config.nodeCountMetric()).append("\" where ").append(this.config.scenarioTag()).append(" = '").append(this.processName).append("'\n           | and ").append(timeCondition).append(" and ").append(this.config.envTag()).append(" = '").append(this.env).append("' group by ").append(this.config.additionalGroupByTags().mkString(",")).append(", ").append(this.config.nodeIdTag()).append(" fill(0)").toString())).stripMargin();
        }

        public PointInTimeQuery(Function1<String, F> invokeQuery, String processName, String env, MetricsConfig config, MonadError<F> evidence$2) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.evidence$2 = evidence$2;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

