/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0005\u0005=h!B\u000e\u001d\u0001q1\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ya\u0013\u0005\u0006C\u0002!\tA\u0019\u0005\bQ\u0002\u0011\r\u0011b\u0003j\u0011\u0019\u0001\b\u0001)A\u0005U\"9\u0011\u000f\u0001b\u0001\n\u0013\u0011\bBB?\u0001A\u0003%1\u000fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003w\u0002A\u0011AA?\u000f\u001d\t9\t\bE\u0001\u0003\u00133aa\u0007\u000f\t\u0002\u0005-\u0005BB1\u0011\t\u0003\ti\tC\u0004\u0002\u0010B!\t!!%\u0007\r\u0005u\u0006\u0003AA`\u0011)\tik\u0005B\u0001B\u0003%\u00111\u0019\u0005\n\u0003#\u0019\"\u0011!Q\u0001\n}B\u0001BP\n\u0003\u0002\u0003\u0006Ia\u0010\u0005\nqM\u0011\t\u0011)A\u0005\u0003gA!\"a4\u0014\u0005\u0007\u0005\u000b1BAi\u0011\u0019\t7\u0003\"\u0001\u0002V\"9\u0011q]\n\u0005\u0002\u0005%(aD%oM2,\bpR3oKJ\fGo\u001c:\u000b\u0005uq\u0012\u0001C5oM2,\b\u0010\u001a2\u000b\u0005}\u0001\u0013!\u00049s_\u000e,7o]\"pk:$8O\u0003\u0002\"E\u0005Ya.^:tW:\f7m[3s\u0015\t\u0019C%\u0001\u0003u_V\\'\"A\u0013\u0002\u0005AdWCA\u0014V'\r\u0001\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=2T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001D:dC2\fGn\\4hS:<'BA\u001a5\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001b\u0002\u0007\r|W.\u0003\u00028a\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u0019\u0019wN\u001c4jO\u000e\u0001\u0001CA\u001e=\u001b\u0005a\u0012BA\u001f\u001d\u00051IeN\u001a7vq\u000e{gNZ5h\u0003\r)gN\u001e\t\u0003\u0001\u001es!!Q#\u0011\u0005\tSS\"A\"\u000b\u0005\u0011K\u0014A\u0002\u001fs_>$h(\u0003\u0002GU\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1%&A\u0004cC\u000e\\WM\u001c3\u0011\t1\u000b6\u000bX\u0007\u0002\u001b*\u0011ajT\u0001\bG2LWM\u001c;4\u0015\u0005\u0001\u0016\u0001B:uiBL!AU'\u0003\u0017M#H\u000f\u001d\"bG.,g\u000e\u001a\t\u0003)Vc\u0001\u0001B\u0003W\u0001\t\u0007qKA\u0001G+\tAv,\u0005\u0002Z9B\u0011\u0011FW\u0005\u00037*\u0012qAT8uQ&tw\r\u0005\u0002*;&\u0011aL\u000b\u0002\u0004\u0003:LH!\u00021V\u0005\u0004A&\u0001B0%IE\na\u0001P5oSRtDcA2gOR\u0011A-\u001a\t\u0004w\u0001\u0019\u0006\"\u0002&\u0005\u0001\bY\u0005\"\u0002\u001d\u0005\u0001\u0004Q\u0004\"\u0002 \u0005\u0001\u0004y\u0014AC7p]\u0006$WI\u001d:peV\t!\u000eE\u0002l]Nk\u0011\u0001\u001c\u0006\u0003[>\u000bQ!\\8oC\u0012L!a\u001c7\u0003\u00155{g.\u00193FeJ|'/A\u0006n_:\fG-\u0012:s_J\u0004\u0013\u0001D5oM2,\bp\u00117jK:$X#A:\u0011\u0007m\"h/\u0003\u0002v9\t\u00112+[7qY\u0016LeN\u001a7vq\u000ec\u0017.\u001a8u+\t9\u0018\u0010E\u0002U+b\u0004\"\u0001V=\u0005\u000b\u0001T(\u0019\u0001-\t\tm,\u0006\u0001`\u0001\ny1|7-\u00197!\rzZ\u0001!A\u0007j]\u001adW\u000f_\"mS\u0016tG\u000fI\u0001\u0018cV,'/\u001f\"z'&tw\r\\3ES\u001a4WM]3oG\u0016$\"\"!\u0001\u0002\u0010\u0005M\u0011QFA\u0019!\u0011!V+a\u0001\u0011\r\u0001\u000b)aPA\u0005\u0013\r\t9!\u0013\u0002\u0004\u001b\u0006\u0004\bcA\u0015\u0002\f%\u0019\u0011Q\u0002\u0016\u0003\t1{gn\u001a\u0005\u0007\u0003#I\u0001\u0019A \u0002\u0017A\u0014xnY3tg:\u000bW.\u001a\u0005\b\u0003+I\u0001\u0019AA\f\u0003!!\u0017\r^3Ge>l\u0007#B\u0015\u0002\u001a\u0005u\u0011bAA\u000eU\t1q\n\u001d;j_:\u0004B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0003uS6,'BAA\u0014\u0003\u0011Q\u0017M^1\n\t\u0005-\u0012\u0011\u0005\u0002\b\u0013:\u001cH/\u00198u\u0011\u001d\ty#\u0003a\u0001\u0003;\ta\u0001Z1uKR{\u0007B\u0002\u001d\n\u0001\u0004\t\u0019\u0004E\u0002<\u0003kI1!a\u000e\u001d\u00055iU\r\u001e:jGN\u001cuN\u001c4jO\u00069\u0012/^3ss\nK8+^7PM\u0012KgMZ3sK:\u001cWm\u001d\u000b\u000b\u0003\u0003\ti$a\u0010\u0002B\u0005\r\u0003BBA\t\u0015\u0001\u0007q\bC\u0004\u0002\u0016)\u0001\r!!\b\t\u000f\u0005=\"\u00021\u0001\u0002\u001e!1\u0001H\u0003a\u0001\u0003g\ta\u0002Z3uK\u000e$(+Z:uCJ$8\u000f\u0006\u0006\u0002J\u0005u\u0013qLA1\u0003G\u0002B\u0001V+\u0002LA1\u0011QJA,\u0003;qA!a\u0014\u0002T9\u0019!)!\u0015\n\u0003-J1!!\u0016+\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0017\u0002\\\t!A*[:u\u0015\r\t)F\u000b\u0005\u0007\u0003#Y\u0001\u0019A \t\u000f\u0005U1\u00021\u0001\u0002\u001e!9\u0011qF\u0006A\u0002\u0005u\u0001B\u0002\u001d\f\u0001\u0004\t\u0019$\u0001\u000fsK\u0006$'+Z:uCJ$8O\u0012:p[N{WO]2f\u0007>,h\u000e^:\u0015\t\u0005-\u0013\u0011\u000e\u0005\b\u0003Wb\u0001\u0019AA7\u00031\u0019x.\u001e:dK\u000e{WO\u001c;t!\rY\u0014qN\u0005\u0004\u0003cb\"\u0001D%oM2,\bpU3sS\u0016\u001c\u0018a\u00049beN,\u0017J\u001c4mkb$\u0015\r^3\u0015\t\u0005u\u0011q\u000f\u0005\u0007\u0003sj\u0001\u0019A \u0002\t\u0011\fG/Z\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u007f\u0002B\u0001V+\u0002\u0002B\u0019\u0011&a!\n\u0007\u0005\u0015%F\u0001\u0003V]&$\u0018aD%oM2,\bpR3oKJ\fGo\u001c:\u0011\u0005m\u00022c\u0001\t)]Q\u0011\u0011\u0011R\u0001'e\u0016$(/[3wK>sG.\u001f*fgVdGO\u0012:p[\u0006\u001bG/[8o-\u0006dW/Z)vKJLX\u0003BAJ\u00033#\u0002\"!&\u0002*\u0006-\u0016\u0011\u0018\u000b\u0005\u0003/\u000b\t\u000bE\u0003U\u00033\u000b\u0019\u0001\u0002\u0004W%\t\u0007\u00111T\u000b\u00041\u0006uEaBAP\u00033\u0013\r\u0001\u0017\u0002\u0005?\u0012\"#\u0007C\u0005\u0002$J\t\t\u0011q\u0001\u0002&\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\t-t\u0017q\u0015\t\u0004)\u0006e\u0005B\u0002\u001d\u0013\u0001\u0004\t\u0019\u0004C\u0004\u0002.J\u0001\r!a,\u0002\u0017%tgo\\6f#V,'/\u001f\t\u0007S\u0005Ev(!.\n\u0007\u0005M&FA\u0005Gk:\u001cG/[8ocA)A+!'\u00028B1\u0011QJA,\u0003[Ba!a/\u0013\u0001\u0004y\u0014aC9vKJL8\u000b\u001e:j]\u001e\u0014\u0001\u0003U8j]RLe\u000eV5nKF+XM]=\u0016\t\u0005\u0005\u0017qY\n\u0004'!r\u0003CB\u0015\u00022~\n)\rE\u0003U\u0003\u000f\f9\f\u0002\u0004W'\t\u0007\u0011\u0011Z\u000b\u00041\u0006-GaBAg\u0003\u000f\u0014\r\u0001\u0017\u0002\u0005?\u0012\"3'\u0001\u0006fm&$WM\\2fII\u0002Ba\u001b8\u0002TB\u0019A+a2\u0015\u0015\u0005]\u0017q\\Aq\u0003G\f)\u000f\u0006\u0003\u0002Z\u0006u\u0007#BAn'\u0005MW\"\u0001\t\t\u000f\u0005=\u0017\u0004q\u0001\u0002R\"9\u0011QV\rA\u0002\u0005\r\u0007BBA\t3\u0001\u0007q\bC\u0003?3\u0001\u0007q\b\u0003\u000493\u0001\u0007\u00111G\u0001\u0006cV,'/\u001f\u000b\u0005\u0003W\fi\u000fE\u0003U\u0003\u000f\f\u0019\u0001C\u0004\u0002zi\u0001\r!!\b")
public class InfluxGenerator<F>
implements LazyLogging {
    private final String env;
    private final MonadError<F> monadError;
    private final SimpleInfluxClient<?> influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <F> F retrieveOnlyResultFromActionValueQuery(MetricsConfig config, Function1<String, F> invokeQuery, String queryString, MonadError<F> evidence$1) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, invokeQuery, queryString, evidence$1);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private SimpleInfluxClient<?> influxClient() {
        return this.influxClient;
    }

    public F queryBySingleDifference(String processName, Option<Instant> dateFrom, Instant dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1 & Serializable)query2 -> this.influxClient().query((String)query2), processName, this.env, config, this.monadError());
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> pointInTimeQuery.query(dateTo)).flatMap((Function1 & Serializable)valuesAtEnd -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> dateFrom.map((Function1 & Serializable)date -> pointInTimeQuery.query((Instant)date)).getOrElse((Function0 & Serializable)() -> this.monadError().unit(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                long value = tuple2._2$mcJ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)))));
            }
            throw new MatchError((Object)tuple2);
        }), this.monadError()), this.monadError());
    }

    public F queryBySumOfDifferences(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        String query3 = "select sum(diff) as count from (SELECT non_negative_difference(\"" + config.countField() + "\") AS diff\n     FROM \"" + config.nodeCountMetric() + "\"\n     WHERE " + config.envTag() + " = '" + this.env + "' AND " + config.scenarioTag() + " = '" + processName + "'\n     AND time > " + dateFrom.getEpochSecond() + "s AND time < " + dateTo.getEpochSecond() + "s\n     GROUP BY " + config.nodeIdTag() + ", " + config.additionalGroupByTags().mkString(",") + ") group by " + config.nodeIdTag();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1 & Serializable)query2 -> this.influxClient().query((String)query2), query3, this.monadError());
    }

    public F detectRestarts(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        long from = dateFrom.getEpochSecond();
        long to = dateTo.getEpochSecond();
        String queryString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT diff FROM (\n         |  SELECT difference(" + config.countField() + ") as diff FROM \"" + config.sourceCountMetric() + "\" WHERE\n         | \"" + config.scenarioTag() + "\" = '" + processName + "' AND " + config.envTag() + " = '" + this.env + "'\n         | AND time >= " + from + "s and time < " + to + "s GROUP BY " + config.additionalGroupByTags().mkString(",") + ", " + config.nodeIdTag() + ") where diff < 0 "));
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> this.influxClient().query(queryString)).map((Function1 & Serializable)series -> (List)series.headOption().map((Function1 & Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$), this.monadError());
    }

    private List<Instant> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        List restarts = sourceCounts.values().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.next$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.next$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                return (B1)this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                            }
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    Object date = colon2.head();
                    List list2 = colon2.next$access$1();
                    if (date instanceof String && list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        Object derivative = colon3.head();
                        List list3 = colon3.next$access$1();
                        if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list3)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return restarts;
    }

    public Instant pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
    }

    public F close() {
        return (F)this.influxClient().close();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<F, Object> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.monadError = backend.responseMonad();
        this.influxClient = new SimpleInfluxClient<F>(config, backend);
    }

    public static class PointInTimeQuery<F>
    implements LazyLogging {
        private final Function1<String, F> invokeQuery;
        private final String processName;
        private final String env;
        private final MetricsConfig config;
        private final MonadError<F> evidence$2;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        public F query(Instant date) {
            long around = date.getEpochSecond();
            return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1("time <= " + around + "s and time > " + around + "s - 1h", "last"), $this.evidence$2)).flatMap((Function1 & Serializable)valuesBefore -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1("time >= " + around + "s and time < " + around + "s + 1h", "first"), $this.evidence$2)).map((Function1 & Serializable)valuesAfter -> (Map)valuesBefore.$plus$plus((IterableOnce)valuesAfter), $this.evidence$2), this.evidence$2);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select " + this.config.nodeIdTag() + " as nodeId, " + aggregateFunction + "(" + this.config.countField() + ") as count\n           | from \"" + this.config.nodeCountMetric() + "\" where " + this.config.scenarioTag() + " = '" + this.processName + "'\n           | and " + timeCondition + " and " + this.config.envTag() + " = '" + this.env + "' group by " + this.config.additionalGroupByTags().mkString(",") + ", " + this.config.nodeIdTag() + " fill(0)"));
        }

        public PointInTimeQuery(Function1<String, F> invokeQuery, String processName, String env, MetricsConfig config, MonadError<F> evidence$2) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.evidence$2 = evidence$2;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

