/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.processCounts.CannotFetchCountsError$;
import pl.touk.nussknacker.processCounts.CountsReporter;
import pl.touk.nussknacker.processCounts.CountsRequest;
import pl.touk.nussknacker.processCounts.ExecutionCount;
import pl.touk.nussknacker.processCounts.RangeCount;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig$;
import pl.touk.nussknacker.processCounts.influxdb.QueryMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001\u0002\b\u0010\u0001iA\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"AA\u000b\u0001B\u0001B\u0003-Q\u000bC\u0003^\u0001\u0011\u0005a\fC\u0004e\u0001\t\u0007I\u0011B3\t\rA\u0004\u0001\u0015!\u0003g\u0011\u001d\t\bA1A\u0005\fIDa!\u001f\u0001!\u0002\u0013\u0019\bb\u0002>\u0001\u0005\u0004%Ia\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u0002?\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA\u0019\u0001\u0011%\u00111\u0007\u0002\u0015\u0013:4G.\u001e=D_VtGo\u001d*fa>\u0014H/\u001a:\u000b\u0005A\t\u0012\u0001C5oM2,\b\u0010\u001a2\u000b\u0005I\u0019\u0012!\u00049s_\u000e,7o]\"pk:$8O\u0003\u0002\u0015+\u0005Ya.^:tW:\f7m[3s\u0015\t1r#\u0001\u0003u_V\\'\"\u0001\r\u0002\u0005Ad7\u0001A\u000b\u00037)\u001aB\u0001\u0001\u000f%sA\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005Y\u0006twMC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"AB(cU\u0016\u001cG\u000fE\u0002&M!j\u0011!E\u0005\u0003OE\u0011abQ8v]R\u001c(+\u001a9peR,'\u000f\u0005\u0002*U1\u0001A!B\u0016\u0001\u0005\u0004a#!\u0001$\u0016\u00055:\u0014C\u0001\u00185!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aL\u001b\n\u0005Y\u0002$aA!os\u0012)\u0001H\u000bb\u0001[\t!q\f\n\u00132!\tQ\u0014)D\u0001<\u0015\taT(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002?\u007f\u0005AA/\u001f9fg\u00064WMC\u0001A\u0003\r\u0019w.\\\u0005\u0003\u0005n\u00121\u0002T1{s2{wmZ5oO\u0006\u0019QM\u001c<\u0011\u0005\u0015ceB\u0001$K!\t9\u0005'D\u0001I\u0015\tI\u0015$\u0001\u0004=e>|GOP\u0005\u0003\u0017B\na\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111\nM\u0001\u0007G>tg-[4\u0011\u0005E\u0013V\"A\b\n\u0005M{!\u0001D%oM2,\bpQ8oM&<\u0017a\u00022bG.,g\u000e\u001a\t\u0005-nCC'D\u0001X\u0015\tA\u0016,A\u0004dY&,g\u000e^\u001a\u000b\u0003i\u000bAa\u001d;ua&\u0011Al\u0016\u0002\f'R$\bOQ1dW\u0016tG-\u0001\u0004=S:LGO\u0010\u000b\u0004?\n\u001cGC\u00011b!\r\t\u0006\u0001\u000b\u0005\u0006)\u0012\u0001\u001d!\u0016\u0005\u0006\u0007\u0012\u0001\r\u0001\u0012\u0005\u0006\u001f\u0012\u0001\r\u0001U\u0001\u0010S:4G.\u001e=HK:,'/\u0019;peV\ta\rE\u0002RO&L!\u0001[\b\u0003\u001f%sg\r\\;y\u000f\u0016tWM]1u_J,\"A\u001b7\u0011\u0007%R3\u000e\u0005\u0002*Y\u0012)\u0001(\u001cb\u0001[!!aN\u000b\u0001p\u0003%aDn\\2bY\u00022eh\u0003\u0001\u0002!%tg\r\\;y\u000f\u0016tWM]1u_J\u0004\u0013AC7p]\u0006$WI\u001d:peV\t1\u000fE\u0002uo\"j\u0011!\u001e\u0006\u0003mf\u000bQ!\\8oC\u0012L!\u0001_;\u0003\u00155{g.\u00193FeJ|'/A\u0006n_:\fG-\u0012:s_J\u0004\u0013!D7fiJL7m]\"p]\u001aLw-F\u0001}!\t\tV0\u0003\u0002\u007f\u001f\tiQ*\u001a;sS\u000e\u001c8i\u001c8gS\u001e\fa\"\\3ue&\u001c7oQ8oM&<\u0007%\u0001\tqe\u0016\u0004\u0018M]3SC^\u001cu.\u001e8ugR1\u0011QAA\r\u0003;\u0001B!\u000b\u0016\u0002\bA1q&!\u0003E\u0003\u001bI1!a\u00031\u0005%1UO\\2uS>t\u0017\u0007E\u00030\u0003\u001f\t\u0019\"C\u0002\u0002\u0012A\u0012aa\u00149uS>t\u0007cA\u0018\u0002\u0016%\u0019\u0011q\u0003\u0019\u0003\t1{gn\u001a\u0005\u0007\u00037Y\u0001\u0019\u0001#\u0002\u0013A\u0014xnY3tg&#\u0007bBA\u0010\u0017\u0001\u0007\u0011\u0011E\u0001\u000eG>,h\u000e^:SKF,Xm\u001d;\u0011\u0007\u0015\n\u0019#C\u0002\u0002&E\u0011QbQ8v]R\u001c(+Z9vKN$\u0018!B2m_N,GCAA\u0016!\ry\u0013QF\u0005\u0004\u0003_\u0001$\u0001B+oSR\f!\u0003\u001d:fa\u0006\u0014XMU1oO\u0016\u001cu.\u001e8ugRA\u0011QGA\u001f\u0003\u007f\ty\u0005\u0005\u0003*U\u0005]\u0002CB#\u0002:\u0011\u000b\u0019\"C\u0002\u0002<9\u00131!T1q\u0011\u0019\tY\"\u0004a\u0001\t\"9\u0011\u0011I\u0007A\u0002\u0005\r\u0013\u0001\u00034s_6$\u0015\r^3\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013!\u0003\u0011!\u0018.\\3\n\t\u00055\u0013q\t\u0002\b\u0013:\u001cH/\u00198u\u0011\u001d\t\t&\u0004a\u0001\u0003\u0007\na\u0001^8ECR,\u0007")
public class InfluxCountsReporter<F>
implements CountsReporter<F>,
LazyLogging {
    private final InfluxConfig config;
    private final InfluxGenerator<?> influxGenerator;
    private final MonadError<F> monadError;
    private final MetricsConfig metricsConfig;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxCountsReporter influxCountsReporter = this;
        synchronized (influxCountsReporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private InfluxGenerator<?> influxGenerator() {
        return this.influxGenerator;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public F prepareRawCounts(String processId, CountsRequest countsRequest) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> {
            CountsRequest countsRequest = countsRequest;
            if (countsRequest instanceof RangeCount) {
                RangeCount rangeCount = (RangeCount)countsRequest;
                Instant fromDate = rangeCount.fromDate();
                Instant toDate = rangeCount.toDate();
                return this.prepareRangeCounts(processId, fromDate, toDate);
            }
            if (countsRequest instanceof ExecutionCount) {
                ExecutionCount executionCount = (ExecutionCount)countsRequest;
                Instant pointInTime = executionCount.pointInTime();
                return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)None$.MODULE$, pointInTime, this.metricsConfig());
            }
            throw new MatchError((Object)countsRequest);
        }).map((Function1 & Serializable)x$1 -> (Function1 & Serializable)key -> x$1.get(key), this.monadError());
    }

    @Override
    public void close() {
    }

    private F prepareRangeCounts(String processId, Instant fromDate, Instant toDate) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> this.influxGenerator().detectRestarts(processId, fromDate, toDate, this.metricsConfig())).flatMap((Function1 & Serializable)restarts -> {
            Tuple2 tuple2 = new Tuple2(restarts, (Object)$this.config.queryMode());
            if (tuple2 != null) {
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value2 = QueryMode$.MODULE$.OnlySumOfDifferences();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value4 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    }
                }
            }
            if (tuple2 != null) {
                List nonEmpty = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value6 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Restarts detected: {}, querying with differential", (Object)nonEmpty.mkString(","));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value8 = QueryMode$.MODULE$.OnlySingleDifference();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    }
                }
            }
            if (tuple2 != null) {
                List dates = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value10 = QueryMode$.MODULE$.OnlySingleDifference();
                Enumeration.Value value11 = value;
                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                    return this.monadError().error((Throwable)CannotFetchCountsError$.MODULE$.restartsDetected((List<Instant>)dates));
                }
            }
            return this.monadError().error((Throwable)new IllegalArgumentException("Unknown QueryMode " + $this.config.queryMode() + " for " + restarts.size() + " restarts"));
        }, this.monadError());
    }

    public InfluxCountsReporter(String env, InfluxConfig config, SttpBackend<F, Object> backend) {
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
        this.influxGenerator = new InfluxGenerator<F>(config, env, backend);
        this.monadError = backend.responseMonad();
        this.metricsConfig = (MetricsConfig)config.metricsConfig().getOrElse((Function0 & Serializable)() -> new MetricsConfig(MetricsConfig$.MODULE$.apply$default$1(), MetricsConfig$.MODULE$.apply$default$2(), MetricsConfig$.MODULE$.apply$default$3(), MetricsConfig$.MODULE$.apply$default$4(), MetricsConfig$.MODULE$.apply$default$5(), MetricsConfig$.MODULE$.apply$default$6(), MetricsConfig$.MODULE$.apply$default$7()));
    }
}

