/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h!\u0002\u000e\u001c\u0001m)\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006YA\u0013\u0005\u0006A\u0002!\t!\u0019\u0005\bO\u0002\u0011\r\u0011b\u0003i\u0011\u0019y\u0007\u0001)A\u0005S\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bB\u0002?\u0001A\u0003%!\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA9\u0001\u0011%\u00111O\u0004\b\u0003sZ\u0002\u0012AA>\r\u0019Q2\u0004#\u0001\u0002~!1\u0001m\u0004C\u0001\u0003\u007fBq!!!\u0010\t\u0003\t\u0019I\u0002\u0004\u00020>\u0001\u0011\u0011\u0017\u0005\u000b\u0003?\u0013\"\u0011!Q\u0001\n\u0005U\u0006\"CA\b%\t\u0005\t\u0015!\u0003?\u0011!i$C!A!\u0002\u0013q\u0004\"C\u001c\u0013\u0005\u0003\u0005\u000b\u0011BA\u0019\u0011)\t\tM\u0005B\u0002B\u0003-\u00111\u0019\u0005\u0007AJ!\t!a2\t\u000f\u0005e'\u0003\"\u0001\u0002\\\ny\u0011J\u001c4mkb<UM\\3sCR|'O\u0003\u0002\u001d;\u0005A\u0011N\u001c4mkb$'M\u0003\u0002\u001f?\u0005i\u0001O]8dKN\u001c8i\\;oiNT!\u0001I\u0011\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003E\r\nA\u0001^8vW*\tA%\u0001\u0002qYV\u0011a\u0005V\n\u0004\u0001\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#AB!osJ+g\r\u0005\u0002/k5\tqF\u0003\u00021c\u0005a1oY1mC2|wmZ5oO*\u0011!gM\u0001\tif\u0004Xm]1gK*\tA'A\u0002d_6L!AN\u0018\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0004\u0001A\u0011!hO\u0007\u00027%\u0011Ah\u0007\u0002\r\u0013:4G.\u001e=D_:4\u0017nZ\u0001\u0004K:4\bCA G\u001d\t\u0001E\t\u0005\u0002BS5\t!I\u0003\u0002Dq\u00051AH]8pizJ!!R\u0015\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000b&\nqAY1dW\u0016tG\r\u0005\u0003L!J[V\"\u0001'\u000b\u00055s\u0015aB2mS\u0016tGo\r\u0006\u0002\u001f\u0006!1\u000f\u001e;q\u0013\t\tFJA\u0006TiR\u0004()Y2lK:$\u0007CA*U\u0019\u0001!Q!\u0016\u0001C\u0002Y\u0013\u0011AR\u000b\u0003/z\u000b\"\u0001W.\u0011\u0005!J\u0016B\u0001.*\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u000b/\n\u0005uK#aA!os\u0012)q\f\u0016b\u0001/\n!q\f\n\u00132\u0003\u0019a\u0014N\\5u}Q\u0019!-\u001a4\u0015\u0005\r$\u0007c\u0001\u001e\u0001%\")\u0011\n\u0002a\u0002\u0015\")q\u0007\u0002a\u0001s!)Q\b\u0002a\u0001}\u0005QQn\u001c8bI\u0016\u0013(o\u001c:\u0016\u0003%\u00042A[7S\u001b\u0005Y'B\u00017O\u0003\u0015iwN\\1e\u0013\tq7N\u0001\u0006N_:\fG-\u0012:s_J\f1\"\\8oC\u0012,%O]8sA\u0005a\u0011N\u001c4mkb\u001cE.[3oiV\t!\u000fE\u0002;gVL!\u0001^\u000e\u0003%MKW\u000e\u001d7f\u0013:4G.\u001e=DY&,g\u000e^\u000b\u0003mb\u00042a\u0015+x!\t\u0019\u0006\u0010B\u0003`s\n\u0007q\u000b\u0003\u0003{)\u0002Y\u0018!\u0003\u001fm_\u000e\fG\u000e\t$?\u0017\u0001\tQ\"\u001b8gYVD8\t\\5f]R\u0004\u0013aF9vKJL()_*j]\u001edW\rR5gM\u0016\u0014XM\\2f)%y\u0018QBA\t\u0003W\ty\u0003\u0005\u0003T)\u0006\u0005\u0001CB \u0002\u0004y\n9!C\u0002\u0002\u0006!\u00131!T1q!\rA\u0013\u0011B\u0005\u0004\u0003\u0017I#\u0001\u0002'p]\u001eDa!a\u0004\n\u0001\u0004q\u0014a\u00039s_\u000e,7o\u001d(b[\u0016Dq!a\u0005\n\u0001\u0004\t)\"\u0001\u0005eCR,gI]8n!\u0015A\u0013qCA\u000e\u0013\r\tI\"\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005!A/[7f\u0015\t\t)#\u0001\u0003kCZ\f\u0017\u0002BA\u0015\u0003?\u0011q!\u00138ti\u0006tG\u000fC\u0004\u0002.%\u0001\r!a\u0007\u0002\r\u0011\fG/\u001a+p\u0011\u00199\u0014\u00021\u0001\u00022A\u0019!(a\r\n\u0007\u0005U2DA\u0007NKR\u0014\u0018nY:D_:4\u0017nZ\u0001\u0018cV,'/\u001f\"z'VlwJ\u001a#jM\u001a,'/\u001a8dKN$\u0012b`A\u001e\u0003{\ty$!\u0011\t\r\u0005=!\u00021\u0001?\u0011\u001d\t\u0019B\u0003a\u0001\u00037Aq!!\f\u000b\u0001\u0004\tY\u0002\u0003\u00048\u0015\u0001\u0007\u0011\u0011G\u0001\u000fI\u0016$Xm\u0019;SKN$\u0018M\u001d;t))\t9%a\u0017\u0002^\u0005}\u0013\u0011\r\t\u0005'R\u000bI\u0005\u0005\u0004\u0002L\u0005U\u00131\u0004\b\u0005\u0003\u001b\n\tFD\u0002B\u0003\u001fJ\u0011AK\u0005\u0004\u0003'J\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003/\nIF\u0001\u0003MSN$(bAA*S!1\u0011qB\u0006A\u0002yBq!a\u0005\f\u0001\u0004\tY\u0002C\u0004\u0002.-\u0001\r!a\u0007\t\r]Z\u0001\u0019AA\u0019\u0003q\u0011X-\u00193SKN$\u0018M\u001d;t\rJ|WnU8ve\u000e,7i\\;oiN$B!!\u0013\u0002h!9\u0011\u0011\u000e\u0007A\u0002\u0005-\u0014\u0001D:pkJ\u001cWmQ8v]R\u001c\bc\u0001\u001e\u0002n%\u0019\u0011qN\u000e\u0003\u0019%sg\r\\;y'\u0016\u0014\u0018.Z:\u0002\u001fA\f'o]3J]\u001adW\u000f\u001f#bi\u0016$B!a\u0007\u0002v!1\u0011qO\u0007A\u0002y\nA\u0001Z1uK\u0006y\u0011J\u001c4mkb<UM\\3sCR|'\u000f\u0005\u0002;\u001fM\u0019qbJ\u0017\u0015\u0005\u0005m\u0014A\n:fiJLWM^3P]2L(+Z:vYR4%o\\7BGRLwN\u001c,bYV,\u0017+^3ssV!\u0011QQAF)!\t9)a'\u0002\u001e\u0006-F\u0003BAE\u0003'\u0003RaUAF\u0003\u0003!a!V\tC\u0002\u00055UcA,\u0002\u0010\u00129\u0011\u0011SAF\u0005\u00049&\u0001B0%IIB\u0011\"!&\u0012\u0003\u0003\u0005\u001d!a&\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0003k[\u0006e\u0005cA*\u0002\f\"1q'\u0005a\u0001\u0003cAq!a(\u0012\u0001\u0004\t\t+A\u0006j]Z|7.Z)vKJL\bC\u0002\u0015\u0002$z\n9+C\u0002\u0002&&\u0012\u0011BR;oGRLwN\\\u0019\u0011\u000bM\u000bY)!+\u0011\r\u0005-\u0013QKA6\u0011\u0019\ti+\u0005a\u0001}\u0005Y\u0011/^3ssN#(/\u001b8h\u0005A\u0001v.\u001b8u\u0013:$\u0016.\\3Rk\u0016\u0014\u00180\u0006\u0003\u00024\u0006e6c\u0001\n([A1\u0001&a)?\u0003o\u0003RaUA]\u0003S#a!\u0016\nC\u0002\u0005mVcA,\u0002>\u00129\u0011qXA]\u0005\u00049&\u0001B0%IM\n!\"\u001a<jI\u0016t7-\u001a\u00133!\u0011QW.!2\u0011\u0007M\u000bI\f\u0006\u0006\u0002J\u0006E\u00171[Ak\u0003/$B!a3\u0002PB)\u0011Q\u001a\n\u0002F6\tq\u0002C\u0004\u0002Bb\u0001\u001d!a1\t\u000f\u0005}\u0005\u00041\u0001\u00026\"1\u0011q\u0002\rA\u0002yBQ!\u0010\rA\u0002yBaa\u000e\rA\u0002\u0005E\u0012!B9vKJLH\u0003BAo\u0003?\u0004RaUA]\u0003\u0003Aq!a\u001e\u001a\u0001\u0004\tY\u0002")
public class InfluxGenerator<F>
implements LazyLogging {
    private final String env;
    private final MonadError<F> monadError;
    private final SimpleInfluxClient<?> influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <F> F retrieveOnlyResultFromActionValueQuery(MetricsConfig config, Function1<String, F> invokeQuery, String queryString, MonadError<F> evidence$1) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, invokeQuery, queryString, evidence$1);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private SimpleInfluxClient<?> influxClient() {
        return this.influxClient;
    }

    public F queryBySingleDifference(String processName, Option<Instant> dateFrom, Instant dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1 & Serializable)query2 -> this.influxClient().query((String)query2), processName, this.env, config, this.monadError());
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> pointInTimeQuery.query(dateTo)).flatMap((Function1 & Serializable)valuesAtEnd -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> dateFrom.map((Function1 & Serializable)date -> pointInTimeQuery.query((Instant)date)).getOrElse((Function0 & Serializable)() -> this.monadError().unit(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                long value = tuple2._2$mcJ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)))));
            }
            throw new MatchError((Object)tuple2);
        }), this.monadError()), this.monadError());
    }

    public F queryBySumOfDifferences(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        String query3 = "select sum(diff) as count from (SELECT non_negative_difference(\"" + config.countField() + "\") AS diff\n     FROM \"" + config.nodeCountMetric() + "\"\n     WHERE " + config.envTag() + " = '" + this.env + "' AND " + config.scenarioTag() + " = '" + processName + "'\n     AND time > " + dateFrom.getEpochSecond() + "s AND time < " + dateTo.getEpochSecond() + "s\n     GROUP BY " + config.nodeIdTag() + ", " + config.additionalGroupByTags().mkString(",") + ") group by " + config.nodeIdTag();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1 & Serializable)query2 -> this.influxClient().query((String)query2), query3, this.monadError());
    }

    public F detectRestarts(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        long from = dateFrom.getEpochSecond();
        long to = dateTo.getEpochSecond();
        String queryString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT diff FROM (\n         |  SELECT difference(" + config.countField() + ") as diff FROM \"" + config.sourceCountMetric() + "\" WHERE\n         | \"" + config.scenarioTag() + "\" = '" + processName + "' AND " + config.envTag() + " = '" + this.env + "'\n         | AND time >= " + from + "s and time < " + to + "s GROUP BY " + config.additionalGroupByTags().mkString(",") + ", " + config.nodeIdTag() + ") where diff < 0 "));
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> this.influxClient().query(queryString)).map((Function1 & Serializable)series -> (List)series.headOption().map((Function1 & Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$), this.monadError());
    }

    private List<Instant> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        List restarts = sourceCounts.values().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.next$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.next$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                return (B1)this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                            }
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    Object date = colon2.head();
                    List list2 = colon2.next$access$1();
                    if (date instanceof String && list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        Object derivative = colon3.head();
                        List list3 = colon3.next$access$1();
                        if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list3)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return restarts;
    }

    public Instant pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<F, Object> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.monadError = backend.responseMonad();
        this.influxClient = new SimpleInfluxClient<F>(config, backend);
    }

    public static class PointInTimeQuery<F>
    implements LazyLogging {
        private final Function1<String, F> invokeQuery;
        private final String processName;
        private final String env;
        private final MetricsConfig config;
        private final MonadError<F> evidence$2;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        public F query(Instant date) {
            long around = date.getEpochSecond();
            return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1("time <= " + around + "s and time > " + around + "s - 1h", "last"), $this.evidence$2)).flatMap((Function1 & Serializable)valuesBefore -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1("time >= " + around + "s and time < " + around + "s + 1h", "first"), $this.evidence$2)).map((Function1 & Serializable)valuesAfter -> (Map)valuesBefore.$plus$plus((IterableOnce)valuesAfter), $this.evidence$2), this.evidence$2);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select " + this.config.nodeIdTag() + " as nodeId, " + aggregateFunction + "(" + this.config.countField() + ") as count\n           | from \"" + this.config.nodeCountMetric() + "\" where " + this.config.scenarioTag() + " = '" + this.processName + "'\n           | and " + timeCondition + " and " + this.config.envTag() + " = '" + this.env + "' group by " + this.config.additionalGroupByTags().mkString(",") + ", " + this.config.nodeIdTag() + " fill(0)"));
        }

        public PointInTimeQuery(Function1<String, F> invokeQuery, String processName, String env, MetricsConfig config, MonadError<F> evidence$2) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.evidence$2 = evidence$2;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

