/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0005\u0005Uh!\u0002\u000e\u001c\u0001m)\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006YA\u0013\u0005\u0006A\u0002!\t!\u0019\u0005\bO\u0002\u0011\r\u0011b\u0003i\u0011\u0019y\u0007\u0001)A\u0005S\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bB\u0002?\u0001A\u0003%!\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002L\u0001!\t!!\u0014\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBAC\u0001\u0011%\u0011qQ\u0004\b\u0003\u001b[\u0002\u0012AAH\r\u0019Q2\u0004#\u0001\u0002\u0012\"1\u0001m\u0004C\u0001\u0003'Cq!!&\u0010\t\u0003\t9J\u0002\u0004\u0002D>\u0001\u0011Q\u0019\u0005\u000b\u0003g\u0013\"\u0011!Q\u0001\n\u0005%\u0007BCA\b%\t\u0005\t\u0015!\u0003\u0002\u0012!AQH\u0005B\u0001B\u0003%a\bC\u00058%\t\u0005\t\u0015!\u0003\u0002F!Q\u0011Q\u001b\n\u0003\u0004\u0003\u0006Y!a6\t\r\u0001\u0014B\u0011AAn\u0011\u001d\tiO\u0005C\u0001\u0003_\u0014q\"\u00138gYVDx)\u001a8fe\u0006$xN\u001d\u0006\u00039u\t\u0001\"\u001b8gYVDHM\u0019\u0006\u0003=}\tQ\u0002\u001d:pG\u0016\u001c8oQ8v]R\u001c(B\u0001\u0011\"\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005\t\u001a\u0013\u0001\u0002;pk.T\u0011\u0001J\u0001\u0003a2,\"A\n+\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]Uj\u0011a\f\u0006\u0003aE\nAb]2bY\u0006dwnZ4j]\u001eT!AM\u001a\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001N\u0001\u0004G>l\u0017B\u0001\u001c0\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h\u0007\u0001\u0001\"AO\u001e\u000e\u0003mI!\u0001P\u000e\u0003\u0019%sg\r\\;y\u0007>tg-[4\u0002\u0007\u0015tg\u000f\u0005\u0002@\r:\u0011\u0001\t\u0012\t\u0003\u0003&j\u0011A\u0011\u0006\u0003\u0007b\na\u0001\u0010:p_Rt\u0014BA#*\u0003\u0019\u0001&/\u001a3fM&\u0011q\t\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015K\u0013a\u00022bG.,g\u000e\u001a\t\u0005\u0017B\u00136,D\u0001M\u0015\tie*A\u0004dY&,g\u000e^\u001a\u000b\u0003=\u000bAa\u001d;ua&\u0011\u0011\u000b\u0014\u0002\f'R$\bOQ1dW\u0016tG\r\u0005\u0002T)2\u0001A!B+\u0001\u0005\u00041&!\u0001$\u0016\u0005]s\u0016C\u0001-\\!\tA\u0013,\u0003\u0002[S\t9aj\u001c;iS:<\u0007C\u0001\u0015]\u0013\ti\u0016FA\u0002B]f$Qa\u0018+C\u0002]\u0013Aa\u0018\u0013%c\u00051A(\u001b8jiz\"2AY3g)\t\u0019G\rE\u0002;\u0001ICQ!\u0013\u0003A\u0004)CQa\u000e\u0003A\u0002eBQ!\u0010\u0003A\u0002y\n!\"\\8oC\u0012,%O]8s+\u0005I\u0007c\u00016n%6\t1N\u0003\u0002m\u001d\u0006)Qn\u001c8bI&\u0011an\u001b\u0002\u000b\u001b>t\u0017\rZ#se>\u0014\u0018aC7p]\u0006$WI\u001d:pe\u0002\nA\"\u001b8gYVD8\t\\5f]R,\u0012A\u001d\t\u0004uM,\u0018B\u0001;\u001c\u0005I\u0019\u0016.\u001c9mK&sg\r\\;y\u00072LWM\u001c;\u0016\u0005YD\bcA*UoB\u00111\u000b\u001f\u0003\u0006?f\u0014\ra\u0016\u0005\u0005uR\u000310A\u0005=Y>\u001c\u0017\r\u001c\u0011G}-\u0001\u0011!D5oM2,\bp\u00117jK:$\b%A\frk\u0016\u0014\u0018PQ=TS:<G.\u001a#jM\u001a,'/\u001a8dKRIq0!\u0004\u0002&\u0005}\u00121\t\t\u0005'R\u000b\t\u0001\u0005\u0004@\u0003\u0007q\u0014qA\u0005\u0004\u0003\u000bA%aA'baB\u0019\u0001&!\u0003\n\u0007\u0005-\u0011F\u0001\u0003M_:<\u0007bBA\b\u0013\u0001\u0007\u0011\u0011C\u0001\faJ|7-Z:t\u001d\u0006lW\r\u0005\u0003\u0002\u0014\u0005\u0005RBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u000fA\u0014xnY3tg*!\u00111DA\u000f\u0003\r\t\u0007/\u001b\u0006\u0004\u0003?y\u0012AB3oO&tW-\u0003\u0003\u0002$\u0005U!a\u0003)s_\u000e,7o\u001d(b[\u0016Dq!a\n\n\u0001\u0004\tI#\u0001\u0005eCR,gI]8n!\u0015A\u00131FA\u0018\u0013\r\ti#\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005!A/[7f\u0015\t\tI$\u0001\u0003kCZ\f\u0017\u0002BA\u001f\u0003g\u0011q!\u00138ti\u0006tG\u000fC\u0004\u0002B%\u0001\r!a\f\u0002\r\u0011\fG/\u001a+p\u0011\u00199\u0014\u00021\u0001\u0002FA\u0019!(a\u0012\n\u0007\u0005%3DA\u0007NKR\u0014\u0018nY:D_:4\u0017nZ\u0001\u0018cV,'/\u001f\"z'VlwJ\u001a#jM\u001a,'/\u001a8dKN$\u0012b`A(\u0003#\n\u0019&!\u0016\t\u000f\u0005=!\u00021\u0001\u0002\u0012!9\u0011q\u0005\u0006A\u0002\u0005=\u0002bBA!\u0015\u0001\u0007\u0011q\u0006\u0005\u0007o)\u0001\r!!\u0012\u0002\u001d\u0011,G/Z2u%\u0016\u001cH/\u0019:ugRQ\u00111LA8\u0003c\n\u0019(!\u001e\u0011\tM#\u0016Q\f\t\u0007\u0003?\nI'a\f\u000f\t\u0005\u0005\u0014Q\r\b\u0004\u0003\u0006\r\u0014\"\u0001\u0016\n\u0007\u0005\u001d\u0014&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0014Q\u000e\u0002\u0005\u0019&\u001cHOC\u0002\u0002h%Bq!a\u0004\f\u0001\u0004\t\t\u0002C\u0004\u0002(-\u0001\r!a\f\t\u000f\u0005\u00053\u00021\u0001\u00020!1qg\u0003a\u0001\u0003\u000b\nAD]3bIJ+7\u000f^1siN4%o\\7T_V\u00148-Z\"pk:$8\u000f\u0006\u0003\u0002^\u0005m\u0004bBA?\u0019\u0001\u0007\u0011qP\u0001\rg>,(oY3D_VtGo\u001d\t\u0004u\u0005\u0005\u0015bAAB7\ta\u0011J\u001c4mkb\u001cVM]5fg\u0006y\u0001/\u0019:tK&sg\r\\;y\t\u0006$X\r\u0006\u0003\u00020\u0005%\u0005BBAF\u001b\u0001\u0007a(\u0001\u0003eCR,\u0017aD%oM2,\bpR3oKJ\fGo\u001c:\u0011\u0005iz1cA\b([Q\u0011\u0011qR\u0001'e\u0016$(/[3wK>sG.\u001f*fgVdGO\u0012:p[\u0006\u001bG/[8o-\u0006dW/Z)vKJLX\u0003BAM\u0003?#\u0002\"a'\u00020\u0006E\u0016q\u0018\u000b\u0005\u0003;\u000b9\u000bE\u0003T\u0003?\u000b\t\u0001\u0002\u0004V#\t\u0007\u0011\u0011U\u000b\u0004/\u0006\rFaBAS\u0003?\u0013\ra\u0016\u0002\u0005?\u0012\"#\u0007C\u0005\u0002*F\t\t\u0011q\u0001\u0002,\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\t)l\u0017Q\u0016\t\u0004'\u0006}\u0005BB\u001c\u0012\u0001\u0004\t)\u0005C\u0004\u00024F\u0001\r!!.\u0002\u0017%tgo\\6f#V,'/\u001f\t\u0007Q\u0005]f(a/\n\u0007\u0005e\u0016FA\u0005Gk:\u001cG/[8ocA)1+a(\u0002>B1\u0011qLA5\u0003\u007fBa!!1\u0012\u0001\u0004q\u0014aC9vKJL8\u000b\u001e:j]\u001e\u0014\u0001\u0003U8j]RLe\u000eV5nKF+XM]=\u0016\t\u0005\u001d\u0017QZ\n\u0004%\u001dj\u0003C\u0002\u0015\u00028z\nY\rE\u0003T\u0003\u001b\fi\f\u0002\u0004V%\t\u0007\u0011qZ\u000b\u0004/\u0006EGaBAj\u0003\u001b\u0014\ra\u0016\u0002\u0005?\u0012\"3'\u0001\u0006fm&$WM\\2fII\u0002BA[7\u0002ZB\u00191+!4\u0015\u0015\u0005u\u0017Q]At\u0003S\fY\u000f\u0006\u0003\u0002`\u0006\r\b#BAq%\u0005eW\"A\b\t\u000f\u0005U\u0007\u0004q\u0001\u0002X\"9\u00111\u0017\rA\u0002\u0005%\u0007bBA\b1\u0001\u0007\u0011\u0011\u0003\u0005\u0006{a\u0001\rA\u0010\u0005\u0007oa\u0001\r!!\u0012\u0002\u000bE,XM]=\u0015\t\u0005E\u00181\u001f\t\u0006'\u00065\u0017\u0011\u0001\u0005\b\u0003\u0017K\u0002\u0019AA\u0018\u0001")
public class InfluxGenerator<F>
implements LazyLogging {
    private final String env;
    private final MonadError<F> monadError;
    private final SimpleInfluxClient<?> influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <F> F retrieveOnlyResultFromActionValueQuery(MetricsConfig config, Function1<String, F> invokeQuery, String queryString, MonadError<F> evidence$1) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, invokeQuery, queryString, evidence$1);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private SimpleInfluxClient<?> influxClient() {
        return this.influxClient;
    }

    public F queryBySingleDifference(ProcessName processName, Option<Instant> dateFrom, Instant dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1 & Serializable)query2 -> this.influxClient().query((String)query2), processName, this.env, config, this.monadError());
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> pointInTimeQuery.query(dateTo)).flatMap((Function1 & Serializable)valuesAtEnd -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> dateFrom.map((Function1 & Serializable)date -> pointInTimeQuery.query((Instant)date)).getOrElse((Function0 & Serializable)() -> this.monadError().unit(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))).map((Function1 & Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                long value = tuple2._2$mcJ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)))));
            }
            throw new MatchError((Object)tuple2);
        }), this.monadError()), this.monadError());
    }

    public F queryBySumOfDifferences(ProcessName processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        String query3 = "select sum(diff) as count from (SELECT non_negative_difference(\"" + config.countField() + "\") AS diff\n     FROM \"" + config.nodeCountMetric() + "\"\n     WHERE " + config.envTag() + " = '" + this.env + "' AND " + config.scenarioTag() + " = '" + processName + "'\n     AND time > " + dateFrom.getEpochSecond() + "s AND time < " + dateTo.getEpochSecond() + "s\n     GROUP BY " + config.nodeIdTag() + ", " + config.additionalGroupByTags().mkString(",") + ") group by " + config.nodeIdTag();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1 & Serializable)query2 -> this.influxClient().query((String)query2), query3, this.monadError());
    }

    public F detectRestarts(ProcessName processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        long from = dateFrom.getEpochSecond();
        long to = dateTo.getEpochSecond();
        String queryString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT diff FROM (\n         |  SELECT difference(" + config.countField() + ") as diff FROM \"" + config.sourceCountMetric() + "\" WHERE\n         | \"" + config.scenarioTag() + "\" = '" + processName + "' AND " + config.envTag() + " = '" + this.env + "'\n         | AND time >= " + from + "s and time < " + to + "s GROUP BY " + config.additionalGroupByTags().mkString(",") + ", " + config.nodeIdTag() + ") where diff < 0 "));
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> this.influxClient().query(queryString)).map((Function1 & Serializable)series -> (List)series.headOption().map((Function1 & Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$), this.monadError());
    }

    private List<Instant> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        List restarts = sourceCounts.values().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.next$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.next$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                return (B1)this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                            }
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    Object date = colon2.head();
                    List list2 = colon2.next$access$1();
                    if (date instanceof String && list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        Object derivative = colon3.head();
                        List list3 = colon3.next$access$1();
                        if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list3)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return restarts;
    }

    public Instant pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<F, Object> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.monadError = backend.responseMonad();
        this.influxClient = new SimpleInfluxClient<F>(config, backend);
    }

    public static class PointInTimeQuery<F>
    implements LazyLogging {
        private final Function1<String, F> invokeQuery;
        private final ProcessName processName;
        private final String env;
        private final MetricsConfig config;
        private final MonadError<F> evidence$2;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        public F query(Instant date) {
            long around = date.getEpochSecond();
            return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1("time <= " + around + "s and time > " + around + "s - 1h", "last"), $this.evidence$2)).flatMap((Function1 & Serializable)valuesBefore -> syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1("time >= " + around + "s and time < " + around + "s + 1h", "first"), $this.evidence$2)).map((Function1 & Serializable)valuesAfter -> (Map)valuesBefore.$plus$plus((IterableOnce)valuesAfter), $this.evidence$2), this.evidence$2);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select " + this.config.nodeIdTag() + " as nodeId, " + aggregateFunction + "(" + this.config.countField() + ") as count\n           | from \"" + this.config.nodeCountMetric() + "\" where " + this.config.scenarioTag() + " = '" + this.processName + "'\n           | and " + timeCondition + " and " + this.config.envTag() + " = '" + this.env + "' group by " + this.config.additionalGroupByTags().mkString(",") + ", " + this.config.nodeIdTag() + " fill(0)"));
        }

        public PointInTimeQuery(Function1<String, F> invokeQuery, ProcessName processName, String env, MetricsConfig config, MonadError<F> evidence$2) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.evidence$2 = evidence$2;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

