/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.processCounts.CannotFetchCountsError$;
import pl.touk.nussknacker.processCounts.CountsReporter;
import pl.touk.nussknacker.processCounts.CountsRequest;
import pl.touk.nussknacker.processCounts.ExecutionCount;
import pl.touk.nussknacker.processCounts.RangeCount;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig$;
import pl.touk.nussknacker.processCounts.influxdb.QueryMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import sttp.client.SttpBackend;
import sttp.client.monad.MonadError;
import sttp.client.monad.syntax;
import sttp.client.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\b\u0011\u0001mA\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005^\u0001\t\u0005\t\u0015a\u0003_\u0011\u0015\t\b\u0001\"\u0001s\u0011\u001dI\bA1A\u0005\u0002iDq!a\u0003\u0001A\u0003%1\u0010C\u0005\u0002\u000e\u0001\u0011\r\u0011b\u0003\u0002\u0010!A\u0011Q\u0004\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002 \u0001\u0011\r\u0011\"\u0003\u0002\"!A\u0011\u0011\u0006\u0001!\u0002\u0013\t\u0019\u0003C\u0004\u0002,\u0001!\t%!\f\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011\u0011\u000b\u0001\u0005\n\u0005M#\u0001F%oM2,\bpQ8v]R\u001c(+\u001a9peR,'O\u0003\u0002\u0012%\u0005A\u0011N\u001c4mkb$'M\u0003\u0002\u0014)\u0005i\u0001O]8dKN\u001c8i\\;oiNT!!\u0006\f\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003/a\tA\u0001^8vW*\t\u0011$\u0001\u0002qY\u000e\u0001QC\u0001\u000f,'\u0011\u0001Q$\n\u001e\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001\u00027b]\u001eT\u0011AI\u0001\u0005U\u00064\u0018-\u0003\u0002%?\t1qJ\u00196fGR\u00042AJ\u0014*\u001b\u0005\u0011\u0012B\u0001\u0015\u0013\u00059\u0019u.\u001e8ugJ+\u0007o\u001c:uKJ\u0004\"AK\u0016\r\u0001\u0011)A\u0006\u0001b\u0001[\t\ta)\u0006\u0002/qE\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\b\u001d>$\b.\u001b8h!\t\u0001d'\u0003\u00028c\t\u0019\u0011I\\=\u0005\u000beZ#\u0019\u0001\u0018\u0003\t}#C%\r\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\nAb]2bY\u0006dwnZ4j]\u001eT!a\u0010!\u0002\u0011QL\b/Z:bM\u0016T\u0011!Q\u0001\u0004G>l\u0017BA\"=\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0007\u0015tg\u000f\u0005\u0002G\u001b:\u0011qi\u0013\t\u0003\u0011Fj\u0011!\u0013\u0006\u0003\u0015j\ta\u0001\u0010:p_Rt\u0014B\u0001'2\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051\u000b\u0014AB2p]\u001aLw\r\u0005\u0002S'6\t\u0001#\u0003\u0002U!\ta\u0011J\u001c4mkb\u001cuN\u001c4jO\u0006aq/Y5u\r>\u00148\t\\8tKB!\u0001gV-[\u0013\tA\u0016GA\u0005Gk:\u001cG/[8ocA\u0019!f\u000b.\u0011\u0005AZ\u0016B\u0001/2\u0005\u0011)f.\u001b;\u0002\u000f\t\f7m[3oIB)q\fZ\u00150M6\t\u0001M\u0003\u0002bE\u000611\r\\5f]RT\u0011aY\u0001\u0005gR$\b/\u0003\u0002fA\nY1\u000b\u001e;q\u0005\u0006\u001c7.\u001a8e!\t9gN\u0004\u0002iY:\u0011\u0011n\u001b\b\u0003\u0011*L\u0011aY\u0005\u0003C\nL!!\u001c1\u0002\u000fA\f7m[1hK&\u0011q\u000e\u001d\u0002\t\u001d>$\b.\u001b8h)*\u0011Q\u000eY\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM4x\u000f\u001f\u000b\u0003iV\u00042A\u0015\u0001*\u0011\u0015iV\u0001q\u0001_\u0011\u0015!U\u00011\u0001F\u0011\u0015\u0001V\u00011\u0001R\u0011\u0015)V\u00011\u0001W\u0003=IgN\u001a7vq\u001e+g.\u001a:bi>\u0014X#A>\u0011\u0007Ich0\u0003\u0002~!\ty\u0011J\u001c4mkb<UM\\3sCR|'/F\u0002\u0000\u0003\u0007\u0001BAK\u0016\u0002\u0002A\u0019!&a\u0001\u0005\re\n)A1\u0001/\u0011\u0019\t9a\u000b\u0001\u0002\n\u0005IA\b\\8dC2\u0004cIP\u0006\u0001\u0003AIgN\u001a7vq\u001e+g.\u001a:bi>\u0014\b%\u0001\u0006n_:\fG-\u0012:s_J,\"!!\u0005\u0011\u000b\u0005M\u0011\u0011D\u0015\u000e\u0005\u0005U!bAA\fA\u0006)Qn\u001c8bI&!\u00111DA\u000b\u0005)iuN\\1e\u000bJ\u0014xN]\u0001\f[>t\u0017\rZ#se>\u0014\b%A\u0007nKR\u0014\u0018nY:D_:4\u0017nZ\u000b\u0003\u0003G\u00012AUA\u0013\u0013\r\t9\u0003\u0005\u0002\u000e\u001b\u0016$(/[2t\u0007>tg-[4\u0002\u001d5,GO]5dg\u000e{gNZ5hA\u0005\u0001\u0002O]3qCJ,'+Y<D_VtGo\u001d\u000b\u0007\u0003_\ty$a\u0011\u0011\t)Z\u0013\u0011\u0007\t\u0006a]+\u00151\u0007\t\u0006a\u0005U\u0012\u0011H\u0005\u0004\u0003o\t$AB(qi&|g\u000eE\u00021\u0003wI1!!\u00102\u0005\u0011auN\\4\t\r\u0005\u0005C\u00021\u0001F\u0003%\u0001(o\\2fgNLE\rC\u0004\u0002F1\u0001\r!a\u0012\u0002\u001b\r|WO\u001c;t%\u0016\fX/Z:u!\r1\u0013\u0011J\u0005\u0004\u0003\u0017\u0012\"!D\"pk:$8OU3rk\u0016\u001cH/A\u0003dY>\u001cX\rF\u0001[\u0003I\u0001(/\u001a9be\u0016\u0014\u0016M\\4f\u0007>,h\u000e^:\u0015\u0011\u0005U\u0013QLA0\u0003_\u0002BAK\u0016\u0002XA1a)!\u0017F\u0003sI1!a\u0017P\u0005\ri\u0015\r\u001d\u0005\u0007\u0003\u0003r\u0001\u0019A#\t\u000f\u0005\u0005d\u00021\u0001\u0002d\u0005AaM]8n\t\u0006$X\r\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tI'I\u0001\u0005i&lW-\u0003\u0003\u0002n\u0005\u001d$aB%ogR\fg\u000e\u001e\u0005\b\u0003cr\u0001\u0019AA2\u0003\u0019!x\u000eR1uK\u0002")
public class InfluxCountsReporter<F>
implements CountsReporter<F>,
LazyLogging {
    private final InfluxConfig config;
    private final Function1<F, BoxedUnit> waitForClose;
    private final InfluxGenerator<?> influxGenerator;
    private final MonadError<F> monadError;
    private final MetricsConfig metricsConfig;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxCountsReporter influxCountsReporter = this;
        synchronized (influxCountsReporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public InfluxGenerator<?> influxGenerator() {
        return this.influxGenerator;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public F prepareRawCounts(String processId, CountsRequest countsRequest) {
        Object object;
        CountsRequest countsRequest2 = countsRequest;
        if (countsRequest2 instanceof RangeCount) {
            RangeCount rangeCount = (RangeCount)countsRequest2;
            Instant fromDate = rangeCount.fromDate();
            Instant toDate = rangeCount.toDate();
            object = this.prepareRangeCounts(processId, fromDate, toDate);
        } else if (countsRequest2 instanceof ExecutionCount) {
            ExecutionCount executionCount = (ExecutionCount)countsRequest2;
            Instant pointInTime = executionCount.pointInTime();
            object = this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)None$.MODULE$, pointInTime, this.metricsConfig());
        } else {
            throw new MatchError((Object)countsRequest2);
        }
        return (F)syntax.MonadErrorOps$.MODULE$.map$extension(syntax$.MODULE$.MonadErrorOps(object), (Function1 & Serializable)x$1 -> (Function1 & Serializable)key -> x$1.get(key), this.monadError());
    }

    @Override
    public void close() {
        this.waitForClose.apply(this.influxGenerator().close());
    }

    private F prepareRangeCounts(String processId, Instant fromDate, Instant toDate) {
        return (F)syntax.MonadErrorOps$.MODULE$.flatMap$extension(syntax$.MODULE$.MonadErrorOps(this.influxGenerator().detectRestarts(processId, fromDate, toDate, this.metricsConfig())), (Function1 & Serializable)restarts -> {
            Tuple2 tuple2 = new Tuple2(restarts, (Object)$this.config.queryMode());
            if (tuple2 != null) {
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value2 = QueryMode$.MODULE$.OnlySumOfDifferences();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value4 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    }
                }
            }
            if (tuple2 != null) {
                List nonEmpty = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value6 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Restarts detected: {}, querying with differential", (Object)nonEmpty.mkString(","));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value8 = QueryMode$.MODULE$.OnlySingleDifference();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    }
                }
            }
            if (tuple2 != null) {
                List dates = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value10 = QueryMode$.MODULE$.OnlySingleDifference();
                Enumeration.Value value11 = value;
                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                    return this.monadError().error((Throwable)CannotFetchCountsError$.MODULE$.restartsDetected((List<Instant>)dates));
                }
            }
            return this.monadError().error((Throwable)new IllegalArgumentException("Unknown QueryMode " + $this.config.queryMode() + " for " + restarts.size() + " restarts"));
        }, this.monadError());
    }

    public InfluxCountsReporter(String env, InfluxConfig config, Function1<F, BoxedUnit> waitForClose, SttpBackend<F, Nothing$, ?> backend) {
        this.config = config;
        this.waitForClose = waitForClose;
        LazyLogging.$init$((LazyLogging)this);
        this.influxGenerator = new InfluxGenerator<F>(config, env, backend);
        this.monadError = backend.responseMonad();
        this.metricsConfig = (MetricsConfig)config.metricsConfig().getOrElse((Function0 & Serializable)() -> new MetricsConfig(MetricsConfig$.MODULE$.apply$default$1(), MetricsConfig$.MODULE$.apply$default$2(), MetricsConfig$.MODULE$.apply$default$3(), MetricsConfig$.MODULE$.apply$default$4(), MetricsConfig$.MODULE$.apply$default$5(), MetricsConfig$.MODULE$.apply$default$6(), MetricsConfig$.MODULE$.apply$default$7()));
    }
}

