/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator$;
import pl.touk.nussknacker.processCounts.influxdb.InfluxSeries;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.SimpleInfluxClient;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import sttp.client.SttpBackend;
import sttp.client.monad.MonadError;
import sttp.client.monad.syntax;
import sttp.client.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0005\t\ra!B\u000e\u001d\u0001q1\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ya\u0013\u0005\u0006Y\u0002!\t!\u001c\u0005\bg\u0002\u0011\r\u0011b\u0003u\u0011\u0019Y\b\u0001)A\u0005k\"9A\u0010\u0001b\u0001\n\u0013i\bbBA\t\u0001\u0001\u0006IA \u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002z\u0001!I!a\u001f\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u0011q\u0012\u0001\u0005\u0002\u0005EuaBAN9!\u0005\u0011Q\u0014\u0004\u00077qA\t!a(\t\r1\u0004B\u0011AAQ\u0011\u001d\t\u0019\u000b\u0005C\u0001\u0003K3a!!5\u0011\u0001\u0005M\u0007BCAa'\t\u0005\t\u0015!\u0003\u0002X\"I\u0011qE\n\u0003\u0002\u0003\u0006Ia\u0010\u0005\t}M\u0011\t\u0011)A\u0005\u007f!I\u0001h\u0005B\u0001B\u0003%\u0011\u0011\n\u0005\u000b\u0003G\u001c\"1!Q\u0001\f\u0005\u0015\bB\u00027\u0014\t\u0003\tI\u000fC\u0004\u0002|N!\t!!@\u0003\u001f%sg\r\\;y\u000f\u0016tWM]1u_JT!!\b\u0010\u0002\u0011%tg\r\\;yI\nT!a\b\u0011\u0002\u001bA\u0014xnY3tg\u000e{WO\u001c;t\u0015\t\t#%A\u0006okN\u001c8N\\1dW\u0016\u0014(BA\u0012%\u0003\u0011!x.^6\u000b\u0003\u0015\n!\u0001\u001d7\u0016\u0005\u001d*6c\u0001\u0001)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\u0004\"a\f\u001c\u000e\u0003AR!!\r\u001a\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005M\"\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003U\n1aY8n\u0013\t9\u0004GA\u0006MCjLHj\\4hS:<\u0017AB2p]\u001aLwm\u0001\u0001\u0011\u0005mbT\"\u0001\u000f\n\u0005ub\"\u0001D%oM2,\bpQ8oM&<\u0017aA3omB\u0011\u0001i\u0012\b\u0003\u0003\u0016\u0003\"A\u0011\u0016\u000e\u0003\rS!\u0001R\u001d\u0002\rq\u0012xn\u001c;?\u0013\t1%&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$+\u0003\u001d\u0011\u0017mY6f]\u0012\u0004R\u0001T)T3\u0006l\u0011!\u0014\u0006\u0003\u001d>\u000baa\u00197jK:$(\"\u0001)\u0002\tM$H\u000f]\u0005\u0003%6\u00131b\u0015;ua\n\u000b7m[3oIB\u0011A+\u0016\u0007\u0001\t\u00151\u0006A1\u0001X\u0005\u00051UC\u0001-`#\tIF\f\u0005\u0002*5&\u00111L\u000b\u0002\b\u001d>$\b.\u001b8h!\tIS,\u0003\u0002_U\t\u0019\u0011I\\=\u0005\u000b\u0001,&\u0019\u0001-\u0003\t}#C%\r\t\u0003E&t!aY4\u000f\u0005\u00114gB\u0001\"f\u0013\u0005\u0001\u0016B\u0001(P\u0013\tAW*A\u0004qC\u000e\\\u0017mZ3\n\u0005)\\'\u0001\u0003(pi\"Lgn\u001a+\u000b\u0005!l\u0015A\u0002\u001fj]&$h\bF\u0002ocJ$\"a\u001c9\u0011\u0007m\u00021\u000bC\u0003K\t\u0001\u000f1\nC\u00039\t\u0001\u0007!\bC\u0003?\t\u0001\u0007q(\u0001\u0006n_:\fG-\u0012:s_J,\u0012!\u001e\t\u0004mf\u001cV\"A<\u000b\u0005al\u0015!B7p]\u0006$\u0017B\u0001>x\u0005)iuN\\1e\u000bJ\u0014xN]\u0001\f[>t\u0017\rZ#se>\u0014\b%\u0001\u0007j]\u001adW\u000f_\"mS\u0016tG/F\u0001\u007f!\u0011Yt0a\u0001\n\u0007\u0005\u0005AD\u0001\nTS6\u0004H.Z%oM2,\bp\u00117jK:$X\u0003BA\u0003\u0003\u0013\u0001B\u0001V+\u0002\bA\u0019A+!\u0003\u0005\r\u0001\fYA1\u0001Y\u0011\u0019\ti!\u0016\u0001\u0002\u0010\u0005IA\b\\8dC2\u0004cIP\u0006\u0001\u00035IgN\u001a7vq\u000ec\u0017.\u001a8uA\u00059\u0012/^3ss\nK8+\u001b8hY\u0016$\u0015N\u001a4fe\u0016t7-\u001a\u000b\u000b\u0003/\t)#!\u000b\u0002D\u0005\u001d\u0003\u0003\u0002+V\u00033\u0001b\u0001QA\u000e\u007f\u0005}\u0011bAA\u000f\u0013\n\u0019Q*\u00199\u0011\u0007%\n\t#C\u0002\u0002$)\u0012A\u0001T8oO\"1\u0011qE\u0005A\u0002}\n1\u0002\u001d:pG\u0016\u001c8OT1nK\"9\u00111F\u0005A\u0002\u00055\u0012\u0001\u00033bi\u00164%o\\7\u0011\u000b%\ny#a\r\n\u0007\u0005E\"F\u0001\u0004PaRLwN\u001c\t\u0005\u0003k\ty$\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u0011!\u0018.\\3\u000b\u0005\u0005u\u0012\u0001\u00026bm\u0006LA!!\u0011\u00028\t9\u0011J\\:uC:$\bbBA#\u0013\u0001\u0007\u00111G\u0001\u0007I\u0006$X\rV8\t\raJ\u0001\u0019AA%!\rY\u00141J\u0005\u0004\u0003\u001bb\"!D'fiJL7m]\"p]\u001aLw-A\frk\u0016\u0014\u0018PQ=Tk6|e\rR5gM\u0016\u0014XM\\2fgRQ\u0011qCA*\u0003+\n9&!\u0017\t\r\u0005\u001d\"\u00021\u0001@\u0011\u001d\tYC\u0003a\u0001\u0003gAq!!\u0012\u000b\u0001\u0004\t\u0019\u0004\u0003\u00049\u0015\u0001\u0007\u0011\u0011J\u0001\u000fI\u0016$Xm\u0019;SKN$\u0018M\u001d;t))\ty&!\u001d\u0002t\u0005U\u0014q\u000f\t\u0005)V\u000b\t\u0007\u0005\u0004\u0002d\u0005-\u00141\u0007\b\u0005\u0003K\nIGD\u0002C\u0003OJ\u0011aK\u0005\u0003Q*JA!!\u001c\u0002p\t!A*[:u\u0015\tA'\u0006\u0003\u0004\u0002(-\u0001\ra\u0010\u0005\b\u0003WY\u0001\u0019AA\u001a\u0011\u001d\t)e\u0003a\u0001\u0003gAa\u0001O\u0006A\u0002\u0005%\u0013\u0001\b:fC\u0012\u0014Vm\u001d;beR\u001chI]8n'>,(oY3D_VtGo\u001d\u000b\u0005\u0003C\ni\bC\u0004\u0002\u00001\u0001\r!!!\u0002\u0019M|WO]2f\u0007>,h\u000e^:\u0011\u0007m\n\u0019)C\u0002\u0002\u0006r\u0011A\"\u00138gYVD8+\u001a:jKN\fq\u0002]1sg\u0016LeN\u001a7vq\u0012\u000bG/\u001a\u000b\u0005\u0003g\tY\t\u0003\u0004\u0002\u000e6\u0001\raP\u0001\u0005I\u0006$X-A\u0003dY>\u001cX\r\u0006\u0002\u0002\u0014B!A+VAK!\rI\u0013qS\u0005\u0004\u00033S#\u0001B+oSR\fq\"\u00138gYVDx)\u001a8fe\u0006$xN\u001d\t\u0003wA\u00192\u0001\u0005\u0015/)\t\ti*\u0001\u0014sKR\u0014\u0018.\u001a<f\u001f:d\u0017PU3tk2$hI]8n\u0003\u000e$\u0018n\u001c8WC2,X-U;fef,B!a*\u0002.RA\u0011\u0011VA_\u0003\u007f\u000bi\r\u0006\u0003\u0002,\u0006U\u0006#\u0002+\u0002.\u0006eAA\u0002,\u0013\u0005\u0004\ty+F\u0002Y\u0003c#q!a-\u0002.\n\u0007\u0001L\u0001\u0003`I\u0011\u0012\u0004\"CA\\%\u0005\u0005\t9AA]\u0003))g/\u001b3f]\u000e,G%\r\t\u0005mf\fY\fE\u0002U\u0003[Ca\u0001\u000f\nA\u0002\u0005%\u0003bBAa%\u0001\u0007\u00111Y\u0001\fS:4xn[3Rk\u0016\u0014\u0018\u0010\u0005\u0004*\u0003\u000b|\u0014\u0011Z\u0005\u0004\u0003\u000fT#!\u0003$v]\u000e$\u0018n\u001c82!\u0015!\u0016QVAf!\u0019\t\u0019'a\u001b\u0002\u0002\"1\u0011q\u001a\nA\u0002}\n1\"];fef\u001cFO]5oO\n\u0001\u0002k\\5oi&sG+[7f#V,'/_\u000b\u0005\u0003+\fYnE\u0002\u0014Q9\u0002b!KAc\u007f\u0005e\u0007#\u0002+\u0002\\\u0006-GA\u0002,\u0014\u0005\u0004\ti.F\u0002Y\u0003?$q!!9\u0002\\\n\u0007\u0001L\u0001\u0003`I\u0011\u001a\u0014AC3wS\u0012,gnY3%eA!a/_At!\r!\u00161\u001c\u000b\u000b\u0003W\f\u00190!>\u0002x\u0006eH\u0003BAw\u0003c\u0004R!a<\u0014\u0003Ol\u0011\u0001\u0005\u0005\b\u0003GL\u00029AAs\u0011\u001d\t\t-\u0007a\u0001\u0003/Da!a\n\u001a\u0001\u0004y\u0004\"\u0002 \u001a\u0001\u0004y\u0004B\u0002\u001d\u001a\u0001\u0004\tI%A\u0003rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002\u0000\n\u0005\u0001#\u0002+\u0002\\\u0006e\u0001bBAG5\u0001\u0007\u00111\u0007")
public class InfluxGenerator<F>
implements LazyLogging {
    private final String env;
    private final MonadError<F> monadError;
    private final SimpleInfluxClient<?> influxClient;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <F> F retrieveOnlyResultFromActionValueQuery(MetricsConfig config, Function1<String, F> invokeQuery, String queryString, MonadError<F> evidence$1) {
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, invokeQuery, queryString, evidence$1);
    }

    private Logger logger$lzycompute() {
        InfluxGenerator influxGenerator = this;
        synchronized (influxGenerator) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private SimpleInfluxClient<?> influxClient() {
        return this.influxClient;
    }

    public F queryBySingleDifference(String processName, Option<Instant> dateFrom, Instant dateTo, MetricsConfig config) {
        PointInTimeQuery pointInTimeQuery = new PointInTimeQuery((Function1 & Serializable)query2 -> this.influxClient().query((String)query2), processName, this.env, config, this.monadError());
        return (F)syntax.MonadErrorOps$.MODULE$.flatMap$extension(syntax$.MODULE$.MonadErrorOps(pointInTimeQuery.query(dateTo)), (Function1 & Serializable)valuesAtEnd -> syntax.MonadErrorOps$.MODULE$.map$extension(syntax$.MODULE$.MonadErrorOps(dateFrom.map((Function1 & Serializable)date -> pointInTimeQuery.query((Instant)date)).getOrElse((Function0 & Serializable)() -> this.monadError().unit(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))), (Function1 & Serializable)valuesAtStart -> (Map)valuesAtEnd.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                long value = tuple2._2$mcJ$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)BoxesRunTime.boxToLong((long)(value - BoxesRunTime.unboxToLong((Object)valuesAtStart.getOrElse((Object)key, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)))));
            }
            throw new MatchError((Object)tuple2);
        }), this.monadError()), this.monadError());
    }

    public F queryBySumOfDifferences(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        String query3 = "select sum(diff) as count from (SELECT non_negative_difference(\"" + config.countField() + "\") AS diff\n     FROM \"" + config.nodeCountMetric() + "\"\n     WHERE " + config.envTag() + " = '" + this.env + "' AND " + config.scenarioTag() + " = '" + processName + "'\n     AND time > " + dateFrom.getEpochSecond() + "s AND time < " + dateTo.getEpochSecond() + "s\n     GROUP BY " + config.nodeIdTag() + ", " + config.additionalGroupByTags().mkString(",") + ") group by " + config.nodeIdTag();
        return InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(config, (Function1 & Serializable)query2 -> this.influxClient().query((String)query2), query3, this.monadError());
    }

    public F detectRestarts(String processName, Instant dateFrom, Instant dateTo, MetricsConfig config) {
        long from = dateFrom.getEpochSecond();
        long to = dateTo.getEpochSecond();
        String queryString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("SELECT diff FROM (\n         |  SELECT difference(" + config.countField() + ") as diff FROM \"" + config.sourceCountMetric() + "\" WHERE\n         | \"" + config.scenarioTag() + "\" = '" + processName + "' AND " + config.envTag() + " = '" + this.env + "'\n         | AND time >= " + from + "s and time < " + to + "s GROUP BY " + config.additionalGroupByTags().mkString(",") + ", " + config.nodeIdTag() + ") where diff < 0 "));
        return (F)syntax.MonadErrorOps$.MODULE$.map$extension(syntax$.MODULE$.MonadErrorOps(this.influxClient().query(queryString)), (Function1 & Serializable)series -> (List)series.headOption().map((Function1 & Serializable)sourceCounts -> this.readRestartsFromSourceCounts((InfluxSeries)sourceCounts)).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$), this.monadError());
    }

    private List<Instant> readRestartsFromSourceCounts(InfluxSeries sourceCounts) {
        List restarts = sourceCounts.values().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ InfluxGenerator $outer;

            public final <A1 extends List<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)A1;
                    Object date = colon2.head();
                    List list = colon2.next$access$1();
                    if (date instanceof String) {
                        String string = (String)date;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list;
                            Object derivative = colon3.head();
                            List list2 = colon3.next$access$1();
                            if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list2)) {
                                return (B1)this.$outer.pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(string);
                            }
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(List<Object> x1) {
                List<Object> list = x1;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    Object date = colon2.head();
                    List list2 = colon2.next$access$1();
                    if (date instanceof String && list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        Object derivative = colon3.head();
                        List list3 = colon3.next$access$1();
                        if (derivative instanceof BigDecimal && Nil$.MODULE$.equals(list3)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return restarts;
    }

    public Instant pl$touk$nussknacker$processCounts$influxdb$InfluxGenerator$$parseInfluxDate(String date) {
        return ZonedDateTime.parse(date, DateTimeFormatter.ISO_ZONED_DATE_TIME).toInstant();
    }

    public F close() {
        return (F)this.influxClient().close();
    }

    public InfluxGenerator(InfluxConfig config, String env, SttpBackend<F, Nothing$, ?> backend) {
        this.env = env;
        LazyLogging.$init$((LazyLogging)this);
        this.monadError = backend.responseMonad();
        this.influxClient = new SimpleInfluxClient<F>(config, backend);
    }

    public static class PointInTimeQuery<F>
    implements LazyLogging {
        private final Function1<String, F> invokeQuery;
        private final String processName;
        private final String env;
        private final MetricsConfig config;
        private final MonadError<F> evidence$2;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            PointInTimeQuery pointInTimeQuery = this;
            synchronized (pointInTimeQuery) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        public F query(Instant date) {
            long around = date.getEpochSecond();
            return (F)syntax.MonadErrorOps$.MODULE$.flatMap$extension(syntax$.MODULE$.MonadErrorOps(InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery(this.config, this.invokeQuery, this.query$1("time <= " + around + "s and time > " + around + "s - 1h", "last"), this.evidence$2)), (Function1 & Serializable)valuesBefore -> syntax.MonadErrorOps$.MODULE$.map$extension(syntax$.MODULE$.MonadErrorOps(InfluxGenerator$.MODULE$.retrieveOnlyResultFromActionValueQuery($this.config, $this.invokeQuery, this.query$1("time >= " + around + "s and time < " + around + "s + 1h", "first"), $this.evidence$2)), (Function1 & Serializable)valuesAfter -> (Map)valuesBefore.$plus$plus((IterableOnce)valuesAfter), $this.evidence$2), this.evidence$2);
        }

        private final String query$1(String timeCondition, String aggregateFunction) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select " + this.config.nodeIdTag() + " as nodeId, " + aggregateFunction + "(" + this.config.countField() + ") as count\n           | from \"" + this.config.nodeCountMetric() + "\" where " + this.config.scenarioTag() + " = '" + this.processName + "'\n           | and " + timeCondition + " and " + this.config.envTag() + " = '" + this.env + "' group by " + this.config.additionalGroupByTags().mkString(",") + ", " + this.config.nodeIdTag() + " fill(0)"));
        }

        public PointInTimeQuery(Function1<String, F> invokeQuery, String processName, String env, MetricsConfig config, MonadError<F> evidence$2) {
            this.invokeQuery = invokeQuery;
            this.processName = processName;
            this.env = env;
            this.config = config;
            this.evidence$2 = evidence$2;
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

