/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.processCounts.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.processCounts.CannotFetchCountsError$;
import pl.touk.nussknacker.processCounts.CountsReporter;
import pl.touk.nussknacker.processCounts.CountsRequest;
import pl.touk.nussknacker.processCounts.ExecutionCount;
import pl.touk.nussknacker.processCounts.RangeCount;
import pl.touk.nussknacker.processCounts.influxdb.InfluxConfig;
import pl.touk.nussknacker.processCounts.influxdb.InfluxGenerator;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig;
import pl.touk.nussknacker.processCounts.influxdb.MetricsConfig$;
import pl.touk.nussknacker.processCounts.influxdb.QueryMode$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sttp.client3.SttpBackend;
import sttp.monad.MonadError;
import sttp.monad.syntax$;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001B\b\u0011\u0001mA\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005^\u0001\t\u0005\t\u0015a\u0003_\u0011\u00151\u0007\u0001\"\u0001h\u0011\u001dq\u0007A1A\u0005\u0002=DaA\u001f\u0001!\u0002\u0013\u0001\bbB>\u0001\u0005\u0004%Y\u0001 \u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003~\u0011%\tI\u0001\u0001b\u0001\n\u0013\tY\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0007\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!a\u000e\u0001\t\u0003\nI\u0004C\u0004\u0002<\u0001!I!!\u0010\u0003)%sg\r\\;y\u0007>,h\u000e^:SKB|'\u000f^3s\u0015\t\t\"#\u0001\u0005j]\u001adW\u000f\u001f3c\u0015\t\u0019B#A\u0007qe>\u001cWm]:D_VtGo\u001d\u0006\u0003+Y\t1B\\;tg.t\u0017mY6fe*\u0011q\u0003G\u0001\u0005i>,8NC\u0001\u001a\u0003\t\u0001Hn\u0001\u0001\u0016\u0005qY3\u0003\u0002\u0001\u001eKi\u0002\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\t1\fgn\u001a\u0006\u0002E\u0005!!.\u0019<b\u0013\t!sD\u0001\u0004PE*,7\r\u001e\t\u0004M\u001dJS\"\u0001\n\n\u0005!\u0012\"AD\"pk:$8OU3q_J$XM\u001d\t\u0003U-b\u0001\u0001B\u0003-\u0001\t\u0007QFA\u0001G+\tq\u0003(\u0005\u00020kA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t9aj\u001c;iS:<\u0007C\u0001\u00197\u0013\t9\u0014GA\u0002B]f$Q!O\u0016C\u00029\u0012Aa\u0018\u0013%cA\u00111HQ\u0007\u0002y)\u0011QHP\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u007f\u0001\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0003\u0006\u00191m\\7\n\u0005\rc$a\u0003'bufdunZ4j]\u001e\f1!\u001a8w!\t1UJ\u0004\u0002H\u0017B\u0011\u0001*M\u0007\u0002\u0013*\u0011!JG\u0001\u0007yI|w\u000e\u001e \n\u00051\u000b\u0014A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001T\u0019\u0002\r\r|gNZ5h!\t\u00116+D\u0001\u0011\u0013\t!\u0006C\u0001\u0007J]\u001adW\u000f_\"p]\u001aLw-\u0001\u0007xC&$hi\u001c:DY>\u001cX\r\u0005\u00031/fS\u0016B\u0001-2\u0005%1UO\\2uS>t\u0017\u0007E\u0002+Wi\u0003\"\u0001M.\n\u0005q\u000b$\u0001B+oSR\fqAY1dW\u0016tG\r\u0005\u0003`I&*T\"\u00011\u000b\u0005\u0005\u0014\u0017aB2mS\u0016tGo\r\u0006\u0002G\u0006!1\u000f\u001e;q\u0013\t)\u0007MA\u0006TiR\u0004()Y2lK:$\u0017A\u0002\u001fj]&$h\b\u0006\u0003iW2lGCA5k!\r\u0011\u0006!\u000b\u0005\u0006;\u0016\u0001\u001dA\u0018\u0005\u0006\t\u0016\u0001\r!\u0012\u0005\u0006!\u0016\u0001\r!\u0015\u0005\u0006+\u0016\u0001\rAV\u0001\u0010S:4G.\u001e=HK:,'/\u0019;peV\t\u0001\u000fE\u0002ScNL!A\u001d\t\u0003\u001f%sg\r\\;y\u000f\u0016tWM]1u_J,\"\u0001\u001e<\u0011\u0007)ZS\u000f\u0005\u0002+m\u0012)\u0011h\u001eb\u0001]!!\u0001p\u000b\u0001z\u0003%aDn\\2bY\u00022eh\u0003\u0001\u0002!%tg\r\\;y\u000f\u0016tWM]1u_J\u0004\u0013AC7p]\u0006$WI\u001d:peV\tQ\u0010\u0005\u0003\u007f\u0003\u0007IS\"A@\u000b\u0007\u0005\u0005!-A\u0003n_:\fG-C\u0002\u0002\u0006}\u0014!\"T8oC\u0012,%O]8s\u0003-iwN\\1e\u000bJ\u0014xN\u001d\u0011\u0002\u001b5,GO]5dg\u000e{gNZ5h+\t\ti\u0001E\u0002S\u0003\u001fI1!!\u0005\u0011\u00055iU\r\u001e:jGN\u001cuN\u001c4jO\u0006qQ.\u001a;sS\u000e\u001c8i\u001c8gS\u001e\u0004\u0013\u0001\u00059sKB\f'/\u001a*bo\u000e{WO\u001c;t)\u0019\tI\"!\u000b\u0002.A!!fKA\u000e!\u0015\u0001t+RA\u000f!\u0015\u0001\u0014qDA\u0012\u0013\r\t\t#\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007A\n)#C\u0002\u0002(E\u0012A\u0001T8oO\"1\u00111\u0006\u0007A\u0002\u0015\u000b\u0011\u0002\u001d:pG\u0016\u001c8/\u00133\t\u000f\u0005=B\u00021\u0001\u00022\u0005i1m\\;oiN\u0014V-];fgR\u00042AJA\u001a\u0013\r\t)D\u0005\u0002\u000e\u0007>,h\u000e^:SKF,Xm\u001d;\u0002\u000b\rdwn]3\u0015\u0003i\u000b!\u0003\u001d:fa\u0006\u0014XMU1oO\u0016\u001cu.\u001e8ugRA\u0011qHA$\u0003\u0013\nI\u0006\u0005\u0003+W\u0005\u0005\u0003C\u0002$\u0002D\u0015\u000b\u0019#C\u0002\u0002F=\u00131!T1q\u0011\u0019\tYC\u0004a\u0001\u000b\"9\u00111\n\bA\u0002\u00055\u0013\u0001\u00034s_6$\u0015\r^3\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\"\u0003\u0011!\u0018.\\3\n\t\u0005]\u0013\u0011\u000b\u0002\b\u0013:\u001cH/\u00198u\u0011\u001d\tYF\u0004a\u0001\u0003\u001b\na\u0001^8ECR,\u0007")
public class InfluxCountsReporter<F>
implements CountsReporter<F>,
LazyLogging {
    private final InfluxConfig config;
    private final Function1<F, BoxedUnit> waitForClose;
    private final InfluxGenerator<?> influxGenerator;
    private final MonadError<F> monadError;
    private final MetricsConfig metricsConfig;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxCountsReporter influxCountsReporter = this;
        synchronized (influxCountsReporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public InfluxGenerator<?> influxGenerator() {
        return this.influxGenerator;
    }

    private MonadError<F> monadError() {
        return this.monadError;
    }

    private MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public F prepareRawCounts(String processId, CountsRequest countsRequest) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> {
            CountsRequest countsRequest = countsRequest;
            if (countsRequest instanceof RangeCount) {
                RangeCount rangeCount = (RangeCount)countsRequest;
                Instant fromDate = rangeCount.fromDate();
                Instant toDate = rangeCount.toDate();
                return this.prepareRangeCounts(processId, fromDate, toDate);
            }
            if (countsRequest instanceof ExecutionCount) {
                ExecutionCount executionCount = (ExecutionCount)countsRequest;
                Instant pointInTime = executionCount.pointInTime();
                return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)None$.MODULE$, pointInTime, this.metricsConfig());
            }
            throw new MatchError((Object)countsRequest);
        }).map((Function1 & Serializable)x$1 -> (Function1 & Serializable)key -> x$1.get(key), this.monadError());
    }

    @Override
    public void close() {
        this.waitForClose.apply(this.influxGenerator().close());
    }

    private F prepareRangeCounts(String processId, Instant fromDate, Instant toDate) {
        return (F)syntax$.MODULE$.MonadErrorOps((Function0 & Serializable)() -> this.influxGenerator().detectRestarts(processId, fromDate, toDate, this.metricsConfig())).flatMap((Function1 & Serializable)restarts -> {
            Tuple2 tuple2 = new Tuple2(restarts, (Object)$this.config.queryMode());
            if (tuple2 != null) {
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value2 = QueryMode$.MODULE$.OnlySumOfDifferences();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value4 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    }
                }
            }
            if (tuple2 != null) {
                List nonEmpty = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value6 = QueryMode$.MODULE$.SumOfDifferencesForRestarts();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Restarts detected: {}, querying with differential", (Object)nonEmpty.mkString(","));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return this.influxGenerator().queryBySumOfDifferences(processId, fromDate, toDate, this.metricsConfig());
                }
            }
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                if (Nil$.MODULE$.equals(list)) {
                    Enumeration.Value value8 = QueryMode$.MODULE$.OnlySingleDifference();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        return this.influxGenerator().queryBySingleDifference(processId, (Option<Instant>)new Some((Object)fromDate), toDate, this.metricsConfig());
                    }
                }
            }
            if (tuple2 != null) {
                List dates = (List)tuple2._1();
                Enumeration.Value value = (Enumeration.Value)tuple2._2();
                Enumeration.Value value10 = QueryMode$.MODULE$.OnlySingleDifference();
                Enumeration.Value value11 = value;
                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                    return this.monadError().error((Throwable)CannotFetchCountsError$.MODULE$.restartsDetected((List<Instant>)dates));
                }
            }
            return this.monadError().error((Throwable)new IllegalArgumentException("Unknown QueryMode " + $this.config.queryMode() + " for " + restarts.size() + " restarts"));
        }, this.monadError());
    }

    public InfluxCountsReporter(String env, InfluxConfig config, Function1<F, BoxedUnit> waitForClose, SttpBackend<F, Object> backend) {
        this.config = config;
        this.waitForClose = waitForClose;
        LazyLogging.$init$((LazyLogging)this);
        this.influxGenerator = new InfluxGenerator<F>(config, env, backend);
        this.monadError = backend.responseMonad();
        this.metricsConfig = (MetricsConfig)config.metricsConfig().getOrElse((Function0 & Serializable)() -> new MetricsConfig(MetricsConfig$.MODULE$.apply$default$1(), MetricsConfig$.MODULE$.apply$default$2(), MetricsConfig$.MODULE$.apply$default$3(), MetricsConfig$.MODULE$.apply$default$4(), MetricsConfig$.MODULE$.apply$default$5(), MetricsConfig$.MODULE$.apply$default$6(), MetricsConfig$.MODULE$.apply$default$7()));
    }
}

