/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.process.util;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.engine.api.MetaData;
import pl.touk.nussknacker.engine.api.ProcessAdditionalFields;
import pl.touk.nussknacker.engine.api.TypeSpecificData;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class MetaDataExtractor$ {
    public static final MetaDataExtractor$ MODULE$;

    static {
        new MetaDataExtractor$();
    }

    public <T extends TypeSpecificData> Either<NonEmptyList<ProcessCompilationError.WrongProcessType>, T> extractTypeSpecificData(MetaData metaData, ClassTag<T> classTag) {
        TypeSpecificData typeSpecificData = metaData.typeSpecificData();
        Option option = classTag.unapply((Object)typeSpecificData);
        Object object = !option.isEmpty() && option.get() != null ? package$.MODULE$.Right().apply((Object)typeSpecificData) : package$.MODULE$.Left().apply((Object)NonEmptyList$.MODULE$.of((Object)new ProcessCompilationError.WrongProcessType(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ProcessCompilationError.WrongProcessType[0])));
        return object;
    }

    public <T extends TypeSpecificData> T extractTypeSpecificDataOrFail(MetaData metaData, ClassTag<T> classTag) {
        return (T)((TypeSpecificData)this.extractTypeSpecificData(metaData, classTag).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(NonEmptyList<ProcessCompilationError.WrongProcessType> x$1) {
                throw new IllegalArgumentException("Wrong process type");
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final T apply(T x) {
                return (T)((TypeSpecificData)Predef$.MODULE$.identity(x));
            }
        }));
    }

    public Option<String> extractProperty(MetaData metaData, String property) {
        return metaData.additionalFields().flatMap((Function1)new Serializable(property){
            public static final long serialVersionUID = 0L;
            private final String property$1;

            public final Option<String> apply(ProcessAdditionalFields x$2) {
                return x$2.properties().get((Object)this.property$1);
            }
            {
                this.property$1 = property$1;
            }
        });
    }

    public String extractProperty(MetaData metaData, String property, String string) {
        return (String)this.extractProperty(metaData, property).getOrElse((Function0)new Serializable(string){
            public static final long serialVersionUID = 0L;
            private final String default$1;

            public final String apply() {
                return this.default$1;
            }
            {
                this.default$1 = default$1;
            }
        });
    }

    public Option<Object> extractBooleanProperty(MetaData metaData, String property) {
        return this.extractProperty(metaData, property).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3)).toBoolean();
            }
        });
    }

    public boolean extractBooleanProperty(MetaData metaData, String property, boolean bl) {
        return BoxesRunTime.unboxToBoolean((Object)this.extractProperty(metaData, property).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(bl){
            public static final long serialVersionUID = 0L;
            private final boolean default$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.default$2;
            }
            {
                this.default$2 = default$2;
            }
        }));
    }

    public Option<Object> extractLongProperty(MetaData metaData, String property) {
        return this.extractProperty(metaData, property).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
            }
        });
    }

    public long extractLongProperty(MetaData metaData, String property, long l) {
        return BoxesRunTime.unboxToLong((Object)this.extractProperty(metaData, property).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String str) {
                return new StringOps(Predef$.MODULE$.augmentString(str)).toLong();
            }
        }).getOrElse((Function0)new Serializable(l){
            public static final long serialVersionUID = 0L;
            private final long default$3;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.default$3;
            }
            {
                this.default$3 = default$3;
            }
        }));
    }

    public LocalDateTime extractDateTimeProperty(MetaData metaData, String property, LocalDateTime localDateTime) {
        return (LocalDateTime)this.extractProperty(metaData, property).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LocalDateTime apply(String x$6) {
                return LocalDateTime.parse(x$6, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
        }).getOrElse((Function0)new Serializable(localDateTime){
            public static final long serialVersionUID = 0L;
            private final LocalDateTime default$4;

            public final LocalDateTime apply() {
                return this.default$4;
            }
            {
                this.default$4 = default$4;
            }
        });
    }

    public LocalTime extractTimeProperty(MetaData metaData, String property, LocalTime localTime) {
        return (LocalTime)this.extractProperty(metaData, property).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LocalTime apply(String x$7) {
                return LocalTime.parse(x$7, DateTimeFormatter.ISO_LOCAL_TIME);
            }
        }).getOrElse((Function0)new Serializable(localTime){
            public static final long serialVersionUID = 0L;
            private final LocalTime default$5;

            public final LocalTime apply() {
                return this.default$5;
            }
            {
                this.default$5 = default$5;
            }
        });
    }

    public LocalDate extractDateProperty(MetaData metaData, String property, LocalDate localDate) {
        return (LocalDate)this.extractProperty(metaData, property).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LocalDate apply(String x$8) {
                return LocalDate.parse(x$8, DateTimeFormatter.ISO_DATE);
            }
        }).getOrElse((Function0)new Serializable(localDate){
            public static final long serialVersionUID = 0L;
            private final LocalDate default$6;

            public final LocalDate apply() {
                return this.default$6;
            }
            {
                this.default$6 = default$6;
            }
        });
    }

    public Duration extractDurationProperty(MetaData metaData, String property, Duration duration) {
        return (Duration)this.extractProperty(metaData, property).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Duration apply(String x$9) {
                return Duration.parse(x$9);
            }
        }).getOrElse((Function0)new Serializable(duration){
            public static final long serialVersionUID = 0L;
            private final Duration default$7;

            public final Duration apply() {
                return this.default$7;
            }
            {
                this.default$7 = default$7;
            }
        });
    }

    public Period extractPeriodProperty(MetaData metaData, String property, Period period) {
        return (Period)this.extractProperty(metaData, property).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Period apply(String x$10) {
                return Period.parse(x$10);
            }
        }).getOrElse((Function0)new Serializable(period){
            public static final long serialVersionUID = 0L;
            private final Period default$8;

            public final Period apply() {
                return this.default$8;
            }
            {
                this.default$8 = default$8;
            }
        });
    }

    private MetaDataExtractor$() {
        MODULE$ = this;
    }
}

