/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.process.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.flink.api.common.ExecutionConfig;

public class TimeSerializers {
    public static void addDefaultSerializers(ExecutionConfig executionConfig) {
        TimeSerializers.addSerializer(executionConfig, Duration.class, new DurationSerializer());
        TimeSerializers.addSerializer(executionConfig, Instant.class, new InstantSerializer());
        TimeSerializers.addSerializer(executionConfig, LocalDate.class, new LocalDateSerializer());
        TimeSerializers.addSerializer(executionConfig, LocalTime.class, new LocalTimeSerializer());
        TimeSerializers.addSerializer(executionConfig, LocalDateTime.class, new LocalDateTimeSerializer());
        TimeSerializers.addSerializer(executionConfig, ZoneOffset.class, new ZoneOffsetSerializer());
        TimeSerializers.addSerializer(executionConfig, ZoneId.class, new ZoneIdSerializer());
        TimeSerializers.addSerializer(executionConfig, OffsetTime.class, new OffsetTimeSerializer());
        TimeSerializers.addSerializer(executionConfig, OffsetDateTime.class, new OffsetDateTimeSerializer());
        TimeSerializers.addSerializer(executionConfig, ZonedDateTime.class, new ZonedDateTimeSerializer());
        TimeSerializers.addSerializer(executionConfig, Year.class, new YearSerializer());
        TimeSerializers.addSerializer(executionConfig, YearMonth.class, new YearMonthSerializer());
        TimeSerializers.addSerializer(executionConfig, MonthDay.class, new MonthDaySerializer());
        TimeSerializers.addSerializer(executionConfig, Period.class, new PeriodSerializer());
    }

    private static <T, Y extends Serializer<T>> void addSerializer(ExecutionConfig executionConfig, Class<T> clazz, Y y) {
        executionConfig.getRegisteredTypesWithKryoSerializers().put(clazz, new ExecutionConfig.SerializableSerializer(y));
        executionConfig.getDefaultKryoSerializers().put(clazz, new ExecutionConfig.SerializableSerializer(y));
    }

    private static class PeriodSerializer
    extends Serializer<Period>
    implements Serializable {
        private PeriodSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Period period) {
            output.writeInt(period.getYears(), true);
            output.writeInt(period.getMonths(), true);
            output.writeInt(period.getDays(), true);
        }

        public Period read(Kryo kryo, Input input, Class<Period> clazz) {
            int n = input.readInt(true);
            int n2 = input.readInt(true);
            int n3 = input.readInt(true);
            return Period.of(n, n2, n3);
        }
    }

    private static class MonthDaySerializer
    extends Serializer<MonthDay>
    implements Serializable {
        private MonthDaySerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, MonthDay monthDay) {
            output.writeByte(monthDay.getMonthValue());
            output.writeByte(monthDay.getDayOfMonth());
        }

        public MonthDay read(Kryo kryo, Input input, Class<MonthDay> clazz) {
            byte by = input.readByte();
            byte by2 = input.readByte();
            return MonthDay.of(by, (int)by2);
        }
    }

    private static class YearMonthSerializer
    extends Serializer<YearMonth>
    implements Serializable {
        private YearMonthSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, YearMonth yearMonth) {
            output.writeInt(yearMonth.getYear(), true);
            output.writeByte(yearMonth.getMonthValue());
        }

        public YearMonth read(Kryo kryo, Input input, Class<YearMonth> clazz) {
            int n = input.readInt(true);
            byte by = input.readByte();
            return YearMonth.of(n, by);
        }
    }

    private static class YearSerializer
    extends Serializer<Year>
    implements Serializable {
        private YearSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Year year) {
            output.writeInt(year.getValue(), true);
        }

        public Year read(Kryo kryo, Input input, Class<Year> clazz) {
            return Year.of(input.readInt(true));
        }
    }

    private static class ZonedDateTimeSerializer
    extends Serializer<ZonedDateTime>
    implements Serializable {
        private ZonedDateTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, ZonedDateTime zonedDateTime) {
            LocalDateSerializer.write(output, zonedDateTime.toLocalDate());
            LocalTimeSerializer.write(output, zonedDateTime.toLocalTime());
            ZoneIdSerializer.write(output, zonedDateTime.getZone());
        }

        public ZonedDateTime read(Kryo kryo, Input input, Class<ZonedDateTime> clazz) {
            LocalDate localDate = LocalDateSerializer.read(input);
            LocalTime localTime = LocalTimeSerializer.read(input);
            ZoneId zoneId = ZoneIdSerializer.read(input);
            return ZonedDateTime.of(localDate, localTime, zoneId);
        }
    }

    private static class OffsetDateTimeSerializer
    extends Serializer<OffsetDateTime>
    implements Serializable {
        private OffsetDateTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, OffsetDateTime offsetDateTime) {
            LocalDateSerializer.write(output, offsetDateTime.toLocalDate());
            LocalTimeSerializer.write(output, offsetDateTime.toLocalTime());
            ZoneOffsetSerializer.write(output, offsetDateTime.getOffset());
        }

        public OffsetDateTime read(Kryo kryo, Input input, Class<OffsetDateTime> clazz) {
            LocalDate localDate = LocalDateSerializer.read(input);
            LocalTime localTime = LocalTimeSerializer.read(input);
            ZoneOffset zoneOffset = ZoneOffsetSerializer.read(input);
            return OffsetDateTime.of(localDate, localTime, zoneOffset);
        }
    }

    private static class OffsetTimeSerializer
    extends Serializer<OffsetTime>
    implements Serializable {
        private OffsetTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, OffsetTime offsetTime) {
            LocalTimeSerializer.write(output, offsetTime.toLocalTime());
            ZoneOffsetSerializer.write(output, offsetTime.getOffset());
        }

        public OffsetTime read(Kryo kryo, Input input, Class<OffsetTime> clazz) {
            LocalTime localTime = LocalTimeSerializer.read(input);
            ZoneOffset zoneOffset = ZoneOffsetSerializer.read(input);
            return OffsetTime.of(localTime, zoneOffset);
        }
    }

    private static class ZoneIdSerializer
    extends Serializer<ZoneId>
    implements Serializable {
        private ZoneIdSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, ZoneId zoneId) {
            ZoneIdSerializer.write(output, zoneId);
        }

        static void write(Output output, ZoneId zoneId) {
            output.writeString(zoneId.getId());
        }

        public ZoneId read(Kryo kryo, Input input, Class<ZoneId> clazz) {
            return ZoneIdSerializer.read(input);
        }

        static ZoneId read(Input input) {
            String string = input.readString();
            return ZoneId.of(string);
        }
    }

    private static class ZoneOffsetSerializer
    extends Serializer<ZoneOffset>
    implements Serializable {
        private ZoneOffsetSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, ZoneOffset zoneOffset) {
            ZoneOffsetSerializer.write(output, zoneOffset);
        }

        static void write(Output output, ZoneOffset zoneOffset) {
            int n = zoneOffset.getTotalSeconds();
            int n2 = n % 900 == 0 ? n / 900 : 127;
            output.writeByte(n2);
            if (n2 == 127) {
                output.writeInt(n);
            }
        }

        public ZoneOffset read(Kryo kryo, Input input, Class<ZoneOffset> clazz) {
            return ZoneOffsetSerializer.read(input);
        }

        static ZoneOffset read(Input input) {
            byte by = input.readByte();
            return by == 127 ? ZoneOffset.ofTotalSeconds(input.readInt()) : ZoneOffset.ofTotalSeconds(by * 900);
        }
    }

    private static class LocalTimeSerializer
    extends Serializer<LocalTime>
    implements Serializable {
        private LocalTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, LocalTime localTime) {
            LocalTimeSerializer.write(output, localTime);
        }

        static void write(Output output, LocalTime localTime) {
            if (localTime.getNano() == 0) {
                if (localTime.getSecond() == 0) {
                    if (localTime.getMinute() == 0) {
                        output.writeByte(~localTime.getHour());
                    } else {
                        output.writeByte(localTime.getHour());
                        output.writeByte(~localTime.getMinute());
                    }
                } else {
                    output.writeByte(localTime.getHour());
                    output.writeByte(localTime.getMinute());
                    output.writeByte(~localTime.getSecond());
                }
            } else {
                output.writeByte(localTime.getHour());
                output.writeByte(localTime.getMinute());
                output.writeByte(localTime.getSecond());
                output.writeInt(localTime.getNano(), true);
            }
        }

        public LocalTime read(Kryo kryo, Input input, Class<LocalTime> clazz) {
            return LocalTimeSerializer.read(input);
        }

        static LocalTime read(Input input) {
            int n = input.readByte();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (n < 0) {
                n ^= 0xFFFFFFFF;
            } else {
                n2 = input.readByte();
                if (n2 < 0) {
                    n2 ^= 0xFFFFFFFF;
                } else {
                    n3 = input.readByte();
                    if (n3 < 0) {
                        n3 ^= 0xFFFFFFFF;
                    } else {
                        n4 = input.readInt(true);
                    }
                }
            }
            return LocalTime.of(n, n2, n3, n4);
        }
    }

    private static class LocalDateTimeSerializer
    extends Serializer<LocalDateTime>
    implements Serializable {
        private LocalDateTimeSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, LocalDateTime localDateTime) {
            LocalDateSerializer.write(output, localDateTime.toLocalDate());
            LocalTimeSerializer.write(output, localDateTime.toLocalTime());
        }

        public LocalDateTime read(Kryo kryo, Input input, Class<LocalDateTime> clazz) {
            LocalDate localDate = LocalDateSerializer.read(input);
            LocalTime localTime = LocalTimeSerializer.read(input);
            return LocalDateTime.of(localDate, localTime);
        }
    }

    private static class LocalDateSerializer
    extends Serializer<LocalDate>
    implements Serializable {
        private LocalDateSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, LocalDate localDate) {
            LocalDateSerializer.write(output, localDate);
        }

        static void write(Output output, LocalDate localDate) {
            output.writeInt(localDate.getYear(), true);
            output.writeByte(localDate.getMonthValue());
            output.writeByte(localDate.getDayOfMonth());
        }

        public LocalDate read(Kryo kryo, Input input, Class<LocalDate> clazz) {
            return LocalDateSerializer.read(input);
        }

        static LocalDate read(Input input) {
            int n = input.readInt(true);
            byte by = input.readByte();
            byte by2 = input.readByte();
            return LocalDate.of(n, by, (int)by2);
        }
    }

    private static class InstantSerializer
    extends Serializer<Instant>
    implements Serializable {
        private InstantSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Instant instant) {
            output.writeLong(instant.getEpochSecond(), true);
            output.writeInt(instant.getNano(), true);
        }

        public Instant read(Kryo kryo, Input input, Class<Instant> clazz) {
            long l = input.readLong(true);
            int n = input.readInt(true);
            return Instant.ofEpochSecond(l, n);
        }
    }

    private static class DurationSerializer
    extends Serializer<Duration>
    implements Serializable {
        private DurationSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Duration duration) {
            output.writeLong(duration.getSeconds());
            output.writeInt(duration.getNano(), true);
        }

        public Duration read(Kryo kryo, Input input, Class<Duration> clazz) {
            long l = input.readLong();
            int n = input.readInt(true);
            return Duration.ofSeconds(l, n);
        }
    }
}

