/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.restmodel.validation;

import pl.touk.nussknacker.engine.api.context.ParameterValidationError;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError;
import pl.touk.nussknacker.engine.api.util.ReflectUtils$;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess$;
import pl.touk.nussknacker.engine.graph.node$;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.restmodel.validation.ValidationResults$NodeValidationErrorType$;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;

public final class PrettyValidationErrors$ {
    public static PrettyValidationErrors$ MODULE$;

    static {
        new PrettyValidationErrors$();
    }

    public ValidationResults.NodeValidationError formatErrorMessage(ProcessCompilationError error) {
        ValidationResults.NodeValidationError nodeValidationError;
        String typ = this.getErrorTypeName(error);
        ProcessCompilationError processCompilationError = error;
        if (processCompilationError instanceof ProcessCompilationError.ExpressionParserCompilationError) {
            ProcessCompilationError.ExpressionParserCompilationError expressionParserCompilationError = (ProcessCompilationError.ExpressionParserCompilationError)processCompilationError;
            String message = expressionParserCompilationError.message();
            Option fieldName = expressionParserCompilationError.fieldName();
            String x$1 = new StringBuilder(28).append("Failed to parse expression: ").append(message).toString();
            String x$2 = new StringBuilder(68).append("There is problem with expression in field ").append(fieldName).append(" - it could not be parsed.").toString();
            Option x$3 = fieldName;
            Enumeration.Value x$4 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$1, x$2, x$4, x$3, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.FragmentParamClassLoadError) {
            ProcessCompilationError.FragmentParamClassLoadError fragmentParamClassLoadError = (ProcessCompilationError.FragmentParamClassLoadError)processCompilationError;
            String fieldName = fragmentParamClassLoadError.fieldName();
            String refClazzName = fragmentParamClassLoadError.refClazzName();
            String x$5 = "Invalid parameter type.";
            String x$6 = new StringBuilder(15).append("Failed to load ").append(refClazzName).toString();
            Some x$7 = new Some((Object)node$.MODULE$.qualifiedParamFieldName(fieldName, (Option)new Some((Object)node$.MODULE$.TypFieldName())));
            Enumeration.Value x$8 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$5, x$6, x$8, (Option)x$7, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.DuplicatedNodeIds) {
            ProcessCompilationError.DuplicatedNodeIds duplicatedNodeIds = (ProcessCompilationError.DuplicatedNodeIds)processCompilationError;
            Set ids = duplicatedNodeIds.nodeIds();
            nodeValidationError = PrettyValidationErrors$.node$1("Two nodes cannot have same id", new StringBuilder(20).append("Duplicate node ids: ").append(ids.mkString(", ")).toString(), ValidationResults$NodeValidationErrorType$.MODULE$.RenderNotAllowed(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (ProcessCompilationError.EmptyProcess$.MODULE$.equals(processCompilationError)) {
            nodeValidationError = PrettyValidationErrors$.node$1("Empty scenario", "Scenario is empty, please add some nodes", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidRootNode) {
            nodeValidationError = PrettyValidationErrors$.node$1("Invalid root node", "Scenario can start only from source node", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidTailOfBranch) {
            nodeValidationError = PrettyValidationErrors$.node$1("Scenario must end with a sink, processor or fragment", "Scenario must end with a sink, processor or fragment", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.IdError) {
            ProcessCompilationError.IdError idError = (ProcessCompilationError.IdError)processCompilationError;
            nodeValidationError = this.mapIdErrorToNodeError(idError);
        } else if (processCompilationError instanceof ProcessCompilationError.ScenarioNameValidationError) {
            ProcessCompilationError.ScenarioNameValidationError scenarioNameValidationError = (ProcessCompilationError.ScenarioNameValidationError)processCompilationError;
            String message = scenarioNameValidationError.message();
            String description = scenarioNameValidationError.description();
            String x$9 = message;
            String x$10 = description;
            Some x$11 = new Some((Object)CanonicalProcess$.MODULE$.IdFieldName());
            Enumeration.Value x$12 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$9, x$10, x$12, (Option)x$11, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.SpecificDataValidationError) {
            String message;
            ProcessCompilationError.SpecificDataValidationError specificDataValidationError = (ProcessCompilationError.SpecificDataValidationError)processCompilationError;
            String field = specificDataValidationError.fieldName();
            String x$13 = message = specificDataValidationError.message();
            String x$14 = message;
            Some x$15 = new Some((Object)field);
            Enumeration.Value x$16 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$13, x$14, x$16, (Option)x$15, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.NonUniqueEdgeType) {
            ProcessCompilationError.NonUniqueEdgeType nonUniqueEdgeType = (ProcessCompilationError.NonUniqueEdgeType)processCompilationError;
            String etype = nonUniqueEdgeType.edgeType();
            String nodeId = nonUniqueEdgeType.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("Edges are not unique", new StringBuilder(73).append("Node ").append(nodeId).append(" has duplicate outgoing edges of type: ").append(etype).append(", it cannot be saved properly").toString(), ValidationResults$NodeValidationErrorType$.MODULE$.SaveNotAllowed(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.NonUniqueEdge) {
            ProcessCompilationError.NonUniqueEdge nonUniqueEdge = (ProcessCompilationError.NonUniqueEdge)processCompilationError;
            String nodeId = nonUniqueEdge.nodeId();
            String target = nonUniqueEdge.target();
            nodeValidationError = PrettyValidationErrors$.node$1("Edges are not unique", new StringBuilder(68).append("Node ").append(nodeId).append(" has duplicate outgoing edges to: ").append(target).append(", it cannot be saved properly").toString(), ValidationResults$NodeValidationErrorType$.MODULE$.SaveNotAllowed(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.LooseNode) {
            ProcessCompilationError.LooseNode looseNode = (ProcessCompilationError.LooseNode)processCompilationError;
            String nodeId = looseNode.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("Loose node", new StringBuilder(61).append("Node ").append(nodeId).append(" is not connected to source, it cannot be saved properly").toString(), ValidationResults$NodeValidationErrorType$.MODULE$.SaveNotAllowed(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.DisabledNode) {
            ProcessCompilationError.DisabledNode disabledNode = (ProcessCompilationError.DisabledNode)processCompilationError;
            String nodeId = disabledNode.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(17).append("Node ").append(nodeId).append(" is disabled").toString(), "Deploying scenario with disabled node can have unexpected consequences", ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingParameters) {
            ProcessCompilationError.MissingParameters missingParameters = (ProcessCompilationError.MissingParameters)processCompilationError;
            Set params = missingParameters.params();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(28).append("Node parameters not filled: ").append(params.mkString(", ")).toString(), new StringBuilder(39).append("Please fill missing node parameters: : ").append(params.mkString(", ")).toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ParameterValidationError) {
            ParameterValidationError parameterValidationError = (ParameterValidationError)processCompilationError;
            nodeValidationError = PrettyValidationErrors$.handleParameterValidationError$1(parameterValidationError, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingCustomNodeExecutor) {
            ProcessCompilationError.MissingCustomNodeExecutor missingCustomNodeExecutor = (ProcessCompilationError.MissingCustomNodeExecutor)processCompilationError;
            String id = missingCustomNodeExecutor.name();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(25).append("Missing custom executor: ").append(id).toString(), new StringBuilder(59).append("Please check the name of custom executor, ").append(id).append(" is not available").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingService) {
            ProcessCompilationError.MissingService missingService = (ProcessCompilationError.MissingService)processCompilationError;
            String id = missingService.serviceId();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(28).append("Missing processor/enricher: ").append(id).toString(), new StringBuilder(62).append("Please check the name of processor/enricher, ").append(id).append(" is not available").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingSinkFactory) {
            ProcessCompilationError.MissingSinkFactory missingSinkFactory = (ProcessCompilationError.MissingSinkFactory)processCompilationError;
            String id = missingSinkFactory.typ();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(14).append("Missing sink: ").append(id).toString(), new StringBuilder(48).append("Please check the name of sink, ").append(id).append(" is not available").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingSourceFactory) {
            ProcessCompilationError.MissingSourceFactory missingSourceFactory = (ProcessCompilationError.MissingSourceFactory)processCompilationError;
            String id = missingSourceFactory.typ();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(16).append("Missing source: ").append(id).toString(), new StringBuilder(50).append("Please check the name of source, ").append(id).append(" is not available").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.RedundantParameters) {
            ProcessCompilationError.RedundantParameters redundantParameters = (ProcessCompilationError.RedundantParameters)processCompilationError;
            Set params = redundantParameters.params();
            nodeValidationError = PrettyValidationErrors$.node$1("Redundant parameters", new StringBuilder(34).append("Please omit redundant parameters: ").append(params.mkString(", ")).toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.WrongParameters) {
            ProcessCompilationError.WrongParameters wrongParameters = (ProcessCompilationError.WrongParameters)processCompilationError;
            Set requiredParameters = wrongParameters.requiredParameters();
            Set passedParameters = wrongParameters.passedParameters();
            nodeValidationError = PrettyValidationErrors$.node$1("Wrong parameters", new StringBuilder(27).append("Please provide ").append(requiredParameters.mkString(", ")).append(" instead of ").append(passedParameters.mkString(", ")).toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.OverwrittenVariable) {
            ProcessCompilationError.OverwrittenVariable overwrittenVariable = (ProcessCompilationError.OverwrittenVariable)processCompilationError;
            String varName = overwrittenVariable.variableName();
            Option paramName = overwrittenVariable.paramName();
            String x$17 = new StringBuilder(43).append("Variable output name '").append(varName).append("' is already defined.").toString();
            String x$18 = "You cannot overwrite variables";
            Option x$19 = paramName;
            Enumeration.Value x$20 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$17, x$18, x$20, x$19, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidVariableOutputName) {
            ProcessCompilationError.InvalidVariableOutputName invalidVariableOutputName = (ProcessCompilationError.InvalidVariableOutputName)processCompilationError;
            String varName = invalidVariableOutputName.name();
            Option paramName = invalidVariableOutputName.paramName();
            String x$21 = new StringBuilder(97).append("Variable output name '").append(varName).append("' is not a valid identifier (only letters, numbers or '_', cannot be empty)").toString();
            String x$22 = "Please use only letters, numbers or '_', also identifier cannot be empty.";
            Option x$23 = paramName;
            Enumeration.Value x$24 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$21, x$22, x$24, x$23, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.NotSupportedExpressionLanguage) {
            ProcessCompilationError.NotSupportedExpressionLanguage notSupportedExpressionLanguage = (ProcessCompilationError.NotSupportedExpressionLanguage)processCompilationError;
            String languageId = notSupportedExpressionLanguage.languageId();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(26).append("Language ").append(languageId).append(" is not supported").toString(), "Currently only SPEL expressions are supported", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingPart) {
            ProcessCompilationError.MissingPart missingPart = (ProcessCompilationError.MissingPart)processCompilationError;
            String id = missingPart.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("MissingPart", new StringBuilder(22).append("Node ").append(id).append(" has missing part").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.UnsupportedPart) {
            ProcessCompilationError.UnsupportedPart unsupportedPart = (ProcessCompilationError.UnsupportedPart)processCompilationError;
            String id = unsupportedPart.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("UnsupportedPart", new StringBuilder(38).append("Type of node ").append(id).append(" is unsupported right now").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.UnknownFragment) {
            ProcessCompilationError.UnknownFragment unknownFragment = (ProcessCompilationError.UnknownFragment)processCompilationError;
            String id = unknownFragment.id();
            String nodeId = unknownFragment.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("Unknown fragment", new StringBuilder(37).append("Node ").append(nodeId).append(" uses fragment ").append(id).append(" which is missing").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidFragment) {
            ProcessCompilationError.InvalidFragment invalidFragment = (ProcessCompilationError.InvalidFragment)processCompilationError;
            String id = invalidFragment.id();
            String nodeId = invalidFragment.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("Invalid fragment", new StringBuilder(37).append("Node ").append(nodeId).append(" uses fragment ").append(id).append(" which is invalid").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.FatalUnknownError) {
            ProcessCompilationError.FatalUnknownError fatalUnknownError = (ProcessCompilationError.FatalUnknownError)processCompilationError;
            String message = fatalUnknownError.message();
            nodeValidationError = PrettyValidationErrors$.node$1("Unknown, fatal validation error", new StringBuilder(41).append("Fatal error: ").append(message).append(", please check configuration").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.CannotCreateObjectError) {
            ProcessCompilationError.CannotCreateObjectError cannotCreateObjectError = (ProcessCompilationError.CannotCreateObjectError)processCompilationError;
            String message = cannotCreateObjectError.message();
            String nodeId = cannotCreateObjectError.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(19).append("Could not create ").append(nodeId).append(": ").append(message).toString(), new StringBuilder(19).append("Could not create ").append(nodeId).append(": ").append(message).toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.UnresolvedFragment) {
            ProcessCompilationError.UnresolvedFragment unresolvedFragment = (ProcessCompilationError.UnresolvedFragment)processCompilationError;
            String id = unresolvedFragment.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("Unresolved fragment", new StringBuilder(45).append("fragment ").append(id).append(" encountered, this should not happen").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.FragmentOutputNotDefined) {
            ProcessCompilationError.FragmentOutputNotDefined fragmentOutputNotDefined = (ProcessCompilationError.FragmentOutputNotDefined)processCompilationError;
            String id = fragmentOutputNotDefined.id();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(19).append("Output ").append(id).append(" not defined").toString(), "Please check fragment definition", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.UnknownFragmentOutput) {
            ProcessCompilationError.UnknownFragmentOutput unknownFragmentOutput = (ProcessCompilationError.UnknownFragmentOutput)processCompilationError;
            String id = unknownFragmentOutput.id();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(24).append("Unknown fragment output ").append(id).toString(), "Please check fragment definition", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.DisablingManyOutputsFragment) {
            ProcessCompilationError.DisablingManyOutputsFragment disablingManyOutputsFragment = (ProcessCompilationError.DisablingManyOutputsFragment)processCompilationError;
            String id = disablingManyOutputsFragment.id();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(42).append("Cannot disable fragment ").append(id).append(". Has many outputs").toString(), "Please check fragment definition", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.DisablingNoOutputsFragment) {
            ProcessCompilationError.DisablingNoOutputsFragment disablingNoOutputsFragment = (ProcessCompilationError.DisablingNoOutputsFragment)processCompilationError;
            String id = disablingNoOutputsFragment.id();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(40).append("Cannot disable fragment ").append(id).append(". Hasn't outputs").toString(), "Please check fragment definition", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingRequiredProperty) {
            ProcessCompilationError.MissingRequiredProperty missingRequiredProperty = (ProcessCompilationError.MissingRequiredProperty)processCompilationError;
            String fieldName = missingRequiredProperty.paramName();
            Option label = missingRequiredProperty.label();
            nodeValidationError = this.missingRequiredProperty(typ, fieldName, (Option<String>)label);
        } else if (processCompilationError instanceof ProcessCompilationError.UnknownProperty) {
            ProcessCompilationError.UnknownProperty unknownProperty = (ProcessCompilationError.UnknownProperty)processCompilationError;
            String propertyName = unknownProperty.paramName();
            nodeValidationError = this.unknownProperty(typ, propertyName);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidPropertyFixedValue) {
            ProcessCompilationError.InvalidPropertyFixedValue invalidPropertyFixedValue = (ProcessCompilationError.InvalidPropertyFixedValue)processCompilationError;
            String fieldName = invalidPropertyFixedValue.paramName();
            Option label = invalidPropertyFixedValue.label();
            String value = invalidPropertyFixedValue.value();
            List values = invalidPropertyFixedValue.values();
            nodeValidationError = this.invalidPropertyFixedValue(typ, fieldName, (Option<String>)label, value, (List<String>)values);
        } else if (processCompilationError instanceof ProcessCompilationError.CustomNodeError) {
            ProcessCompilationError.CustomNodeError customNodeError = (ProcessCompilationError.CustomNodeError)processCompilationError;
            String message = customNodeError.message();
            Option paramName = customNodeError.paramName();
            nodeValidationError = new ValidationResults.NodeValidationError(typ, message, message, (Option<String>)paramName, ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed());
        } else if (processCompilationError instanceof ProcessCompilationError.MultipleOutputsForName) {
            ProcessCompilationError.MultipleOutputsForName multipleOutputsForName = (ProcessCompilationError.MultipleOutputsForName)processCompilationError;
            String name = multipleOutputsForName.name();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(97).append("There is more than one output with '").append(name).append("' name defined in the fragment, currently this is not allowed").toString(), "Please check fragment definition", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InitialValueNotPresentInPossibleValues) {
            ProcessCompilationError.InitialValueNotPresentInPossibleValues initialValueNotPresentInPossibleValues = (ProcessCompilationError.InitialValueNotPresentInPossibleValues)processCompilationError;
            String paramName = initialValueNotPresentInPossibleValues.paramName();
            String x$25 = new StringBuilder(98).append("The initial value provided for parameter '").append(paramName).append("' is not present in the parameter's possible values list").toString();
            String x$26 = "Please check fragment definition";
            Some x$27 = new Some((Object)node$.MODULE$.qualifiedParamFieldName(paramName, (Option)new Some((Object)node$.MODULE$.InitialValueFieldName())));
            Enumeration.Value x$28 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$25, x$26, x$28, (Option)x$27, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.UnsupportedFixedValuesType) {
            ProcessCompilationError.UnsupportedFixedValuesType unsupportedFixedValuesType = (ProcessCompilationError.UnsupportedFixedValuesType)processCompilationError;
            String paramName = unsupportedFixedValuesType.paramName();
            String typ2 = unsupportedFixedValuesType.typ();
            String x$29 = new StringBuilder(77).append("Fixed values list can only be be provided for type String or Boolean, found: ").append(typ2).toString();
            String x$30 = "Please check fragment definition";
            Some x$31 = new Some((Object)node$.MODULE$.qualifiedParamFieldName(paramName, (Option)new Some((Object)node$.MODULE$.TypFieldName())));
            Enumeration.Value x$32 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$29, x$30, x$32, (Option)x$31, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.RequireValueFromEmptyFixedList) {
            ProcessCompilationError.RequireValueFromEmptyFixedList requireValueFromEmptyFixedList = (ProcessCompilationError.RequireValueFromEmptyFixedList)processCompilationError;
            String paramName = requireValueFromEmptyFixedList.paramName();
            String x$33 = new StringBuilder(63).append("Required parameter '").append(paramName).append("' cannot be a member of an empty fixed list").toString();
            String x$34 = "Please check fragment definition";
            Some x$35 = new Some((Object)node$.MODULE$.qualifiedParamFieldName(paramName, (Option)new Some((Object)node$.MODULE$.InputModeFieldName())));
            Enumeration.Value x$36 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$33, x$34, x$36, (Option)x$35, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.ExpressionParserCompilationErrorInFragmentDefinition) {
            ProcessCompilationError.ExpressionParserCompilationErrorInFragmentDefinition expressionParserCompilationErrorInFragmentDefinition = (ProcessCompilationError.ExpressionParserCompilationErrorInFragmentDefinition)processCompilationError;
            String message = expressionParserCompilationErrorInFragmentDefinition.message();
            String paramName = expressionParserCompilationErrorInFragmentDefinition.paramName();
            Option subFieldName = expressionParserCompilationErrorInFragmentDefinition.subFieldName();
            String originalExpr = expressionParserCompilationErrorInFragmentDefinition.originalExpr();
            String x$37 = new StringBuilder(28).append("Failed to parse expression: ").append(message).toString();
            String x$38 = new StringBuilder(36).append("There is a problem with expression: ").append(originalExpr).toString();
            Some x$39 = new Some((Object)node$.MODULE$.qualifiedParamFieldName(paramName, subFieldName));
            Enumeration.Value x$40 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$37, x$38, x$40, (Option)x$39, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidValidationExpression) {
            ProcessCompilationError.InvalidValidationExpression invalidValidationExpression = (ProcessCompilationError.InvalidValidationExpression)processCompilationError;
            String message = invalidValidationExpression.message();
            String paramName = invalidValidationExpression.paramName();
            String originalExpr = invalidValidationExpression.originalExpr();
            String x$41 = new StringBuilder(31).append("Invalid validation expression: ").append(message).toString();
            String x$42 = new StringBuilder(47).append("There is a problem with validation expression: ").append(originalExpr).toString();
            Some x$43 = new Some((Object)node$.MODULE$.qualifiedParamFieldName(paramName, (Option)new Some((Object)node$.MODULE$.ValidationExpressionFieldName())));
            Enumeration.Value x$44 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$41, x$42, x$44, (Option)x$43, typ);
        } else {
            throw new MatchError((Object)processCompilationError);
        }
        return nodeValidationError;
    }

    public ValidationResults.NodeValidationError noValidatorKnown(String processingType) {
        return new ValidationResults.NodeValidationError(processingType, new StringBuilder(27).append("No validator available for ").append(processingType).toString(), "No validator for scenario type - please check configuration", (Option<String>)None$.MODULE$, ValidationResults$NodeValidationErrorType$.MODULE$.RenderNotAllowed());
    }

    private ValidationResults.NodeValidationError unknownProperty(String typ, String propertyName) {
        return new ValidationResults.NodeValidationError(typ, new StringBuilder(17).append("Unknown property ").append(propertyName).toString(), new StringBuilder(22).append("Property ").append(propertyName).append(" is not known").toString(), (Option<String>)new Some((Object)propertyName), ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed());
    }

    private ValidationResults.NodeValidationError missingRequiredProperty(String typ, String fieldName, Option<String> label) {
        String labelText = this.getLabel(label);
        return new ValidationResults.NodeValidationError(typ, new StringBuilder(31).append("Configured property ").append(fieldName).append(labelText).append(" is missing").toString(), new StringBuilder(29).append("Please fill missing property ").append(fieldName).append(labelText).toString(), (Option<String>)new Some((Object)fieldName), ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed());
    }

    private ValidationResults.NodeValidationError invalidPropertyFixedValue(String typ, String propertyName, Option<String> label, String value, List<String> values) {
        String labelText = this.getLabel(label);
        return new ValidationResults.NodeValidationError(typ, new StringBuilder(27).append("Property ").append(propertyName).append(labelText).append(" has invalid value").toString(), new StringBuilder(24).append("Expected one of ").append(values.mkString(", ")).append(", got: ").append(value).append(".").toString(), (Option<String>)new Some((Object)propertyName), ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed());
    }

    private String getLabel(Option<String> label) {
        String string;
        Option<String> option = label;
        if (option instanceof Some) {
            Some some = (Some)option;
            String text = (String)some.value();
            string = new StringBuilder(3).append(" (").append(text).append(")").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private String getErrorTypeName(ProcessCompilationError error) {
        return ReflectUtils$.MODULE$.simpleNameWithoutSuffix(error.getClass());
    }

    private ValidationResults.NodeValidationError mapIdErrorToNodeError(ProcessCompilationError.IdError error) {
        String string;
        String string2;
        String string3;
        Enumeration.Value value;
        String string4;
        ProcessCompilationError.IdError idError = error;
        if (idError instanceof ProcessCompilationError.ScenarioIdError) {
            ProcessCompilationError.ScenarioIdError scenarioIdError = (ProcessCompilationError.ScenarioIdError)idError;
            boolean isFragment = scenarioIdError.isFragment();
            string4 = isFragment ? "Fragment" : "Scenario";
        } else if (idError instanceof ProcessCompilationError.NodeIdValidationError) {
            string4 = "Node";
        } else {
            throw new MatchError((Object)idError);
        }
        String validatedObjectType = string4;
        ProcessCompilationError.IdError idError2 = error;
        if (idError2 instanceof ProcessCompilationError.ScenarioIdError) {
            value = ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed();
        } else if (idError2 instanceof ProcessCompilationError.NodeIdValidationError) {
            ProcessCompilationError.NodeIdValidationError nodeIdValidationError = (ProcessCompilationError.NodeIdValidationError)idError2;
            ProcessCompilationError.IdErrorType errorType = nodeIdValidationError.errorType();
            ProcessCompilationError.IdErrorType idErrorType = errorType;
            boolean bl = ProcessCompilationError.EmptyValue$.MODULE$.equals(idErrorType) ? true : idErrorType instanceof ProcessCompilationError.IllegalCharactersId;
            Enumeration.Value value2 = bl ? ValidationResults$NodeValidationErrorType$.MODULE$.RenderNotAllowed() : ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed();
            value = value2;
        } else {
            throw new MatchError((Object)idError2);
        }
        Enumeration.Value errorSeverity = value;
        ProcessCompilationError.IdError idError3 = error;
        if (idError3 instanceof ProcessCompilationError.ScenarioIdError) {
            string3 = CanonicalProcess$.MODULE$.IdFieldName();
        } else if (idError3 instanceof ProcessCompilationError.NodeIdValidationError) {
            string3 = node$.MODULE$.IdFieldName();
        } else {
            throw new MatchError((Object)idError3);
        }
        String fieldName = string3;
        ProcessCompilationError.IdErrorType idErrorType = error.errorType();
        if (ProcessCompilationError.EmptyValue$.MODULE$.equals(idErrorType)) {
            string2 = new StringBuilder(38).append(validatedObjectType).append(" name is mandatory and cannot be empty").toString();
        } else if (ProcessCompilationError.BlankId$.MODULE$.equals(idErrorType)) {
            string2 = new StringBuilder(21).append(validatedObjectType).append(" name cannot be blank").toString();
        } else if (ProcessCompilationError.LeadingSpacesId$.MODULE$.equals(idErrorType)) {
            string2 = new StringBuilder(32).append(validatedObjectType).append(" name cannot have leading spaces").toString();
        } else if (ProcessCompilationError.TrailingSpacesId$.MODULE$.equals(idErrorType)) {
            string2 = new StringBuilder(33).append(validatedObjectType).append(" name cannot have trailing spaces").toString();
        } else if (idErrorType instanceof ProcessCompilationError.IllegalCharactersId) {
            ProcessCompilationError.IllegalCharactersId illegalCharactersId = (ProcessCompilationError.IllegalCharactersId)idErrorType;
            String illegalCharactersHumanReadable = illegalCharactersId.illegalCharacterHumanReadable();
            string2 = new StringBuilder(51).append(validatedObjectType).append(" name contains invalid characters. ").append(illegalCharactersHumanReadable).append(" are not allowed").toString();
        } else {
            throw new MatchError((Object)idErrorType);
        }
        String message = string2;
        ProcessCompilationError.IdErrorType idErrorType2 = error.errorType();
        if (ProcessCompilationError.EmptyValue$.MODULE$.equals(idErrorType2)) {
            string = new StringBuilder(11).append("Empty ").append(validatedObjectType.toLowerCase()).append(" name").toString();
        } else if (ProcessCompilationError.BlankId$.MODULE$.equals(idErrorType2)) {
            string = new StringBuilder(11).append("Blank ").append(validatedObjectType.toLowerCase()).append(" name").toString();
        } else if (ProcessCompilationError.LeadingSpacesId$.MODULE$.equals(idErrorType2)) {
            string = new StringBuilder(23).append("Leading spaces in ").append(validatedObjectType.toLowerCase()).append(" name").toString();
        } else if (ProcessCompilationError.TrailingSpacesId$.MODULE$.equals(idErrorType2)) {
            string = new StringBuilder(24).append("Trailing spaces in ").append(validatedObjectType.toLowerCase()).append(" name").toString();
        } else if (idErrorType2 instanceof ProcessCompilationError.IllegalCharactersId) {
            string = new StringBuilder(27).append("Invalid characters in ").append(validatedObjectType.toLowerCase()).append(" name").toString();
        } else {
            throw new MatchError((Object)idErrorType2);
        }
        String description = string;
        return new ValidationResults.NodeValidationError(this.getErrorTypeName((ProcessCompilationError)error), message, description, (Option<String>)new Some((Object)fieldName), errorSeverity);
    }

    private static final ValidationResults.NodeValidationError node$1(String message, String description, Enumeration.Value errorType, Option fieldName, String typ$1) {
        return new ValidationResults.NodeValidationError(typ$1, message, description, (Option<String>)fieldName, errorType);
    }

    private static final Enumeration.Value node$default$3$1() {
        return ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed();
    }

    private static final Option node$default$4$1() {
        return None$.MODULE$;
    }

    private static final ValidationResults.NodeValidationError handleParameterValidationError$1(ParameterValidationError error, String typ$1) {
        String x$1 = error.message();
        String x$2 = error.description();
        Some x$3 = new Some((Object)error.paramName());
        Enumeration.Value x$4 = PrettyValidationErrors$.node$default$3$1();
        return PrettyValidationErrors$.node$1(x$1, x$2, x$4, (Option)x$3, typ$1);
    }

    private PrettyValidationErrors$() {
        MODULE$ = this;
    }
}

