/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.restmodel.validation;

import pl.touk.nussknacker.engine.api.context.ParameterValidationError;
import pl.touk.nussknacker.engine.api.context.ProcessCompilationError;
import pl.touk.nussknacker.engine.api.util.ReflectUtils$;
import pl.touk.nussknacker.engine.graph.EdgeType;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.restmodel.validation.ValidationResults$NodeValidationErrorType$;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;

public final class PrettyValidationErrors$ {
    public static PrettyValidationErrors$ MODULE$;

    static {
        new PrettyValidationErrors$();
    }

    public ValidationResults.NodeValidationError formatErrorMessage(ProcessCompilationError error) {
        ValidationResults.NodeValidationError nodeValidationError;
        String typ = ReflectUtils$.MODULE$.simpleNameWithoutSuffix(error.getClass());
        ProcessCompilationError processCompilationError = error;
        if (processCompilationError instanceof ProcessCompilationError.ExpressionParserCompilationError) {
            ProcessCompilationError.ExpressionParserCompilationError expressionParserCompilationError = (ProcessCompilationError.ExpressionParserCompilationError)processCompilationError;
            String message = expressionParserCompilationError.message();
            Option fieldName = expressionParserCompilationError.fieldName();
            String x$1 = new StringBuilder(28).append("Failed to parse expression: ").append(message).toString();
            String x$2 = new StringBuilder(68).append("There is problem with expression in field ").append(fieldName).append(" - it could not be parsed.").toString();
            Option x$3 = fieldName;
            Enumeration.Value x$4 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$1, x$2, x$4, x$3, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.SubprocessParamClassLoadError) {
            ProcessCompilationError.SubprocessParamClassLoadError subprocessParamClassLoadError = (ProcessCompilationError.SubprocessParamClassLoadError)processCompilationError;
            String fieldName = subprocessParamClassLoadError.fieldName();
            String refClazzName = subprocessParamClassLoadError.refClazzName();
            String x$5 = "Invalid parameter type.";
            String x$6 = new StringBuilder(15).append("Failed to load ").append(refClazzName).toString();
            Some x$7 = new Some((Object)fieldName);
            Enumeration.Value x$8 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$5, x$6, x$8, (Option)x$7, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.DuplicatedNodeIds) {
            ProcessCompilationError.DuplicatedNodeIds duplicatedNodeIds = (ProcessCompilationError.DuplicatedNodeIds)processCompilationError;
            Set ids = duplicatedNodeIds.nodeIds();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(20).append("Duplicate node ids: ").append(ids.mkString(", ")).toString(), "Two nodes cannot have same id", ValidationResults$NodeValidationErrorType$.MODULE$.RenderNotAllowed(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.ScenarioNameValidationError) {
            ProcessCompilationError.ScenarioNameValidationError scenarioNameValidationError = (ProcessCompilationError.ScenarioNameValidationError)processCompilationError;
            String message = scenarioNameValidationError.message();
            String description = scenarioNameValidationError.description();
            nodeValidationError = PrettyValidationErrors$.node$1(message, description, PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.SpecificDataValidationError) {
            String message;
            ProcessCompilationError.SpecificDataValidationError specificDataValidationError = (ProcessCompilationError.SpecificDataValidationError)processCompilationError;
            String field = specificDataValidationError.fieldName();
            String x$9 = message = specificDataValidationError.message();
            String x$10 = message;
            Some x$11 = new Some((Object)field);
            Enumeration.Value x$12 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$9, x$10, x$12, (Option)x$11, typ);
        } else if (ProcessCompilationError.EmptyProcess$.MODULE$.equals(processCompilationError)) {
            nodeValidationError = PrettyValidationErrors$.node$1("Empty scenario", "Scenario is empty, please add some nodes", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidRootNode) {
            nodeValidationError = PrettyValidationErrors$.node$1("Invalid root node", "Scenario can start only from source node", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidTailOfBranch) {
            nodeValidationError = PrettyValidationErrors$.node$1("Invalid end of scenario", "Scenario branch can only end with sink, processor or ending custom transformer", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingParameters) {
            ProcessCompilationError.MissingParameters missingParameters = (ProcessCompilationError.MissingParameters)processCompilationError;
            Set params = missingParameters.params();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(28).append("Node parameters not filled: ").append(params.mkString(", ")).toString(), new StringBuilder(39).append("Please fill missing node parameters: : ").append(params.mkString(", ")).toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ParameterValidationError) {
            ParameterValidationError parameterValidationError = (ParameterValidationError)processCompilationError;
            nodeValidationError = PrettyValidationErrors$.handleParameterValidationError$1(parameterValidationError, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingCustomNodeExecutor) {
            ProcessCompilationError.MissingCustomNodeExecutor missingCustomNodeExecutor = (ProcessCompilationError.MissingCustomNodeExecutor)processCompilationError;
            String id = missingCustomNodeExecutor.name();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(25).append("Missing custom executor: ").append(id).toString(), new StringBuilder(59).append("Please check the name of custom executor, ").append(id).append(" is not available").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingService) {
            ProcessCompilationError.MissingService missingService = (ProcessCompilationError.MissingService)processCompilationError;
            String id = missingService.serviceId();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(28).append("Missing processor/enricher: ").append(id).toString(), new StringBuilder(62).append("Please check the name of processor/enricher, ").append(id).append(" is not available").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingSinkFactory) {
            ProcessCompilationError.MissingSinkFactory missingSinkFactory = (ProcessCompilationError.MissingSinkFactory)processCompilationError;
            String id = missingSinkFactory.typ();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(14).append("Missing sink: ").append(id).toString(), new StringBuilder(48).append("Please check the name of sink, ").append(id).append(" is not available").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingSourceFactory) {
            ProcessCompilationError.MissingSourceFactory missingSourceFactory = (ProcessCompilationError.MissingSourceFactory)processCompilationError;
            String id = missingSourceFactory.typ();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(16).append("Missing source: ").append(id).toString(), new StringBuilder(50).append("Please check the name of source, ").append(id).append(" is not available").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.RedundantParameters) {
            ProcessCompilationError.RedundantParameters redundantParameters = (ProcessCompilationError.RedundantParameters)processCompilationError;
            Set params = redundantParameters.params();
            nodeValidationError = PrettyValidationErrors$.node$1("Redundant parameters", new StringBuilder(34).append("Please omit redundant parameters: ").append(params.mkString(", ")).toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.WrongParameters) {
            ProcessCompilationError.WrongParameters wrongParameters = (ProcessCompilationError.WrongParameters)processCompilationError;
            Set requiredParameters = wrongParameters.requiredParameters();
            Set passedParameters = wrongParameters.passedParameters();
            nodeValidationError = PrettyValidationErrors$.node$1("Wrong parameters", new StringBuilder(27).append("Please provide ").append(requiredParameters.mkString(", ")).append(" instead of ").append(passedParameters.mkString(", ")).toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.OverwrittenVariable) {
            ProcessCompilationError.OverwrittenVariable overwrittenVariable = (ProcessCompilationError.OverwrittenVariable)processCompilationError;
            String varName = overwrittenVariable.variableName();
            Option paramName = overwrittenVariable.paramName();
            String x$13 = new StringBuilder(43).append("Variable output name '").append(varName).append("' is already defined.").toString();
            String x$14 = "You cannot overwrite variables";
            Option x$15 = paramName;
            Enumeration.Value x$16 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$13, x$14, x$16, x$15, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidVariableOutputName) {
            ProcessCompilationError.InvalidVariableOutputName invalidVariableOutputName = (ProcessCompilationError.InvalidVariableOutputName)processCompilationError;
            String varName = invalidVariableOutputName.name();
            Option paramName = invalidVariableOutputName.paramName();
            String x$17 = new StringBuilder(97).append("Variable output name '").append(varName).append("' is not a valid identifier (only letters, numbers or '_', cannot be empty)").toString();
            String x$18 = "Please use only letters, numbers or '_', also identifier cannot be empty.";
            Option x$19 = paramName;
            Enumeration.Value x$20 = PrettyValidationErrors$.node$default$3$1();
            nodeValidationError = PrettyValidationErrors$.node$1(x$17, x$18, x$20, x$19, typ);
        } else if (processCompilationError instanceof ProcessCompilationError.NotSupportedExpressionLanguage) {
            ProcessCompilationError.NotSupportedExpressionLanguage notSupportedExpressionLanguage = (ProcessCompilationError.NotSupportedExpressionLanguage)processCompilationError;
            String languageId = notSupportedExpressionLanguage.languageId();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(26).append("Language ").append(languageId).append(" is not supported").toString(), "Currently only SPEL expressions are supported", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingPart) {
            ProcessCompilationError.MissingPart missingPart = (ProcessCompilationError.MissingPart)processCompilationError;
            String id = missingPart.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("MissingPart", new StringBuilder(22).append("Node ").append(id).append(" has missing part").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.UnsupportedPart) {
            ProcessCompilationError.UnsupportedPart unsupportedPart = (ProcessCompilationError.UnsupportedPart)processCompilationError;
            String id = unsupportedPart.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("UnsupportedPart", new StringBuilder(38).append("Type of node ").append(id).append(" is unsupported right now").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.UnknownSubprocess) {
            ProcessCompilationError.UnknownSubprocess unknownSubprocess = (ProcessCompilationError.UnknownSubprocess)processCompilationError;
            String id = unknownSubprocess.id();
            String nodeId = unknownSubprocess.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("Unknown fragment", new StringBuilder(37).append("Node ").append(nodeId).append(" uses fragment ").append(id).append(" which is missing").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidSubprocess) {
            ProcessCompilationError.InvalidSubprocess invalidSubprocess = (ProcessCompilationError.InvalidSubprocess)processCompilationError;
            String id = invalidSubprocess.id();
            String nodeId = invalidSubprocess.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("Invalid fragment", new StringBuilder(37).append("Node ").append(nodeId).append(" uses fragment ").append(id).append(" which is invalid").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.FatalUnknownError) {
            ProcessCompilationError.FatalUnknownError fatalUnknownError = (ProcessCompilationError.FatalUnknownError)processCompilationError;
            String message = fatalUnknownError.message();
            nodeValidationError = PrettyValidationErrors$.node$1("Unkown, fatal validation error", new StringBuilder(41).append("Fatal error: ").append(message).append(", please check configuration").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.CannotCreateObjectError) {
            ProcessCompilationError.CannotCreateObjectError cannotCreateObjectError = (ProcessCompilationError.CannotCreateObjectError)processCompilationError;
            String message = cannotCreateObjectError.message();
            String nodeId = cannotCreateObjectError.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(19).append("Could not create ").append(nodeId).append(": ").append(message).toString(), new StringBuilder(19).append("Could not create ").append(nodeId).append(": ").append(message).toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.UnresolvedSubprocess) {
            ProcessCompilationError.UnresolvedSubprocess unresolvedSubprocess = (ProcessCompilationError.UnresolvedSubprocess)processCompilationError;
            String id = unresolvedSubprocess.nodeId();
            nodeValidationError = PrettyValidationErrors$.node$1("Unresolved fragment", new StringBuilder(45).append("fragment ").append(id).append(" encountered, this should not happen").toString(), PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.FragmentOutputNotDefined) {
            ProcessCompilationError.FragmentOutputNotDefined fragmentOutputNotDefined = (ProcessCompilationError.FragmentOutputNotDefined)processCompilationError;
            String id = fragmentOutputNotDefined.id();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(19).append("Output ").append(id).append(" not defined").toString(), "Please check fragment definition", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.UnknownFragmentOutput) {
            ProcessCompilationError.UnknownFragmentOutput unknownFragmentOutput = (ProcessCompilationError.UnknownFragmentOutput)processCompilationError;
            String id = unknownFragmentOutput.id();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(24).append("Unknown fragment output ").append(id).toString(), "Please check fragment definition", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.DisablingManyOutputsSubprocess) {
            ProcessCompilationError.DisablingManyOutputsSubprocess disablingManyOutputsSubprocess = (ProcessCompilationError.DisablingManyOutputsSubprocess)processCompilationError;
            String id = disablingManyOutputsSubprocess.id();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(42).append("Cannot disable fragment ").append(id).append(". Has many outputs").toString(), "Please check fragment definition", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.DisablingNoOutputsSubprocess) {
            ProcessCompilationError.DisablingNoOutputsSubprocess disablingNoOutputsSubprocess = (ProcessCompilationError.DisablingNoOutputsSubprocess)processCompilationError;
            String id = disablingNoOutputsSubprocess.id();
            nodeValidationError = PrettyValidationErrors$.node$1(new StringBuilder(40).append("Cannot disable fragment ").append(id).append(". Hasn't outputs").toString(), "Please check fragment definition", PrettyValidationErrors$.node$default$3$1(), PrettyValidationErrors$.node$default$4$1(), typ);
        } else if (processCompilationError instanceof ProcessCompilationError.MissingRequiredProperty) {
            ProcessCompilationError.MissingRequiredProperty missingRequiredProperty = (ProcessCompilationError.MissingRequiredProperty)processCompilationError;
            String fieldName = missingRequiredProperty.paramName();
            Option label = missingRequiredProperty.label();
            nodeValidationError = this.missingRequiredProperty(typ, fieldName, (Option<String>)label);
        } else if (processCompilationError instanceof ProcessCompilationError.UnknownProperty) {
            ProcessCompilationError.UnknownProperty unknownProperty = (ProcessCompilationError.UnknownProperty)processCompilationError;
            String propertyName = unknownProperty.paramName();
            nodeValidationError = this.unknownProperty(typ, propertyName);
        } else if (processCompilationError instanceof ProcessCompilationError.InvalidPropertyFixedValue) {
            ProcessCompilationError.InvalidPropertyFixedValue invalidPropertyFixedValue = (ProcessCompilationError.InvalidPropertyFixedValue)processCompilationError;
            String fieldName = invalidPropertyFixedValue.paramName();
            Option label = invalidPropertyFixedValue.label();
            String value = invalidPropertyFixedValue.value();
            List values = invalidPropertyFixedValue.values();
            nodeValidationError = this.invalidPropertyFixedValue(typ, fieldName, (Option<String>)label, value, (List<String>)values);
        } else if (processCompilationError instanceof ProcessCompilationError.CustomNodeError) {
            ProcessCompilationError.CustomNodeError customNodeError = (ProcessCompilationError.CustomNodeError)processCompilationError;
            String message = customNodeError.message();
            Option paramName = customNodeError.paramName();
            nodeValidationError = new ValidationResults.NodeValidationError(typ, message, message, (Option<String>)paramName, ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed());
        } else {
            throw new MatchError((Object)processCompilationError);
        }
        return nodeValidationError;
    }

    public ValidationResults.NodeValidationError noValidatorKnown(String typ) {
        return new ValidationResults.NodeValidationError(typ, new StringBuilder(27).append("No validator available for ").append(typ).toString(), "No validator for scenario type - please check configuration", (Option<String>)None$.MODULE$, ValidationResults$NodeValidationErrorType$.MODULE$.RenderNotAllowed());
    }

    public ValidationResults.NodeValidationError invalidCharacters(String typ) {
        return new ValidationResults.NodeValidationError(typ, "Node id contains invalid characters", "\", . and ' are not allowed in node id", (Option<String>)None$.MODULE$, ValidationResults$NodeValidationErrorType$.MODULE$.RenderNotAllowed());
    }

    public ValidationResults.NodeValidationError duplicatedNodeIds(String typ, List<String> duplicates) {
        return new ValidationResults.NodeValidationError(typ, "Two nodes cannot have same id", new StringBuilder(20).append("Duplicate node ids: ").append(duplicates.mkString(", ")).toString(), (Option<String>)None$.MODULE$, ValidationResults$NodeValidationErrorType$.MODULE$.RenderNotAllowed());
    }

    public ValidationResults.NodeValidationError emptyNodeId(String typ) {
        return new ValidationResults.NodeValidationError(typ, "Nodes cannot have empty id", "Nodes cannot have empty id", (Option<String>)None$.MODULE$, ValidationResults$NodeValidationErrorType$.MODULE$.RenderNotAllowed());
    }

    public ValidationResults.NodeValidationError nonuniqeEdgeType(String typ, EdgeType etype) {
        return new ValidationResults.NodeValidationError(typ, "Edges are not unique", new StringBuilder(72).append("Node has duplicate outgoing edges of type: ").append(etype).append(", it cannot be saved properly").toString(), (Option<String>)None$.MODULE$, ValidationResults$NodeValidationErrorType$.MODULE$.SaveNotAllowed());
    }

    public ValidationResults.NodeValidationError nonuniqeEdge(String typ, String target) {
        return new ValidationResults.NodeValidationError(typ, "Edges are not unique", new StringBuilder(67).append("Node has duplicate outgoing edges to: ").append(target).append(", it cannot be saved properly").toString(), (Option<String>)None$.MODULE$, ValidationResults$NodeValidationErrorType$.MODULE$.SaveNotAllowed());
    }

    public ValidationResults.NodeValidationError looseNode(String typ) {
        return new ValidationResults.NodeValidationError(typ, "Loose node", "Node is not connected to source, it cannot be saved properly", (Option<String>)None$.MODULE$, ValidationResults$NodeValidationErrorType$.MODULE$.SaveNotAllowed());
    }

    public ValidationResults.NodeValidationError disabledNode(String typ) {
        return new ValidationResults.NodeValidationError(typ, "Node is disabled", "Deploying scenario with disabled node can have unexpected consequences", (Option<String>)None$.MODULE$, ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed());
    }

    public ValidationResults.NodeValidationError unknownProperty(String typ, String propertyName) {
        return new ValidationResults.NodeValidationError(typ, new StringBuilder(17).append("Unknown property ").append(propertyName).toString(), new StringBuilder(22).append("Property ").append(propertyName).append(" is not known").toString(), (Option<String>)new Some((Object)propertyName), ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed());
    }

    private ValidationResults.NodeValidationError missingRequiredProperty(String typ, String fieldName, Option<String> label) {
        String labelText = this.getLabel(label);
        return new ValidationResults.NodeValidationError(typ, new StringBuilder(31).append("Configured property ").append(fieldName).append(labelText).append(" is missing").toString(), new StringBuilder(29).append("Please fill missing property ").append(fieldName).append(labelText).toString(), (Option<String>)new Some((Object)fieldName), ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed());
    }

    private ValidationResults.NodeValidationError invalidPropertyFixedValue(String typ, String propertyName, Option<String> label, String value, List<String> values) {
        String labelText = this.getLabel(label);
        return new ValidationResults.NodeValidationError(typ, new StringBuilder(27).append("Property ").append(propertyName).append(labelText).append(" has invalid value").toString(), new StringBuilder(26).append("Expected one of ").append(values.mkString(", ")).append(", got: '").append(value).append("'.").toString(), (Option<String>)new Some((Object)propertyName), ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed());
    }

    private String getLabel(Option<String> label) {
        String string;
        Option<String> option = label;
        if (option instanceof Some) {
            Some some = (Some)option;
            String text = (String)some.value();
            string = new StringBuilder(3).append(" (").append(text).append(")").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private static final ValidationResults.NodeValidationError node$1(String message, String description, Enumeration.Value errorType, Option fieldName, String typ$1) {
        return new ValidationResults.NodeValidationError(typ$1, message, description, (Option<String>)fieldName, errorType);
    }

    private static final Enumeration.Value node$default$3$1() {
        return ValidationResults$NodeValidationErrorType$.MODULE$.SaveAllowed();
    }

    private static final Option node$default$4$1() {
        return None$.MODULE$;
    }

    private static final ValidationResults.NodeValidationError handleParameterValidationError$1(ParameterValidationError error, String typ$1) {
        String x$1 = error.message();
        String x$2 = error.description();
        Some x$3 = new Some((Object)error.paramName());
        Enumeration.Value x$4 = PrettyValidationErrors$.node$default$3$1();
        return PrettyValidationErrors$.node$1(x$1, x$2, x$4, (Option)x$3, typ$1);
    }

    private PrettyValidationErrors$() {
        MODULE$ = this;
    }
}

