/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Error;
import io.circe.KeyEncoder$;
import io.circe.syntax.package;
import pl.touk.nussknacker.engine.sttp.SttpJson$;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ClientApi$;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ErrorHandler;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Right;
import sttp.client.IsOption$;
import sttp.client.RequestT;
import sttp.client.Response;
import sttp.client.ResponseError;
import sttp.client.SttpBackend;
import sttp.client.circe.package$;
import sttp.model.MediaType;
import sttp.model.MediaType$;
import sttp.model.StatusCode$;
import sttp.model.Uri$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001=\u0011qbT!vi\"\u00144\t\\5f]R\f\u0005/\u001b\u0006\u0003\u0007\u0011\taa\\1vi\"\u0014$BA\u0003\u0007\u0003!\u0019XmY;sSRL(BA\u0004\t\u0003\t)\u0018N\u0003\u0002\n\u0015\u0005Ya.^:tW:\f7m[3s\u0015\tYA\"\u0001\u0003u_V\\'\"A\u0007\u0002\u0005Ad7\u0001A\u000b\u0004!M\u00025c\u0001\u0001\u0012/A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\u0004\"\u0001G\u0010\u000e\u0003eQ!AG\u000e\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005qi\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003y\t1aY8n\u0013\t\u0001\u0013DA\u0006MCjLHj\\4hS:<\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t!S%D\u0001\u0003\u0013\t1#AA\nP\u0003V$\bNM\"p]\u001aLw-\u001e:bi&|g\u000e\u0003\u0005)\u0001\t\r\t\u0015a\u0003*\u0003))g/\u001b3f]\u000e,G%\r\t\u0004U=\nT\"A\u0016\u000b\u00051j\u0013!B2je\u000e,'\"\u0001\u0018\u0002\u0005%|\u0017B\u0001\u0019,\u0005\u001d!UmY8eKJ\u0004\"AM\u001a\r\u0001\u0011)A\u0007\u0001b\u0001k\ty\u0001K]8gS2,'+Z:q_:\u001cX-\u0005\u00027sA\u0011!cN\u0005\u0003qM\u0011qAT8uQ&tw\r\u0005\u0002\u0013u%\u00111h\u0005\u0002\u0004\u0003:L\b\u0002C\u001f\u0001\u0005\u0007\u0005\u000b1\u0002 \u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002+_}\u0002\"A\r!\u0005\u000b\u0005\u0003!\u0019A\u001b\u0003'\u0005\u001b7-Z:t)>\\WM\u001c*fgB|gn]3\t\u0011\r\u0003!\u0011!Q\u0001\f\u0011\u000b!!Z2\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u001b\u0012AC2p]\u000e,(O]3oi&\u0011\u0011J\u0012\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRD\u0001b\u0013\u0001\u0003\u0002\u0003\u0006Y\u0001T\u0001\bE\u0006\u001c7.\u001a8e!\u0015i%\u000b\u0016\u001cX\u001b\u0005q%BA(Q\u0003\u0019\u0019G.[3oi*\t\u0011+\u0001\u0003tiR\u0004\u0018BA*O\u0005-\u0019F\u000f\u001e9CC\u000e\\WM\u001c3\u0011\u0005\u0015+\u0016B\u0001,G\u0005\u00191U\u000f^;sKB\u0011\u0001L\u0019\b\u00033\u0002t!AW0\u000f\u0005msV\"\u0001/\u000b\u0005us\u0011A\u0002\u001fs_>$h(C\u0001R\u0013\ty\u0005+\u0003\u0002b\u001d\u00069\u0001/Y2lC\u001e,\u0017BA2e\u0005!qu\u000e\u001e5j]\u001e$&BA1O\u0011\u00151\u0007\u0001\"\u0001h\u0003\u0019a\u0014N\\5u}Q\u0011\u0001N\u001c\u000b\u0006S*\\G.\u001c\t\u0005I\u0001\tt\bC\u0003)K\u0002\u000f\u0011\u0006C\u0003>K\u0002\u000fa\bC\u0003DK\u0002\u000fA\tC\u0003LK\u0002\u000fA\nC\u0003#K\u0002\u00071\u0005C\u0003q\u0001\u0011\u0005\u0011/\u0001\nbG\u000e,7o\u001d+pW\u0016t'+Z9vKN$HC\u0001:t!\r)Uk\u0010\u0005\u0006i>\u0004\r!^\u0001\u0012CV$\bn\u001c:ju\u0006$\u0018n\u001c8D_\u0012,\u0007C\u0001<z\u001d\t\u0011r/\u0003\u0002y'\u00051\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tA8\u0003C\u0003~\u0001\u0011\u0005a0\u0001\bqe>4\u0017\u000e\\3SKF,Xm\u001d;\u0015\u0007}\f\t\u0001E\u0002F+FBa!a\u0001}\u0001\u0004)\u0018aC1dG\u0016\u001c8\u000fV8lK:D\u0001\"a\u0002\u0001\t#!\u0011\u0011B\u0001\u0011Q\u0006tG\r\\5oOJ+7\u000f]8og\u0016,B!a\u0003\u00024Q1\u0011QBA\u001c\u0003w\u0001B!R+\u0002\u0010A)Q*!\u0005\u0002\u0016%\u0019\u00111\u0003(\u0003\u0011I+7\u000f]8og\u0016\u0004\u0002\"a\u0006\u0002 \u0005\u0015\u0012\u0011\u0007\b\u0005\u00033\tiBD\u0002\\\u00037I\u0011\u0001F\u0005\u0003CNIA!!\t\u0002$\t1Q)\u001b;iKJT!!Y\n\u0011\u000b5\u000b9#a\u000b\n\u0007\u0005%bJA\u0007SKN\u0004xN\\:f\u000bJ\u0014xN\u001d\t\u0004U\u00055\u0012bAA\u0018W\t)QI\u001d:peB\u0019!'a\r\u0005\u000f\u0005U\u0012Q\u0001b\u0001k\t\tA\u000b\u0003\u0005\u0002:\u0005\u0015\u0001\u0019AA\b\u0003!\u0011Xm\u001d9p]N,\u0007bBA\u001f\u0003\u000b\u0001\r!^\u0001\u0013G2LWM\u001c;FeJ|'/T3tg\u0006<WmB\u0004\u0002B\tA\t!a\u0011\u0002\u001f=\u000bU\u000f\u001e53\u00072LWM\u001c;Ba&\u00042\u0001JA#\r\u0019\t!\u0001#\u0001\u0002HM\u0019\u0011QI\t\t\u000f\u0019\f)\u0005\"\u0001\u0002LQ\u0011\u00111\t\u0005\t\u0003\u001f\n)\u0005\"\u0001\u0002R\u0005)\u0011\r\u001d9msV1\u00111KA.\u0003?\"B!!\u0016\u0002tQQ\u0011qKA1\u0003O\ni'a\u001c\u0011\r\u0011\u0002\u0011\u0011LA/!\r\u0011\u00141\f\u0003\u0007i\u00055#\u0019A\u001b\u0011\u0007I\ny\u0006\u0002\u0004B\u0003\u001b\u0012\r!\u000e\u0005\u000b\u0003G\ni%!AA\u0004\u0005\u0015\u0014AC3wS\u0012,gnY3%gA!!fLA-\u0011)\tI'!\u0014\u0002\u0002\u0003\u000f\u00111N\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004\u0003\u0002\u00160\u0003;BaaQA'\u0001\b!\u0005bBA9\u0003\u001b\u0002\u001d\u0001T\u0001\fgR$\bOQ1dW\u0016tG\r\u0003\u0004#\u0003\u001b\u0002\ra\t")
public class OAuth2ClientApi<ProfileResponse, AccessTokenResponse>
implements LazyLogging {
    private final OAuth2Configuration configuration;
    private final Decoder<ProfileResponse> evidence$1;
    private final Decoder<AccessTokenResponse> evidence$2;
    private final ExecutionContext ec;
    private final SttpBackend<Future, Nothing$, Nothing$> backend;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <ProfileResponse, AccessTokenResponse> OAuth2ClientApi<ProfileResponse, AccessTokenResponse> apply(OAuth2Configuration oAuth2Configuration, Decoder<ProfileResponse> decoder, Decoder<AccessTokenResponse> decoder2, ExecutionContext executionContext, SttpBackend<Future, Nothing$, ?> sttpBackend) {
        return OAuth2ClientApi$.MODULE$.apply(oAuth2Configuration, decoder, decoder2, executionContext, sttpBackend);
    }

    private Logger logger$lzycompute() {
        OAuth2ClientApi oAuth2ClientApi = this;
        synchronized (oAuth2ClientApi) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public Future<AccessTokenResponse> accessTokenRequest(String authorizationCode) {
        block4: {
            RequestT requestT;
            RequestT request;
            Map payload;
            block3: {
                Right right;
                boolean bl;
                block2: {
                    payload = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), (Object)this.configuration.clientId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret"), (Object)this.configuration.clientSecret()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"code"), (Object)authorizationCode), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"redirect_uri"), (Object)this.configuration.redirectUrl())}))).$plus$plus(this.configuration.accessTokenParams());
                    request = sttp.client.package$.MODULE$.basicRequest().contentType(this.configuration.accessTokenRequestContentType()).response(package$.MODULE$.asJson(this.evidence$2, IsOption$.MODULE$.otherIsNotOption())).post(Uri$.MODULE$.apply(this.configuration.accessTokenUri())).headers(this.configuration.headers());
                    Either contentType = MediaType$.MODULE$.parse(this.configuration.accessTokenRequestContentType());
                    bl = false;
                    right = null;
                    Either either = contentType;
                    if (!(either instanceof Right)) break block2;
                    bl = true;
                    right = (Right)either;
                    MediaType mediaType = (MediaType)right.b();
                    MediaType mediaType2 = MediaType$.MODULE$.ApplicationJson();
                    MediaType mediaType3 = mediaType;
                    if (mediaType2 != null ? !mediaType2.equals(mediaType3) : mediaType3 != null) break block2;
                    requestT = request.body((Object)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)payload), (Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString())), package$.MODULE$.circeBodySerializer(Encoder$.MODULE$.encodeJson(), package$.MODULE$.circeBodySerializer$default$2()));
                    break block3;
                }
                if (!bl) break block4;
                MediaType mediaType = (MediaType)right.b();
                MediaType mediaType4 = MediaType$.MODULE$.ApplicationXWwwFormUrlencoded();
                MediaType mediaType5 = mediaType;
                if (mediaType4 != null ? !mediaType4.equals(mediaType5) : mediaType5 != null) break block4;
                requestT = request.body(payload);
            }
            request = requestT;
            return ((Future)request.send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1)new Serializable(this, payload){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ OAuth2ClientApi $outer;
                private final Map payload$1;

                public final Future<Response<Either<ResponseError<Error>, AccessTokenResponse>>> apply(Response<Either<ResponseError<Error>, AccessTokenResponse>> x$1) {
                    return this.$outer.handlingResponse(x$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot authorize user by data: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.payload$1})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.payload$1 = payload$1;
                }
            }, this.ec).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Future<AccessTokenResponse> apply(Response<Either<ResponseError<Error>, AccessTokenResponse>> response) {
                    return SttpJson$.MODULE$.failureToFuture(response);
                }
            }, this.ec);
        }
        throw new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.of((Object)new OAuth2ErrorHandler.OAuth2ServerError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported content-type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.configuration.accessTokenRequestContentType()}))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OAuth2ErrorHandler.OAuth2ServerError[0])));
    }

    public Future<ProfileResponse> profileRequest(String accessToken) {
        Map headers = this.configuration.headers().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.configuration.authorizationHeader()), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bearer ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{accessToken})))})));
        return ((Future)sttp.client.package$.MODULE$.basicRequest().response(package$.MODULE$.asJson(this.evidence$1, IsOption$.MODULE$.otherIsNotOption())).get(Uri$.MODULE$.apply(this.configuration.profileUri())).headers(headers).send(this.backend, Predef.$eq$colon$eq$.MODULE$.tpEquals())).flatMap((Function1)new Serializable(this, accessToken){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OAuth2ClientApi $outer;
            private final String accessToken$1;

            public final Future<Response<Either<ResponseError<Error>, ProfileResponse>>> apply(Response<Either<ResponseError<Error>, ProfileResponse>> x$2) {
                return this.$outer.handlingResponse(x$2, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot authenticate user by token: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.accessToken$1})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.accessToken$1 = accessToken$1;
            }
        }, this.ec).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Future<ProfileResponse> apply(Response<Either<ResponseError<Error>, ProfileResponse>> response) {
                return SttpJson$.MODULE$.failureToFuture(response);
            }
        }, this.ec);
    }

    public <T> Future<Response<Either<ResponseError<Error>, T>>> handlingResponse(Response<Either<ResponseError<Error>, T>> response, String clientErrorMessage) {
        BoxedUnit boxedUnit;
        if (StatusCode$.MODULE$.isClientError$extension(response.code())) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Handling ClientError response: {}, error: {}", new Object[]{response, clientErrorMessage});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            Future$ future$ = Future$.MODULE$;
            throw new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.of((Object)new OAuth2ErrorHandler.OAuth2AccessTokenRejection(clientErrorMessage), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OAuth2ErrorHandler.OAuth2AccessTokenRejection[0])));
        }
        if (response.isSuccess()) {
            return Future$.MODULE$.successful(response);
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Handling ServerError response: {}", new Object[]{response});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Future$ future$ = Future$.MODULE$;
        throw new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.of((Object)new OAuth2ErrorHandler.OAuth2ServerError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OAuth2 Server error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response}))), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OAuth2ErrorHandler.OAuth2ServerError[0])));
    }

    public OAuth2ClientApi(OAuth2Configuration configuration, Decoder<ProfileResponse> evidence$1, Decoder<AccessTokenResponse> evidence$2, ExecutionContext ec, SttpBackend<Future, Nothing$, ?> backend) {
        this.configuration = configuration;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.ec = ec;
        this.backend = backend;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

