/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import cats.data.NonEmptyList;
import cats.data.Validated;
import io.circe.Decoder;
import java.io.Serializable;
import java.security.PublicKey;
import pl.touk.nussknacker.ui.security.oauth2.BaseOAuth2Service;
import pl.touk.nussknacker.ui.security.oauth2.JwtConfiguration;
import pl.touk.nussknacker.ui.security.oauth2.JwtStandardClaims;
import pl.touk.nussknacker.ui.security.oauth2.JwtValidator;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ClientApi;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ErrorHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Deadline;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0007\u000f\u0001mA\u0011\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011#\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019C\u0001\"\u0013\u0001\u0003\u0004\u0003\u0006YA\u0013\u0005\t%\u0002\u0011\u0019\u0011)A\u0006'\"AA\u000b\u0001B\u0002B\u0003-Q\u000b\u0003\u0005^\u0001\t\u0005\t\u0015a\u0003_\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u001dq\u0007A1A\u0005\u0012=Daa\u001d\u0001!\u0002\u0013\u0001\b\u0002\u0003;\u0001\u0011\u000b\u0007I\u0011C;\t\u000bq\u0004A\u0011C?\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,\t\u0001\"j\u001e;P\u0003V$\bNM*feZL7-\u001a\u0006\u0003\u001fA\taa\\1vi\"\u0014$BA\t\u0013\u0003!\u0019XmY;sSRL(BA\n\u0015\u0003\t)\u0018N\u0003\u0002\u0016-\u0005Ya.^:tW:\f7m[3s\u0015\t9\u0002$\u0001\u0003u_V\\'\"A\r\u0002\u0005Ad7\u0001A\u000b\u00059\r\u0002tkE\u0002\u0001;Y\u0002BAH\u0010\"_5\ta\"\u0003\u0002!\u001d\t\t\")Y:f\u001f\u0006+H\u000f\u001b\u001aTKJ4\u0018nY3\u0011\u0005\t\u001aC\u0002\u0001\u0003\u0006I\u0001\u0011\r!\n\u0002\r+N,'/\u00138g_\u0012\u000bG/Y\t\u0003M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012qAT8uQ&tw\r\u0005\u0002([%\u0011a\u0006\u000b\u0002\u0004\u0003:L\bC\u0001\u00121\t\u0015\t\u0004A1\u00013\u0005E\tU\u000f\u001e5pe&T\u0018\r^5p]\u0012\u000bG/Y\t\u0003MM\u0002\"A\b\u001b\n\u0005Ur!aF(BkRD''Q;uQ>\u0014\u0018N_1uS>tG)\u0019;b!\t9d(D\u00019\u0015\tI$(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002<y\u0005AA/\u001f9fg\u00064WMC\u0001>\u0003\r\u0019w.\\\u0005\u0003\u007fa\u00121\u0002T1{s2{wmZ5oO\u0006I1\r\\5f]R\f\u0005/\u001b\t\u0005=\t\u000bs&\u0003\u0002D\u001d\tyq*Q;uQJ\u001aE.[3oi\u0006\u0003\u0018.\u0003\u0002A?\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"AH$\n\u0005!s!aE(BkRD'gQ8oM&<WO]1uS>t\u0017AC3wS\u0012,gnY3%cA\u00191\nU\u0011\u000e\u00031S!!\u0014(\u0002\u000b\rL'oY3\u000b\u0003=\u000b!![8\n\u0005Ec%a\u0002#fG>$WM]\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA&Q_\u0005QQM^5eK:\u001cW\rJ\u001a\u0011\u0007-\u0003f\u000b\u0005\u0002#/\u0012)\u0001\f\u0001b\u00013\nI!j\u001e;DY\u0006LWn]\t\u0003Mi\u0003\"AH.\n\u0005qs!!\u0005&xiN#\u0018M\u001c3be\u0012\u001cE.Y5ng\u0006\u0011Qm\u0019\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\"\n!bY8oGV\u0014(/\u001a8u\u0013\t\u0019\u0007M\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2A\u001a7n)\u00159\u0007.\u001b6l!\u0015q\u0002!I\u0018W\u0011\u0015Iu\u0001q\u0001K\u0011\u0015\u0011v\u0001q\u0001T\u0011\u0015!v\u0001q\u0001V\u0011\u0015iv\u0001q\u0001_\u0011\u0015\u0001u\u00011\u0001B\u0011\u0015)u\u00011\u0001G\u0003UIg\u000e\u001e:pgB,7\r^!dG\u0016\u001c8\u000fV8lK:,\u0012\u0001\u001d\t\u0003OEL!A\u001d\u0015\u0003\u000f\t{w\u000e\\3b]\u00061\u0012N\u001c;s_N\u0004Xm\u0019;BG\u000e,7o\u001d+pW\u0016t\u0007%\u0001\u0007koR4\u0016\r\\5eCR|'/F\u0001w!\r9s/_\u0005\u0003q\"\u0012aa\u00149uS>t\u0007C\u0001\u0010{\u0013\tYhB\u0001\u0007KoR4\u0016\r\\5eCR|'/A\bj]R\u0014xn\u001d9fGR$vn[3o+\rq\u0018Q\u0001\u000b\u0004\u007f\u0006=A\u0003BA\u0001\u0003\u0013\u0001BaJ<\u0002\u0004A\u0019!%!\u0002\u0005\r\u0005\u001d1B1\u0001&\u0005\u0019\u0019E.Y5ng\"I\u00111B\u0006\u0002\u0002\u0003\u000f\u0011QB\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004\u0003B&Q\u0003\u0007Aq!!\u0005\f\u0001\u0004\t\u0019\"A\u0003u_.,g\u000e\u0005\u0003\u0002\u0016\u0005\rb\u0002BA\f\u0003?\u00012!!\u0007)\u001b\t\tYBC\u0002\u0002\u001ei\ta\u0001\u0010:p_Rt\u0014bAA\u0011Q\u00051\u0001K]3eK\u001aLA!!\n\u0002(\t11\u000b\u001e:j]\u001eT1!!\t)\u0003\r\u001a\u0007.Z2l\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8B]\u0012|%\r^1j]V\u001bXM]5oM>$B!!\f\u0002HA)q,a\f\u00024%\u0019\u0011\u0011\u00071\u0003\r\u0019+H/\u001e:f!\u00199\u0013QG\u0011\u0002:%\u0019\u0011q\u0007\u0015\u0003\rQ+\b\u000f\\33!\u00119s/a\u000f\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011a\u0003!!WO]1uS>t\u0017\u0002BA#\u0003\u007f\u0011\u0001\u0002R3bI2Lg.\u001a\u0005\b\u0003\u0013b\u0001\u0019AA\n\u0003-\t7mY3tgR{7.\u001a8")
public class JwtOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData, JwtClaims extends JwtStandardClaims>
extends BaseOAuth2Service<UserInfoData, AuthorizationData> {
    private Option<JwtValidator> jwtValidator;
    private final OAuth2Configuration configuration;
    private final Decoder<JwtClaims> evidence$3;
    private final ExecutionContext ec;
    private final boolean introspectAccessToken;
    private volatile boolean bitmap$0;

    public boolean introspectAccessToken() {
        return this.introspectAccessToken;
    }

    private Option<JwtValidator> jwtValidator$lzycompute() {
        JwtOAuth2Service jwtOAuth2Service = this;
        synchronized (jwtOAuth2Service) {
            if (!this.bitmap$0) {
                this.jwtValidator = this.configuration.jwt().filter((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)JwtOAuth2Service.$anonfun$jwtValidator$1(config))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.authServerPublicKey()).map((Function1 & Serializable & scala.Serializable)x$3 -> new JwtValidator((PublicKey)x$3));
                this.bitmap$0 = true;
            }
        }
        this.configuration = null;
        return this.jwtValidator;
    }

    public Option<JwtValidator> jwtValidator() {
        return !this.bitmap$0 ? this.jwtValidator$lzycompute() : this.jwtValidator;
    }

    public <Claims> Option<Claims> introspectToken(String token, Decoder<Claims> evidence$4) {
        return this.jwtValidator().map((Function1 & Serializable & scala.Serializable)x$4 -> {
            Object claims;
            Validated validated = x$4.introspect(token, evidence$4);
            if (!(validated instanceof Validated.Valid)) {
                if (validated instanceof Validated.Invalid) {
                    Validated.Invalid invalid = (Validated.Invalid)validated;
                    NonEmptyList jwtErrors = (NonEmptyList)invalid.e();
                    throw new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)jwtErrors);
                }
                throw new MatchError(validated);
            }
            Validated.Valid valid = (Validated.Valid)validated;
            Object object = claims = valid.a();
            return object;
        });
    }

    @Override
    public Future<Tuple2<UserInfoData, Option<Deadline>>> checkAuthorizationAndObtainUserinfo(String accessToken) {
        Option expirationFromToken = new Some((Object)accessToken).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)this.introspectAccessToken())).flatMap((Function1 & Serializable & scala.Serializable)token -> this.introspectToken((String)token, (Decoder)$this.evidence$3)).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.expirationTime());
        return super.checkAuthorizationAndObtainUserinfo(accessToken).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object userInfo = tuple2._1();
            Option expiration = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2(userInfo, (Object)expirationFromToken.orElse((Function0 & Serializable & scala.Serializable)() -> expiration));
            return tuple22;
        }, this.ec);
    }

    public static final /* synthetic */ boolean $anonfun$jwtValidator$1(JwtConfiguration config) {
        return config.userinfoFromIdToken() || config.accessTokenIsJwt();
    }

    public JwtOAuth2Service(OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi, OAuth2Configuration configuration, Decoder<UserInfoData> evidence$1, Decoder<AuthorizationData> evidence$2, Decoder<JwtClaims> evidence$3, ExecutionContext ec) {
        this.configuration = configuration;
        this.evidence$3 = evidence$3;
        this.ec = ec;
        super(clientApi, evidence$1, evidence$2, ec);
        this.introspectAccessToken = configuration.jwt().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.accessTokenIsJwt()));
    }
}

