/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.util.cache.CacheConfig$;
import pl.touk.nussknacker.engine.util.cache.DefaultAsyncCache;
import pl.touk.nussknacker.engine.util.cache.DefaultAsyncCache$;
import pl.touk.nussknacker.engine.util.cache.ExpiryConfig;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\u0006\f\u0001aA\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0001B\u0001B\u0003-a\tC\u0003M\u0001\u0011\u0005Q\nC\u0004T\u0001\t\u0007I\u0011\u0003+\t\rM\u0004\u0001\u0015!\u0003V\u0011\u0015!\b\u0001\"\u0001v\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!Q\u0011Q\u0002\u0001\t\u0006\u0004%I!a\u0004\u0003)\r\u000b7\r[5oO>\u000bU\u000f\u001e53'\u0016\u0014h/[2f\u0015\taQ\"\u0001\u0004pCV$\bN\r\u0006\u0003\u001d=\t\u0001b]3dkJLG/\u001f\u0006\u0003!E\t!!^5\u000b\u0005I\u0019\u0012a\u00038vgN\\g.Y2lKJT!\u0001F\u000b\u0002\tQ|Wo\u001b\u0006\u0002-\u0005\u0011\u0001\u000f\\\u0002\u0001+\rIb\u0005M\n\u0005\u0001i\u0001c\u0007\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0005C\t\"s&D\u0001\f\u0013\t\u00193BA\u0007P\u0003V$\bNM*feZL7-\u001a\t\u0003K\u0019b\u0001\u0001B\u0003(\u0001\t\u0007\u0001F\u0001\u0007Vg\u0016\u0014\u0018J\u001c4p\t\u0006$\u0018-\u0005\u0002*YA\u00111DK\u0005\u0003Wq\u0011qAT8uQ&tw\r\u0005\u0002\u001c[%\u0011a\u0006\b\u0002\u0004\u0003:L\bCA\u00131\t\u0015\t\u0004A1\u00013\u0005E\tU\u000f\u001e5pe&T\u0018\r^5p]\u0012\u000bG/Y\t\u0003SM\u0002\"!\t\u001b\n\u0005UZ!aF(BkRD''Q;uQ>\u0014\u0018N_1uS>tG)\u0019;b!\t9d(D\u00019\u0015\tI$(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002<y\u0005AA/\u001f9fg\u00064WMC\u0001>\u0003\r\u0019w.\\\u0005\u0003\u007fa\u00121\u0002T1{s2{wmZ5oO\u0006AA-\u001a7fO\u0006$X-A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003C\rK!\u0001R\u0006\u0003'=\u000bU\u000f\u001e53\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0005\u0015\u001c\u0007CA$K\u001b\u0005A%BA%\u001d\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0017\"\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\rq\u0015K\u0015\u000b\u0003\u001fB\u0003B!\t\u0001%_!)Q\t\u0002a\u0002\r\")\u0001\t\u0002a\u0001A!)\u0011\t\u0002a\u0001\u0005\u0006\u0019\u0012-\u001e;i_JL'0\u0019;j_:\u001c8)Y2iKV\tQ\u000b\u0005\u0003W;~SW\"A,\u000b\u0005aK\u0016!B2bG\",'B\u0001.\\\u0003\u0011)H/\u001b7\u000b\u0005q\u000b\u0012AB3oO&tW-\u0003\u0002_/\n\tB)\u001a4bk2$\u0018i]=oG\u000e\u000b7\r[3\u0011\u0005\u0001<gBA1f!\t\u0011G$D\u0001d\u0015\t!w#\u0001\u0004=e>|GOP\u0005\u0003Mr\ta\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011a\r\b\t\u00057-$S.\u0003\u0002m9\t1A+\u001e9mKJ\u0002\"A\\9\u000e\u0003=T!\u0001\u001d%\u0002\u0011\u0011,(/\u0019;j_:L!A]8\u0003\u0011\u0011+\u0017\r\u001a7j]\u0016\fA#Y;uQ>\u0014\u0018N_1uS>t7oQ1dQ\u0016\u0004\u0013AH8ci\u0006Lg.Q;uQ>\u0014\u0018N_1uS>t\u0017I\u001c3Vg\u0016\u0014\u0018J\u001c4p)\t1X\u0010E\u0002HofL!\u0001\u001f%\u0003\r\u0019+H/\u001e:f!\u0011Y2n\f>\u0011\u0007mYH%\u0003\u0002}9\t1q\n\u001d;j_:DQA`\u0004A\u0002}\u000b\u0011#Y;uQ>\u0014\u0018N_1uS>t7i\u001c3f\u0003\r\u001a\u0007.Z2l\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8B]\u0012|%\r^1j]V\u001bXM]5oM>$B!a\u0001\u0002\nA!qi^A\u0003!\u0015Y2\u000eJA\u0004!\rY20\u001c\u0005\u0007\u0003\u0017A\u0001\u0019A0\u0002\u0017\u0005\u001c7-Z:t)>\\WM\\\u0001\u0012I\u00164\u0017-\u001e7u\u000bb\u0004\u0018N]1uS>tWCAA\t!\rq\u00171C\u0005\u0004\u0003+y'A\u0004$j]&$X\rR;sCRLwN\u001c")
public class CachingOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData>
implements OAuth2Service<UserInfoData, AuthorizationData>,
LazyLogging {
    private FiniteDuration defaultExpiration;
    private final OAuth2Service<UserInfoData, AuthorizationData> delegate;
    private final OAuth2Configuration configuration;
    private final ExecutionContext ec;
    private final DefaultAsyncCache<String, Tuple2<UserInfoData, Deadline>> authorizationsCache;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        CachingOAuth2Service cachingOAuth2Service = this;
        synchronized (cachingOAuth2Service) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public DefaultAsyncCache<String, Tuple2<UserInfoData, Deadline>> authorizationsCache() {
        return this.authorizationsCache;
    }

    @Override
    public Future<Tuple2<AuthorizationData, Option<UserInfoData>>> obtainAuthorizationAndUserInfo(String authorizationCode) {
        return this.delegate.obtainAuthorizationAndUserInfo(authorizationCode).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OAuth2AuthorizationData authorization = (OAuth2AuthorizationData)tuple2._1();
            Option userInfo2 = (Option)tuple2._2();
            userInfo2.foreach((Function1 & Serializable & scala.Serializable)userInfo -> {
                CachingOAuth2Service.$anonfun$obtainAuthorizationAndUserInfo$2(this, authorization, userInfo);
                return BoxedUnit.UNIT;
            });
            Tuple2 tuple22 = new Tuple2((Object)authorization, (Object)userInfo2);
            return tuple22;
        }, this.ec);
    }

    @Override
    public Future<Tuple2<UserInfoData, Option<Deadline>>> checkAuthorizationAndObtainUserinfo(String accessToken) {
        return this.authorizationsCache().getOrCreate((Object)accessToken, (Function0 & Serializable & scala.Serializable)() -> $this.delegate.checkAuthorizationAndObtainUserinfo(accessToken).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object userInfo = tuple2._1();
            Option expiration = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2(userInfo, expiration.getOrElse((Function0 & Serializable & scala.Serializable)() -> Deadline$.MODULE$.now().$plus(this.defaultExpiration())));
            return tuple22;
        }, $this.ec)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object userInfo = tuple2._1();
            Deadline expiration = (Deadline)tuple2._2();
            Tuple2 tuple22 = new Tuple2(userInfo, (Object)new Some((Object)expiration));
            return tuple22;
        }, this.ec);
    }

    private FiniteDuration defaultExpiration$lzycompute() {
        CachingOAuth2Service cachingOAuth2Service = this;
        synchronized (cachingOAuth2Service) {
            if (!this.bitmap$0) {
                this.defaultExpiration = this.configuration.defaultTokenExpirationTime();
                this.bitmap$0 = true;
            }
        }
        this.configuration = null;
        return this.defaultExpiration;
    }

    private FiniteDuration defaultExpiration() {
        return !this.bitmap$0 ? this.defaultExpiration$lzycompute() : this.defaultExpiration;
    }

    public static final /* synthetic */ void $anonfun$obtainAuthorizationAndUserInfo$2(CachingOAuth2Service $this, OAuth2AuthorizationData authorization$1, Object userInfo) {
        $this.authorizationsCache().put((Object)authorization$1.accessToken(), Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Tuple2(userInfo, (Object)Deadline$.MODULE$.now().$plus((FiniteDuration)authorization$1.expirationPeriod().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultExpiration()))), $this.ec));
    }

    public CachingOAuth2Service(OAuth2Service<UserInfoData, AuthorizationData> delegate, OAuth2Configuration configuration, ExecutionContext ec) {
        this.delegate = delegate;
        this.configuration = configuration;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.authorizationsCache = new DefaultAsyncCache(CacheConfig$.MODULE$.apply(new ExpiryConfig<String, Tuple2<UserInfoData, Deadline>>(null){

            public Option expireAfterAccessFn(Object k, Object v, Deadline now) {
                return ExpiryConfig.expireAfterAccessFn$((ExpiryConfig)this, (Object)k, (Object)v, (Deadline)now);
            }

            public Option<Deadline> expireAfterWriteFn(String key, Tuple2<UserInfoData, Deadline> value, Deadline now) {
                return new Some(value._2());
            }
            {
                ExpiryConfig.$init$((ExpiryConfig)this);
            }
        }), DefaultAsyncCache$.MODULE$.$lessinit$greater$default$2(), ec);
    }
}

