/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.util.cache.CacheConfig$;
import pl.touk.nussknacker.engine.util.cache.DefaultAsyncCache;
import pl.touk.nussknacker.engine.util.cache.DefaultAsyncCache$;
import pl.touk.nussknacker.engine.util.cache.ExpiryConfig;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\u0006\f\u0001aA\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0001B\u0001B\u0003-a\tC\u0003M\u0001\u0011\u0005Q\nC\u0004T\u0001\t\u0007I\u0011\u0003+\t\rM\u0004\u0001\u0015!\u0003V\u0011\u0015!\b\u0001\"\u0001v\u0011\u0015q\b\u0001\"\u0001\u0000\u0011)\ty\u0001\u0001EC\u0002\u0013%\u0011\u0011\u0003\u0002\u0015\u0007\u0006\u001c\u0007.\u001b8h\u001f\u0006+H\u000f\u001b\u001aTKJ4\u0018nY3\u000b\u00051i\u0011AB8bkRD'G\u0003\u0002\u000f\u001f\u0005A1/Z2ve&$\u0018P\u0003\u0002\u0011#\u0005\u0011Q/\u001b\u0006\u0003%M\t1B\\;tg.t\u0017mY6fe*\u0011A#F\u0001\u0005i>,8NC\u0001\u0017\u0003\t\u0001Hn\u0001\u0001\u0016\u0007e1\u0003g\u0005\u0003\u00015\u00012\u0004CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0003\"E\u0011zS\"A\u0006\n\u0005\rZ!!D(BkRD'gU3sm&\u001cW\r\u0005\u0002&M1\u0001A!B\u0014\u0001\u0005\u0004A#\u0001D+tKJLeNZ8ECR\f\u0017CA\u0015-!\tY\"&\u0003\u0002,9\t9aj\u001c;iS:<\u0007CA\u000e.\u0013\tqCDA\u0002B]f\u0004\"!\n\u0019\u0005\u000bE\u0002!\u0019\u0001\u001a\u0003#\u0005+H\u000f[8sSj\fG/[8o\t\u0006$\u0018-\u0005\u0002*gA\u0011\u0011\u0005N\u0005\u0003k-\u0011qcT!vi\"\u0014\u0014)\u001e;i_JL'0\u0019;j_:$\u0015\r^1\u0011\u0005]rT\"\u0001\u001d\u000b\u0005eR\u0014\u0001D:dC2\fGn\\4hS:<'BA\u001e=\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001f\u0002\u0007\r|W.\u0003\u0002@q\tYA*\u0019>z\u0019><w-\u001b8h\u0003!!W\r\\3hCR,\u0017!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\"\u0007&\u0011Ai\u0003\u0002\u0014\u001f\u0006+H\u000f\u001b\u001aD_:4\u0017nZ;sCRLwN\\\u0001\u0003K\u000e\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u000f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002L\u0011\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079\u000b&\u000b\u0006\u0002P!B!\u0011\u0005\u0001\u00130\u0011\u0015)E\u0001q\u0001G\u0011\u0015\u0001E\u00011\u0001!\u0011\u0015\tE\u00011\u0001C\u0003M\tW\u000f\u001e5pe&T\u0018\r^5p]N\u001c\u0015m\u00195f+\u0005)\u0006\u0003\u0002,^?*l\u0011a\u0016\u0006\u00031f\u000bQaY1dQ\u0016T!AW.\u0002\tU$\u0018\u000e\u001c\u0006\u00039F\ta!\u001a8hS:,\u0017B\u00010X\u0005E!UMZ1vYR\f5/\u001f8d\u0007\u0006\u001c\u0007.\u001a\t\u0003A\u001et!!Y3\u0011\u0005\tdR\"A2\u000b\u0005\u0011<\u0012A\u0002\u001fs_>$h(\u0003\u0002g9\u00051\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t1G\u0004\u0005\u0003\u001cW\u0012j\u0017B\u00017\u001d\u0005\u0019!V\u000f\u001d7feA\u0011a.]\u0007\u0002_*\u0011\u0001\u000fS\u0001\tIV\u0014\u0018\r^5p]&\u0011!o\u001c\u0002\t\t\u0016\fG\r\\5oK\u0006!\u0012-\u001e;i_JL'0\u0019;j_:\u001c8)Y2iK\u0002\nad\u001c2uC&t\u0017)\u001e;i_JL'0\u0019;j_:\fe\u000eZ+tKJLeNZ8\u0015\u0007YTH\u0010E\u0002HofL!\u0001\u001f%\u0003\r\u0019+H/\u001e:f!\u0011Y2n\f\u0013\t\u000bm<\u0001\u0019A0\u0002#\u0005,H\u000f[8sSj\fG/[8o\u0007>$W\rC\u0003~\u000f\u0001\u0007q,A\u0006sK\u0012L'/Z2u+JL\u0017aI2iK\u000e\\\u0017)\u001e;i_JL'0\u0019;j_:\fe\u000eZ(ci\u0006Lg.V:fe&tgm\u001c\u000b\u0005\u0003\u0003\tY\u0001\u0005\u0003Ho\u0006\r\u0001#B\u000elI\u0005\u0015\u0001\u0003B\u000e\u0002\b5L1!!\u0003\u001d\u0005\u0019y\u0005\u000f^5p]\"1\u0011Q\u0002\u0005A\u0002}\u000b1\"Y2dKN\u001cHk\\6f]\u0006\tB-\u001a4bk2$X\t\u001f9je\u0006$\u0018n\u001c8\u0016\u0005\u0005M\u0001c\u00018\u0002\u0016%\u0019\u0011qC8\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0002")
public class CachingOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData>
implements OAuth2Service<UserInfoData, AuthorizationData>,
LazyLogging {
    private FiniteDuration defaultExpiration;
    private final OAuth2Service<UserInfoData, AuthorizationData> delegate;
    private final OAuth2Configuration configuration;
    private final ExecutionContext ec;
    private final DefaultAsyncCache<String, Tuple2<UserInfoData, Deadline>> authorizationsCache;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        CachingOAuth2Service cachingOAuth2Service = this;
        synchronized (cachingOAuth2Service) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public DefaultAsyncCache<String, Tuple2<UserInfoData, Deadline>> authorizationsCache() {
        return this.authorizationsCache;
    }

    @Override
    public Future<Tuple2<AuthorizationData, UserInfoData>> obtainAuthorizationAndUserInfo(String authorizationCode, String redirectUri) {
        return this.delegate.obtainAuthorizationAndUserInfo(authorizationCode, redirectUri).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OAuth2AuthorizationData authorization = (OAuth2AuthorizationData)tuple2._1();
            Object userInfo = tuple2._2();
            this.authorizationsCache().put((Object)authorization.accessToken(), Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new Tuple2(userInfo, (Object)Deadline$.MODULE$.now().$plus((FiniteDuration)authorization.expirationPeriod().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultExpiration()))), $this.ec));
            Tuple2 tuple22 = new Tuple2((Object)authorization, userInfo);
            return tuple22;
        }, this.ec);
    }

    @Override
    public Future<Tuple2<UserInfoData, Option<Deadline>>> checkAuthorizationAndObtainUserinfo(String accessToken) {
        return this.authorizationsCache().getOrCreate((Object)accessToken, (Function0 & Serializable & scala.Serializable)() -> $this.delegate.checkAuthorizationAndObtainUserinfo(accessToken).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object userInfo = tuple2._1();
            Option expiration = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2(userInfo, expiration.getOrElse((Function0 & Serializable & scala.Serializable)() -> Deadline$.MODULE$.now().$plus(this.defaultExpiration())));
            return tuple22;
        }, $this.ec)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object userInfo = tuple2._1();
            Deadline expiration = (Deadline)tuple2._2();
            Tuple2 tuple22 = new Tuple2(userInfo, (Object)new Some((Object)expiration));
            return tuple22;
        }, this.ec);
    }

    private FiniteDuration defaultExpiration$lzycompute() {
        CachingOAuth2Service cachingOAuth2Service = this;
        synchronized (cachingOAuth2Service) {
            if (!this.bitmap$0) {
                this.defaultExpiration = this.configuration.defaultTokenExpirationTime();
                this.bitmap$0 = true;
            }
        }
        this.configuration = null;
        return this.defaultExpiration;
    }

    private FiniteDuration defaultExpiration() {
        return !this.bitmap$0 ? this.defaultExpiration$lzycompute() : this.defaultExpiration;
    }

    public CachingOAuth2Service(OAuth2Service<UserInfoData, AuthorizationData> delegate, OAuth2Configuration configuration, ExecutionContext ec) {
        this.delegate = delegate;
        this.configuration = configuration;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.authorizationsCache = new DefaultAsyncCache(CacheConfig$.MODULE$.apply(new ExpiryConfig<String, Tuple2<UserInfoData, Deadline>>(null){

            public Option expireAfterAccessFn(Object k, Object v, Deadline now) {
                return ExpiryConfig.expireAfterAccessFn$((ExpiryConfig)this, (Object)k, (Object)v, (Deadline)now);
            }

            public Option<Deadline> expireAfterWriteFn(String key, Tuple2<UserInfoData, Deadline> value, Deadline now) {
                return new Some(value._2());
            }
            {
                ExpiryConfig.$init$((ExpiryConfig)this);
            }
        }), DefaultAsyncCache$.MODULE$.$lessinit$greater$default$2(), ec);
    }
}

