/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import io.circe.Decoder;
import java.io.Serializable;
import java.security.Key;
import java.security.PublicKey;
import java.time.Instant;
import java.util.NoSuchElementException;
import pdi.jwt.JwtHeader;
import pl.touk.nussknacker.ui.security.oauth2.BaseOAuth2Service;
import pl.touk.nussknacker.ui.security.oauth2.JwtStandardClaims;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ClientApi;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ErrorHandler;
import pl.touk.nussknacker.ui.security.oauth2.jwt.JwtValidator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\b\u0011\u0001uA\u0011B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011$\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001b\u0013\u0001\u0003\u0004\u0003\u0006Y\u0001\u0014\u0005\t7\u0002\u0011\t\u0011)A\u00069\")!\r\u0001C\u0001G\"9!\u000e\u0001b\u0001\n#Y\u0007BB8\u0001A\u0003%A\u000eC\u0004q\u0001\t\u0007I\u0011C9\t\u000f\u0005\u0005\u0001\u0001)A\u0005e\"Q\u00111\u0001\u0001\t\u0006\u0004%\t\"!\u0002\t\u000f\u0005M\u0001\u0001\"\u0005\u0002\u0016!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA'\u0001\u0011E\u0011q\n\u0005\b\u0003+\u0002A\u0011KA,\u0005AQu\u000f^(BkRD'gU3sm&\u001cWM\u0003\u0002\u0012%\u00051q.Y;uQJR!a\u0005\u000b\u0002\u0011M,7-\u001e:jifT!!\u0006\f\u0002\u0005UL'BA\f\u0019\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005eQ\u0012\u0001\u0002;pk.T\u0011aG\u0001\u0003a2\u001c\u0001!\u0006\u0003\u001fKI*6c\u0001\u0001 qA!\u0001%I\u00122\u001b\u0005\u0001\u0012B\u0001\u0012\u0011\u0005E\u0011\u0015m]3P\u0003V$\bNM*feZL7-\u001a\t\u0003I\u0015b\u0001\u0001B\u0003'\u0001\t\u0007qE\u0001\u0007Vg\u0016\u0014\u0018J\u001c4p\t\u0006$\u0018-\u0005\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t9aj\u001c;iS:<\u0007CA\u00150\u0013\t\u0001$FA\u0002B]f\u0004\"\u0001\n\u001a\u0005\u000bM\u0002!\u0019\u0001\u001b\u0003#\u0005+H\u000f[8sSj\fG/[8o\t\u0006$\u0018-\u0005\u0002)kA\u0011\u0001EN\u0005\u0003oA\u0011qcT!vi\"\u0014\u0014)\u001e;i_JL'0\u0019;j_:$\u0015\r^1\u0011\u0005e\u0002U\"\u0001\u001e\u000b\u0005mb\u0014\u0001D:dC2\fGn\\4hS:<'BA\u001f?\u0003!!\u0018\u0010]3tC\u001a,'\"A \u0002\u0007\r|W.\u0003\u0002Bu\tYA*\u0019>z\u0019><w-\u001b8h\u0003%\u0019G.[3oi\u0006\u0003\u0018\u000e\u0005\u0003!\t\u000e\n\u0014BA#\u0011\u0005=y\u0015)\u001e;ie\rc\u0017.\u001a8u\u0003BL\u0017B\u0001\"\"\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011\u0001%S\u0005\u0003\u0015B\u00111cT!vi\"\u00144i\u001c8gS\u001e,(/\u0019;j_:\f!\"\u001a<jI\u0016t7-\u001a\u00132!\ri%\u000bV\u0007\u0002\u001d*\u0011q\nU\u0001\u0006G&\u00148-\u001a\u0006\u0002#\u0006\u0011\u0011n\\\u0005\u0003':\u0013q\u0001R3d_\u0012,'\u000f\u0005\u0002%+\u0012)a\u000b\u0001b\u0001/\n\t\u0012iY2fgN$vn[3o\u00072\f\u0017.\\:\u0012\u0005!B\u0006C\u0001\u0011Z\u0013\tQ\u0006CA\tKoR\u001cF/\u00198eCJ$7\t\\1j[N\f!!Z2\u0011\u0005u\u0003W\"\u00010\u000b\u0005}S\u0013AC2p]\u000e,(O]3oi&\u0011\u0011M\u0018\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDc\u00013iSR\u0019QMZ4\u0011\u000b\u0001\u00021%\r+\t\u000b-+\u00019\u0001'\t\u000bm+\u00019\u0001/\t\u000b\t+\u0001\u0019A\"\t\u000b\u001d+\u0001\u0019\u0001%\u0002!\u0005\u001c7-Z:t)>\\WM\\%t\u0015^$X#\u00017\u0011\u0005%j\u0017B\u00018+\u0005\u001d\u0011un\u001c7fC:\f\u0011#Y2dKN\u001cHk\\6f]&\u001b(j\u001e;!\u0003m\u0011X-];je\u0016$\u0017iY2fgN$vn[3o\u0003V$\u0017.\u001a8dKV\t!\u000fE\u0002*gVL!\u0001\u001e\u0016\u0003\r=\u0003H/[8o!\t1XP\u0004\u0002xwB\u0011\u0001PK\u0007\u0002s*\u0011!\u0010H\u0001\u0007yI|w\u000e\u001e \n\u0005qT\u0013A\u0002)sK\u0012,g-\u0003\u0002\u007f\u007f\n11\u000b\u001e:j]\u001eT!\u0001 \u0016\u00029I,\u0017/^5sK\u0012\f5mY3tgR{7.\u001a8Bk\u0012LWM\\2fA\u0005a!n\u001e;WC2LG-\u0019;peV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\t\u0002\u0007)<H/\u0003\u0003\u0002\u0012\u0005-!\u0001\u0004&xiZ\u000bG.\u001b3bi>\u0014\u0018AE5oiJ|7\u000f]3di*;H\u000fV8lK:,B!a\u0006\u0002$Q!\u0011\u0011DA\u0017)\u0011\tY\"a\n\u0011\u000bu\u000bi\"!\t\n\u0007\u0005}aL\u0001\u0004GkR,(/\u001a\t\u0004I\u0005\rBABA\u0013\u0017\t\u0007qE\u0001\u0004DY\u0006LWn\u001d\u0005\n\u0003SY\u0011\u0011!a\u0002\u0003W\t!\"\u001a<jI\u0016t7-\u001a\u00133!\u0011i%+!\t\t\r\u0005=2\u00021\u0001v\u0003\u0015!xn[3o\u0003UIg\u000e\u001e:pgB,7\r^!dG\u0016\u001c8\u000fV8lK:$B!!\u000e\u0002JA)Q,!\b\u00028A!\u0011f]A\u001d!\u0011\tY$!\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nA\u0001^5nK*\u0011\u00111I\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002H\u0005u\"aB%ogR\fg\u000e\u001e\u0005\u0007\u0003\u0017b\u0001\u0019A;\u0002\u0017\u0005\u001c7-Z:t)>\\WM\\\u0001\u001am\u0016\u0014\u0018NZ=BG\u000e,7o\u001d+pW\u0016t\u0017)\u001e3jK:\u001cW\rF\u0002m\u0003#Ba!a\u0015\u000e\u0001\u0004A\u0016AB2mC&l7/A\npER\f\u0017N\\!vi\"|'/\u001b>bi&|g\u000e\u0006\u0004\u0002Z\u0005m\u0013q\f\t\u0005;\u0006u\u0011\u0007\u0003\u0004\u0002^9\u0001\r!^\u0001\u0012CV$\bn\u001c:ju\u0006$\u0018n\u001c8D_\u0012,\u0007BBA1\u001d\u0001\u0007Q/A\u0006sK\u0012L'/Z2u+JL\u0007")
public class JwtOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData, AccessTokenClaims extends JwtStandardClaims>
extends BaseOAuth2Service<UserInfoData, AuthorizationData> {
    private JwtValidator jwtValidator;
    private final OAuth2Configuration configuration;
    private final Decoder<AccessTokenClaims> evidence$1;
    private final ExecutionContext ec;
    private final boolean accessTokenIsJwt;
    private final Option<String> requiredAccessTokenAudience;
    private volatile boolean bitmap$0;

    public boolean accessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public Option<String> requiredAccessTokenAudience() {
        return this.requiredAccessTokenAudience;
    }

    private JwtValidator jwtValidator$lzycompute() {
        JwtOAuth2Service jwtOAuth2Service = this;
        synchronized (jwtOAuth2Service) {
            if (!this.bitmap$0) {
                this.jwtValidator = new JwtValidator((Function1<JwtHeader, Key>)(Function1 & Serializable & scala.Serializable)x$5 -> (PublicKey)$this.configuration.jwt().flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.authServerPublicKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NoSuchElementException("JWT configuration not found");
                }));
                this.bitmap$0 = true;
            }
        }
        return this.jwtValidator;
    }

    public JwtValidator jwtValidator() {
        return !this.bitmap$0 ? this.jwtValidator$lzycompute() : this.jwtValidator;
    }

    public <Claims> Future<Claims> introspectJwtToken(String token, Decoder<Claims> evidence$2) {
        Future future;
        Validated<OAuth2ErrorHandler.OAuth2JwtError, Claims> validated = this.jwtValidator().introspect(token, evidence$2);
        if (validated instanceof Validated.Valid) {
            Validated.Valid valid = (Validated.Valid)validated;
            Object claims = valid.a();
            future = Future$.MODULE$.successful(claims);
        } else if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            OAuth2ErrorHandler.OAuth2JwtError jwtError = (OAuth2ErrorHandler.OAuth2JwtError)invalid.e();
            future = Future$.MODULE$.failed((Throwable)new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.one((Object)jwtError)));
        } else {
            throw new MatchError(validated);
        }
        return future;
    }

    @Override
    public Future<Option<Instant>> introspectAccessToken(String accessToken2) {
        return this.accessTokenIsJwt() ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> accessToken2, this.ec).flatMap((Function1 & Serializable & scala.Serializable)accessToken -> this.introspectJwtToken((String)accessToken, (Decoder)$this.evidence$1), this.ec).flatMap((Function1 & Serializable & scala.Serializable)claims -> this.verifyAccessTokenAudience((JwtStandardClaims)claims) ? Future$.MODULE$.successful(claims.expirationTime()) : Future$.MODULE$.failed((Throwable)new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.one((Object)new OAuth2ErrorHandler.OAuth2AccessTokenRejection("Invalid audience claim")))), this.ec) : super.introspectAccessToken(accessToken2);
    }

    public boolean verifyAccessTokenAudience(JwtStandardClaims claims) {
        return this.requiredAccessTokenAudience().isEmpty() || claims.audienceAsList().exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)JwtOAuth2Service.$anonfun$verifyAccessTokenAudience$1(this, elem)));
    }

    @Override
    public Future<AuthorizationData> obtainAuthorization(String authorizationCode, String redirectUri) {
        return super.clientApi().accessTokenRequest(authorizationCode, redirectUri).andThen((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JwtOAuth2Service $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Try<AuthorizationData>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Future<Option<Instant>> future;
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    OAuth2AuthorizationData authorization = (OAuth2AuthorizationData)success.value();
                    if (this.$outer.accessTokenIsJwt()) {
                        future = this.$outer.introspectAccessToken(authorization.accessToken());
                        return (B1)future;
                    }
                }
                future = function1.apply(x1);
                return (B1)future;
            }

            public final boolean isDefinedAt(Try<AuthorizationData> x1) {
                Try<AuthorizationData> try_ = x1;
                boolean bl = try_ instanceof Success && this.$outer.accessTokenIsJwt();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.ec);
    }

    public static final /* synthetic */ boolean $anonfun$verifyAccessTokenAudience$1(JwtOAuth2Service $this, Object elem) {
        return $this.requiredAccessTokenAudience().contains(elem);
    }

    public JwtOAuth2Service(OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi, OAuth2Configuration configuration, Decoder<AccessTokenClaims> evidence$1, ExecutionContext ec) {
        this.configuration = configuration;
        this.evidence$1 = evidence$1;
        this.ec = ec;
        super(clientApi, ec);
        this.accessTokenIsJwt = configuration.jwt().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.accessTokenIsJwt()));
        this.requiredAccessTokenAudience = configuration.jwt().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.audience());
    }
}

