/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder;
import java.io.Serializable;
import pl.touk.nussknacker.ui.security.oauth2.BaseOAuth2Service$;
import pl.touk.nussknacker.ui.security.oauth2.DefaultOAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.IntrospectedAccessTokenData;
import pl.touk.nussknacker.ui.security.oauth2.IntrospectedAccessTokenData$;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ClientApi;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ErrorHandler;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Service;
import scala.Function1;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import sttp.client3.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\b\u0010\u0001qA\u0001\"\u0011\u0001\u0003\u0006\u0004%\tB\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0007\"Aq\t\u0001B\u0001B\u0003-\u0001\nC\u0003O\u0001\u0011\u0005q\nC\u0003U\u0001\u0011\u0015Q\u000bC\u0003l\u0001\u0011EA\u000e\u0003\u0004q\u0001\u0011\u0005s\"\u001d\u0005\u0006q\u0002!\t\"\u001f\u0005\u0007q\u0002!\teD?\b\u000f\u0005\rq\u0002#\u0001\u0002\u0006\u00191ab\u0004E\u0001\u0003\u000fAaAT\u0006\u0005\u0002\u0005=\u0001bBA\t\u0017\u0011\u0005\u00111\u0003\u0002\u0012\u0005\u0006\u001cXmT!vi\"\u00144+\u001a:wS\u000e,'B\u0001\t\u0012\u0003\u0019y\u0017-\u001e;ie)\u0011!cE\u0001\tg\u0016\u001cWO]5us*\u0011A#F\u0001\u0003k&T!AF\f\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u00031e\tA\u0001^8vW*\t!$\u0001\u0002qY\u000e\u0001QcA\u000f%cM\u0019\u0001AH\u001c\u0011\t}\u0001#\u0005M\u0007\u0002\u001f%\u0011\u0011e\u0004\u0002\u000e\u001f\u0006+H\u000f\u001b\u001aTKJ4\u0018nY3\u0011\u0005\r\"C\u0002\u0001\u0003\u0006K\u0001\u0011\rA\n\u0002\r+N,'/\u00138g_\u0012\u000bG/Y\t\u0003O5\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012qAT8uQ&tw\r\u0005\u0002)]%\u0011q&\u000b\u0002\u0004\u0003:L\bCA\u00122\t\u0015\u0011\u0004A1\u00014\u0005E\tU\u000f\u001e5pe&T\u0018\r^5p]\u0012\u000bG/Y\t\u0003OQ\u0002\"aH\u001b\n\u0005Yz!aF(BkRD''Q;uQ>\u0014\u0018N_1uS>tG)\u0019;b!\tAt(D\u0001:\u0015\tQ4(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002={\u0005AA/\u001f9fg\u00064WMC\u0001?\u0003\r\u0019w.\\\u0005\u0003\u0001f\u00121\u0002T1{s2{wmZ5oO\u0006I1\r\\5f]R\f\u0005/[\u000b\u0002\u0007B!q\u0004\u0012\u00121\u0013\t)uBA\bP\u0003V$\bNM\"mS\u0016tG/\u00119j\u0003)\u0019G.[3oi\u0006\u0003\u0018\u000eI\u0001\u0003K\u000e\u0004\"!\u0013'\u000e\u0003)S!aS\u0015\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002N\u0015\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u001bFCA)S!\u0011y\u0002A\t\u0019\t\u000b\u001d#\u00019\u0001%\t\u000b\u0005#\u0001\u0019A\"\u0002M=\u0014G/Y5o\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8B]\u0012\fU\u000f\u001e5f]RL7-\u0019;f+N,'\u000fF\u0002W9&\u00042!S,Z\u0013\tA&J\u0001\u0004GkR,(/\u001a\t\u0005Qi\u0003$%\u0003\u0002\\S\t1A+\u001e9mKJBQ!X\u0003A\u0002y\u000b\u0011#Y;uQ>\u0014\u0018N_1uS>t7i\u001c3f!\tyfM\u0004\u0002aIB\u0011\u0011-K\u0007\u0002E*\u00111mG\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015L\u0013A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!Z\u0015\t\u000b),\u0001\u0019\u00010\u0002\u0017I,G-\u001b:fGR,&/[\u0001\u0014_\n$\u0018-\u001b8BkRDwN]5{CRLwN\u001c\u000b\u0004[:|\u0007cA%Xa!)QL\u0002a\u0001=\")!N\u0002a\u0001=\u0006)\u0012N\u001c;s_N\u0004Xm\u0019;BG\u000e,7o\u001d+pW\u0016tGC\u0001:w!\rIuk\u001d\t\u0003?QL!!^\b\u00037%sGO]8ta\u0016\u001cG/\u001a3BG\u000e,7o\u001d+pW\u0016tG)\u0019;b\u0011\u00159x\u00011\u0001_\u0003-\t7mY3tgR{7.\u001a8\u0002!\u0005,H\u000f[3oi&\u001c\u0017\r^3Vg\u0016\u0014HC\u0001>|!\rIuK\t\u0005\u0006y\"\u0001\r\u0001M\u0001\u0012CV$\bn\u001c:ju\u0006$\u0018n\u001c8ECR\fGc\u0001>\u007f\u007f\")q/\u0003a\u0001=\"1\u0011\u0011A\u0005A\u0002M\fq\"Y2dKN\u001cHk\\6f]\u0012\u000bG/Y\u0001\u0012\u0005\u0006\u001cXmT!vi\"\u00144+\u001a:wS\u000e,\u0007CA\u0010\f'\rY\u0011\u0011\u0002\t\u0004Q\u0005-\u0011bAA\u0007S\t1\u0011I\\=SK\u001a$\"!!\u0002\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005U\u0011Q\u0004\u000b\u0005\u0003/\t\t\u0006\u0006\u0005\u0002\u001a\u0005\u0015\u0012\u0011HA\u001e!\u0019y\u0002!a\u0007\u0002 A\u00191%!\b\u0005\u000b\u0015j!\u0019\u0001\u0014\u0011\u0007}\t\t#C\u0002\u0002$=\u0011a\u0004R3gCVdGoT!vi\"\u0014\u0014)\u001e;i_JL'0\u0019;j_:$\u0015\r^1\t\u0013\u0005\u001dR\"!AA\u0004\u0005%\u0012AC3wS\u0012,gnY3%cA1\u00111FA\u001b\u00037i!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0006G&\u00148-\u001a\u0006\u0003\u0003g\t!![8\n\t\u0005]\u0012Q\u0006\u0002\b\t\u0016\u001cw\u000eZ3s\u0011\u00159U\u0002q\u0001I\u0011\u001d\ti$\u0004a\u0002\u0003\u007f\tqAY1dW\u0016tG\rE\u0004\u0002B\u0005-\u0013qJ\u0017\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nqa\u00197jK:$8G\u0003\u0002\u0002J\u0005!1\u000f\u001e;q\u0013\u0011\ti%a\u0011\u0003\u0017M#H\u000f\u001d\"bG.,g\u000e\u001a\t\u0003\u0013^Cq!a\u0015\u000e\u0001\u0004\t)&A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0004?\u0005]\u0013bAA-\u001f\t\u0019r*Q;uQJ\u001auN\u001c4jOV\u0014\u0018\r^5p]\u0002")
public class BaseOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData>
extends OAuth2Service<UserInfoData, AuthorizationData>
implements LazyLogging {
    private final OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <UserInfoData> BaseOAuth2Service<UserInfoData, DefaultOAuth2AuthorizationData> apply(OAuth2Configuration oAuth2Configuration, Decoder<UserInfoData> decoder, ExecutionContext executionContext, SttpBackend<Future, Object> sttpBackend) {
        return BaseOAuth2Service$.MODULE$.apply(oAuth2Configuration, decoder, executionContext, sttpBackend);
    }

    private Logger logger$lzycompute() {
        BaseOAuth2Service baseOAuth2Service = this;
        synchronized (baseOAuth2Service) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi() {
        return this.clientApi;
    }

    @Override
    public final Future<Tuple2<AuthorizationData, UserInfoData>> obtainAuthorizationAndAuthenticateUser(String authorizationCode, String redirectUri) {
        return this.obtainAuthorization(authorizationCode, redirectUri).flatMap((Function1 & Serializable & scala.Serializable)authorizationData -> this.authenticateUser(authorizationData).map((Function1 & Serializable & scala.Serializable)userInfo -> new Tuple2(authorizationData, userInfo), $this.ec), this.ec);
    }

    public Future<AuthorizationData> obtainAuthorization(String authorizationCode, String redirectUri) {
        return this.clientApi().accessTokenRequest(authorizationCode, redirectUri);
    }

    @Override
    public Future<IntrospectedAccessTokenData> introspectAccessToken(String accessToken) {
        return Future$.MODULE$.failed((Throwable)new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.one((Object)new OAuth2ErrorHandler.OAuth2AccessTokenRejection("The access token cannot be validated"))));
    }

    public Future<UserInfoData> authenticateUser(AuthorizationData authorizationData) {
        return this.authenticateUser(authorizationData.accessToken(), IntrospectedAccessTokenData$.MODULE$.empty());
    }

    @Override
    public Future<UserInfoData> authenticateUser(String accessToken, IntrospectedAccessTokenData accessTokenData) {
        return this.clientApi().profileRequest(accessToken);
    }

    public BaseOAuth2Service(OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi, ExecutionContext ec) {
        this.clientApi = clientApi;
        this.ec = ec;
        super(ec);
        LazyLogging.$init$((LazyLogging)this);
    }
}

