/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oidc;

import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$HS256$;
import pdi.jwt.JwtHeader;
import pl.touk.nussknacker.ui.security.oauth2.jwt.JwtValidator;
import pl.touk.nussknacker.ui.security.oidc.OidcAuthenticationConfiguration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;

public final class OidcService$ {
    public static OidcService$ MODULE$;

    static {
        new OidcService$();
    }

    public JwtValidator createJwtValidator(OidcAuthenticationConfiguration configuration) {
        return new JwtValidator((Function1<JwtHeader, Key>)(Function1 & java.io.Serializable & Serializable)jwtHeader -> {
            Key key;
            Option option = jwtHeader.keyId();
            if (option instanceof Some) {
                Some some = (Some)option;
                String definedKeyId = (String)some.value();
                key = MODULE$.jwkProvider(configuration).get(definedKeyId).getPublicKey();
            } else if (None$.MODULE$.equals(option)) {
                String definedClientSecret = (String)configuration.clientSecret().getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
                    throw new IllegalStateException("clientSecret must be specified in configuration for JWT without keyId for OIDC");
                });
                key = new SecretKeySpec(definedClientSecret.getBytes(StandardCharsets.UTF_8), ((JwtAlgorithm)jwtHeader.algorithm().getOrElse((Function0 & java.io.Serializable & Serializable)() -> JwtAlgorithm$HS256$.MODULE$)).name());
            } else {
                throw new MatchError((Object)option);
            }
            return key;
        });
    }

    private JwkProvider jwkProvider(OidcAuthenticationConfiguration configuration) {
        return new JwkProviderBuilder(configuration.resolvedJwksUri().toURL()).build();
    }

    private OidcService$() {
        MODULE$ = this;
    }
}

