/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder;
import java.io.Serializable;
import pl.touk.nussknacker.ui.security.oauth2.BaseOAuth2Service$;
import pl.touk.nussknacker.ui.security.oauth2.DefaultOAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ClientApi;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ErrorHandler;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Service;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Deadline;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\b\u0011\u0001uA\u0001\"\u0012\u0001\u0003\u0006\u0004%\tB\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u000f\"A1\n\u0001B\u0001B\u0003-A\nC\u0003S\u0001\u0011\u00051\u000bC\u0003Y\u0001\u0011\u0015\u0011\fC\u0003p\u0001\u0011\u0015\u0001\u000fC\u0003\u007f\u0001\u0011Eq\u0010C\u0004\u0002\b\u0001!\t\"!\u0003\t\u000f\u0005=\u0001\u0001\"\u0005\u0002\u0012!9\u0011q\u0002\u0001\u0005\u0012\u0005eqaBA\u000f!!\u0005\u0011q\u0004\u0004\u0007\u001fAA\t!!\t\t\rIcA\u0011AA\u0012\u0011\u001d\t)\u0003\u0004C\u0001\u0003O\u0011\u0011CQ1tK>\u000bU\u000f\u001e53'\u0016\u0014h/[2f\u0015\t\t\"#\u0001\u0004pCV$\bN\r\u0006\u0003'Q\t\u0001b]3dkJLG/\u001f\u0006\u0003+Y\t!!^5\u000b\u0005]A\u0012a\u00038vgN\\g.Y2lKJT!!\u0007\u000e\u0002\tQ|Wo\u001b\u0006\u00027\u0005\u0011\u0001\u000f\\\u0002\u0001+\rq2&N\n\u0005\u0001})3\b\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0005M\u001dJC'D\u0001\u0011\u0013\tA\u0003CA\u0007P\u0003V$\bNM*feZL7-\u001a\t\u0003U-b\u0001\u0001B\u0003-\u0001\t\u0007QF\u0001\u0007Vg\u0016\u0014\u0018J\u001c4p\t\u0006$\u0018-\u0005\u0002/cA\u0011\u0001eL\u0005\u0003a\u0005\u0012qAT8uQ&tw\r\u0005\u0002!e%\u00111'\t\u0002\u0004\u0003:L\bC\u0001\u00166\t\u00151\u0004A1\u00018\u0005E\tU\u000f\u001e5pe&T\u0018\r^5p]\u0012\u000bG/Y\t\u0003]a\u0002\"AJ\u001d\n\u0005i\u0002\"aF(BkRD''Q;uQ>\u0014\u0018N_1uS>tG)\u0019;b!\ta4)D\u0001>\u0015\tqt(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002A\u0003\u0006AA/\u001f9fg\u00064WMC\u0001C\u0003\r\u0019w.\\\u0005\u0003\tv\u00121\u0002T1{s2{wmZ5oO\u0006I1\r\\5f]R\f\u0005/[\u000b\u0002\u000fB!a\u0005S\u00155\u0013\tI\u0005CA\bP\u0003V$\bNM\"mS\u0016tG/\u00119j\u0003)\u0019G.[3oi\u0006\u0003\u0018\u000eI\u0001\u0003K\u000e\u0004\"!\u0014)\u000e\u00039S!aT\u0011\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002R\u001d\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Q;FCA+W!\u00111\u0003!\u000b\u001b\t\u000b-#\u00019\u0001'\t\u000b\u0015#\u0001\u0019A$\u0002==\u0014G/Y5o\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8B]\u0012,6/\u001a:J]\u001a|Gc\u0001.a[B\u0019QjW/\n\u0005qs%A\u0002$viV\u0014X\r\u0005\u0003!=RJ\u0013BA0\"\u0005\u0019!V\u000f\u001d7fe!)\u0011-\u0002a\u0001E\u0006\t\u0012-\u001e;i_JL'0\u0019;j_:\u001cu\u000eZ3\u0011\u0005\rTgB\u00013i!\t)\u0017%D\u0001g\u0015\t9G$\u0001\u0004=e>|GOP\u0005\u0003S\u0006\na\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011.\t\u0005\u0006]\u0016\u0001\rAY\u0001\fe\u0016$\u0017N]3diV\u0013\u0018.A\u0012dQ\u0016\u001c7.Q;uQ>\u0014\u0018N_1uS>t\u0017I\u001c3PER\f\u0017N\\+tKJLgNZ8\u0015\u0005Ed\bcA'\\eB!\u0001EX\u0015t!\r\u0001CO^\u0005\u0003k\u0006\u0012aa\u00149uS>t\u0007CA<{\u001b\u0005A(BA=O\u0003!!WO]1uS>t\u0017BA>y\u0005!!U-\u00193mS:,\u0007\"B?\u0007\u0001\u0004\u0011\u0017aC1dG\u0016\u001c8\u000fV8lK:\f1c\u001c2uC&t\u0017)\u001e;i_JL'0\u0019;j_:$b!!\u0001\u0002\u0004\u0005\u0015\u0001cA'\\i!)\u0011m\u0002a\u0001E\")an\u0002a\u0001E\u0006)\u0012N\u001c;s_N\u0004Xm\u0019;BG\u000e,7o\u001d+pW\u0016tG\u0003BA\u0006\u0003\u001b\u00012!T.t\u0011\u0015i\b\u00021\u0001c\u00039y'\r^1j]V\u001bXM]%oM>$B!a\u0005\u0002\u0016A\u0019QjW\u0015\t\r\u0005]\u0011\u00021\u00015\u0003E\tW\u000f\u001e5pe&T\u0018\r^5p]\u0012\u000bG/\u0019\u000b\u0005\u0003'\tY\u0002C\u0003~\u0015\u0001\u0007!-A\tCCN,w*Q;uQJ\u001aVM\u001d<jG\u0016\u0004\"A\n\u0007\u0014\u00051yBCAA\u0010\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\tI#!\r\u0015\t\u0005-\u00121\u0010\u000b\t\u0003[\tI$!\u0014\u0002PA1a\u0005AA\u0018\u0003g\u00012AKA\u0019\t\u0015acB1\u0001.!\r1\u0013QG\u0005\u0004\u0003o\u0001\"A\b#fM\u0006,H\u000e^(BkRD''Q;uQ>\u0014\u0018N_1uS>tG)\u0019;b\u0011%\tYDDA\u0001\u0002\b\ti$\u0001\u0006fm&$WM\\2fIE\u0002b!a\u0010\u0002J\u0005=RBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u000b\rL'oY3\u000b\u0005\u0005\u001d\u0013AA5p\u0013\u0011\tY%!\u0011\u0003\u000f\u0011+7m\u001c3fe\")1J\u0004a\u0002\u0019\"9\u0011\u0011\u000b\bA\u0004\u0005M\u0013a\u00022bG.,g\u000e\u001a\t\n\u0003+\ny&a\u0019/\u0003Kj!!a\u0016\u000b\t\u0005e\u00131L\u0001\u0007G2LWM\u001c;\u000b\u0005\u0005u\u0013\u0001B:uiBLA!!\u0019\u0002X\tY1\u000b\u001e;q\u0005\u0006\u001c7.\u001a8e!\ti5\f\u0005\u0003\u0002h\u0005Ud\u0002BA5\u0003crA!a\u001b\u0002p9\u0019Q-!\u001c\n\u0005\u0005u\u0013\u0002BA-\u00037JA!a\u001d\u0002X\u00059\u0001/Y2lC\u001e,\u0017\u0002BA<\u0003s\u0012\u0001BT8uQ&tw\r\u0016\u0006\u0005\u0003g\n9\u0006C\u0004\u0002~9\u0001\r!a \u0002\u001b\r|gNZ5hkJ\fG/[8o!\r1\u0013\u0011Q\u0005\u0004\u0003\u0007\u0003\"aE(BkRD'gQ8oM&<WO]1uS>t\u0007")
public class BaseOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData>
implements OAuth2Service<UserInfoData, AuthorizationData>,
LazyLogging {
    private final OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <UserInfoData> BaseOAuth2Service<UserInfoData, DefaultOAuth2AuthorizationData> apply(OAuth2Configuration oAuth2Configuration, Decoder<UserInfoData> decoder, ExecutionContext executionContext, SttpBackend<Future, Nothing$, ?> sttpBackend) {
        return BaseOAuth2Service$.MODULE$.apply(oAuth2Configuration, decoder, executionContext, sttpBackend);
    }

    private Logger logger$lzycompute() {
        BaseOAuth2Service baseOAuth2Service = this;
        synchronized (baseOAuth2Service) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi() {
        return this.clientApi;
    }

    @Override
    public final Future<Tuple2<AuthorizationData, UserInfoData>> obtainAuthorizationAndUserInfo(String authorizationCode, String redirectUri) {
        return this.obtainAuthorization(authorizationCode, redirectUri).flatMap((Function1 & Serializable & scala.Serializable)authorizationData -> this.obtainUserInfo(authorizationData).map((Function1 & Serializable & scala.Serializable)userInfo -> new Tuple2(authorizationData, userInfo), $this.ec), this.ec);
    }

    @Override
    public final Future<Tuple2<UserInfoData, Option<Deadline>>> checkAuthorizationAndObtainUserinfo(String accessToken) {
        return this.introspectAccessToken(accessToken).flatMap((Function1 & Serializable & scala.Serializable)deadline -> this.obtainUserInfo(accessToken).map((Function1 & Serializable & scala.Serializable)userInfo -> new Tuple2(userInfo, deadline), $this.ec), this.ec);
    }

    public Future<AuthorizationData> obtainAuthorization(String authorizationCode, String redirectUri) {
        return this.clientApi().accessTokenRequest(authorizationCode, redirectUri);
    }

    public Future<Option<Deadline>> introspectAccessToken(String accessToken) {
        return Future$.MODULE$.failed((Throwable)new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.one((Object)new OAuth2ErrorHandler.OAuth2AccessTokenRejection("The access token cannot be validated"))));
    }

    public Future<UserInfoData> obtainUserInfo(AuthorizationData authorizationData) {
        return this.obtainUserInfo(authorizationData.accessToken());
    }

    public Future<UserInfoData> obtainUserInfo(String accessToken) {
        return this.clientApi().profileRequest(accessToken);
    }

    public BaseOAuth2Service(OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi, ExecutionContext ec) {
        this.clientApi = clientApi;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
    }
}

