/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder;
import java.io.Serializable;
import pl.touk.nussknacker.ui.security.api.AuthenticatedUser;
import pl.touk.nussknacker.ui.security.oauth2.BaseOAuth2Service$;
import pl.touk.nussknacker.ui.security.oauth2.CachingOAuth2Service;
import pl.touk.nussknacker.ui.security.oauth2.CachingOAuth2Service$;
import pl.touk.nussknacker.ui.security.oauth2.DefaultOAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.DefaultOAuth2AuthorizationData$;
import pl.touk.nussknacker.ui.security.oauth2.DefaultOAuth2ServiceFactory$;
import pl.touk.nussknacker.ui.security.oauth2.DefaultOidcAuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.DefaultOidcAuthorizationData$;
import pl.touk.nussknacker.ui.security.oauth2.GenericOidcService$;
import pl.touk.nussknacker.ui.security.oauth2.GitHubProfile$;
import pl.touk.nussknacker.ui.security.oauth2.GitHubProfileResponse;
import pl.touk.nussknacker.ui.security.oauth2.GitHubProfileResponse$;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Service;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ServiceFactory;
import pl.touk.nussknacker.ui.security.oauth2.OpenIdConnectProfile$;
import pl.touk.nussknacker.ui.security.oauth2.OpenIdConnectUserInfo;
import pl.touk.nussknacker.ui.security.oauth2.OpenIdConnectUserInfo$;
import pl.touk.nussknacker.ui.security.oauth2.ProfileFormat$;
import pl.touk.nussknacker.ui.security.oauth2.UserMappingOAuth2Service;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001M4A\u0001C\u0005\u0001-!)1\u0006\u0001C\u0001Y!)a\u0006\u0001C!_\u001d)\u0001.\u0003E\u0001S\u001a)\u0001\"\u0003E\u0001U\")1\u0006\u0002C\u0001W\")A\u000e\u0002C\u0001[\")!\u000f\u0002C\u0001Y\tYB)\u001a4bk2$x*Q;uQJ\u001aVM\u001d<jG\u00164\u0015m\u0019;pefT!AC\u0006\u0002\r=\fW\u000f\u001e53\u0015\taQ\"\u0001\u0005tK\u000e,(/\u001b;z\u0015\tqq\"\u0001\u0002vS*\u0011\u0001#E\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u0013'\u0005!Ao\\;l\u0015\u0005!\u0012A\u00019m\u0007\u0001\u0019B\u0001A\f\u001eCA\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0010\u000e\u0003%I!\u0001I\u0005\u0003)=\u000bU\u000f\u001e53'\u0016\u0014h/[2f\r\u0006\u001cGo\u001c:z!\t\u0011\u0013&D\u0001$\u0015\t!S%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002'O\u0005AA/\u001f9fg\u00064WMC\u0001)\u0003\r\u0019w.\\\u0005\u0003U\r\u00121\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\f\t\u0003=\u0001\taa\u0019:fCR,GC\u0001\u0019d)\r\tT(\u0012\t\u0005=I\"$(\u0003\u00024\u0013\tiq*Q;uQJ\u001aVM\u001d<jG\u0016\u0004\"!\u000e\u001d\u000e\u0003YR!aN\u0006\u0002\u0007\u0005\u0004\u0018.\u0003\u0002:m\t\t\u0012)\u001e;iK:$\u0018nY1uK\u0012,6/\u001a:\u0011\u0005yY\u0014B\u0001\u001f\n\u0005]y\u0015)\u001e;ie\u0005+H\u000f[8sSj\fG/[8o\t\u0006$\u0018\rC\u0003?\u0005\u0001\u000fq(\u0001\u0002fGB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!)G\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001#B\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000fC\u0003G\u0005\u0001\u000fq)A\u0004cC\u000e\\WM\u001c3\u0011\u000b!kuJU+\u000e\u0003%S!AS&\u0002\r\rd\u0017.\u001a8u\u0015\u0005a\u0015\u0001B:uiBL!AT%\u0003\u0017M#H\u000f\u001d\"bG.,g\u000e\u001a\t\u0003\u0001BK!!U!\u0003\r\u0019+H/\u001e:f!\tA2+\u0003\u0002U3\t9aj\u001c;iS:<\u0007C\u0001,a\u001d\t9fL\u0004\u0002Y;:\u0011\u0011\fX\u0007\u00025*\u00111,F\u0001\u0007yI|w\u000e\u001e \n\u00031K!AS&\n\u0005}K\u0015a\u00029bG.\fw-Z\u0005\u0003C\n\u0014\u0001BT8uQ&tw\r\u0016\u0006\u0003?&CQ\u0001\u001a\u0002A\u0002\u0015\fQbY8oM&<WO]1uS>t\u0007C\u0001\u0010g\u0013\t9\u0017BA\nP\u0003V$\bNM\"p]\u001aLw-\u001e:bi&|g.A\u000eEK\u001a\fW\u000f\u001c;P\u0003V$\bNM*feZL7-\u001a$bGR|'/\u001f\t\u0003=\u0011\u0019\"\u0001B\f\u0015\u0003%\fqa]3sm&\u001cW\r\u0006\u0002ocR\u0019\u0011g\u001c9\t\u000b\u00193\u00019A$\t\u000by2\u00019A \t\u000b\u00114\u0001\u0019A3\u0002\u000b\u0005\u0004\b\u000f\\=")
public class DefaultOAuth2ServiceFactory
implements OAuth2ServiceFactory,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static DefaultOAuth2ServiceFactory apply() {
        return DefaultOAuth2ServiceFactory$.MODULE$.apply();
    }

    public static OAuth2Service<AuthenticatedUser, OAuth2AuthorizationData> service(OAuth2Configuration oAuth2Configuration, SttpBackend<Future, Nothing$, ?> sttpBackend, ExecutionContext executionContext) {
        return DefaultOAuth2ServiceFactory$.MODULE$.service(oAuth2Configuration, sttpBackend, executionContext);
    }

    private Logger logger$lzycompute() {
        DefaultOAuth2ServiceFactory defaultOAuth2ServiceFactory = this;
        synchronized (defaultOAuth2ServiceFactory) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public OAuth2Service<AuthenticatedUser, OAuth2AuthorizationData> create(OAuth2Configuration configuration, ExecutionContext ec, SttpBackend<Future, Nothing$, ?> backend) {
        UserMappingOAuth2Service<Product, OAuth2AuthorizationData> userMappingOAuth2Service;
        Enumeration.Value value = (Enumeration.Value)configuration.profileFormat().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("profileFormat is missing in the authentication configuration");
        });
        Enumeration.Value value2 = ProfileFormat$.MODULE$.OIDC();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Switch to the OIDC authentication provider instead of the OIDC format in the generic OAuth2 provider");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            userMappingOAuth2Service = new UserMappingOAuth2Service<OpenIdConnectUserInfo, DefaultOidcAuthorizationData>((OAuth2Service<OpenIdConnectUserInfo, DefaultOidcAuthorizationData>)GenericOidcService$.MODULE$.apply(configuration, ec, backend), (Function1<OpenIdConnectUserInfo, AuthenticatedUser>)(Function1 & Serializable & scala.Serializable)userInfo -> OpenIdConnectProfile$.MODULE$.getAuthenticatedUser((OpenIdConnectUserInfo)userInfo, configuration), OpenIdConnectUserInfo$.MODULE$.decodeOpenIdConnectUserInfo(), (Decoder<DefaultOidcAuthorizationData>)DefaultOidcAuthorizationData$.MODULE$.codecForDefaultOidcAuthorizationData(), ec, backend);
        } else {
            Enumeration.Value value4 = ProfileFormat$.MODULE$.GITHUB();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                userMappingOAuth2Service = new UserMappingOAuth2Service<GitHubProfileResponse, DefaultOAuth2AuthorizationData>((OAuth2Service<GitHubProfileResponse, DefaultOAuth2AuthorizationData>)BaseOAuth2Service$.MODULE$.apply(configuration, GitHubProfileResponse$.MODULE$.codecForGitHubProfileResponse(), ec, backend), (Function1<GitHubProfileResponse, AuthenticatedUser>)(Function1 & Serializable & scala.Serializable)profileResponse -> GitHubProfile$.MODULE$.getAuthenticatedUser((GitHubProfileResponse)profileResponse, configuration), (Decoder<GitHubProfileResponse>)GitHubProfileResponse$.MODULE$.codecForGitHubProfileResponse(), (Decoder<DefaultOAuth2AuthorizationData>)DefaultOAuth2AuthorizationData$.MODULE$.codecForDefaultOAuth2AuthorizationData(), ec, backend);
            } else {
                throw new MatchError((Object)value);
            }
        }
        return new CachingOAuth2Service<OpenIdConnectUserInfo, DefaultOidcAuthorizationData>(userMappingOAuth2Service, configuration, CachingOAuth2Service$.MODULE$.$lessinit$greater$default$3(), ec);
    }

    public DefaultOAuth2ServiceFactory() {
        OAuth2ServiceFactory.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

