/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import io.circe.Decoder;
import java.time.Instant;
import pl.touk.nussknacker.ui.security.api.AuthenticatedUser;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Service;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import sttp.client3.SttpBackend;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\u0006\f\u0001aA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\t\u0001B\u0002B\u0003-1\t\u0003\u0005L\u0001\t\r\t\u0015a\u0003M\u0011!i\u0005A!A!\u0002\u0017q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b1B+\t\u000b\u0001\u0004A\u0011A1\t\u000b)\u0004A\u0011A6\t\r}\u0004A\u0011AA\u0001\u0005a)6/\u001a:NCB\u0004\u0018N\\4P\u0003V$\bNM*feZL7-\u001a\u0006\u0003\u00195\taa\\1vi\"\u0014$B\u0001\b\u0010\u0003!\u0019XmY;sSRL(B\u0001\t\u0012\u0003\t)\u0018N\u0003\u0002\u0013'\u0005Ya.^:tW:\f7m[3s\u0015\t!R#\u0001\u0003u_V\\'\"\u0001\f\u0002\u0005Ad7\u0001A\u000b\u00043ab3c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004B!\t\u0012%U5\t1\"\u0003\u0002$\u0017\tiq*Q;uQJ\u001aVM\u001d<jG\u0016\u0004\"!\n\u0015\u000e\u0003\u0019R!aJ\u0007\u0002\u0007\u0005\u0004\u0018.\u0003\u0002*M\t\t\u0012)\u001e;iK:$\u0018nY1uK\u0012,6/\u001a:\u0011\u0005-bC\u0002\u0001\u0003\u0006[\u0001\u0011\rA\f\u0002\u0012\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8ECR\f\u0017CA\u00183!\tY\u0002'\u0003\u000229\t9aj\u001c;iS:<\u0007CA\u00114\u0013\t!4BA\fP\u0003V$\bNM!vi\"|'/\u001b>bi&|g\u000eR1uC\u0006AA-\u001a7fO\u0006$X\r\u0005\u0003\"E]R\u0003CA\u00169\t\u0015I\u0004A1\u0001;\u00051)6/\u001a:J]\u001a|G)\u0019;b#\ty3\b\u0005\u0002\u001cy%\u0011Q\b\b\u0002\u0004\u0003:L\u0018A\u00057pO\u001e,G-V:fe\u001a+hn\u0019;j_:\u0004Ba\u0007!8I%\u0011\u0011\t\b\u0002\n\rVt7\r^5p]F\n!\"\u001a<jI\u0016t7-\u001a\u00132!\r!\u0015jN\u0007\u0002\u000b*\u0011aiR\u0001\u0006G&\u00148-\u001a\u0006\u0002\u0011\u0006\u0011\u0011n\\\u0005\u0003\u0015\u0016\u0013q\u0001R3d_\u0012,'/\u0001\u0006fm&$WM\\2fII\u00022\u0001R%+\u0003\t)7\r\u0005\u0002P%6\t\u0001K\u0003\u0002R9\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005M\u0003&\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u001d\u0011\u0017mY6f]\u0012\u0004BAV.^w5\tqK\u0003\u0002Y3\u000691\r\\5f]R\u001c$\"\u0001.\u0002\tM$H\u000f]\u0005\u00039^\u00131b\u0015;ua\n\u000b7m[3oIB\u0011qJX\u0005\u0003?B\u0013aAR;ukJ,\u0017A\u0002\u001fj]&$h\bF\u0002cQ&$Ra\u00193fM\u001e\u0004B!\t\u00018U!)!i\u0002a\u0002\u0007\")1j\u0002a\u0002\u0019\")Qj\u0002a\u0002\u001d\")Ak\u0002a\u0002+\")Qg\u0002a\u0001m!)ah\u0002a\u0001\u007f\u0005qrN\u0019;bS:\fU\u000f\u001e5pe&T\u0018\r^5p]\u0006sG-V:fe&sgm\u001c\u000b\u0004YBl\bcA(_[B!1D\u001c\u0016%\u0013\tyGD\u0001\u0004UkBdWM\r\u0005\u0006c\"\u0001\rA]\u0001\u0012CV$\bn\u001c:ju\u0006$\u0018n\u001c8D_\u0012,\u0007CA:{\u001d\t!\b\u0010\u0005\u0002v95\taO\u0003\u0002x/\u00051AH]8pizJ!!\u001f\u000f\u0002\rA\u0013X\rZ3g\u0013\tYHP\u0001\u0004TiJLgn\u001a\u0006\u0003srAQA \u0005A\u0002I\f1B]3eSJ,7\r^+sS\u0006\u00193\r[3dW\u0006+H\u000f[8sSj\fG/[8o\u0003:$wJ\u0019;bS:,6/\u001a:j]\u001a|G\u0003BA\u0002\u0003;\u0001Ba\u00140\u0002\u0006A)1D\u001c\u0013\u0002\bA)1$!\u0003\u0002\u000e%\u0019\u00111\u0002\u000f\u0003\r=\u0003H/[8o!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\tA\u0001^5nK*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!aB%ogR\fg\u000e\u001e\u0005\u0007\u0003?I\u0001\u0019\u0001:\u0002\u0017\u0005\u001c7-Z:t)>\\WM\u001c")
public class UserMappingOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData>
implements OAuth2Service<AuthenticatedUser, AuthorizationData> {
    private final OAuth2Service<UserInfoData, AuthorizationData> delegate;
    private final Function1<UserInfoData, AuthenticatedUser> loggedUserFunction;
    private final ExecutionContext ec;

    @Override
    public Future<Tuple2<AuthorizationData, AuthenticatedUser>> obtainAuthorizationAndUserInfo(String authorizationCode, String redirectUri) {
        return this.delegate.obtainAuthorizationAndUserInfo(authorizationCode, redirectUri).map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OAuth2AuthorizationData authorization = (OAuth2AuthorizationData)tuple2._1();
            Object userInfo = tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)authorization, $this.loggedUserFunction.apply(userInfo));
            return tuple22;
        }, this.ec);
    }

    @Override
    public Future<Tuple2<AuthenticatedUser, Option<Instant>>> checkAuthorizationAndObtainUserinfo(String accessToken) {
        return this.delegate.checkAuthorizationAndObtainUserinfo(accessToken).map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object userInfo = tuple2._1();
            Option expiration = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2($this.loggedUserFunction.apply(userInfo), (Object)expiration);
            return tuple22;
        }, this.ec);
    }

    public UserMappingOAuth2Service(OAuth2Service<UserInfoData, AuthorizationData> delegate, Function1<UserInfoData, AuthenticatedUser> loggedUserFunction, Decoder<UserInfoData> evidence$1, Decoder<AuthorizationData> evidence$2, ExecutionContext ec, SttpBackend<Future, Object> backend) {
        this.delegate = delegate;
        this.loggedUserFunction = loggedUserFunction;
        this.ec = ec;
    }
}

