/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.util.matching.Regex;

public final class CertificatesAndKeys$ {
    public static final CertificatesAndKeys$ MODULE$ = new CertificatesAndKeys$();

    public PublicKey publicKeyFromString(String keyStr, Charset charset) {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(this.decodeBase64(this.extractBase64EncodedPEM(keyStr), charset));
        return KeyFactory.getInstance("RSA").generatePublic(keySpec);
    }

    public PublicKey publicKeyFromStringCertificate(String certStr, Charset charset) {
        ByteArrayInputStream certStream = new ByteArrayInputStream(this.decodeBase64(this.extractBase64EncodedPEM(certStr), charset));
        return CertificateFactory.getInstance("X.509").generateCertificate(certStream).getPublicKey();
    }

    public String extractBase64EncodedPEM(String pem) {
        Regex beginningPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^-----BEGIN.*-----"));
        Regex endingPattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("-----END.*$"));
        return beginningPattern.replaceFirstIn((CharSequence)endingPattern.replaceFirstIn((CharSequence)pem.replaceAll(System.lineSeparator(), ""), ""), "");
    }

    public byte[] decodeBase64(String encoded, Charset charset) {
        return Base64.getDecoder().decode(encoded.getBytes(charset));
    }

    public String encodeBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public String textualRepresentationOfPublicKey(PublicKey publicKey) {
        return "-----BEGIN PUBLIC KEY-----\n" + this.encodeBase64(publicKey.getEncoded()) + "\n-----END PUBLIC KEY-----";
    }

    private CertificatesAndKeys$() {
    }
}

