/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import com.github.benmanes.caffeine.cache.Ticker;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.concurrent.TimeUnit;
import pl.touk.nussknacker.engine.util.cache.CacheConfig$;
import pl.touk.nussknacker.engine.util.cache.DefaultCache;
import pl.touk.nussknacker.engine.util.cache.ExpiryConfig;
import pl.touk.nussknacker.ui.security.oauth2.CachingOAuth2Service$;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001B\b\u0011\u0001uA\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005X\u0001\t\u0005\t\u0015a\u0003Y\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u001d1\u0007A1A\u0005\u0012\u001dDq!a\u0004\u0001A\u0003%\u0001\u000eC\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!Q\u0011q\u0007\u0001\t\u0006\u0004%I!!\u000f\b\u0013\u0005\u001d\u0003#!A\t\u0002\u0005%c\u0001C\b\u0011\u0003\u0003E\t!a\u0013\t\rycA\u0011AA'\u0011%\ty\u0005DI\u0001\n\u0003\t\tF\u0001\u000bDC\u000eD\u0017N\\4P\u0003V$\bNM*feZL7-\u001a\u0006\u0003#I\taa\\1vi\"\u0014$BA\n\u0015\u0003!\u0019XmY;sSRL(BA\u000b\u0017\u0003\t)\u0018N\u0003\u0002\u00181\u0005Ya.^:tW:\f7m[3s\u0015\tI\"$\u0001\u0003u_V\\'\"A\u000e\u0002\u0005Ad7\u0001A\u000b\u0004=-*4\u0003\u0002\u0001 Km\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0014(SQj\u0011\u0001E\u0005\u0003QA\u0011QbT!vi\"\u00144+\u001a:wS\u000e,\u0007C\u0001\u0016,\u0019\u0001!Q\u0001\f\u0001C\u00025\u0012A\"V:fe&sgm\u001c#bi\u0006\f\"AL\u0019\u0011\u0005\u0001z\u0013B\u0001\u0019\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\t\u001a\n\u0005M\n#aA!osB\u0011!&\u000e\u0003\u0006m\u0001\u0011\ra\u000e\u0002\u0012\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8ECR\f\u0017C\u0001\u00189!\t1\u0013(\u0003\u0002;!\t9r*Q;uQJ\nU\u000f\u001e5pe&T\u0018\r^5p]\u0012\u000bG/\u0019\t\u0003y\rk\u0011!\u0010\u0006\u0003}}\nAb]2bY\u0006dwnZ4j]\u001eT!\u0001Q!\u0002\u0011QL\b/Z:bM\u0016T\u0011AQ\u0001\u0004G>l\u0017B\u0001#>\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0011\u0011,G.Z4bi\u0016\fQbY8oM&<WO]1uS>t\u0007C\u0001\u0014I\u0013\tI\u0005CA\nP\u0003V$\bNM\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004uS\u000e\\WM\u001d\t\u0003\u0019Vk\u0011!\u0014\u0006\u0003\u001d>\u000bQaY1dQ\u0016T!\u0001U)\u0002\u0011\r\fgMZ3j]\u0016T!AU*\u0002\u0011\t,g.\\1oKNT!\u0001V!\u0002\r\u001dLG\u000f[;c\u0013\t1VJ\u0001\u0004US\u000e\\WM]\u0001\u0003K\u000e\u0004\"!\u0017/\u000e\u0003iS!aW\u0011\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002^5\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0001\u001cG-\u001a\u000b\u0003C\n\u0004BA\n\u0001*i!)q+\u0002a\u00021\")Q)\u0002a\u0001K!)a)\u0002a\u0001\u000f\"9!*\u0002I\u0001\u0002\u0004Y\u0015aE1vi\"|'/\u001b>bi&|gn]\"bG\",W#\u00015\u0011\t%|\u0017\u000f`\u0007\u0002U*\u0011aj\u001b\u0006\u0003Y6\fA!\u001e;jY*\u0011aNF\u0001\u0007K:<\u0017N\\3\n\u0005AT'\u0001\u0004#fM\u0006,H\u000e^\"bG\",\u0007C\u0001:z\u001d\t\u0019x\u000f\u0005\u0002uC5\tQO\u0003\u0002w9\u00051AH]8pizJ!\u0001_\u0011\u0002\rA\u0013X\rZ3g\u0013\tQ8P\u0001\u0004TiJLgn\u001a\u0006\u0003q\u0006\u0002B\u0001I?*\u007f&\u0011a0\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005!A/[7f\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011q!\u00138ti\u0006tG/\u0001\u000bbkRDwN]5{CRLwN\\:DC\u000eDW\rI\u0001\u001f_\n$\u0018-\u001b8BkRDwN]5{CRLwN\\!oIV\u001bXM]%oM>$b!!\u0006\u0002\u001e\u0005\u0005\u0002#B-\u0002\u0018\u0005m\u0011bAA\r5\n1a)\u001e;ve\u0016\u0004B\u0001I?5S!1\u0011q\u0004\u0005A\u0002E\f\u0011#Y;uQ>\u0014\u0018N_1uS>t7i\u001c3f\u0011\u0019\t\u0019\u0003\u0003a\u0001c\u0006Y!/\u001a3je\u0016\u001cG/\u0016:j\u0003\r\u001a\u0007.Z2l\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8B]\u0012|%\r^1j]V\u001bXM]5oM>$B!!\u000b\u00024A)\u0011,a\u0006\u0002,A)\u0001%`\u0015\u0002.A!\u0001%a\f\u0000\u0013\r\t\t$\t\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005U\u0012\u00021\u0001r\u0003-\t7mY3tgR{7.\u001a8\u00023\u0011,g-Y;mi\u0016C\b/\u001b:bi&|g\u000eR;sCRLwN\\\u000b\u0003\u0003w\u0001B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003R\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\u0005\u0015\u0013q\b\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003Q\u0019\u0015m\u00195j]\u001e|\u0015)\u001e;ieM+'O^5dKB\u0011a\u0005D\n\u0003\u0019}!\"!!\u0013\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\t\u0019&!\u001b\u0002lU\u0011\u0011Q\u000b\u0016\u0004\u0017\u0006]3FAA-!\u0011\tY&!\u001a\u000e\u0005\u0005u#\u0002BA0\u0003C\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r\u0014%\u0001\u0006b]:|G/\u0019;j_:LA!a\u001a\u0002^\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b1r!\u0019A\u0017\u0005\u000bYr!\u0019A\u001c")
public class CachingOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData>
implements OAuth2Service<UserInfoData, AuthorizationData>,
LazyLogging {
    private FiniteDuration defaultExpirationDuration;
    private final OAuth2Service<UserInfoData, AuthorizationData> delegate;
    private OAuth2Configuration configuration;
    private final ExecutionContext ec;
    private final DefaultCache<String, Tuple2<UserInfoData, Instant>> authorizationsCache;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static <UserInfoData, AuthorizationData extends OAuth2AuthorizationData> Ticker $lessinit$greater$default$3() {
        return CachingOAuth2Service$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger$lzycompute() {
        CachingOAuth2Service cachingOAuth2Service = this;
        synchronized (cachingOAuth2Service) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public DefaultCache<String, Tuple2<UserInfoData, Instant>> authorizationsCache() {
        return this.authorizationsCache;
    }

    @Override
    public Future<Tuple2<AuthorizationData, UserInfoData>> obtainAuthorizationAndUserInfo(String authorizationCode, String redirectUri) {
        return this.delegate.obtainAuthorizationAndUserInfo(authorizationCode, redirectUri).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                OAuth2AuthorizationData authorization = (OAuth2AuthorizationData)tuple2._1();
                Object userInfo = tuple2._2();
                FiniteDuration expirationDuration = (FiniteDuration)authorization.expirationPeriod().getOrElse((Function0 & Serializable)() -> this.defaultExpirationDuration());
                this.authorizationsCache().put((Object)authorization.accessToken(), (Object)new Tuple2(userInfo, (Object)Instant.now().plusNanos(expirationDuration.toNanos())));
                return new Tuple2((Object)authorization, userInfo);
            }
            throw new MatchError((Object)tuple2);
        }, this.ec);
    }

    @Override
    public Future<Tuple2<UserInfoData, Option<Instant>>> checkAuthorizationAndObtainUserinfo(String accessToken) {
        Future future;
        Option option = this.authorizationsCache().get((Object)accessToken);
        if (option instanceof Some) {
            Some some = (Some)option;
            Tuple2 value = (Tuple2)some.value();
            future = Future$.MODULE$.successful((Object)value);
        } else if (None$.MODULE$.equals(option)) {
            future = this.delegate.checkAuthorizationAndObtainUserinfo(accessToken).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option expirationInstant;
                    Instant expiration;
                    Object userInfo = tuple2._1();
                    Tuple2 value = new Tuple2(userInfo, (Object)(expiration = (Instant)(expirationInstant = (Option)tuple2._2()).getOrElse((Function0 & Serializable)() -> Instant.now().plusNanos(this.defaultExpirationDuration().toNanos()))));
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.authorizationsCache().put((Object)accessToken, (Object)value));
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Failed to populate cache.", exception);
                        }
                    } else if (try_ instanceof Success) {
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return value;
                }
                throw new MatchError((Object)tuple2);
            }, this.ec);
        } else {
            throw new MatchError((Object)option);
        }
        Future userInfo = future;
        return userInfo.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object userInfo = tuple2._1();
                Instant expiration = (Instant)tuple2._2();
                return new Tuple2(userInfo, (Object)new Some((Object)expiration));
            }
            throw new MatchError((Object)tuple2);
        }, this.ec);
    }

    private FiniteDuration defaultExpirationDuration$lzycompute() {
        CachingOAuth2Service cachingOAuth2Service = this;
        synchronized (cachingOAuth2Service) {
            if (!this.bitmap$0) {
                this.defaultExpirationDuration = this.configuration.defaultTokenExpirationDuration();
                this.bitmap$0 = true;
            }
        }
        this.configuration = null;
        return this.defaultExpirationDuration;
    }

    private FiniteDuration defaultExpirationDuration() {
        if (!this.bitmap$0) {
            return this.defaultExpirationDuration$lzycompute();
        }
        return this.defaultExpirationDuration;
    }

    public CachingOAuth2Service(OAuth2Service<UserInfoData, AuthorizationData> delegate, OAuth2Configuration configuration, Ticker ticker, ExecutionContext ec) {
        this.delegate = delegate;
        this.configuration = configuration;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.authorizationsCache = new DefaultCache(CacheConfig$.MODULE$.apply(new ExpiryConfig<String, Tuple2<UserInfoData, Instant>>(null){

            public Option expireAfterAccessFn(Object k, Object v, Deadline now) {
                return ExpiryConfig.expireAfterAccessFn$((ExpiryConfig)this, (Object)k, (Object)v, (Deadline)now);
            }

            public Option<Deadline> expireAfterWriteFn(String key, Tuple2<UserInfoData, Instant> value, Deadline now) {
                return new Some((Object)Deadline$.MODULE$.now().$plus(FiniteDuration$.MODULE$.apply(Duration.between(Instant.now(), (Temporal)value._2()).toNanos(), TimeUnit.NANOSECONDS)));
            }
            {
                ExpiryConfig.$init$((ExpiryConfig)this);
            }
        }), ticker);
    }
}

