/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2.jwt;

import cats.data.Validated;
import cats.implicits$;
import cats.syntax.EitherOps$;
import io.circe.Decoder;
import io.circe.Json;
import java.io.Serializable;
import java.security.Key;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import pdi.jwt.JwtCirce$;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtOptions$;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ErrorHandler;
import pl.touk.nussknacker.ui.security.oauth2.jwt.ParsedJwtToken;
import pl.touk.nussknacker.ui.security.oauth2.jwt.RawJwtToken;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\u0004\b\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006i\u0001!\t!\u000e\u0005\u0006U\u0002!Ia\u001b\u0005\u0006q\u0002!I!\u001f\u0002\r\u0015^$h+\u00197jI\u0006$xN\u001d\u0006\u0003\u0011%\t1A[<u\u0015\tQ1\"\u0001\u0004pCV$\bN\r\u0006\u0003\u00195\t\u0001b]3dkJLG/\u001f\u0006\u0003\u001d=\t!!^5\u000b\u0005A\t\u0012a\u00038vgN\\g.Y2lKJT!AE\n\u0002\tQ|Wo\u001b\u0006\u0002)\u0005\u0011\u0001\u000f\\\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\fW\u0016L\bK]8wS\u0012,'\u000f\u0005\u0003\u0019?\u0005B\u0013B\u0001\u0011\u001a\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002#M5\t1E\u0003\u0002\tI)\tQ%A\u0002qI&L!aJ\u0012\u0003\u0013);H\u000fS3bI\u0016\u0014\bCA\u0015.\u001b\u0005Q#B\u0001\u0007,\u0015\u0005a\u0013\u0001\u00026bm\u0006L!A\f\u0016\u0003\u0007-+\u00170\u0001\u0004=S:LGO\u0010\u000b\u0003cM\u0002\"A\r\u0001\u000e\u0003\u001dAQ!\b\u0002A\u0002y\t!\"\u001b8ue>\u001c\b/Z2u+\t1$\n\u0006\u00028;R\u0011\u0001h\u0015\t\u0005sy\u0002\u0005*D\u0001;\u0015\tYD(\u0001\u0003eCR\f'\"A\u001f\u0002\t\r\fGo]\u0005\u0003\u007fi\u0012\u0011BV1mS\u0012\fG/\u001a3\u0011\u0005\u0005+eB\u0001\"D\u001b\u0005I\u0011B\u0001#\n\u0003Iy\u0015)\u001e;ie\u0015\u0013(o\u001c:IC:$G.\u001a:\n\u0005\u0019;%AD(BkRD'GS<u\u000bJ\u0014xN\u001d\u0006\u0003\t&\u0001\"!\u0013&\r\u0001\u0011)1j\u0001b\u0001\u0019\nYAk\\6f]\u000ec\u0017-[7t#\ti\u0005\u000b\u0005\u0002\u0019\u001d&\u0011q*\u0007\u0002\b\u001d>$\b.\u001b8h!\tA\u0012+\u0003\u0002S3\t\u0019\u0011I\\=\t\u000fQ\u001b\u0011\u0011!a\u0002+\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007Y[\u0006*D\u0001X\u0015\tA\u0016,A\u0003dSJ\u001cWMC\u0001[\u0003\tIw.\u0003\u0002]/\n9A)Z2pI\u0016\u0014\b\"\u00020\u0004\u0001\u0004y\u0016!\u0002;pW\u0016t\u0007C\u00011h\u001d\t\tW\r\u0005\u0002c35\t1M\u0003\u0002e+\u00051AH]8pizJ!AZ\r\u0002\rA\u0013X\rZ3g\u0013\tA\u0017N\u0001\u0004TiJLgn\u001a\u0006\u0003Mf\ta\u0002Z3d_\u0012,Wk]5oO.+\u0017\u0010F\u0002mkZ\u00042!\u001c9s\u001b\u0005q'BA8\u001a\u0003\u0011)H/\u001b7\n\u0005Et'a\u0001+ssB\u0011ak]\u0005\u0003i^\u0013AAS:p]\")a\f\u0002a\u0001?\")q\u000f\u0002a\u0001Q\u0005\u00191.Z=\u00027A\f'o]3e)>\\WM\\,ji\"|W\u000f^*jO:\fG/\u001e:f)\rQ\u0018Q\u0006\t\bw\u0006\u0005\u0011qAA\u0014\u001d\tahP\u0004\u0002c{&\t!$\u0003\u0002\u00003\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0002\u0003\u000b\u0011a!R5uQ\u0016\u0014(BA@\u001a!\u0011\tI!a\t\u000f\u0007\u0005-1I\u0004\u0003\u0002\u000e\u0005\u0005b\u0002BA\b\u0003?qA!!\u0005\u0002\u001e9!\u00111CA\u000e\u001d\u0011\t)\"!\u0007\u000f\u0007\t\f9\"C\u0001\u0015\u0013\t\u00112#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!AC\u0006\n\u0007\u0005\u0015rIA\fP\u0003V$\bN\r&xi\u0012+7m\u001c3f%\u0006<XI\u001d:peB\u0019!'!\u000b\n\u0007\u0005-rA\u0001\bQCJ\u001cX\r\u001a&xiR{7.\u001a8\t\u000by+\u0001\u0019A0")
public class JwtValidator {
    private final Function1<JwtHeader, Key> keyProvider;

    public <TokenClaims> Validated<OAuth2ErrorHandler.OAuth2JwtError, TokenClaims> introspect(String token, Decoder<TokenClaims> evidence$1) {
        return EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(this.parsedTokenWithoutSignature(token).flatMap((Function1 & Serializable)parsedToken -> EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(Try$.MODULE$.apply((Function0 & Serializable)() -> (Key)$this.keyProvider.apply((Object)parsedToken.header())).toEither()), (Function1 & Serializable)x$1 -> new OAuth2ErrorHandler.OAuth2JwtKeyDetermineError((ParsedJwtToken)parsedToken, (Throwable)x$1)).flatMap((Function1 & Serializable)key -> EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(this.decodeUsingKey(token, (Key)key).toEither()), (Function1 & Serializable)x$2 -> new OAuth2ErrorHandler.OAuth2JwtDecodeClaimsError((ParsedJwtToken)parsedToken, (Key)key, (Throwable)x$2)).flatMap((Function1 & Serializable)tokenClaimsJson -> EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(tokenClaimsJson.as(evidence$1)), (Function1 & Serializable)x$3 -> new OAuth2ErrorHandler.OAuth2JwtDecodeClaimsJsonError((ParsedJwtToken)parsedToken, (Key)key, (Json)tokenClaimsJson, (Throwable)x$3)).map((Function1 & Serializable)parsedTokenClaims -> parsedTokenClaims))))));
    }

    private Try<Json> decodeUsingKey(String token, Key key) {
        Key key2 = key;
        if (key2 instanceof PublicKey) {
            PublicKey publicKey = (PublicKey)key2;
            return JwtCirce$.MODULE$.decodeJson(token, publicKey);
        }
        if (key2 instanceof SecretKey) {
            SecretKey secretKey = (SecretKey)key2;
            return JwtCirce$.MODULE$.decodeJson(token, secretKey);
        }
        throw new IllegalArgumentException("Not supported key: " + key2);
    }

    private Either<OAuth2ErrorHandler.OAuth2JwtDecodeRawError, ParsedJwtToken> parsedTokenWithoutSignature(String token) {
        return EitherOps$.MODULE$.bimap$extension(implicits$.MODULE$.catsSyntaxEither(JwtCirce$.MODULE$.decodeAll(token, JwtOptions$.MODULE$.DEFAULT().copy(false, JwtOptions$.MODULE$.DEFAULT().copy$default$2(), JwtOptions$.MODULE$.DEFAULT().copy$default$3(), JwtOptions$.MODULE$.DEFAULT().copy$default$4())).toEither()), (Function1 & Serializable)x$4 -> new OAuth2ErrorHandler.OAuth2JwtDecodeRawError(new RawJwtToken(token), (Throwable)x$4), ((Function3 & Serializable)(Function3 & Serializable)(header, claim, signature) -> new ParsedJwtToken((JwtHeader)header, (JwtClaim)claim, (String)signature)).tupled());
    }

    public JwtValidator(Function1<JwtHeader, Key> keyProvider) {
        this.keyProvider = keyProvider;
    }
}

