/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.api;

import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import java.io.Serializable;
import pl.touk.nussknacker.security.AuthCredentials;
import pl.touk.nussknacker.security.ImpersonatedUserIdentity;
import pl.touk.nussknacker.ui.security.api.AkkaBasedAuthManager;
import pl.touk.nussknacker.ui.security.api.AuthManager$;
import pl.touk.nussknacker.ui.security.api.AuthenticatedUser;
import pl.touk.nussknacker.ui.security.api.AuthenticatedUser$;
import pl.touk.nussknacker.ui.security.api.AuthenticationConfiguration;
import pl.touk.nussknacker.ui.security.api.AuthenticationError;
import pl.touk.nussknacker.ui.security.api.AuthenticationResources;
import pl.touk.nussknacker.ui.security.api.AuthorizationError;
import pl.touk.nussknacker.ui.security.api.CreationError;
import pl.touk.nussknacker.ui.security.api.CreationError$ImpersonationNotAllowed$;
import pl.touk.nussknacker.ui.security.api.ImpersonatedUserData;
import pl.touk.nussknacker.ui.security.api.ImpersonationAuthenticationError;
import pl.touk.nussknacker.ui.security.api.ImpersonationNotSupported$;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.security.api.LoggedUser$;
import pl.touk.nussknacker.ui.security.api.SecurityError$CannotAuthenticateUser$;
import pl.touk.nussknacker.ui.security.api.SecurityError$ImpersonatedUserDataNotFoundError$;
import pl.touk.nussknacker.ui.security.api.SecurityError$ImpersonationMissingPermissionError$;
import pl.touk.nussknacker.ui.security.api.SecurityError$ImpersonationNotSupportedError$;
import pl.touk.nussknacker.ui.security.api.SecurityError$InsufficientPermission$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.tapir.Codec$;
import sttp.tapir.DecodeResult;
import sttp.tapir.EndpointIO;
import sttp.tapir.EndpointInput;
import sttp.tapir.Mapping;
import sttp.tapir.Mapping$;
import sttp.tapir.package$;
import sttp.tapir.typelevel.ParamConcat$;
import sttp.tapir.typelevel.TupleOps;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\r\u001b\u0001\u001dB\u0001B\r\u0001\u0003\u0006\u0004%\tb\r\u0005\to\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003-\u0011\bC\u0003@\u0001\u0011\u0005\u0001\t\u0003\u0005F\u0001!\u0015\r\u0011\"\u0005G\u0011!Q\u0005\u0001#b\u0001\n#Y\u0005\"B0\u0001\t\u0003\u0001\u0007\"\u0002;\u0001\t\u0003)\b\"\u0002@\u0001\t\u0003y\bbBA\n\u0001\u0011%\u0011Q\u0003\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\t9\u0005\u0001C\t\u0003\u0013:q!!\u001b\u001b\u0011\u0003\tYG\u0002\u0004\u001a5!\u0005\u0011Q\u000e\u0005\u0007\u007f9!\t!a\u001c\t\u0013\u0005EdB1A\u0005\u0002\u0005M\u0004\u0002CAB\u001d\u0001\u0006I!!\u001e\u0007\r\u0005\u0015e\"AAD\u0011)\tII\u0005B\u0001B\u0003%\u00111\u0012\u0005\u0007\u007fI!\t!a%\t\u000f\u0005m%\u0003\"\u0001\u0002\u001e\"9\u00111\u0015\n\u0005\n\u0005\u0015\u0006bBA\\%\u0011%\u0011\u0011\u0018\u0005\n\u0003\u0013t\u0011\u0011!C\u0002\u0003\u0017\u00141\"Q;uQ6\u000bg.Y4fe*\u00111\u0004H\u0001\u0004CBL'BA\u000f\u001f\u0003!\u0019XmY;sSRL(BA\u0010!\u0003\t)\u0018N\u0003\u0002\"E\u0005Ya.^:tW:\f7m[3s\u0015\t\u0019C%\u0001\u0003u_V\\'\"A\u0013\u0002\u0005Ad7\u0001A\n\u0004\u0001!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020a5\t!$\u0003\u000225\t!\u0012i[6b\u0005\u0006\u001cX\rZ!vi\"l\u0015M\\1hKJ\fq#Y;uQ\u0016tG/[2bi&|gNU3t_V\u00148-Z:\u0016\u0003Q\u0002\"aL\u001b\n\u0005YR\"aF!vi\",g\u000e^5dCRLwN\u001c*fg>,(oY3t\u0003a\tW\u000f\u001e5f]RL7-\u0019;j_:\u0014Vm]8ve\u000e,7\u000fI\u0001\u0003K\u000e\u0004\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0016\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002?w\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005#EC\u0001\"D!\ty\u0003\u0001C\u00039\t\u0001\u000f\u0011\bC\u00033\t\u0001\u0007A'\u0001\u000fjg\u0006#W.\u001b8J[B,'o]8oCRLwN\u001c)pgNL'\r\\3\u0016\u0003\u001d\u0003\"!\u000b%\n\u0005%S#a\u0002\"p_2,\u0017M\\\u0001\u0014CV$\b.\u001a8uS\u000e\fG/[8o%VdWm]\u000b\u0002\u0019B\u0019Q*\u0016-\u000f\u00059\u001bfBA(S\u001b\u0005\u0001&BA)'\u0003\u0019a$o\\8u}%\t1&\u0003\u0002UU\u00059\u0001/Y2lC\u001e,\u0017B\u0001,X\u0005\u0011a\u0015n\u001d;\u000b\u0005QS\u0003CA-]\u001d\ty#,\u0003\u0002\\5\u0005Y\u0012)\u001e;iK:$\u0018nY1uS>t7i\u001c8gS\u001e,(/\u0019;j_:L!!\u00180\u0003\u0015\r{gNZ5h%VdWM\u0003\u0002\\5\u0005a\u0011-\u001e;iK:$\u0018nY1uKR\u0011\u0011-\u001c\t\u0004u\t$\u0017BA2<\u0005\u00191U\u000f^;sKB!Q*Z4k\u0013\t1wK\u0001\u0004FSRDWM\u001d\t\u0003_!L!!\u001b\u000e\u0003'\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u0016\u0013(o\u001c:\u0011\u0005=Z\u0017B\u00017\u001b\u0005E\tU\u000f\u001e5f]RL7-\u0019;fIV\u001bXM\u001d\u0005\u0006]\u001e\u0001\ra\\\u0001\u0010CV$\bn\u0011:fI\u0016tG/[1mgB\u0011\u0001O]\u0007\u0002c*\u0011Q\u0004I\u0005\u0003gF\u0014q\"Q;uQ\u000e\u0013X\rZ3oi&\fGn]\u0001\u001cCV$\b.\u001a8uS\u000e\fG/[8o\u000b:$\u0007o\\5oi&s\u0007/\u001e;\u0015\u0003Y\u00042a\u001e?p\u001b\u0005A(BA={\u0003\u0015!\u0018\r]5s\u0015\u0005Y\u0018\u0001B:uiBL!! =\u0003\u001b\u0015sG\r]8j]RLe\u000e];u\u0003%\tW\u000f\u001e5pe&TX\r\u0006\u0003\u0002\u0002\u0005=\u0001CB'f\u0003\u0007\tI\u0001E\u00020\u0003\u000bI1!a\u0002\u001b\u0005I\tU\u000f\u001e5pe&T\u0018\r^5p]\u0016\u0013(o\u001c:\u0011\u0007=\nY!C\u0002\u0002\u000ei\u0011!\u0002T8hO\u0016$Wk]3s\u0011\u0019\t\t\"\u0003a\u0001U\u0006!Qo]3s\u0003u\tW\u000f\u001e5f]RL7-\u0019;f/&$\b.S7qKJ\u001cxN\\1uS>tG#B1\u0002\u0018\u0005e\u0002bBA\r\u0015\u0001\u0007\u00111D\u0001!S6\u0004XM]:p]\u0006$\u0018N\\4Vg\u0016\u0014\u0018)\u001e;i\u0007J,G-\u001a8uS\u0006d7\u000f\u0005\u0003\u0002\u001e\u0005Mb\u0002BA\u0010\u0003_qA!!\t\u0002.9!\u00111EA\u0016\u001d\u0011\t)#!\u000b\u000f\u0007=\u000b9#C\u0001&\u0013\t\u0019C%\u0003\u0002\"E%\u0011Q\u0004I\u0005\u0004\u0003c\t\u0018aD!vi\"\u001c%/\u001a3f]RL\u0017\r\\:\n\t\u0005U\u0012q\u0007\u0002\u0016!\u0006\u001c8/\u001a3BkRD7I]3eK:$\u0018.\u00197t\u0015\r\t\t$\u001d\u0005\b\u0003wQ\u0001\u0019AA\u001f\u0003aIW\u000e]3sg>t\u0017\r^3e+N,'/\u00133f]RLG/\u001f\t\u0004a\u0006}\u0012bAA!c\nA\u0012*\u001c9feN|g.\u0019;fIV\u001bXM]%eK:$\u0018\u000e^=\u0002?\u0005,H\u000f[3oi&\u001c\u0017\r^3XSRD\u0017I\\8os6|Wo]!dG\u0016\u001c8\u000fF\u0001b\u0003MA\u0017M\u001c3mK&k\u0007/\u001a:t_:\fG/[8o)\u0019\tY%a\u0015\u0002XA)Q*ZA'UB\u0019q&a\u0014\n\u0007\u0005E#D\u0001\u0011J[B,'o]8oCRLwN\\!vi\",g\u000e^5dCRLwN\\#se>\u0014\bBBA+\u0019\u0001\u0007!.A\tj[B,'o]8oCRLgnZ+tKJDq!a\u000f\r\u0001\u0004\tI\u0006\u0005\u0003\u0002\\\u0005\rd\u0002BA/\u0003?\u0002\"a\u0014\u0016\n\u0007\u0005\u0005$&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\n9G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003CR\u0013aC!vi\"l\u0015M\\1hKJ\u0004\"a\f\b\u0014\u00059ACCAA6\u0003UIW\u000e]3sg>t\u0017\r^3IK\u0006$WM\u001d(b[\u0016,\"!!\u001e\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005!A.\u00198h\u0015\t\ty(\u0001\u0003kCZ\f\u0017\u0002BA3\u0003s\na#[7qKJ\u001cxN\\1uK\"+\u0017\rZ3s\u001d\u0006lW\r\t\u0002&\u00136\u0004XM]:p]\u0006$\u0018n\u001c8D_:\u001c\u0018\u000eZ3sS:<\u0017J\u001c9vi\u0016sG\r]8j]R\u001c\"A\u0005\u0015\u0002\u0015UtG-\u001a:ms&tw\r\u0005\u0003xy\u00065\u0005#B\u0015\u0002\u0010\u0006m\u0011bAAIU\t1q\n\u001d;j_:$B!!&\u0002\u001aB\u0019\u0011q\u0013\n\u000e\u00039Aq!!#\u0015\u0001\u0004\tY)A\rxSRD\u0007k\\:tS\ndW-S7qKJ\u001cxN\\1uS>tGc\u0001<\u0002 \"1\u0011\u0011U\u000bA\u0002\u001d\u000ba#\u00198p]flw.^:BG\u000e,7o]#oC\ndW\rZ\u0001!S6\u0004XM]:p]\u0006$\u0018n\u001c8IK\u0006$WM]#oIB|\u0017N\u001c;J]B,H/\u0006\u0002\u0002(B1\u0011\u0011VAX\u0003ks1a^AV\u0013\r\ti\u000b_\u0001\u000b\u000b:$\u0007o\\5oi&{\u0015\u0002BAY\u0003g\u0013a\u0001S3bI\u0016\u0014(bAAWqB)\u0011&a$\u0002Z\u0005\tS.\u00199qK\u0012\fU\u000f\u001e5f]RL7-\u0019;j_:,e\u000e\u001a9pS:$\u0018J\u001c9viR!\u00111XAd!\u00199\u0018QXAa_&\u0019\u0011q\u0018=\u0003\u000f5\u000b\u0007\u000f]5oOB9\u0011&a1\u0002\u000e\u0006U\u0016bAAcU\t1A+\u001e9mKJBa!!)\u0018\u0001\u00049\u0015!J%na\u0016\u00148o\u001c8bi&|gnQ8og&$WM]5oO&s\u0007/\u001e;F]\u0012\u0004x.\u001b8u)\u0011\t)*!4\t\u000f\u0005%\u0005\u00041\u0001\u0002\f\u0002")
public class AuthManager
implements AkkaBasedAuthManager {
    private boolean isAdminImpersonationPossible;
    private List<AuthenticationConfiguration.ConfigRule> authenticationRules;
    private final AuthenticationResources authenticationResources;
    private final ExecutionContext ec;
    private volatile byte bitmap$0;

    public static ImpersonationConsideringInputEndpoint ImpersonationConsideringInputEndpoint(EndpointInput<Option<AuthCredentials.PassedAuthCredentials>> underlying) {
        return AuthManager$.MODULE$.ImpersonationConsideringInputEndpoint(underlying);
    }

    public static String impersonateHeaderName() {
        return AuthManager$.MODULE$.impersonateHeaderName();
    }

    @Override
    public Directive<Tuple1<AuthenticatedUser>> authenticate() {
        return AkkaBasedAuthManager.authenticate$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> authorizeRoute(AuthenticatedUser user, Function1<LoggedUser, Function1<RequestContext, Future<RouteResult>>> secureRoute) {
        return AkkaBasedAuthManager.authorizeRoute$(this, user, secureRoute);
    }

    public AuthenticationResources authenticationResources() {
        return this.authenticationResources;
    }

    private boolean isAdminImpersonationPossible$lzycompute() {
        AuthManager authManager = this;
        synchronized (authManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.isAdminImpersonationPossible = this.authenticationResources().configuration().isAdminImpersonationPossible();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.isAdminImpersonationPossible;
    }

    public boolean isAdminImpersonationPossible() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.isAdminImpersonationPossible$lzycompute();
        }
        return this.isAdminImpersonationPossible;
    }

    private List<AuthenticationConfiguration.ConfigRule> authenticationRules$lzycompute() {
        AuthManager authManager = this;
        synchronized (authManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.authenticationRules = this.authenticationResources().configuration().rules();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.authenticationRules;
    }

    public List<AuthenticationConfiguration.ConfigRule> authenticationRules() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.authenticationRules$lzycompute();
        }
        return this.authenticationRules;
    }

    public Future<Either<AuthenticationError, AuthenticatedUser>> authenticate(AuthCredentials authCredentials) {
        AuthCredentials authCredentials2 = authCredentials;
        if (AuthCredentials.NoCredentialsProvided$.MODULE$.equals(authCredentials2)) {
            return this.authenticateWithAnonymousAccess();
        }
        if (authCredentials2 instanceof AuthCredentials.PassedAuthCredentials) {
            AuthCredentials.PassedAuthCredentials passedAuthCredentials = (AuthCredentials.PassedAuthCredentials)authCredentials2;
            return this.authenticationResources().authenticate(passedAuthCredentials).map((Function1 & Serializable)x$1 -> x$1.toRight((Function0 & Serializable)() -> SecurityError$CannotAuthenticateUser$.MODULE$), this.ec);
        }
        if (authCredentials2 instanceof AuthCredentials.ImpersonatedAuthCredentials) {
            AuthCredentials.ImpersonatedAuthCredentials impersonatedAuthCredentials = (AuthCredentials.ImpersonatedAuthCredentials)authCredentials2;
            AuthCredentials.PassedAuthCredentials impersonatingUserAuthCredentials = impersonatedAuthCredentials.impersonatingUserCredentials();
            ImpersonatedUserIdentity impersonatedUserIdentity = impersonatedAuthCredentials.impersonatedUserIdentity();
            return this.authenticateWithImpersonation(impersonatingUserAuthCredentials, impersonatedUserIdentity);
        }
        throw new MatchError((Object)authCredentials2);
    }

    public EndpointInput<AuthCredentials> authenticationEndpointInput() {
        return AuthManager$.MODULE$.ImpersonationConsideringInputEndpoint(this.authenticationResources().authenticationMethod()).withPossibleImpersonation(this.authenticationResources().getAnonymousRole().isDefined());
    }

    public Either<AuthorizationError, LoggedUser> authorize(AuthenticatedUser user) {
        if (user.roles().nonEmpty()) {
            return LoggedUser$.MODULE$.create(user, this.authenticationRules(), this.isAdminImpersonationPossible()).left().map((Function1 & Serializable)x0$1 -> {
                CreationError creationError = x0$1;
                if (CreationError$ImpersonationNotAllowed$.MODULE$.equals(creationError)) {
                    return SecurityError$ImpersonationMissingPermissionError$.MODULE$;
                }
                throw new MatchError((Object)creationError);
            });
        }
        return scala.package$.MODULE$.Left().apply((Object)SecurityError$InsufficientPermission$.MODULE$);
    }

    private Future<Either<AuthenticationError, AuthenticatedUser>> authenticateWithImpersonation(AuthCredentials.PassedAuthCredentials impersonatingUserAuthCredentials, ImpersonatedUserIdentity impersonatedUserIdentity) {
        return this.authenticationResources().authenticate(impersonatingUserAuthCredentials).map((Function1 & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                AuthenticatedUser impersonatingUser = (AuthenticatedUser)some.value();
                return this.handleImpersonation(impersonatingUser, impersonatedUserIdentity.value());
            }
            if (None$.MODULE$.equals(option)) {
                return scala.package$.MODULE$.Left().apply((Object)SecurityError$CannotAuthenticateUser$.MODULE$);
            }
            throw new MatchError((Object)option);
        }, this.ec);
    }

    private Future<Either<AuthenticationError, AuthenticatedUser>> authenticateWithAnonymousAccess() {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> this.authenticationResources().getAnonymousRole().map((Function1 & Serializable)role -> AuthenticatedUser$.MODULE$.createAnonymousUser((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{role}))))).toRight((Function0 & Serializable)() -> SecurityError$CannotAuthenticateUser$.MODULE$), this.ec);
    }

    public Either<ImpersonationAuthenticationError, AuthenticatedUser> handleImpersonation(AuthenticatedUser impersonatingUser, String impersonatedUserIdentity) {
        Left left;
        ImpersonationNotSupported$ impersonationNotSupported$;
        Either<ImpersonationNotSupported$, Option<ImpersonatedUserData>> either = this.authenticationResources().impersonationSupport().getImpersonatedUserDataWithSupportCheck(impersonatedUserIdentity);
        if (either instanceof Right) {
            Right right = (Right)either;
            Option maybeImpersonatedUserData = (Option)right.value();
            Option option = maybeImpersonatedUserData;
            if (option instanceof Some) {
                Some some = (Some)option;
                ImpersonatedUserData impersonatedUserData = (ImpersonatedUserData)some.value();
                return scala.package$.MODULE$.Right().apply((Object)AuthenticatedUser$.MODULE$.createImpersonatedUser(impersonatingUser, impersonatedUserData));
            }
            if (None$.MODULE$.equals(option)) {
                return scala.package$.MODULE$.Left().apply((Object)SecurityError$ImpersonatedUserDataNotFoundError$.MODULE$);
            }
            throw new MatchError((Object)option);
        }
        if (either instanceof Left && ImpersonationNotSupported$.MODULE$.equals(impersonationNotSupported$ = (ImpersonationNotSupported$)(left = (Left)either).value())) {
            return scala.package$.MODULE$.Left().apply((Object)SecurityError$ImpersonationNotSupportedError$.MODULE$);
        }
        throw new MatchError(either);
    }

    public AuthManager(AuthenticationResources authenticationResources, ExecutionContext ec) {
        this.authenticationResources = authenticationResources;
        this.ec = ec;
        AkkaBasedAuthManager.$init$(this);
    }

    public static class ImpersonationConsideringInputEndpoint {
        private final EndpointInput<Option<AuthCredentials.PassedAuthCredentials>> underlying;

        public EndpointInput<AuthCredentials> withPossibleImpersonation(boolean anonymousAccessEnabled) {
            return (EndpointInput)this.underlying.and(this.impersonationHeaderEndpointInput(), ParamConcat$.MODULE$.concatSingleAndSingle(TupleOps.Join$.MODULE$.join(TupleOps.FoldLeft$.MODULE$.t1(TupleOps.Join$.Fold$.MODULE$.step(TupleOps.AppendOne$.MODULE$.append1()))))).map(this.mappedAuthenticationEndpointInput(anonymousAccessEnabled));
        }

        private EndpointIO.Header<Option<String>> impersonationHeaderEndpointInput() {
            return package$.MODULE$.header(AuthManager$.MODULE$.impersonateHeaderName(), Codec$.MODULE$.listHeadOption(Codec$.MODULE$.string()));
        }

        private Mapping<Tuple2<Option<AuthCredentials.PassedAuthCredentials>, Option<String>>, AuthCredentials> mappedAuthenticationEndpointInput(boolean anonymousAccessEnabled) {
            return Mapping$.MODULE$.fromDecode((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option2 = (Option)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        AuthCredentials.PassedAuthCredentials passedCredentials = (AuthCredentials.PassedAuthCredentials)some.value();
                        if (None$.MODULE$.equals(option2)) {
                            return new DecodeResult.Value((Object)passedCredentials);
                        }
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option3 = (Option)tuple2._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        AuthCredentials.PassedAuthCredentials passedCredentials = (AuthCredentials.PassedAuthCredentials)some.value();
                        if (option3 instanceof Some) {
                            Some some2 = (Some)option3;
                            String identity = (String)some2.value();
                            return new DecodeResult.Value((Object)new AuthCredentials.ImpersonatedAuthCredentials(passedCredentials, new ImpersonatedUserIdentity(identity)));
                        }
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option4 = (Option)tuple2._2();
                    if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option4) && !anonymousAccessEnabled) {
                        return DecodeResult.Missing$.MODULE$;
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option5 = (Option)tuple2._2();
                    if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option5)) {
                        return new DecodeResult.Value((Object)AuthCredentials.NoCredentialsProvided$.MODULE$);
                    }
                }
                if (tuple2 != null) {
                    Option option = (Option)tuple2._1();
                    Option option6 = (Option)tuple2._2();
                    if (None$.MODULE$.equals(option) && option6 instanceof Some) {
                        return DecodeResult.Missing$.MODULE$;
                    }
                }
                throw new MatchError((Object)tuple2);
            }, (Function1 & Serializable)x0$2 -> {
                AuthCredentials authCredentials = x0$2;
                if (authCredentials instanceof AuthCredentials.PassedAuthCredentials) {
                    AuthCredentials.PassedAuthCredentials passedAuthCredentials = (AuthCredentials.PassedAuthCredentials)authCredentials;
                    String value = passedAuthCredentials.value();
                    return new Tuple2((Object)new Some((Object)new AuthCredentials.PassedAuthCredentials(value)), (Object)None$.MODULE$);
                }
                if (AuthCredentials.NoCredentialsProvided$.MODULE$.equals(authCredentials)) {
                    return new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                }
                if (authCredentials instanceof AuthCredentials.ImpersonatedAuthCredentials) {
                    AuthCredentials.ImpersonatedAuthCredentials impersonatedAuthCredentials = (AuthCredentials.ImpersonatedAuthCredentials)authCredentials;
                    AuthCredentials.PassedAuthCredentials impersonating = impersonatedAuthCredentials.impersonatingUserCredentials();
                    ImpersonatedUserIdentity impersonatedUserIdentity = impersonatedAuthCredentials.impersonatedUserIdentity();
                    return new Tuple2((Object)new Some((Object)impersonating), (Object)new Some((Object)impersonatedUserIdentity.value()));
                }
                throw new MatchError((Object)authCredentials);
            });
        }

        public ImpersonationConsideringInputEndpoint(EndpointInput<Option<AuthCredentials.PassedAuthCredentials>> underlying) {
            this.underlying = underlying;
        }
    }
}

