/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.ssl;

import akka.http.scaladsl.ConnectionContext$;
import akka.http.scaladsl.HttpsConnectionContext;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import pl.touk.nussknacker.ui.security.ssl.KeyStoreConfig;

public final class HttpsConnectionContextFactory$ {
    public static final HttpsConnectionContextFactory$ MODULE$ = new HttpsConnectionContextFactory$();

    public HttpsConnectionContext createServerContext(KeyStoreConfig keyStoreConfig) {
        SSLContext sslContext = this.prepareSSLContext(keyStoreConfig);
        return ConnectionContext$.MODULE$.httpsServer(sslContext);
    }

    public HttpsConnectionContext createClientContext(KeyStoreConfig keyStoreConfig) {
        SSLContext sslContext = this.prepareSSLContext(keyStoreConfig);
        return ConnectionContext$.MODULE$.httpsClient(sslContext);
    }

    public SSLContext prepareSSLContext(KeyStoreConfig keyStoreConfig) {
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(keyStoreConfig.uri().toURL().openStream(), keyStoreConfig.password());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(ks, keyStoreConfig.password());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ks);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private HttpsConnectionContextFactory$() {
    }
}

