/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import com.github.benmanes.caffeine.cache.Ticker;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.concurrent.TimeUnit;
import pl.touk.nussknacker.engine.util.cache.CacheConfig$;
import pl.touk.nussknacker.engine.util.cache.DefaultCache;
import pl.touk.nussknacker.engine.util.cache.ExpiryConfig;
import pl.touk.nussknacker.ui.security.oauth2.CachingOAuth2Service$;
import pl.touk.nussknacker.ui.security.oauth2.IntrospectedAccessTokenData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\t\u0013\u0001}A\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\t\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005W\u0001\t\u0005\t\u0015a\u0003X\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u001d)\u0007A1A\u0005\u0012\u0019Dq!!\u0004\u0001A\u0003%q\rC\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!A\u0011Q\u0007\u0001\u0005BI\t9\u0004\u0003\u0005\u0002D\u0001!\tEEA#\u0011)\ty\u0005\u0001EC\u0002\u0013%\u0011\u0011K\u0004\n\u0003?\u0012\u0012\u0011!E\u0001\u0003C2\u0001\"\u0005\n\u0002\u0002#\u0005\u00111\r\u0005\u0007;:!\t!a\u001b\t\u0013\u00055d\"%A\u0005\u0002\u0005=$\u0001F\"bG\"LgnZ(BkRD'gU3sm&\u001cWM\u0003\u0002\u0014)\u00051q.Y;uQJR!!\u0006\f\u0002\u0011M,7-\u001e:jifT!a\u0006\r\u0002\u0005UL'BA\r\u001b\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005ma\u0012\u0001\u0002;pk.T\u0011!H\u0001\u0003a2\u001c\u0001!F\u0002!OQ\u001a2\u0001A\u0011;!\u0011\u00113%J\u001a\u000e\u0003II!\u0001\n\n\u0003\u001b=\u000bU\u000f\u001e53'\u0016\u0014h/[2f!\t1s\u0005\u0004\u0001\u0005\u000b!\u0002!\u0019A\u0015\u0003\u0019U\u001bXM]%oM>$\u0015\r^1\u0012\u0005)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#a\u0002(pi\"Lgn\u001a\t\u0003WEJ!A\r\u0017\u0003\u0007\u0005s\u0017\u0010\u0005\u0002'i\u0011)Q\u0007\u0001b\u0001m\t\t\u0012)\u001e;i_JL'0\u0019;j_:$\u0015\r^1\u0012\u0005):\u0004C\u0001\u00129\u0013\tI$CA\fP\u0003V$\bNM!vi\"|'/\u001b>bi&|g\u000eR1uCB\u00111HQ\u0007\u0002y)\u0011QHP\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u007f\u0001\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0003\u0006\u00191m\\7\n\u0005\rc$a\u0003'bufdunZ4j]\u001e\f\u0001\u0002Z3mK\u001e\fG/Z\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005\t:\u0015B\u0001%\u0013\u0005My\u0015)\u001e;ie\r{gNZ5hkJ\fG/[8o\u0003\u0019!\u0018nY6feB\u00111\nV\u0007\u0002\u0019*\u0011QJT\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0003\u001fB\u000b\u0001bY1gM\u0016Lg.\u001a\u0006\u0003#J\u000b\u0001BY3o[\u0006tWm\u001d\u0006\u0003'\u0002\u000baaZ5uQV\u0014\u0017BA+M\u0005\u0019!\u0016nY6fe\u0006\u0011Qm\u0019\t\u00031nk\u0011!\u0017\u0006\u000352\n!bY8oGV\u0014(/\u001a8u\u0013\ta\u0016L\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"Ba\u00182dIR\u0011\u0001-\u0019\t\u0005E\u0001)3\u0007C\u0003W\u000b\u0001\u000fq\u000bC\u0003E\u000b\u0001\u0007\u0011\u0005C\u0003F\u000b\u0001\u0007a\tC\u0004J\u000bA\u0005\t\u0019\u0001&\u0002'\u0005,H\u000f[8sSj\fG/[8og\u000e\u000b7\r[3\u0016\u0003\u001d\u0004B\u0001\u001b8qw6\t\u0011N\u0003\u0002NU*\u00111\u000e\\\u0001\u0005kRLGN\u0003\u0002n1\u00051QM\\4j]\u0016L!a\\5\u0003\u0019\u0011+g-Y;mi\u000e\u000b7\r[3\u0011\u0005EDhB\u0001:w!\t\u0019H&D\u0001u\u0015\t)h$\u0001\u0004=e>|GOP\u0005\u0003o2\na\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011q\u000f\f\t\u0005Wq,c0\u0003\u0002~Y\t1A+\u001e9mKJ\u00022a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001\u0002;j[\u0016T!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\tAA\u0004J]N$\u0018M\u001c;\u0002)\u0005,H\u000f[8sSj\fG/[8og\u000e\u000b7\r[3!\u0003\u0019z'\r^1j]\u0006+H\u000f[8sSj\fG/[8o\u0003:$\u0017)\u001e;iK:$\u0018nY1uKV\u001bXM\u001d\u000b\u0007\u0003'\tY\"a\b\u0011\u000ba\u000b)\"!\u0007\n\u0007\u0005]\u0011L\u0001\u0004GkR,(/\u001a\t\u0005Wq\u001cT\u0005\u0003\u0004\u0002\u001e!\u0001\r\u0001]\u0001\u0012CV$\bn\u001c:ju\u0006$\u0018n\u001c8D_\u0012,\u0007BBA\u0011\u0011\u0001\u0007\u0001/A\u0006sK\u0012L'/Z2u+JL\u0017!J2iK\u000e\\\u0017)\u001e;i_JL'0\u0019;j_:\fe\u000eZ!vi\",g\u000e^5dCR,Wk]3s)\u0011\t9#!\r\u0011\u000ba\u000b)\"!\u000b\u0011\u000b-bX%a\u000b\u0011\t-\niC`\u0005\u0004\u0003_a#AB(qi&|g\u000e\u0003\u0004\u00024%\u0001\r\u0001]\u0001\fC\u000e\u001cWm]:U_.,g.A\u000bj]R\u0014xn\u001d9fGR\f5mY3tgR{7.\u001a8\u0015\t\u0005e\u0012\u0011\t\t\u00061\u0006U\u00111\b\t\u0004E\u0005u\u0012bAA %\tY\u0012J\u001c;s_N\u0004Xm\u0019;fI\u0006\u001b7-Z:t)>\\WM\u001c#bi\u0006Da!a\r\u000b\u0001\u0004\u0001\u0018\u0001E1vi\",g\u000e^5dCR,Wk]3s)\u0019\t9%!\u0013\u0002LA!\u0001,!\u0006&\u0011\u0019\t\u0019d\u0003a\u0001a\"9\u0011QJ\u0006A\u0002\u0005m\u0012aD1dG\u0016\u001c8\u000fV8lK:$\u0015\r^1\u00023\u0011,g-Y;mi\u0016C\b/\u001b:bi&|g\u000eR;sCRLwN\\\u000b\u0003\u0003'\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033J\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\u0005u\u0013q\u000b\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003Q\u0019\u0015m\u00195j]\u001e|\u0015)\u001e;ieM+'O^5dKB\u0011!ED\n\u0004\u001d\u0005\u0015\u0004cA\u0016\u0002h%\u0019\u0011\u0011\u000e\u0017\u0003\r\u0005s\u0017PU3g)\t\t\t'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0007\u0003c\n9)!#\u0016\u0005\u0005M$f\u0001&\u0002v-\u0012\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00022\n!\"\u00198o_R\fG/[8o\u0013\u0011\t))a\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003)!\t\u0007\u0011\u0006B\u00036!\t\u0007a\u0007")
public class CachingOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData>
extends OAuth2Service<UserInfoData, AuthorizationData>
implements LazyLogging {
    private FiniteDuration defaultExpirationDuration;
    private final OAuth2Service<UserInfoData, AuthorizationData> delegate;
    private OAuth2Configuration configuration;
    private final ExecutionContext ec;
    private final DefaultCache<String, Tuple2<UserInfoData, Instant>> authorizationsCache;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static <UserInfoData, AuthorizationData extends OAuth2AuthorizationData> Ticker $lessinit$greater$default$3() {
        return CachingOAuth2Service$.MODULE$.$lessinit$greater$default$3();
    }

    private Logger logger$lzycompute() {
        CachingOAuth2Service cachingOAuth2Service = this;
        synchronized (cachingOAuth2Service) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public DefaultCache<String, Tuple2<UserInfoData, Instant>> authorizationsCache() {
        return this.authorizationsCache;
    }

    @Override
    public Future<Tuple2<AuthorizationData, UserInfoData>> obtainAuthorizationAndAuthenticateUser(String authorizationCode, String redirectUri) {
        return this.delegate.obtainAuthorizationAndAuthenticateUser(authorizationCode, redirectUri).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                OAuth2AuthorizationData authorization = (OAuth2AuthorizationData)tuple2._1();
                Object userInfo = tuple2._2();
                FiniteDuration expirationDuration = (FiniteDuration)authorization.expirationPeriod().getOrElse((Function0 & Serializable)() -> this.defaultExpirationDuration());
                this.authorizationsCache().put((Object)authorization.accessToken(), (Object)new Tuple2(userInfo, (Object)Instant.now().plusNanos(expirationDuration.toNanos())));
                return new Tuple2((Object)authorization, userInfo);
            }
            throw new MatchError((Object)tuple2);
        }, this.ec);
    }

    @Override
    public Future<Tuple2<UserInfoData, Option<Instant>>> checkAuthorizationAndAuthenticateUser(String accessToken) {
        Future future;
        Option option = this.authorizationsCache().get((Object)accessToken);
        if (option instanceof Some) {
            Some some = (Some)option;
            Tuple2 value = (Tuple2)some.value();
            future = Future$.MODULE$.successful((Object)value);
        } else if (None$.MODULE$.equals(option)) {
            future = this.delegate.checkAuthorizationAndAuthenticateUser(accessToken).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Option expirationInstant;
                    Instant expiration;
                    Object userInfo = tuple2._1();
                    Tuple2 value = new Tuple2(userInfo, (Object)(expiration = (Instant)(expirationInstant = (Option)tuple2._2()).getOrElse((Function0 & Serializable)() -> Instant.now().plusNanos(this.defaultExpirationDuration().toNanos()))));
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.authorizationsCache().put((Object)accessToken, (Object)value));
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Failed to populate cache.", exception);
                        }
                    } else if (try_ instanceof Success) {
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    return value;
                }
                throw new MatchError((Object)tuple2);
            }, this.ec);
        } else {
            throw new MatchError((Object)option);
        }
        Future userInfo = future;
        return userInfo.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object userInfo = tuple2._1();
                Instant expiration = (Instant)tuple2._2();
                return new Tuple2(userInfo, (Object)new Some((Object)expiration));
            }
            throw new MatchError((Object)tuple2);
        }, this.ec);
    }

    @Override
    public Future<IntrospectedAccessTokenData> introspectAccessToken(String accessToken) {
        return this.delegate.introspectAccessToken(accessToken);
    }

    @Override
    public Future<UserInfoData> authenticateUser(String accessToken, IntrospectedAccessTokenData accessTokenData) {
        return this.delegate.authenticateUser(accessToken, accessTokenData);
    }

    private FiniteDuration defaultExpirationDuration$lzycompute() {
        CachingOAuth2Service cachingOAuth2Service = this;
        synchronized (cachingOAuth2Service) {
            if (!this.bitmap$0) {
                this.defaultExpirationDuration = this.configuration.defaultTokenExpirationDuration();
                this.bitmap$0 = true;
            }
        }
        this.configuration = null;
        return this.defaultExpirationDuration;
    }

    private FiniteDuration defaultExpirationDuration() {
        if (!this.bitmap$0) {
            return this.defaultExpirationDuration$lzycompute();
        }
        return this.defaultExpirationDuration;
    }

    public CachingOAuth2Service(OAuth2Service<UserInfoData, AuthorizationData> delegate, OAuth2Configuration configuration, Ticker ticker, ExecutionContext ec) {
        this.delegate = delegate;
        this.configuration = configuration;
        this.ec = ec;
        super(ec);
        LazyLogging.$init$((LazyLogging)this);
        this.authorizationsCache = new DefaultCache(CacheConfig$.MODULE$.apply(new ExpiryConfig<String, Tuple2<UserInfoData, Instant>>(null){

            public Option expireAfterAccessFn(Object k, Object v, Deadline now) {
                return ExpiryConfig.expireAfterAccessFn$((ExpiryConfig)this, (Object)k, (Object)v, (Deadline)now);
            }

            public Option<Deadline> expireAfterWriteFn(String key, Tuple2<UserInfoData, Instant> value, Deadline now) {
                return new Some((Object)Deadline$.MODULE$.now().$plus(FiniteDuration$.MODULE$.apply(Duration.between(Instant.now(), (Temporal)value._2()).toNanos(), TimeUnit.NANOSECONDS)));
            }
            {
                ExpiryConfig.$init$((ExpiryConfig)this);
            }
        }), ticker);
    }
}

