/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import io.circe.Decoder;
import java.io.Serializable;
import java.security.Key;
import java.security.PublicKey;
import java.util.NoSuchElementException;
import pdi.jwt.JwtHeader;
import pl.touk.nussknacker.ui.security.oauth2.BaseOAuth2Service;
import pl.touk.nussknacker.ui.security.oauth2.IntrospectedAccessTokenData;
import pl.touk.nussknacker.ui.security.oauth2.JwtStandardClaims;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ClientApi;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ErrorHandler;
import pl.touk.nussknacker.ui.security.oauth2.jwt.JwtValidator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001\u0002\b\u0010\u0001qA\u0011\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ#\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0004\u0003\u0006Ya\u0013\u0005\t5\u0002\u0011\t\u0011)A\u00067\")\u0011\r\u0001C\u0001E\"9\u0011\u000e\u0001b\u0001\n#Q\u0007B\u00028\u0001A\u0003%1\u000e\u0003\u0005p\u0001!\u0015\r\u0011\"\u0005q\u0011\u00159\b\u0001\"\u0005y\u0011!\t\u0019\u0003\u0001C!\u001f\u0005\u0015\u0002bBA\u001a\u0001\u0011%\u0011Q\u0007\u0005\b\u0003w\u0001A\u0011CA\u001f\u0011\u001d\t\t\u0005\u0001C)\u0003\u0007\u0012\u0001CS<u\u001f\u0006+H\u000f\u001b\u001aTKJ4\u0018nY3\u000b\u0005A\t\u0012AB8bkRD'G\u0003\u0002\u0013'\u0005A1/Z2ve&$\u0018P\u0003\u0002\u0015+\u0005\u0011Q/\u001b\u0006\u0003-]\t1B\\;tg.t\u0017mY6fe*\u0011\u0001$G\u0001\u0005i>,8NC\u0001\u001b\u0003\t\u0001Hn\u0001\u0001\u0016\tu!\u0013\u0007V\n\u0004\u0001y9\u0004\u0003B\u0010!EAj\u0011aD\u0005\u0003C=\u0011\u0011CQ1tK>\u000bU\u000f\u001e53'\u0016\u0014h/[2f!\t\u0019C\u0005\u0004\u0001\u0005\u000b\u0015\u0002!\u0019\u0001\u0014\u0003\u0019U\u001bXM]%oM>$\u0015\r^1\u0012\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#a\u0002(pi\"Lgn\u001a\t\u0003Q9J!aL\u0015\u0003\u0007\u0005s\u0017\u0010\u0005\u0002$c\u0011)!\u0007\u0001b\u0001g\t\t\u0012)\u001e;i_JL'0\u0019;j_:$\u0015\r^1\u0012\u0005\u001d\"\u0004CA\u00106\u0013\t1tBA\fP\u0003V$\bNM!vi\"|'/\u001b>bi&|g\u000eR1uCB\u0011\u0001hP\u0007\u0002s)\u0011!hO\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003yu\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002}\u0005\u00191m\\7\n\u0005\u0001K$a\u0003'bufdunZ4j]\u001e\f\u0011b\u00197jK:$\u0018\t]5\u0011\t}\u0019%\u0005M\u0005\u0003\t>\u0011qbT!vi\"\u00144\t\\5f]R\f\u0005/[\u0005\u0003\u0003\u0002\nQbY8oM&<WO]1uS>t\u0007CA\u0010I\u0013\tIuBA\nP\u0003V$\bNM\"p]\u001aLw-\u001e:bi&|g.\u0001\u0006fm&$WM\\2fIE\u00022\u0001T)T\u001b\u0005i%B\u0001(P\u0003\u0015\u0019\u0017N]2f\u0015\u0005\u0001\u0016AA5p\u0013\t\u0011VJA\u0004EK\u000e|G-\u001a:\u0011\u0005\r\"F!B+\u0001\u0005\u00041&!E!dG\u0016\u001c8\u000fV8lK:\u001cE.Y5ngF\u0011qe\u0016\t\u0003?aK!!W\b\u0003#);Ho\u0015;b]\u0012\f'\u000fZ\"mC&l7/\u0001\u0002fGB\u0011AlX\u0007\u0002;*\u0011a,K\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00011^\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004G\u001eDGc\u00013fMB)q\u0004\u0001\u00121'\")!*\u0002a\u0002\u0017\")!,\u0002a\u00027\")\u0011)\u0002a\u0001\u0005\")a)\u0002a\u0001\u000f\u0006\u0001\u0012mY2fgN$vn[3o\u0013NTu\u000f^\u000b\u0002WB\u0011\u0001\u0006\\\u0005\u0003[&\u0012qAQ8pY\u0016\fg.A\tbG\u000e,7o\u001d+pW\u0016t\u0017j\u001d&xi\u0002\nAB[<u-\u0006d\u0017\u000eZ1u_J,\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i>\t1A[<u\u0013\t18O\u0001\u0007KoR4\u0016\r\\5eCR|'/\u0001\nj]R\u0014xn\u001d9fGRTu\u000f\u001e+pW\u0016tWCA=\u0000)\rQ\u0018\u0011\u0002\u000b\u0004w\u0006\r\u0001c\u0001/}}&\u0011Q0\u0018\u0002\u0007\rV$XO]3\u0011\u0005\rzHABA\u0001\u0013\t\u0007aE\u0001\u0004DY\u0006LWn\u001d\u0005\n\u0003\u000bI\u0011\u0011!a\u0002\u0003\u000f\t!\"\u001a<jI\u0016t7-\u001a\u00133!\ra\u0015K \u0005\b\u0003\u0017I\u0001\u0019AA\u0007\u0003\u0015!xn[3o!\u0011\ty!!\b\u000f\t\u0005E\u0011\u0011\u0004\t\u0004\u0003'ISBAA\u000b\u0015\r\t9bG\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005m\u0011&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037I\u0013!F5oiJ|7\u000f]3di\u0006\u001b7-Z:t)>\\WM\u001c\u000b\u0005\u0003O\ty\u0003\u0005\u0003]y\u0006%\u0002cA\u0010\u0002,%\u0019\u0011QF\b\u00037%sGO]8ta\u0016\u001cG/\u001a3BG\u000e,7o\u001d+pW\u0016tG)\u0019;b\u0011\u001d\t\tD\u0003a\u0001\u0003\u001b\t1\"Y2dKN\u001cHk\\6f]\u0006Ib/\u001a:jMf\f5mY3tgR{7.\u001a8Bk\u0012LWM\\2f)\u0011\tI#a\u000e\t\r\u0005e2\u00021\u0001T\u0003\u0019\u0019G.Y5ng\u0006\u0011Bo\\%oiJ|7\u000f]3di\u0016$G)\u0019;b)\u0011\tI#a\u0010\t\r\u0005eB\u00021\u0001T\u0003My'\r^1j]\u0006+H\u000f[8sSj\fG/[8o)\u0019\t)%a\u0012\u0002LA\u0019A\f \u0019\t\u000f\u0005%S\u00021\u0001\u0002\u000e\u0005\t\u0012-\u001e;i_JL'0\u0019;j_:\u001cu\u000eZ3\t\u000f\u00055S\u00021\u0001\u0002\u000e\u0005Y!/\u001a3je\u0016\u001cG/\u0016:j\u0001")
public class JwtOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData, AccessTokenClaims extends JwtStandardClaims>
extends BaseOAuth2Service<UserInfoData, AuthorizationData> {
    private JwtValidator jwtValidator;
    private final OAuth2Configuration configuration;
    private final Decoder<AccessTokenClaims> evidence$1;
    private final ExecutionContext ec;
    private final boolean accessTokenIsJwt;
    private volatile boolean bitmap$0;

    public boolean accessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    private JwtValidator jwtValidator$lzycompute() {
        JwtOAuth2Service jwtOAuth2Service = this;
        synchronized (jwtOAuth2Service) {
            if (!this.bitmap$0) {
                this.jwtValidator = new JwtValidator((Function1<JwtHeader, Key>)(Function1 & Serializable)x$4 -> (PublicKey)$this.configuration.jwt().flatMap((Function1 & Serializable)x$5 -> x$5.authServerPublicKey()).getOrElse((Function0 & Serializable)() -> {
                    throw new NoSuchElementException("JWT configuration not found");
                }));
                this.bitmap$0 = true;
            }
        }
        return this.jwtValidator;
    }

    public JwtValidator jwtValidator() {
        if (!this.bitmap$0) {
            return this.jwtValidator$lzycompute();
        }
        return this.jwtValidator;
    }

    public <Claims> Future<Claims> introspectJwtToken(String token, Decoder<Claims> evidence$2) {
        Validated<OAuth2ErrorHandler.OAuth2JwtError, Claims> validated = this.jwtValidator().introspect(token, evidence$2);
        if (validated instanceof Validated.Valid) {
            Validated.Valid valid = (Validated.Valid)validated;
            Object claims = valid.a();
            return Future$.MODULE$.successful(claims);
        }
        if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            OAuth2ErrorHandler.OAuth2JwtError jwtError = (OAuth2ErrorHandler.OAuth2JwtError)invalid.e();
            return Future$.MODULE$.failed((Throwable)new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.one((Object)jwtError)));
        }
        throw new MatchError(validated);
    }

    @Override
    public Future<IntrospectedAccessTokenData> introspectAccessToken(String accessToken) {
        if (this.accessTokenIsJwt()) {
            return this.introspectJwtToken(accessToken, this.evidence$1).map((Function1 & Serializable)claims -> this.verifyAccessTokenAudience(claims), this.ec);
        }
        return super.introspectAccessToken(accessToken);
    }

    private IntrospectedAccessTokenData verifyAccessTokenAudience(AccessTokenClaims claims) {
        boolean bl = false;
        Some some = null;
        Option option = this.configuration.jwt().flatMap((Function1 & Serializable)x$6 -> x$6.audience());
        if (None$.MODULE$.equals(option)) {
            return this.toIntrospectedData(claims);
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String requiredAudience = (String)some.value();
            if (claims.audienceAsList().contains((Object)requiredAudience)) {
                return this.toIntrospectedData(claims);
            }
        }
        if (bl) {
            String requiredAudience = (String)some.value();
            throw new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.one((Object)new OAuth2ErrorHandler.OAuth2AccessTokenRejection("Invalid audience claim: " + claims.audienceAsList().mkString(",") + " - it should contains " + requiredAudience)));
        }
        throw new MatchError((Object)option);
    }

    public IntrospectedAccessTokenData toIntrospectedData(AccessTokenClaims claims) {
        return new IntrospectedAccessTokenData(claims.subject(), claims.expirationTime(), (Set<String>)Predef$.MODULE$.Set().empty());
    }

    @Override
    public Future<AuthorizationData> obtainAuthorization(String authorizationCode, String redirectUri) {
        return super.clientApi().accessTokenRequest(authorizationCode, redirectUri).andThen((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ JwtOAuth2Service $outer;

            public final <A1 extends Try<AuthorizationData>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    OAuth2AuthorizationData authorization = (OAuth2AuthorizationData)success.value();
                    if (this.$outer.accessTokenIsJwt()) {
                        return (B1)this.$outer.introspectAccessToken(authorization.accessToken());
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Try<AuthorizationData> x1) {
                Try<AuthorizationData> try_ = x1;
                return try_ instanceof Success && this.$outer.accessTokenIsJwt();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.ec);
    }

    public JwtOAuth2Service(OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi, OAuth2Configuration configuration, Decoder<AccessTokenClaims> evidence$1, ExecutionContext ec) {
        this.configuration = configuration;
        this.evidence$1 = evidence$1;
        this.ec = ec;
        super(clientApi, ec);
        this.accessTokenIsJwt = configuration.jwt().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.accessTokenIsJwt()));
    }
}

