/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.circe.Decoder;
import java.io.Serializable;
import java.time.Instant;
import pl.touk.nussknacker.ui.security.oauth2.BaseOAuth2Service$;
import pl.touk.nussknacker.ui.security.oauth2.DefaultOAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ClientApi;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ErrorHandler;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Service;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import sttp.client.SttpBackend;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001B\b\u0011\u0001uA\u0001\"\u0012\u0001\u0003\u0006\u0004%\tB\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u000f\"A1\n\u0001B\u0001B\u0003-A\nC\u0003S\u0001\u0011\u00051\u000bC\u0003Y\u0001\u0011\u0015\u0011\fC\u0003p\u0001\u0011\u0015\u0001\u000fC\u0004\u0002\u0002\u0001!\t\"a\u0001\t\u000f\u0005-\u0001\u0001\"\u0005\u0002\u000e!9\u00111\u0003\u0001\u0005\u0012\u0005U\u0001bBA\n\u0001\u0011E\u0011QD\u0004\b\u0003C\u0001\u0002\u0012AA\u0012\r\u0019y\u0001\u0003#\u0001\u0002&!1!\u000b\u0004C\u0001\u0003OAq!!\u000b\r\t\u0003\tYCA\tCCN,w*Q;uQJ\u001aVM\u001d<jG\u0016T!!\u0005\n\u0002\r=\fW\u000f\u001e53\u0015\t\u0019B#\u0001\u0005tK\u000e,(/\u001b;z\u0015\t)b#\u0001\u0002vS*\u0011q\u0003G\u0001\f]V\u001c8o\u001b8bG.,'O\u0003\u0002\u001a5\u0005!Ao\\;l\u0015\u0005Y\u0012A\u00019m\u0007\u0001)2AH\u00166'\u0011\u0001q$J\u001e\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\u00111s%\u000b\u001b\u000e\u0003AI!\u0001\u000b\t\u0003\u001b=\u000bU\u000f\u001e53'\u0016\u0014h/[2f!\tQ3\u0006\u0004\u0001\u0005\u000b1\u0002!\u0019A\u0017\u0003\u0019U\u001bXM]%oM>$\u0015\r^1\u0012\u00059\n\u0004C\u0001\u00110\u0013\t\u0001\u0014EA\u0004O_RD\u0017N\\4\u0011\u0005\u0001\u0012\u0014BA\u001a\"\u0005\r\te.\u001f\t\u0003UU\"QA\u000e\u0001C\u0002]\u0012\u0011#Q;uQ>\u0014\u0018N_1uS>tG)\u0019;b#\tq\u0003\b\u0005\u0002's%\u0011!\b\u0005\u0002\u0018\u001f\u0006+H\u000f\u001b\u001aBkRDwN]5{CRLwN\u001c#bi\u0006\u0004\"\u0001P\"\u000e\u0003uR!AP \u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0001\u000b\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\t\u000b1aY8n\u0013\t!UHA\u0006MCjLHj\\4hS:<\u0017!C2mS\u0016tG/\u00119j+\u00059\u0005\u0003\u0002\u0014ISQJ!!\u0013\t\u0003\u001f=\u000bU\u000f\u001e53\u00072LWM\u001c;Ba&\f!b\u00197jK:$\u0018\t]5!\u0003\t)7\r\u0005\u0002N!6\taJ\u0003\u0002PC\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Es%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0011Ak\u0016\u000b\u0003+Z\u0003BA\n\u0001*i!)1\n\u0002a\u0002\u0019\")Q\t\u0002a\u0001\u000f\u0006qrN\u0019;bS:\fU\u000f\u001e5pe&T\u0018\r^5p]\u0006sG-V:fe&sgm\u001c\u000b\u00045\u0002l\u0007cA'\\;&\u0011AL\u0014\u0002\u0007\rV$XO]3\u0011\t\u0001rF'K\u0005\u0003?\u0006\u0012a\u0001V;qY\u0016\u0014\u0004\"B1\u0006\u0001\u0004\u0011\u0017!E1vi\"|'/\u001b>bi&|gnQ8eKB\u00111M\u001b\b\u0003I\"\u0004\"!Z\u0011\u000e\u0003\u0019T!a\u001a\u000f\u0002\rq\u0012xn\u001c;?\u0013\tI\u0017%\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA5\"\u0011\u0015qW\u00011\u0001c\u0003-\u0011X\rZ5sK\u000e$XK]5\u0002G\rDWmY6BkRDwN]5{CRLwN\\!oI>\u0013G/Y5o+N,'/\u001b8g_R\u0011\u0011O \t\u0004\u001bn\u0013\b\u0003\u0002\u0011_SM\u00042\u0001\t;w\u0013\t)\u0018E\u0001\u0004PaRLwN\u001c\t\u0003orl\u0011\u0001\u001f\u0006\u0003sj\fA\u0001^5nK*\t10\u0001\u0003kCZ\f\u0017BA?y\u0005\u001dIen\u001d;b]RDQa \u0004A\u0002\t\f1\"Y2dKN\u001cHk\\6f]\u0006\u0019rN\u0019;bS:\fU\u000f\u001e5pe&T\u0018\r^5p]R1\u0011QAA\u0004\u0003\u0013\u00012!T.5\u0011\u0015\tw\u00011\u0001c\u0011\u0015qw\u00011\u0001c\u0003UIg\u000e\u001e:pgB,7\r^!dG\u0016\u001c8\u000fV8lK:$B!a\u0004\u0002\u0012A\u0019QjW:\t\u000b}D\u0001\u0019\u00012\u0002\u001d=\u0014G/Y5o+N,'/\u00138g_R!\u0011qCA\r!\ri5,\u000b\u0005\u0007\u00037I\u0001\u0019\u0001\u001b\u0002#\u0005,H\u000f[8sSj\fG/[8o\t\u0006$\u0018\r\u0006\u0003\u0002\u0018\u0005}\u0001\"B@\u000b\u0001\u0004\u0011\u0017!\u0005\"bg\u0016|\u0015)\u001e;ieM+'O^5dKB\u0011a\u0005D\n\u0003\u0019}!\"!a\t\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u00055\u0012Q\u0007\u000b\u0005\u0003_\ty\b\u0006\u0005\u00022\u0005u\u0012\u0011KA*!\u00191\u0003!a\r\u00028A\u0019!&!\u000e\u0005\u000b1r!\u0019A\u0017\u0011\u0007\u0019\nI$C\u0002\u0002<A\u0011a\u0004R3gCVdGoT!vi\"\u0014\u0014)\u001e;i_JL'0\u0019;j_:$\u0015\r^1\t\u0013\u0005}b\"!AA\u0004\u0005\u0005\u0013AC3wS\u0012,gnY3%cA1\u00111IA'\u0003gi!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0006G&\u00148-\u001a\u0006\u0003\u0003\u0017\n!![8\n\t\u0005=\u0013Q\t\u0002\b\t\u0016\u001cw\u000eZ3s\u0011\u0015Ye\u0002q\u0001M\u0011\u001d\t)F\u0004a\u0002\u0003/\nqAY1dW\u0016tG\rE\u0005\u0002Z\u0005\r\u0014q\r\u0018\u0002j5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u0003C\nAa\u001d;ua&!\u0011QMA.\u0005-\u0019F\u000f\u001e9CC\u000e\\WM\u001c3\u0011\u00055[\u0006\u0003BA6\u0003srA!!\u001c\u0002v9!\u0011qNA:\u001d\r)\u0017\u0011O\u0005\u0003\u0003CJA!!\u0018\u0002`%!\u0011qOA.\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001f\u0002~\tAaj\u001c;iS:<GK\u0003\u0003\u0002x\u0005m\u0003bBAA\u001d\u0001\u0007\u00111Q\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0007\u0019\n))C\u0002\u0002\bB\u00111cT!vi\"\u00144i\u001c8gS\u001e,(/\u0019;j_:\u0004")
public class BaseOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData>
implements OAuth2Service<UserInfoData, AuthorizationData>,
LazyLogging {
    private final OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static <UserInfoData> BaseOAuth2Service<UserInfoData, DefaultOAuth2AuthorizationData> apply(OAuth2Configuration configuration, Decoder<UserInfoData> evidence$1, ExecutionContext ec, SttpBackend<Future, Nothing$, ?> backend) {
        return BaseOAuth2Service$.MODULE$.apply(configuration, evidence$1, ec, backend);
    }

    private Logger logger$lzycompute() {
        BaseOAuth2Service baseOAuth2Service = this;
        synchronized (baseOAuth2Service) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi() {
        return this.clientApi;
    }

    @Override
    public final Future<Tuple2<AuthorizationData, UserInfoData>> obtainAuthorizationAndUserInfo(String authorizationCode, String redirectUri) {
        return this.obtainAuthorization(authorizationCode, redirectUri).flatMap((Function1 & Serializable)authorizationData -> this.obtainUserInfo(authorizationData).map((Function1 & Serializable)userInfo -> new Tuple2(authorizationData, userInfo), $this.ec), this.ec);
    }

    @Override
    public final Future<Tuple2<UserInfoData, Option<Instant>>> checkAuthorizationAndObtainUserinfo(String accessToken) {
        return this.introspectAccessToken(accessToken).flatMap((Function1 & Serializable)expirationInstant -> this.obtainUserInfo(accessToken).map((Function1 & Serializable)userInfo -> new Tuple2(userInfo, expirationInstant), $this.ec), this.ec);
    }

    public Future<AuthorizationData> obtainAuthorization(String authorizationCode, String redirectUri) {
        return this.clientApi().accessTokenRequest(authorizationCode, redirectUri);
    }

    public Future<Option<Instant>> introspectAccessToken(String accessToken) {
        return Future$.MODULE$.failed((Throwable)new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.one((Object)new OAuth2ErrorHandler.OAuth2AccessTokenRejection("The access token cannot be validated"))));
    }

    public Future<UserInfoData> obtainUserInfo(AuthorizationData authorizationData) {
        return this.obtainUserInfo(authorizationData.accessToken());
    }

    public Future<UserInfoData> obtainUserInfo(String accessToken) {
        return this.clientApi().profileRequest(accessToken);
    }

    public BaseOAuth2Service(OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi, ExecutionContext ec) {
        this.clientApi = clientApi;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
    }
}

