/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.security.oauth2;

import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import io.circe.Decoder;
import java.io.Serializable;
import java.security.Key;
import java.security.PublicKey;
import java.time.Instant;
import java.util.NoSuchElementException;
import pdi.jwt.JwtHeader;
import pl.touk.nussknacker.ui.security.oauth2.BaseOAuth2Service;
import pl.touk.nussknacker.ui.security.oauth2.JwtStandardClaims;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2AuthorizationData;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ClientApi;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2Configuration;
import pl.touk.nussknacker.ui.security.oauth2.OAuth2ErrorHandler;
import pl.touk.nussknacker.ui.security.oauth2.jwt.JwtValidator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\b\u0010\u0001qA\u0011\"\u0011\u0001\u0003\u0002\u0003\u0006IAQ#\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0004\u0003\u0006Ya\u0013\u0005\t5\u0002\u0011\t\u0011)A\u00067\")\u0011\r\u0001C\u0001E\"9\u0011\u000e\u0001b\u0001\n#Q\u0007B\u00028\u0001A\u0003%1\u000eC\u0004p\u0001\t\u0007I\u0011\u00039\t\r}\u0004\u0001\u0015!\u0003r\u0011)\t\t\u0001\u0001EC\u0002\u0013E\u00111\u0001\u0005\b\u0003#\u0001A\u0011CA\n\u0011\u001d\ty\u0003\u0001C!\u0003cAq!a\u0013\u0001\t#\niE\u0001\tKoR|\u0015)\u001e;ieM+'O^5dK*\u0011\u0001#E\u0001\u0007_\u0006,H\u000f\u001b\u001a\u000b\u0005I\u0019\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005Q)\u0012AA;j\u0015\t1r#A\u0006okN\u001c8N\\1dW\u0016\u0014(B\u0001\r\u001a\u0003\u0011!x.^6\u000b\u0003i\t!\u0001\u001d7\u0004\u0001U!Q\u0004J\u0019U'\r\u0001ad\u000e\t\u0005?\u0001\u0012\u0003'D\u0001\u0010\u0013\t\tsBA\tCCN,w*Q;uQJ\u001aVM\u001d<jG\u0016\u0004\"a\t\u0013\r\u0001\u0011)Q\u0005\u0001b\u0001M\taQk]3s\u0013:4w\u000eR1uCF\u0011q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\b\u001d>$\b.\u001b8h!\tAc&\u0003\u00020S\t\u0019\u0011I\\=\u0011\u0005\r\nD!\u0002\u001a\u0001\u0005\u0004\u0019$!E!vi\"|'/\u001b>bi&|g\u000eR1uCF\u0011q\u0005\u000e\t\u0003?UJ!AN\b\u0003/=\u000bU\u000f\u001e53\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8ECR\f\u0007C\u0001\u001d@\u001b\u0005I$B\u0001\u001e<\u00031\u00198-\u00197bY><w-\u001b8h\u0015\taT(\u0001\u0005usB,7/\u00194f\u0015\u0005q\u0014aA2p[&\u0011\u0001)\u000f\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-A\u0005dY&,g\u000e^!qSB!qd\u0011\u00121\u0013\t!uBA\bP\u0003V$\bNM\"mS\u0016tG/\u00119j\u0013\t\t\u0005%A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003?!K!!S\b\u0003'=\u000bU\u000f\u001e53\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002M#Nk\u0011!\u0014\u0006\u0003\u001d>\u000bQaY5sG\u0016T\u0011\u0001U\u0001\u0003S>L!AU'\u0003\u000f\u0011+7m\u001c3feB\u00111\u0005\u0016\u0003\u0006+\u0002\u0011\rA\u0016\u0002\u0012\u0003\u000e\u001cWm]:U_.,gn\u00117bS6\u001c\u0018CA\u0014X!\ty\u0002,\u0003\u0002Z\u001f\t\t\"j\u001e;Ti\u0006tG-\u0019:e\u00072\f\u0017.\\:\u0002\u0005\u0015\u001c\u0007C\u0001/`\u001b\u0005i&B\u00010*\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003Av\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\r\u0019w\r\u001b\u000b\u0004I\u00164\u0007#B\u0010\u0001EA\u001a\u0006\"\u0002&\u0006\u0001\bY\u0005\"\u0002.\u0006\u0001\bY\u0006\"B!\u0006\u0001\u0004\u0011\u0005\"\u0002$\u0006\u0001\u00049\u0015\u0001E1dG\u0016\u001c8\u000fV8lK:L5OS<u+\u0005Y\u0007C\u0001\u0015m\u0013\ti\u0017FA\u0004C_>dW-\u00198\u0002#\u0005\u001c7-Z:t)>\\WM\\%t\u0015^$\b%A\u000esKF,\u0018N]3e\u0003\u000e\u001cWm]:U_.,g.Q;eS\u0016t7-Z\u000b\u0002cB\u0019\u0001F\u001d;\n\u0005ML#AB(qi&|g\u000e\u0005\u0002vy:\u0011aO\u001f\t\u0003o&j\u0011\u0001\u001f\u0006\u0003sn\ta\u0001\u0010:p_Rt\u0014BA>*\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mL\u0013\u0001\b:fcVL'/\u001a3BG\u000e,7o\u001d+pW\u0016t\u0017)\u001e3jK:\u001cW\rI\u0001\rU^$h+\u00197jI\u0006$xN]\u000b\u0003\u0003\u000b\u0001B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017y\u0011a\u00016xi&!\u0011qBA\u0005\u00051Qu\u000f\u001e,bY&$\u0017\r^8s\u0003IIg\u000e\u001e:pgB,7\r\u001e&xiR{7.\u001a8\u0016\t\u0005U\u0011\u0011\u0005\u000b\u0005\u0003/\tY\u0003\u0006\u0003\u0002\u001a\u0005\u0015\u0002#\u0002/\u0002\u001c\u0005}\u0011bAA\u000f;\n1a)\u001e;ve\u0016\u00042aIA\u0011\t\u0019\t\u0019c\u0003b\u0001M\t11\t\\1j[ND\u0011\"a\n\f\u0003\u0003\u0005\u001d!!\u000b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0003M#\u0006}\u0001BBA\u0017\u0017\u0001\u0007A/A\u0003u_.,g.A\u000bj]R\u0014xn\u001d9fGR\f5mY3tgR{7.\u001a8\u0015\t\u0005M\u0012q\t\t\u00069\u0006m\u0011Q\u0007\t\u0005QI\f9\u0004\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\tQLW.\u001a\u0006\u0003\u0003\u0003\nAA[1wC&!\u0011QIA\u001e\u0005\u001dIen\u001d;b]RDa!!\u0013\r\u0001\u0004!\u0018aC1dG\u0016\u001c8\u000fV8lK:\f1c\u001c2uC&t\u0017)\u001e;i_JL'0\u0019;j_:$b!a\u0014\u0002R\u0005U\u0003\u0003\u0002/\u0002\u001cABa!a\u0015\u000e\u0001\u0004!\u0018!E1vi\"|'/\u001b>bi&|gnQ8eK\"1\u0011qK\u0007A\u0002Q\f1B]3eSJ,7\r^+sS\u0002")
public class JwtOAuth2Service<UserInfoData, AuthorizationData extends OAuth2AuthorizationData, AccessTokenClaims extends JwtStandardClaims>
extends BaseOAuth2Service<UserInfoData, AuthorizationData> {
    private JwtValidator jwtValidator;
    private final OAuth2Configuration configuration;
    private final Decoder<AccessTokenClaims> evidence$1;
    private final ExecutionContext ec;
    private final boolean accessTokenIsJwt;
    private final Option<String> requiredAccessTokenAudience;
    private volatile boolean bitmap$0;

    public boolean accessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public Option<String> requiredAccessTokenAudience() {
        return this.requiredAccessTokenAudience;
    }

    private JwtValidator jwtValidator$lzycompute() {
        JwtOAuth2Service jwtOAuth2Service = this;
        synchronized (jwtOAuth2Service) {
            if (!this.bitmap$0) {
                this.jwtValidator = new JwtValidator((Function1<JwtHeader, Key>)(Function1 & Serializable)x$5 -> (PublicKey)$this.configuration.jwt().flatMap((Function1 & Serializable)x$6 -> x$6.authServerPublicKey()).getOrElse((Function0 & Serializable)() -> {
                    throw new NoSuchElementException("JWT configuration not found");
                }));
                this.bitmap$0 = true;
            }
        }
        return this.jwtValidator;
    }

    public JwtValidator jwtValidator() {
        if (!this.bitmap$0) {
            return this.jwtValidator$lzycompute();
        }
        return this.jwtValidator;
    }

    public <Claims> Future<Claims> introspectJwtToken(String token, Decoder<Claims> evidence$2) {
        Validated<OAuth2ErrorHandler.OAuth2JwtError, Claims> validated = this.jwtValidator().introspect(token, evidence$2);
        if (validated instanceof Validated.Valid) {
            Validated.Valid valid = (Validated.Valid)validated;
            Object claims = valid.a();
            return Future$.MODULE$.successful(claims);
        }
        if (validated instanceof Validated.Invalid) {
            Validated.Invalid invalid = (Validated.Invalid)validated;
            OAuth2ErrorHandler.OAuth2JwtError jwtError = (OAuth2ErrorHandler.OAuth2JwtError)invalid.e();
            return Future$.MODULE$.failed((Throwable)new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.one((Object)jwtError)));
        }
        throw new MatchError(validated);
    }

    @Override
    public Future<Option<Instant>> introspectAccessToken(String accessToken2) {
        if (this.accessTokenIsJwt()) {
            return Future$.MODULE$.apply((Function0 & Serializable)() -> accessToken2, this.ec).flatMap((Function1 & Serializable)accessToken -> this.introspectJwtToken((String)accessToken, (Decoder)$this.evidence$1), this.ec).flatMap((Function1 & Serializable)claims -> {
                if (this.requiredAccessTokenAudience().isEmpty() || claims.audienceAsList().exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)JwtOAuth2Service.$anonfun$introspectAccessToken$4(this, elem)))) {
                    return Future$.MODULE$.successful(claims.expirationTime());
                }
                return Future$.MODULE$.failed((Throwable)new OAuth2ErrorHandler.OAuth2CompoundException((NonEmptyList<OAuth2ErrorHandler.OAuth2Error>)NonEmptyList$.MODULE$.one((Object)new OAuth2ErrorHandler.OAuth2AccessTokenRejection("Invalid audience claim"))));
            }, this.ec);
        }
        return super.introspectAccessToken(accessToken2);
    }

    @Override
    public Future<AuthorizationData> obtainAuthorization(String authorizationCode, String redirectUri) {
        return super.clientApi().accessTokenRequest(authorizationCode, redirectUri).andThen((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ JwtOAuth2Service $outer;

            public final <A1 extends Try<AuthorizationData>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    OAuth2AuthorizationData authorization = (OAuth2AuthorizationData)success.value();
                    if (this.$outer.accessTokenIsJwt()) {
                        return (B1)this.$outer.introspectAccessToken(authorization.accessToken());
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Try<AuthorizationData> x1) {
                Try<AuthorizationData> try_ = x1;
                return try_ instanceof Success && this.$outer.accessTokenIsJwt();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.ec);
    }

    public static final /* synthetic */ boolean $anonfun$introspectAccessToken$4(JwtOAuth2Service $this, Object elem) {
        return $this.requiredAccessTokenAudience().contains(elem);
    }

    public JwtOAuth2Service(OAuth2ClientApi<UserInfoData, AuthorizationData> clientApi, OAuth2Configuration configuration, Decoder<AccessTokenClaims> evidence$1, ExecutionContext ec) {
        this.configuration = configuration;
        this.evidence$1 = evidence$1;
        this.ec = ec;
        super(clientApi, ec);
        this.accessTokenIsJwt = configuration.jwt().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.accessTokenIsJwt()));
        this.requiredAccessTokenAudience = configuration.jwt().flatMap((Function1 & Serializable)x$4 -> x$4.audience());
    }
}

