/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.sql.db.ignite;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import pl.touk.nussknacker.engine.api.typed.TypedObjectDefinition;
import pl.touk.nussknacker.engine.api.typed.typing;
import pl.touk.nussknacker.sql.db.schema.TableDefinition;
import pl.touk.nussknacker.sql.db.schema.TableDefinition$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005ea\u0001\u0002\u0005\n\u0001YA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006e\u0001!\ta\r\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u0019!\u0005\u0001)A\u0005s!)Q\t\u0001C\u0001\r\")\u0001\u000b\u0001C\u0005#\"9a\u0010AI\u0001\n\u0013y(!E%h]&$X-U;fefDU\r\u001c9fe*\u0011!bC\u0001\u0007S\u001et\u0017\u000e^3\u000b\u00051i\u0011A\u00013c\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003%M\tA\u0001^8vW*\tA#\u0001\u0002qY\u000e\u00011c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0013\u000e\u0003}Q!\u0001I\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\t\u001a\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0011\n1aY8n\u0013\t1sDA\u0006MCjLHj\\4hS:<\u0017!D4fi\u000e{gN\\3di&|g\u000eE\u0002\u0019S-J!AK\r\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u00171\u001b\u0005i#B\u0001\b/\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!M\u0017\u0003\u0015\r{gN\\3di&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003iY\u0002\"!\u000e\u0001\u000e\u0003%AQa\n\u0002A\u0002!\n1\u0003^1cY\u0016\u001c\u0018J\\*dQ\u0016l\u0017-U;fef,\u0012!\u000f\t\u0003u\u0005s!aO \u0011\u0005qJR\"A\u001f\u000b\u0005y*\u0012A\u0002\u001fs_>$h(\u0003\u0002A3\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001\u0015$\u0001\u000buC\ndWm]%o'\u000eDW-\\1Rk\u0016\u0014\u0018\u0010I\u0001\u0010M\u0016$8\r\u001b+bE2,7/T3uCV\tq\t\u0005\u0003;\u0011fR\u0015BA%D\u0005\ri\u0015\r\u001d\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b.\taa]2iK6\f\u0017BA(M\u0005=!\u0016M\u00197f\t\u00164\u0017N\\5uS>t\u0017!F4fi&;g.\u001b;f#V,'/\u001f*fgVdGo]\u000b\u0003%~#Ba\u00159siR\u0011A\u000b\u001b\t\u0004+jkfB\u0001,Y\u001d\tat+C\u0001\u001b\u0013\tI\u0016$A\u0004qC\u000e\\\u0017mZ3\n\u0005mc&\u0001\u0002'jgRT!!W\r\u0011\u0005y{F\u0002\u0001\u0003\u0006A\u001a\u0011\r!\u0019\u0002\u0002)F\u0011!-\u001a\t\u00031\rL!\u0001Z\r\u0003\u000f9{G\u000f[5oOB\u0011\u0001DZ\u0005\u0003Of\u00111!\u00118z\u0011\u0015Ig\u00011\u0001k\u0003\u00051\u0007\u0003\u0002\rl[vK!\u0001\\\r\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0017o\u0013\tyWFA\u0005SKN,H\u000e^*fi\")\u0011O\u0002a\u0001W\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\t\u000bM4\u0001\u0019A\u001d\u0002\u000bE,XM]=\t\u000fU4\u0001\u0013!a\u0001m\u000691/\u001a;Be\u001e\u001c\bcA+[oB!\u0001d\u001b=|!\ta\u00130\u0003\u0002{[\t\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\u0011\u0005aa\u0018BA?\u001a\u0005\u0011)f.\u001b;\u0002?\u001d,G/S4oSR,\u0017+^3ssJ+7/\u001e7ug\u0012\"WMZ1vYR$3'\u0006\u0003\u0002\u0002\u0005]QCAA\u0002U\r1\u0018QA\u0016\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011C\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0005-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)\u0001m\u0002b\u0001C\u0002")
public class IgniteQueryHelper
implements LazyLogging {
    private final Function0<Connection> getConnection;
    private final String tablesInSchemaQuery;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        IgniteQueryHelper igniteQueryHelper = this;
        synchronized (igniteQueryHelper) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private String tablesInSchemaQuery() {
        return this.tablesInSchemaQuery;
    }

    public Map<String, TableDefinition> fetchTablesMeta() {
        return (Map)Using$.MODULE$.resource(this.getConnection.apply(), (Function1 & Serializable)connection -> (Map)this.getIgniteQueryResults((Connection)connection, this.tablesInSchemaQuery(), (List<Function1<PreparedStatement, BoxedUnit>>)new .colon.colon((Function1 & Serializable)x$1 -> {
            x$1.setString(1, connection.getSchema());
            return BoxedUnit.UNIT;
        }, (List)Nil$.MODULE$), (Function1 & Serializable)r -> new Tuple4((Object)r.getString("TABLE_NAME"), (Object)r.getString("COLUMN_NAME"), (Object)r.getString("TYPE"), (Object)BoxesRunTime.boxToBoolean((boolean)r.getBoolean("AFFINITY_COLUMN")))).groupBy((Function1 & Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 != null) {
                String tableName = (String)tuple4._1();
                return tableName;
            }
            throw new MatchError((Object)tuple4);
        }).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String tableName = (String)tuple2._1();
                List entries = (List)tuple2._2();
                List columnTypings = entries.map((Function1 & Serializable)x0$3 -> {
                    Tuple4 tuple4 = x0$3;
                    if (tuple4 != null) {
                        String columnName = (String)tuple4._2();
                        String klassName = (String)tuple4._3();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)typing.Typed$.MODULE$.typedClass(Class.forName(klassName)));
                    }
                    throw new MatchError((Object)tuple4);
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tableName), (Object)TableDefinition$.MODULE$.apply(new TypedObjectDefinition(columnTypings.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
            }
            throw new MatchError((Object)tuple2);
        }), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private <T> List<T> getIgniteQueryResults(Connection connection, String query, List<Function1<PreparedStatement, BoxedUnit>> setArgs, Function1<ResultSet, T> f) {
        return (List)Using$.MODULE$.resource((Object)connection.prepareStatement(query), (Function1 & Serializable)statement -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Executing query: {}", (Object)query);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            setArgs.foreach((Function1 & Serializable)setArg -> {
                setArg.apply((Object)statement);
                return BoxedUnit.UNIT;
            });
            ResultSet resultSet = statement.executeQuery();
            ArrayBuffer arr = ArrayBuffer$.MODULE$.empty();
            while (resultSet.next()) {
                arr.$plus$eq(f.apply((Object)resultSet));
            }
            return arr.toList();
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private <T> List<Function1<PreparedStatement, BoxedUnit>> getIgniteQueryResults$default$3() {
        return Nil$.MODULE$;
    }

    public IgniteQueryHelper(Function0<Connection> getConnection) {
        this.getConnection = getConnection;
        LazyLogging.$init$((LazyLogging)this);
        this.tablesInSchemaQuery = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select t.TABLE_NAME, c.COLUMN_NAME, c.TYPE, c.AFFINITY_COLUMN\n      |from SYS.TABLES t\n      |join SYS.TABLE_COLUMNS c on t.TABLE_NAME = c.TABLE_NAME and t.SCHEMA_NAME = c.SCHEMA_NAME\n      |where t.SCHEMA_NAME = ? and c.COLUMN_NAME not in ('_KEY', '_VAL')\n      |"));
    }
}

