/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.standalone.http.metrics.dropwizard.influxdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.dropwizard.metrics5.influxdb.InfluxDbSender;
import pl.touk.nussknacker.engine.standalone.http.metrics.dropwizard.influxdb.InfluxSenderConfig;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sttp.client.Response;
import sttp.client.SttpBackend;
import sttp.client.TryHttpURLConnectionBackend$;
import sttp.model.StatusCode$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0007\u000f\u0001\u0005B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\b\u000f\u0002\u0011\r\u0011b\u0003I\u0011\u0019Y\u0007\u0001)A\u0005\u0013\"9A\u000e\u0001b\u0001\n\u0013i\u0007B\u0002@\u0001A\u0003%a\u000e\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\t9\u0002\u0001C!\u0003\u0003Aq!!\u0007\u0001\t\u0003\n\t\u0001C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002\u0002\t\u0011\u0012J\u001c4mkb$%\r\u0013;uaN+g\u000eZ3s\u0015\ty\u0001#\u0001\u0005j]\u001adW\u000f\u001f3c\u0015\t\t\"#\u0001\u0006ee>\u0004x/\u001b>be\u0012T!a\u0005\u000b\u0002\u000f5,GO]5dg*\u0011QCF\u0001\u0005QR$\bO\u0003\u0002\u00181\u0005Q1\u000f^1oI\u0006dwN\\3\u000b\u0005eQ\u0012AB3oO&tWM\u0003\u0002\u001c9\u0005Ya.^:tW:\f7m[3s\u0015\tib$\u0001\u0003u_V\\'\"A\u0010\u0002\u0005Ad7\u0001A\n\u0005\u0001\tRC\u0007\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005!A.\u00198h\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\r=\u0013'.Z2u!\tY#'D\u0001-\u0015\tyQF\u0003\u0002/_\u0005AQ.\u001a;sS\u000e\u001cXG\u0003\u0002\u0012a)\t\u0011'\u0001\u0002j_&\u00111\u0007\f\u0002\u000f\u0013:4G.\u001e=EEN+g\u000eZ3s!\t)D(D\u00017\u0015\t9\u0004(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002:u\u0005AA/\u001f9fg\u00064WMC\u0001<\u0003\r\u0019w.\\\u0005\u0003{Y\u00121\u0002T1{s2{wmZ5oO\u0006!1m\u001c8g!\t\u0001\u0015)D\u0001\u000f\u0013\t\u0011eB\u0001\nJ]\u001adW\u000f_*f]\u0012,'oQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002F\rB\u0011\u0001\t\u0001\u0005\u0006}\t\u0001\raP\u0001\bE\u0006\u001c7.\u001a8e+\u0005I\u0005#\u0002&P#fkV\"A&\u000b\u00051k\u0015AB2mS\u0016tGOC\u0001O\u0003\u0011\u0019H\u000f\u001e9\n\u0005A[%aC*uiB\u0014\u0015mY6f]\u0012\u0004\"AU,\u000e\u0003MS!\u0001V+\u0002\tU$\u0018\u000e\u001c\u0006\u0002-\u0006)1oY1mC&\u0011\u0001l\u0015\u0002\u0004)JL\bC\u0001.\\\u001b\u0005)\u0016B\u0001/V\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u00185\u000f\u0005}3gB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u0019\u0007%\u0001\u0004=e>|GOP\u0005\u0002\u001d&\u0011A*T\u0005\u0003O.\u000bq\u0001]1dW\u0006<W-\u0003\u0002jU\nAaj\u001c;iS:<GK\u0003\u0002h\u0017\u0006A!-Y2lK:$\u0007%\u0001\u0004ck\u001a4WM]\u000b\u0002]B\u0019q\u000e\u001e<\u000e\u0003AT!!\u001d:\u0002\u000f5,H/\u00192mK*\u00111/V\u0001\u000bG>dG.Z2uS>t\u0017BA;q\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005]\\hB\u0001=z!\t\tW+\u0003\u0002{+\u00061\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQX+A\u0004ck\u001a4WM\u001d\u0011\u0002\u000f\r|gN\\3diR\u0011\u00111\u0001\t\u00045\u0006\u0015\u0011bAA\u0004+\n!QK\\5u\u0003\u0011\u0019XM\u001c3\u0015\t\u0005\r\u0011Q\u0002\u0005\b\u0003\u001fA\u0001\u0019AA\t\u0003-iW-Y:ve\u0016lWM\u001c;\u0011\u0007\r\n\u0019\"C\u0002\u0002\u0016\u0011\u0012Qb\u0015;sS:<')^5mI\u0016\u0014\u0018!\u00024mkND\u0017A\u00033jg\u000e|gN\\3di\u0006Y\u0011n]\"p]:,7\r^3e)\t\ty\u0002E\u0002[\u0003CI1!a\tV\u0005\u001d\u0011un\u001c7fC:\fQa\u00197pg\u0016\u0004")
public class InfluxDbHttpSender
implements InfluxDbSender,
LazyLogging {
    private final InfluxSenderConfig conf;
    private final SttpBackend<Try, Nothing$, Nothing$> backend;
    private final ArrayBuffer<String> buffer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        InfluxDbHttpSender influxDbHttpSender = this;
        synchronized (influxDbHttpSender) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private SttpBackend<Try, Nothing$, Nothing$> backend() {
        return this.backend;
    }

    private ArrayBuffer<String> buffer() {
        return this.buffer;
    }

    public void connect() {
    }

    public void send(StringBuilder measurement) {
        this.buffer().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{measurement.toString()}));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void flush() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String data = this.buffer().mkString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Sending {} metrics for conf {}", new Object[]{BoxesRunTime.boxToInteger((int)this.buffer().size()), this.conf});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.buffer().clear();
        Try answer = (Try)this.conf.req().body(data).send(this.backend(), Predef.$eq$colon$eq$.MODULE$.tpEquals());
        boolean bl = false;
        Success success = null;
        Try try_ = answer;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Response res = (Response)success.value();
            if (StatusCode$.MODULE$.isSuccess$extension(res.code())) {
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            BoxedUnit boxedUnit4;
            Response res = (Response)success.value();
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Failed to send data to influx: {}, {}", new Object[]{BoxesRunTime.boxToInteger((int)res.code()), res.body()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit4;
            return;
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable ex = failure.exception();
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringBuilder(31).append("Failed to send data to influx: ").append(ex.getMessage()).toString(), ex);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit6 = boxedUnit;
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return true;
    }

    public void close() {
    }

    public InfluxDbHttpSender(InfluxSenderConfig conf) {
        BoxedUnit boxedUnit;
        this.conf = conf;
        LazyLogging.$init$((LazyLogging)this);
        this.backend = TryHttpURLConnectionBackend$.MODULE$.apply(TryHttpURLConnectionBackend$.MODULE$.apply$default$1(), TryHttpURLConnectionBackend$.MODULE$.apply$default$2(), TryHttpURLConnectionBackend$.MODULE$.apply$default$3(), TryHttpURLConnectionBackend$.MODULE$.apply$default$4(), TryHttpURLConnectionBackend$.MODULE$.apply$default$5());
        this.buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("InfluxSender created with url: {}", new Object[]{conf.req().uri()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

