/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.nussknacker.engine.api.Context;
import pl.touk.nussknacker.engine.api.JobData;
import pl.touk.nussknacker.engine.api.Lifecycle;
import pl.touk.nussknacker.engine.api.MetaData;
import pl.touk.nussknacker.engine.api.ProcessListener;
import pl.touk.nussknacker.engine.api.exception.EspExceptionInfo;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.util.Try;

public final class LoggingListener$
implements ProcessListener,
Serializable {
    public static final LoggingListener$ MODULE$;
    private final String className;
    private final ConcurrentHashMap<List<String>, Logger> loggerMap;

    static {
        new LoggingListener$();
    }

    public void open(JobData jobData2) {
        Lifecycle.class.open((Lifecycle)this, (JobData)jobData2);
    }

    public void close() {
        Lifecycle.class.close((Lifecycle)this);
    }

    public String className() {
        return this.className;
    }

    private ConcurrentHashMap<List<String>, Logger> loggerMap() {
        return this.loggerMap;
    }

    private void debug(List<String> keys, Function0<String> message) {
        Logger logger = this.loggerMap().computeIfAbsent(keys, new Function<List<String>, Logger>(){

            public Logger apply(List<String> ks) {
                String loggerKey = ks.mkString(".");
                return LoggerFactory.getLogger((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LoggingListener$.MODULE$.className(), loggerKey})));
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug((String)message.apply());
        }
    }

    public void nodeEntered(String nodeId, Context context, MetaData metadata) {
        this.debug((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{metadata.id(), nodeId})), (Function0<String>)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final Context context$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Node entered. Context: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.context$1}));
            }
            {
                this.context$1 = context$1;
            }
        });
    }

    public void deadEndEncountered(String lastNodeId, Context context, MetaData metadata) {
        this.debug((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{metadata.id(), lastNodeId, "deadEnd"})), (Function0<String>)new Serializable(context){
            public static final long serialVersionUID = 0L;
            private final Context context$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dead end encountered. Context: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.context$2}));
            }
            {
                this.context$2 = context$2;
            }
        });
    }

    public void expressionEvaluated(String nodeId, String expressionId, String expr, Context context, MetaData metadata, Object result) {
        this.debug((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{metadata.id(), nodeId, "expression"})), (Function0<String>)new Serializable(expr, context, result){
            public static final long serialVersionUID = 0L;
            private final String expr$1;
            private final Context context$3;
            private final Object result$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invoked expression: ", " with result ", ". Context: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.expr$1, this.result$1, this.context$3}));
            }
            {
                this.expr$1 = expr$1;
                this.context$3 = context$3;
                this.result$1 = result$1;
            }
        });
    }

    public void serviceInvoked(String nodeId, String id, Context context, MetaData metadata, Map<String, Object> params, Try<Object> result) {
        this.debug((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{metadata.id(), nodeId, "service", id})), (Function0<String>)new Serializable(context, result){
            public static final long serialVersionUID = 0L;
            private final Context context$4;
            private final Try result$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invocation ended-up with result: ", ". Context: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.result$2, this.context$4}));
            }
            {
                this.context$4 = context$4;
                this.result$2 = result$2;
            }
        });
    }

    public void sinkInvoked(String nodeId, String id, Context context, MetaData metadata, Object param) {
        this.debug((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{metadata.id(), nodeId, "sink", id})), (Function0<String>)new Serializable(context, param){
            public static final long serialVersionUID = 0L;
            private final Context context$5;
            private final Object param$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sink invoked with param: ", ". Context: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.param$1, this.context$5}));
            }
            {
                this.context$5 = context$5;
                this.param$1 = param$1;
            }
        });
    }

    public void exceptionThrown(EspExceptionInfo<? extends Throwable> exceptionInfo) {
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LoggingListener$() {
        MODULE$ = this;
        Lifecycle.class.$init$((Lifecycle)this);
        this.className = (String)new StringOps(Predef$.MODULE$.augmentString(this.getClass().getName())).init();
        this.loggerMap = new ConcurrentHashMap();
    }
}

