/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util.functions;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import pl.touk.nussknacker.engine.api.Documentation;
import pl.touk.nussknacker.engine.api.ParamName;

public final class date$ {
    public static date$ MODULE$;
    private final DateTimeFormatter format;

    static {
        new date$();
    }

    private DateTimeFormatter format() {
        return this.format;
    }

    @Documentation(description="Current time")
    public LocalDateTime now() {
        return LocalDateTime.now();
    }

    @Documentation(description="Current timestamp")
    public long nowTimestamp() {
        return System.currentTimeMillis();
    }

    @Documentation(description="Parse date in ISO format (e.g. '2018-11-12T11:22:33') to timestamp")
    public long parseToTimestamp(@ParamName(value="dateString") String dateString) {
        return this.localDateTimeToEpochMillis(this.parseToLocalDate(dateString));
    }

    @Documentation(description="Parse date in ISO format (e.g. '2018-11-12T11:22:33') to date object")
    public LocalDateTime parseToLocalDate(@ParamName(value="dateString") String dateString) {
        return LocalDateTime.parse(dateString, this.format());
    }

    @Documentation(description="Parse date in ISO format (e.g. '2018-11-12T11:22:33+02[Europe/Warsaw]') to date object")
    public ZonedDateTime parseToZonedDate(@ParamName(value="dateString") String dateString) {
        return ZonedDateTime.parse(dateString, this.format());
    }

    @Documentation(description="Convert to Instant object")
    public Instant toInstant(@ParamName(value="timestamp") long timestamp) {
        return Instant.ofEpochMilli(timestamp);
    }

    @Documentation(description="Parse time zone identifier (e.g. UTC, GMT, Europe/Warsaw")
    public ZoneId zone(@ParamName(value="zoneId") String zoneId) {
        return ZoneId.of(zoneId);
    }

    private long localDateTimeToEpochMillis(LocalDateTime d) {
        return d.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    private date$() {
        MODULE$ = this;
        this.format = DateTimeFormatter.ISO_DATE_TIME;
    }
}

