/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util.namespaces;

import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.namespaces.NamingContext;
import pl.touk.nussknacker.engine.api.namespaces.ObjectNaming;
import pl.touk.nussknacker.engine.api.namespaces.ObjectNamingParameters;
import pl.touk.nussknacker.engine.util.namespaces.DefaultNamespacedObjectNamingParameters;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class DefaultNamespacedObjectNaming$
implements ObjectNaming,
LazyLogging {
    public static DefaultNamespacedObjectNaming$ MODULE$;
    private final Map<String, Regex> regexMap;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DefaultNamespacedObjectNaming$();
    }

    private Logger logger$lzycompute() {
        DefaultNamespacedObjectNaming$ defaultNamespacedObjectNaming$ = this;
        synchronized (defaultNamespacedObjectNaming$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public final String NamespacePath() {
        return "namespace";
    }

    public Map<String, Regex> regexMap() {
        return this.regexMap;
    }

    public String prepareName(String originalName, Config config, NamingContext namingContext) {
        return (String)this.forNamespace(config, (Function1 & Serializable & scala.Serializable)namespace -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("Prepending {} to {} for {}", new Object[]{namespace, originalName, namingContext.usageKey()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new StringBuilder(1).append((String)namespace).append("_").append(originalName).toString();
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("Namespace has not been configured, {} left", new Object[]{originalName});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return originalName;
        });
    }

    public Option<ObjectNamingParameters> objectNamingParameters(String originalName, Config config, NamingContext namingContext) {
        return this.forNamespace(config, (Function1 & Serializable & scala.Serializable)namespace -> new DefaultNamespacedObjectNamingParameters(originalName, (String)namespace));
    }

    public Option<String> decodeName(String preparedName, Config config, NamingContext namingContext) {
        return (Option)this.forNamespace(config, (Function1 & Serializable & scala.Serializable)namespace -> {
            Option option;
            String string;
            Regex patternMatcher = MODULE$.namespacePattern((String)namespace);
            Option option2 = patternMatcher.unapplySeq((CharSequence)(string = preparedName));
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String value = (String)((LinearSeqOptimized)option2.get()).apply(0);
                option = new Some((Object)value);
            } else {
                option = Option$.MODULE$.empty();
            }
            return option;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)preparedName));
    }

    private <T> Option<T> forNamespace(Config config, Function1<String, T> action) {
        return config.hasPath("namespace") ? new Some(action.apply((Object)config.getString("namespace"))) : None$.MODULE$;
    }

    private Regex namespacePattern(String namespace) {
        return (Regex)this.regexMap().getOrElse((Object)namespace, (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(5).append(namespace).append("_(.*)").toString())).r());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DefaultNamespacedObjectNaming$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.regexMap = Predef$.MODULE$.Map().empty();
    }
}

