/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.util;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.nussknacker.engine.api.Context;
import pl.touk.nussknacker.engine.api.Lifecycle;
import pl.touk.nussknacker.engine.api.MetaData;
import pl.touk.nussknacker.engine.api.ProcessListener;
import pl.touk.nussknacker.engine.api.exception.NuExceptionInfo;
import pl.touk.nussknacker.engine.api.runtimecontext.EngineRuntimeContext;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.util.Try;

public final class LoggingListener$
implements ProcessListener,
scala.Serializable {
    public static LoggingListener$ MODULE$;
    private final String className;
    private final ConcurrentHashMap<List<String>, Logger> loggerMap;

    static {
        new LoggingListener$();
    }

    public void open(EngineRuntimeContext context) {
        Lifecycle.open$((Lifecycle)this, (EngineRuntimeContext)context);
    }

    public void close() {
        Lifecycle.close$((Lifecycle)this);
    }

    public String className() {
        return this.className;
    }

    private ConcurrentHashMap<List<String>, Logger> loggerMap() {
        return this.loggerMap;
    }

    private void debug(List<String> keys, Function0<String> message) {
        block0: {
            Logger logger = this.loggerMap().computeIfAbsent(keys, new Function<List<String>, Logger>(){

                public <V> Function<V, Logger> compose(Function<? super V, ? extends List<String>> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<List<String>, V> andThen(Function<? super Logger, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public Logger apply(List<String> ks) {
                    String loggerKey = ks.mkString(".");
                    return LoggerFactory.getLogger((String)new StringBuilder(1).append(LoggingListener$.MODULE$.className()).append(".").append(loggerKey).toString());
                }
            });
            if (!logger.isDebugEnabled()) break block0;
            logger.debug((String)message.apply());
        }
    }

    public void nodeEntered(String nodeId, Context context, MetaData metadata) {
        this.debug((List<String>)new .colon.colon((Object)metadata.id(), (List)new .colon.colon((Object)nodeId, (List)Nil$.MODULE$)), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Node entered. Context: ").append(context).toString());
    }

    public void deadEndEncountered(String lastNodeId, Context context, MetaData metadata) {
        this.debug((List<String>)new .colon.colon((Object)metadata.id(), (List)new .colon.colon((Object)lastNodeId, (List)new .colon.colon((Object)"deadEnd", (List)Nil$.MODULE$))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Dead end encountered. Context: ").append(context).toString());
    }

    public void expressionEvaluated(String nodeId, String expressionId, String expr, Context context, MetaData metadata, Object result) {
        this.debug((List<String>)new .colon.colon((Object)metadata.id(), (List)new .colon.colon((Object)nodeId, (List)new .colon.colon((Object)"expression", (List)Nil$.MODULE$))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("invoked expression: ").append(expr).append(" with result ").append(result).append(". Context: ").append(context).toString());
    }

    public void serviceInvoked(String nodeId, String id, Context context, MetaData metadata, Map<String, Object> params, Try<Object> result) {
        this.debug((List<String>)new .colon.colon((Object)metadata.id(), (List)new .colon.colon((Object)nodeId, (List)new .colon.colon((Object)"service", (List)new .colon.colon((Object)id, (List)Nil$.MODULE$)))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Invocation ended-up with result: ").append(result).append(". Context: ").append(context).toString());
    }

    public void sinkInvoked(String nodeId, String id, Context context, MetaData metadata, Object param) {
        this.debug((List<String>)new .colon.colon((Object)metadata.id(), (List)new .colon.colon((Object)nodeId, (List)new .colon.colon((Object)"sink", (List)new .colon.colon((Object)id, (List)Nil$.MODULE$)))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Sink invoked with param: ").append(param).append(". Context: ").append(context).toString());
    }

    public void exceptionThrown(NuExceptionInfo<? extends Throwable> exceptionInfo) {
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LoggingListener$() {
        MODULE$ = this;
        Lifecycle.$init$((Lifecycle)this);
        this.className = (String)new StringOps(Predef$.MODULE$.augmentString(this.getClass().getName())).init();
        this.loggerMap = new ConcurrentHashMap();
    }
}

