/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.miki.superfields.numbers;

import com.vaadin.flow.component.Tag;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.vaadin.miki.superfields.numbers.AbstractSuperFloatingPointField;

@Tag(value="super-big-decimal-field")
public class SuperBigDecimalField
extends AbstractSuperFloatingPointField<BigDecimal, SuperBigDecimalField> {
    private int maximumSignificandIntegerDigits = -1;
    private int maximumSignificandFractionDigits = -1;
    private int maximumExponentDigits = 0;
    private boolean negativeExponentAllowed = true;
    private char exponentSeparator = (char)101;

    public SuperBigDecimalField() {
        this("");
    }

    public SuperBigDecimalField(Locale locale) {
        this("", locale);
    }

    public SuperBigDecimalField(Locale locale, int maxFractionDigits) {
        this("", locale, maxFractionDigits);
    }

    public SuperBigDecimalField(String label) {
        this(label, Locale.getDefault());
    }

    public SuperBigDecimalField(String label, Locale locale) {
        this(label, locale, -1);
    }

    public SuperBigDecimalField(BigDecimal defaultValue, String label) {
        this(defaultValue, label, Locale.getDefault(), -1);
    }

    public SuperBigDecimalField(String label, Locale locale, int maxFractionDigits) {
        this(BigDecimal.ZERO, label, locale, maxFractionDigits);
    }

    public SuperBigDecimalField(BigDecimal defaultValue, String label, Locale locale, int maxFractionDigits) {
        super(defaultValue, (SerializablePredicate & Serializable)d -> d.compareTo(BigDecimal.ZERO) < 0, BigDecimal::abs, label, locale, maxFractionDigits);
    }

    @Override
    public void setDecimalFormat(DecimalFormat format) {
        super.setDecimalFormat(format);
        if (format.toLocalizedPattern().indexOf(69) == -1) {
            this.setExponentSeparator('\u0000');
        } else {
            this.setExponentSeparator('e');
            this.setMaximumExponentDigits(format.getMaximumIntegerDigits());
        }
    }

    @Override
    protected StringBuilder buildRegularExpression(StringBuilder builder, DecimalFormat format) {
        builder = super.buildRegularExpression(builder.append("("), format).append(")");
        if (this.getMaximumExponentDigits() > 0) {
            builder.append("|(^");
            if (this.isNegativeValueAllowed()) {
                builder.append("-?");
            }
            builder.append("\\d{1,").append(this.getMaximumSignificandIntegerDigits()).append("}");
            if (this.getMaximumSignificandFractionDigits() > 0) {
                builder.append("(").append(SuperBigDecimalField.escapeDot(format.getDecimalFormatSymbols().getDecimalSeparator())).append("\\d+)?");
            }
            builder.append("((").append(String.valueOf(this.getExponentSeparator()).toUpperCase(this.getLocale())).append("|").append(String.valueOf(this.getExponentSeparator()).toLowerCase(this.getLocale())).append(")");
            if (this.isNegativeExponentAllowed()) {
                builder.append("(\\+|-)?");
            } else {
                builder.append("\\+?");
            }
            builder.append("\\d{0,").append(this.getMaximumExponentDigits()).append("})").append("$)");
        }
        return builder;
    }

    public final boolean isScientificNotationEnabled() {
        return this.getExponentSeparator() > '\u0000' && this.getMaximumExponentDigits() > 0;
    }

    private boolean isValueInScientificNotation(String rawValue) {
        return this.isScientificNotationEnabled() && rawValue.toUpperCase(this.getLocale()).contains(String.valueOf(this.getExponentSeparator()).toUpperCase(this.getLocale()));
    }

    @Override
    protected BigDecimal parseRawValue(String rawValue, DecimalFormat format) throws ParseException {
        if (!Character.isDigit(((String)rawValue).charAt(((String)rawValue).length() - 1))) {
            rawValue = (String)rawValue + "0";
        }
        if (this.isValueInScientificNotation((String)rawValue)) {
            return new BigDecimal(((String)rawValue).replace(format.getDecimalFormatSymbols().getDecimalSeparator(), '.'));
        }
        boolean oldParse = format.isParseBigDecimal();
        format.setParseBigDecimal(true);
        BigDecimal result = (BigDecimal)format.parse((String)rawValue);
        format.setParseBigDecimal(oldParse);
        return result;
    }

    @Override
    protected void updateFieldValue() {
        if (this.isValueInScientificNotation(this.getRawValue())) {
            try {
                this.setValue((BigDecimal)this.parseRawValue(this.getRawValue()));
            }
            catch (ParseException pe) {
                super.updateFieldValue();
            }
        } else {
            super.updateFieldValue();
        }
    }

    public void setMaximumExponentDigits(int maximumExponentDigits) {
        this.maximumExponentDigits = maximumExponentDigits;
        this.updateRegularExpression();
    }

    public int getMaximumExponentDigits() {
        return this.maximumExponentDigits;
    }

    public final SuperBigDecimalField withMaximumExponentDigits(int maximumExponentDigits) {
        this.setMaximumExponentDigits(maximumExponentDigits);
        return this;
    }

    public int getMaximumSignificandIntegerDigits() {
        if (this.maximumSignificandIntegerDigits < 0) {
            return this.getMaximumIntegerDigits();
        }
        return Math.max(1, Math.min(this.maximumSignificandIntegerDigits, this.getMaximumIntegerDigits()));
    }

    public void setMaximumSignificandIntegerDigits(int maximumSignificandIntegerDigits) {
        this.maximumSignificandIntegerDigits = maximumSignificandIntegerDigits;
        this.updateRegularExpression();
    }

    public final SuperBigDecimalField withMaximumSignificandIntegerDigits(int maximumSignificandIntegerDigits) {
        this.setMaximumSignificandIntegerDigits(maximumSignificandIntegerDigits);
        return this;
    }

    public int getMaximumSignificandFractionDigits() {
        if (this.maximumSignificandFractionDigits < 0) {
            return this.getMaximumFractionDigits();
        }
        return Math.max(0, Math.min(this.maximumSignificandFractionDigits, this.getMaximumFractionDigits()));
    }

    public void setMaximumSignificandFractionDigits(int maximumSignificandFractionDigits) {
        this.maximumSignificandFractionDigits = maximumSignificandFractionDigits;
        this.updateRegularExpression();
    }

    public final SuperBigDecimalField withMaximumSignificandFractionDigits(int maximumSignificandFractionDigits) {
        this.setMaximumSignificandFractionDigits(maximumSignificandFractionDigits);
        return this;
    }

    public char getExponentSeparator() {
        return this.exponentSeparator;
    }

    public void setExponentSeparator(char exponentSeparator) {
        this.exponentSeparator = exponentSeparator;
        this.updateRegularExpression();
    }

    public final SuperBigDecimalField withExponentSeparator(char exponentSeparator) {
        this.setExponentSeparator(exponentSeparator);
        return this;
    }

    public boolean isNegativeExponentAllowed() {
        return this.negativeExponentAllowed;
    }

    public void setNegativeExponentAllowed(boolean negativeExponentAllowed) {
        this.negativeExponentAllowed = negativeExponentAllowed;
        this.updateRegularExpression();
    }

    public final SuperBigDecimalField withNegativeExponentAllowed(boolean negativeExponentAllowed) {
        this.setNegativeExponentAllowed(negativeExponentAllowed);
        return this;
    }
}

